/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.template.TemplateResultListener;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.api.PsiRenameUsage;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u0015H\u0000\u00a8\u0006\u0017"}, d2={"deleteInplaceTemplateSegments", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "templateSegmentRanges", "", "Lcom/intellij/openapi/util/TextRange;", "injectedToHost", "injectedFile", "Lcom/intellij/psi/PsiFile;", "injectedRange", "usageRangeInHost", "hostFile", "usage", "Lcom/intellij/refactoring/rename/api/PsiRenameUsage;", "addTemplateResultListener", "", "Lcom/intellij/codeInsight/template/impl/TemplateState;", "resultConsumer", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/template/TemplateResultListener$TemplateResult;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/refactoring/rename/inplace/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/intellij/refactoring/rename/inplace/UtilKt\n*L\n51#1:77\n51#1:78,3\n*E\n"})
public final class UtilKt {
    @Nullable
    public static final TextRange usageRangeInHost(@NotNull PsiFile hostFile, @NotNull PsiRenameUsage usage2) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)usage2, (String)"usage");
        if (Intrinsics.areEqual((Object)usage2.getFile(), (Object)hostFile)) {
            textRange = usage2.getRange();
        } else {
            Project project2 = hostFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"hostFile.project");
            textRange = UtilKt.injectedToHost(project2, usage2.getFile(), usage2.getRange());
        }
        return textRange;
    }

    private static final TextRange injectedToHost(Project project2, PsiFile injectedFile, TextRange injectedRange) {
        Object object = PsiDocumentManager.getInstance(project2).getDocument(injectedFile);
        DocumentWindow documentWindow = object instanceof DocumentWindow ? (DocumentWindow)object : null;
        if (documentWindow == null) {
            return null;
        }
        DocumentWindow injectedDocument = documentWindow;
        object = injectedDocument.getHostRange(injectedDocument.injectedToHost(injectedRange.getStartOffset()));
        if (object == null) {
            return null;
        }
        Object startOffsetHostRange = object;
        TextRange textRange = injectedDocument.getHostRange(injectedDocument.injectedToHost(injectedRange.getEndOffset()));
        if (textRange == null) {
            return null;
        }
        TextRange endOffsetHostRange = textRange;
        return Intrinsics.areEqual((Object)startOffsetHostRange, (Object)endOffsetHostRange) ? injectedDocument.injectedToHost(injectedRange) : null;
    }

    public static final void addTemplateResultListener(@NotNull TemplateState $this$addTemplateResultListener, @NotNull Function1<? super TemplateResultListener.TemplateResult, Unit> resultConsumer) {
        Intrinsics.checkNotNullParameter((Object)$this$addTemplateResultListener, (String)"<this>");
        Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
        $this$addTemplateResultListener.addTemplateStateListener(new TemplateResultListener(resultConsumer));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Runnable deleteInplaceTemplateSegments(@NotNull Project project2, @NotNull Document document, @NotNull List<? extends TextRange> templateSegmentRanges) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(templateSegmentRanges, (String)"templateSegmentRanges");
        String string2 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String hostDocumentContent = string2;
        Iterable $this$map$iv = templateSegmentRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String content2;
            RangeMarker marker;
            void range;
            RangeMarker rangeMarker;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RangeMarker it = rangeMarker = document.createRangeMarker((TextRange)range);
            boolean bl2 = false;
            it.setGreedyToRight(true);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMark\u2026reedyToRight = true\n    }");
            Intrinsics.checkNotNullExpressionValue((Object)range.substring(hostDocumentContent), (String)"range.substring(hostDocumentContent)");
            collection.add(new Pair((Object)marker, (Object)content2));
        }
        List stateBefore = (List)destination$iv$iv;
        DocumentUtil.executeInBulk(document, () -> UtilKt.deleteInplaceTemplateSegments$lambda$2(templateSegmentRanges, document));
        return () -> UtilKt.deleteInplaceTemplateSegments$lambda$5(project2, document, stateBefore);
    }

    private static final void deleteInplaceTemplateSegments$lambda$2(List $templateSegmentRanges, Document $document) {
        Intrinsics.checkNotNullParameter((Object)$templateSegmentRanges, (String)"$templateSegmentRanges");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        for (TextRange range : CollectionsKt.asReversed((List)$templateSegmentRanges)) {
            $document.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static final void deleteInplaceTemplateSegments$lambda$5$lambda$4$lambda$3(List $stateBefore, Document $document) {
        Intrinsics.checkNotNullParameter((Object)$stateBefore, (String)"$stateBefore");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        for (Pair pair : $stateBefore) {
            RangeMarker marker = (RangeMarker)pair.component1();
            String content2 = (String)pair.component2();
            $document.replaceString(marker.getStartOffset(), marker.getEndOffset(), content2);
        }
    }

    private static final void deleteInplaceTemplateSegments$lambda$5$lambda$4(Document $document, Project $project, List $stateBefore) {
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$stateBefore, (String)"$stateBefore");
        DocumentUtil.executeInBulk($document, () -> UtilKt.deleteInplaceTemplateSegments$lambda$5$lambda$4$lambda$3($stateBefore, $document));
        PsiDocumentManager.getInstance($project).commitDocument($document);
    }

    private static final void deleteInplaceTemplateSegments$lambda$5(Project $project, Document $document, List $stateBefore) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$stateBefore, (String)"$stateBefore");
        WriteCommandAction.writeCommandAction($project).run(() -> UtilKt.deleteInplaceTemplateSegments$lambda$5$lambda$4($document, $project, $stateBefore));
    }
}

