/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableInplaceRenameHandler
implements RenameHandler {
    private static final ThreadLocal<String> ourPreventInlineRenameFlag = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance(VariableInplaceRenameHandler.class);

    public final boolean isAvailableOnDataContext(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = PsiElementRenameHandler.getElement((DataContext)dataContext2);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if (editor2 == null || file2 == null) {
            return false;
        }
        if (ourPreventInlineRenameFlag.get() != null) {
            return false;
        }
        return this.isAvailable(element, editor2, file2);
    }

    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        PsiElement nameSuggestionContext = file2.findElementAt(editor2.getCaretModel().getOffset());
        if (element == null || !element.isValid()) {
            return false;
        }
        RefactoringSupportProvider supportProvider = LanguageRefactoringSupport.INSTANCE.forContext(element);
        return supportProvider != null && editor2.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceRenameAvailable(element, nameSuggestionContext);
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext2) {
        PsiElement element;
        if (project2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        if ((element = PsiElementRenameHandler.getElement((DataContext)dataContext2)) == null) {
            if (LookupManager.getActiveLookup(editor2) != null) {
                PsiElement elementUnderCaret = file2.findElementAt(editor2.getCaretModel().getOffset());
                if (elementUnderCaret != null) {
                    PsiElement parent2 = elementUnderCaret.getParent();
                    element = parent2 instanceof PsiReference ? ((PsiReference)((Object)parent2)).resolve() : PsiTreeUtil.getParentOfType(elementUnderCaret, PsiNamedElement.class);
                }
                if (element == null) {
                    return;
                }
            } else {
                return;
            }
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (this.checkAvailable(element, editor2, dataContext2)) {
            this.doRename(element, editor2, dataContext2);
        }
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, @NotNull DataContext dataContext2) {
        PsiElement element;
        if (project2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        if (dataContext2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement((DataContext)dataContext2);
        }
        LOG.assertTrue(element != null);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (this.checkAvailable(element, editor2, dataContext2)) {
            assert (editor2 != null);
            this.doRename(element, editor2, dataContext2);
        }
    }

    protected boolean checkAvailable(PsiElement elementToRename, Editor editor2, DataContext dataContext2) {
        if (!this.isAvailableOnDataContext(dataContext2)) {
            LOG.error("Recursive invocation");
            RenameHandler handler2 = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            if (handler2 == null) {
                return false;
            }
            handler2.invoke(elementToRename.getProject(), editor2, elementToRename.getContainingFile(), dataContext2);
            return false;
        }
        return true;
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, @NotNull Editor editor2, @Nullable DataContext dataContext2) {
        VariableInplaceRenamer renamer;
        boolean startedRename;
        if (elementToRename == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(8);
        }
        boolean bl = startedRename = (renamer = this.createRenamer(elementToRename, editor2)) != null && renamer.performInplaceRename();
        if (!startedRename && dataContext2 != null) {
            VariableInplaceRenameHandler.performDialogRename(elementToRename, editor2, dataContext2, renamer != null ? renamer.myInitialName : null);
        }
        return renamer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void performDialogRename(PsiElement elementToRename, Editor editor2, @NotNull DataContext dataContext2, String initialName) {
        if (dataContext2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(9);
        }
        try {
            ourPreventInlineRenameFlag.set(initialName == null ? "" : initialName);
            RenameHandler handler2 = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            assert (handler2 != null) : elementToRename.getClass().getName() + ":" + elementToRename;
            handler2.invoke(elementToRename.getProject(), editor2, elementToRename.getContainingFile(), dataContext2);
        }
        finally {
            ourPreventInlineRenameFlag.set(null);
        }
    }

    @Nullable
    public static String getInitialName() {
        String str = ourPreventInlineRenameFlag.get();
        return StringUtil.isEmpty(str) ? null : str;
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor2) {
        if (elementToRename == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(11);
        }
        return new VariableInplaceRenamer((PsiNamedElement)elementToRename, editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doRename";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "performDialogRename";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

