/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteDialog
extends DialogWrapper {
    private final Project myProject;
    private final PsiElement[] myElements;
    private final Callback myCallback;
    private final SafeDeleteProcessorDelegate myDelegate;
    private StateRestoringCheckBox myCbSearchInComments;
    private StateRestoringCheckBox myCbSearchTextOccurrences;
    private JCheckBox myCbSafeDelete;

    public SafeDeleteDialog(Project project2, PsiElement[] elements, Callback callback) {
        super(project2, true);
        this.myProject = project2;
        this.myElements = elements;
        this.myCallback = callback;
        this.myDelegate = this.getDelegate();
        this.setTitle(SafeDeleteHandler.getRefactoringName());
        this.init();
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchForTextOccurences() {
        if (this.myCbSearchTextOccurrences != null) {
            return this.myCbSearchTextOccurrences.isSelected();
        }
        return false;
    }

    protected String getHelpId() {
        return "refactoring.safeDelete";
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        String promptKey = this.isDelete() ? "prompt.delete.elements" : "search.for.usages.and.delete.elements";
        String warningMessage = DeleteUtil.generateWarningMessage(promptKey, this.myElements);
        gbc.insets = JBInsets.create(4, 8);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        panel2.add((Component)new JLabel(warningMessage), gbc);
        if (this.isDelete()) {
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            gbc.insets = JBUI.insets(4, 8, 0, 8);
            this.myCbSafeDelete = new JCheckBox(IdeBundle.message((String)"checkbox.safe.delete.with.usage.search", (Object[])new Object[0]));
            panel2.add((Component)this.myCbSafeDelete, gbc);
            this.myCbSafeDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SafeDeleteDialog.this.updateControls(SafeDeleteDialog.this.myCbSearchInComments);
                    SafeDeleteDialog.this.updateControls(SafeDeleteDialog.this.myCbSearchTextOccurrences);
                }
            });
        }
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.myCbSearchInComments = new StateRestoringCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        panel2.add((Component)this.myCbSearchInComments, gbc);
        if (this.needSearchForTextOccurrences()) {
            ++gbc.gridx;
            this.myCbSearchTextOccurrences = new StateRestoringCheckBox();
            this.myCbSearchTextOccurrences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
            panel2.add((Component)this.myCbSearchTextOccurrences, gbc);
        }
        RefactoringSettings refactoringSettings = RefactoringSettings.getInstance();
        if (this.myCbSafeDelete != null) {
            this.myCbSafeDelete.setSelected(refactoringSettings.SAFE_DELETE_WHEN_DELETE);
        }
        this.myCbSearchInComments.setSelected(this.myDelegate != null ? this.myDelegate.isToSearchInComments(this.myElements[0]) : refactoringSettings.SAFE_DELETE_SEARCH_IN_COMMENTS);
        if (this.myCbSearchTextOccurrences != null) {
            this.myCbSearchTextOccurrences.setSelected(this.myDelegate != null ? this.myDelegate.isToSearchForTextOccurrences(this.myElements[0]) : refactoringSettings.SAFE_DELETE_SEARCH_IN_NON_JAVA);
        }
        this.updateControls(this.myCbSearchTextOccurrences);
        this.updateControls(this.myCbSearchInComments);
        return panel2;
    }

    private void updateControls(@Nullable StateRestoringCheckBox checkBox) {
        if (checkBox == null) {
            return;
        }
        if (this.myCbSafeDelete == null || this.myCbSafeDelete.isSelected()) {
            checkBox.makeSelectable();
        } else {
            checkBox.makeUnselectable(false);
        }
    }

    protected boolean isDelete() {
        return false;
    }

    @Nullable
    private SafeDeleteProcessorDelegate getDelegate() {
        if (this.myElements.length == 1) {
            for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.handlesElement(this.myElements[0])) continue;
                return delegate2;
            }
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private boolean needSearchForTextOccurrences() {
        for (PsiElement element : this.myElements) {
            if (!TextOccurrencesUtil.isSearchTextOccurrencesEnabled(element)) continue;
            return true;
        }
        return false;
    }

    protected void doOKAction() {
        super.doOKAction();
        if (DumbService.isDumb(this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"safe.delete.not.available.indexing"), (String)RefactoringBundle.message((String)"refactoring.indexing.warning.title"), null);
            return;
        }
        NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            if (this.myCallback != null && this.isSafeDelete()) {
                this.myCallback.run(this);
            }
        });
        RefactoringSettings refactoringSettings = RefactoringSettings.getInstance();
        if (this.myCbSafeDelete != null) {
            refactoringSettings.SAFE_DELETE_WHEN_DELETE = this.myCbSafeDelete.isSelected();
        }
        if (this.isSafeDelete()) {
            if (this.myDelegate == null) {
                refactoringSettings.SAFE_DELETE_SEARCH_IN_COMMENTS = this.isSearchInComments();
                if (this.myCbSearchTextOccurrences != null) {
                    refactoringSettings.SAFE_DELETE_SEARCH_IN_NON_JAVA = this.isSearchForTextOccurences();
                }
            } else {
                this.myDelegate.setToSearchInComments(this.myElements[0], this.isSearchInComments());
                if (this.myCbSearchTextOccurrences != null) {
                    this.myDelegate.setToSearchForTextOccurrences(this.myElements[0], this.isSearchForTextOccurences());
                }
            }
        }
    }

    private boolean isSafeDelete() {
        if (this.isDelete()) {
            return this.myCbSafeDelete.isSelected();
        }
        return true;
    }

    public static interface Callback {
        public void run(SafeDeleteDialog var1);
    }
}

