/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.safeDelete.api.SafeDeleteTarget;
import com.intellij.refactoring.safeDelete.api.SafeDeleteTargetProvider;
import com.intellij.refactoring.safeDelete.impl.SafeDeleteKt;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext2) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null || !SafeDeleteProcessor.validElement(element)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{SafeDeleteHandler.getRefactoringName()}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message, (String)SafeDeleteHandler.getRefactoringName(), (String)"refactoring.safeDelete");
            return;
        }
        this.invoke(project2, new PsiElement[]{element}, dataContext2);
    }

    public void invoke(@NotNull Project project2, @NotNull @NotNull PsiElement @NotNull [] elements, DataContext dataContext2) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(2);
        }
        SafeDeleteHandler.invoke(project2, elements, (Module)PlatformCoreDataKeys.MODULE.getData(dataContext2), true, null, null);
    }

    public static void invoke(@NotNull Project project2, @NotNull @NotNull PsiElement @NotNull [] elements, boolean checkDelegates) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(4);
        }
        SafeDeleteHandler.invoke(project2, elements, checkDelegates, null);
    }

    public static void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, boolean checkDelegates, @Nullable Runnable successRunnable) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(6);
        }
        SafeDeleteHandler.invoke(project2, elements, null, checkDelegates, successRunnable, null);
    }

    public static void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, @Nullable Module module2, boolean checkDelegates, @Nullable Runnable successRunnable) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(7);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(8);
        }
        SafeDeleteHandler.invoke(project2, elements, module2, checkDelegates, successRunnable, null);
    }

    public static void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, @Nullable Module module2, boolean checkDelegates, @Nullable Runnable successRunnable, @Nullable Runnable afterRefactoring) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(10);
        }
        SafeDeleteHandler.invoke(project2, elements, module2, checkDelegates, successRunnable, afterRefactoring, false);
    }

    public static void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, @Nullable Module module2, boolean checkDelegates, @Nullable Runnable successRunnable, @Nullable Runnable afterRefactoring, boolean silent) {
        SafeDeleteTarget target2;
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(11);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(12);
        }
        for (PsiElement psiElement : elements) {
            if (SafeDeleteProcessor.validElement(psiElement)) continue;
            return;
        }
        if (elements.length == 1 && (target2 = SafeDeleteTargetProvider.Companion.createSafeDeleteTarget(elements[0])) != null) {
            SafeDeleteKt.safeDelete(project2, target2.createPointer());
            return;
        }
        PsiElement[] temptoDelete = PsiTreeUtil.filterAncestors(elements);
        Set<PsiElement> elementsSet = ContainerUtil.set(temptoDelete);
        LinkedHashSet<? extends PsiElement> fullElementsSet = new LinkedHashSet<PsiElement>();
        if (checkDelegates) {
            for (PsiElement element : temptoDelete) {
                boolean found2 = false;
                for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                    Collection<? extends PsiElement> addElements;
                    if (!delegate2.handlesElement(element)) continue;
                    found2 = true;
                    Collection<? extends PsiElement> collection = addElements = delegate2 instanceof SafeDeleteProcessorDelegateBase ? ((SafeDeleteProcessorDelegateBase)delegate2).getElementsToSearch(element, module2, elementsSet) : delegate2.getElementsToSearch(element, elementsSet);
                    if (addElements == null) {
                        return;
                    }
                    fullElementsSet.addAll(addElements);
                    break;
                }
                if (found2) continue;
                fullElementsSet.add(element);
            }
        } else {
            ContainerUtil.addAll(fullElementsSet, temptoDelete);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, fullElementsSet, (boolean)true)) {
            return;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(fullElementsSet);
        if (ApplicationManager.getApplication().isUnitTestMode() || silent) {
            RefactoringSettings settings = RefactoringSettings.getInstance();
            SafeDeleteProcessor processor = SafeDeleteProcessor.createInstance(project2, null, psiElementArray, settings.SAFE_DELETE_SEARCH_IN_COMMENTS, settings.SAFE_DELETE_SEARCH_IN_NON_JAVA, true);
            if (afterRefactoring != null) {
                processor.setAfterRefactoringCallback(afterRefactoring);
            }
            processor.run();
            if (successRunnable != null) {
                successRunnable.run();
            }
        } else {
            SafeDeleteDialog.Callback callback = dialog -> {
                SafeDeleteProcessor processor = SafeDeleteProcessor.createInstance(project2, () -> {
                    if (successRunnable != null) {
                        successRunnable.run();
                    }
                    dialog.close(1);
                }, elementsToDelete, dialog.isSearchInComments(), dialog.isSearchForTextOccurences(), true);
                if (afterRefactoring != null) {
                    processor.setAfterRefactoringCallback(afterRefactoring);
                }
                processor.run();
            };
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project2, psiElementArray, callback);
            dialog2.show();
        }
    }

    @NlsContexts.DialogTitle
    @NotNull
    public static String getRefactoringName() {
        String string2 = RefactoringBundle.message((String)"safe.delete.title");
        if (string2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(13);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/safeDelete/SafeDeleteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/safeDelete/SafeDeleteHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 13 -> new IllegalStateException(string2);
        };
    }
}

