/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.refactoring.suggested.SignatureChangePresentationKt;
import com.intellij.refactoring.suggested.SignatureChangePresentationModel;
import com.intellij.refactoring.suggested.SignatureChangePresentationModelKt;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 02\u00020\u0001:\u0005/0123B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\"\u0010(\u001a\u00020)2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010+\u001a\u00020\u001a2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010!\u001a\u00020\u0017H\u0002R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation;", "", "model", "Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel;", "font", "Ljava/awt/Font;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "verticalMode", "", "(Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel;Ljava/awt/Font;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;Z)V", "addedAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "kotlin.jvm.PlatformType", "connectionColor", "Ljava/awt/Color;", "connectionStroke", "Ljava/awt/BasicStroke;", "crossStroke", "defaultForegroundColor", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "dummyFontRenderContext", "Ljava/awt/font/FontRenderContext;", "modifiedAttributes", "requiredSize", "Ljava/awt/Dimension;", "getRequiredSize", "()Ljava/awt/Dimension;", "requiredSize$delegate", "Lkotlin/Lazy;", "lineHeight", "", "context", "paint", "", "g", "Ljava/awt/Graphics2D;", "bounds", "Ljava/awt/Rectangle;", "renderAll", "Lcom/intellij/refactoring/suggested/SignatureChangePresentation$ConnectionRouter;", "fontRenderContext", "signatureDimensions", "fragments", "", "Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel$TextFragment;", "ConnectionRouter", "Constants", "HorizontalModeConnectionRouter", "SignatureRenderer", "VerticalModeConnectionRouter", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSignatureChangePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentation\n+ 2 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentationKt\n*L\n1#1,561:1\n553#2:562\n*S KotlinDebug\n*F\n+ 1 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentation\n*L\n124#1:562\n*E\n"})
public final class SignatureChangePresentation {
    @NotNull
    private static final Constants Constants = new Constants(null);
    @NotNull
    private final SignatureChangePresentationModel model;
    @NotNull
    private final Font font;
    private final boolean verticalMode;
    @NotNull
    private final JBColor defaultForegroundColor;
    private final TextAttributes modifiedAttributes;
    private final TextAttributes addedAttributes;
    @NotNull
    private final BasicStroke crossStroke;
    @NotNull
    private final BasicStroke connectionStroke;
    @NotNull
    private final Color connectionColor;
    @NotNull
    private final FontRenderContext dummyFontRenderContext;
    @NotNull
    private final Lazy requiredSize$delegate;
    @Deprecated
    public static final int indentInVerticalMode = 4;
    @Deprecated
    public static final int betweenSignaturesVSpace = 10;
    @Deprecated
    public static final int betweenSignaturesVSpaceWithOneHSegment = 16;
    @Deprecated
    public static final int betweenHSegmentsVSpace = 6;
    @Deprecated
    public static final int betweenConnectorsHSpace = 10;
    @Deprecated
    public static final double rectangularConnectionArcR = 4.0;
    @Deprecated
    public static final int hLineInterruptionGap = 1;
    @Deprecated
    public static final int minHSegmentLength = 25;
    @Deprecated
    public static final int betweenSignaturesHSpace = 50;
    @Deprecated
    public static final int betweenSignaturesConnectionStraightPart = 10;
    @Deprecated
    public static final double verticalModeArcW = 4.0;
    @Deprecated
    public static final int topSpace = 14;
    @Deprecated
    public static final int bottomSpace = 18;
    @Deprecated
    public static final int leftSpace = 0;
    @Deprecated
    public static final int rightSpace = 6;
    @Deprecated
    public static final int connectionLineThickness = 2;
    @Deprecated
    public static final int backgroundGap = 1;

    public SignatureChangePresentation(@NotNull SignatureChangePresentationModel model2, @NotNull Font font, @NotNull EditorColorsScheme colorsScheme, boolean verticalMode) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
        this.model = model2;
        this.font = font;
        this.verticalMode = verticalMode;
        JBColor jBColor = JBColor.namedColor("Label.foreground", Color.black);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(\"Label.foreground\", Color.black)");
        this.defaultForegroundColor = jBColor;
        this.modifiedAttributes = colorsScheme.getAttributes(DiffColors.DIFF_MODIFIED);
        this.addedAttributes = colorsScheme.getAttributes(DiffColors.DIFF_INSERTED);
        this.crossStroke = new BasicStroke(1.0f);
        this.connectionStroke = new BasicStroke(2.0f);
        Color color = this.modifiedAttributes.getBackgroundColor();
        if (color == null) {
            color = this.defaultForegroundColor;
        }
        this.connectionColor = color;
        this.dummyFontRenderContext = new FontRenderContext(new AffineTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), UISettings.Companion.getPreferredFractionalMetricsValue());
        this.requiredSize$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Dimension>(this){
            final /* synthetic */ SignatureChangePresentation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Dimension invoke() {
                Dimension dimension;
                Dimension oldSignatureSize = SignatureChangePresentation.access$signatureDimensions(this.this$0, SignatureChangePresentation.access$getModel$p(this.this$0).getOldSignature(), SignatureChangePresentation.access$getDummyFontRenderContext$p(this.this$0));
                Dimension newSignatureSize = SignatureChangePresentation.access$signatureDimensions(this.this$0, SignatureChangePresentation.access$getModel$p(this.this$0).getNewSignature(), SignatureChangePresentation.access$getDummyFontRenderContext$p(this.this$0));
                if (SignatureChangePresentation.access$getVerticalMode$p(this.this$0)) {
                    dimension = new Dimension(oldSignatureSize.width + newSignatureSize.width + 50 + 0 + 6, Math.max(oldSignatureSize.height, newSignatureSize.height) + 14 + 18);
                } else {
                    void var3_3;
                    boolean bl;
                    Dimension size;
                    block7: {
                        size = new Dimension(Math.max(oldSignatureSize.width, newSignatureSize.width) + 0 + 6, oldSignatureSize.height + newSignatureSize.height + 10 + 14 + 18);
                        Iterable $this$any$iv = SignatureChangePresentation.access$getModel$p(this.this$0).getOldSignature();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SignatureChangePresentationModel.TextFragment it = (SignatureChangePresentationModel.TextFragment)element$iv;
                                boolean bl2 = false;
                                if (!(it.getConnectionId() != null)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        ConnectionRouter connectionRouter = SignatureChangePresentation.access$renderAll(this.this$0, null, SignatureChangePresentation.access$getDummyFontRenderContext$p(this.this$0), new Rectangle(new Point(), size));
                        Intrinsics.checkNotNull((Object)connectionRouter, (String)"null cannot be cast to non-null type com.intellij.refactoring.suggested.SignatureChangePresentation.HorizontalModeConnectionRouter");
                        HorizontalModeConnectionRouter router = (HorizontalModeConnectionRouter)connectionRouter;
                        if (router.getHSegmentLevelsRequired() > 0) {
                            size.height += 6 + 6 * (router.getHSegmentLevelsRequired() - 1);
                        }
                    }
                    dimension = var3_3;
                }
                return dimension;
            }
        }));
    }

    @NotNull
    public final Dimension getRequiredSize() {
        Lazy lazy = this.requiredSize$delegate;
        return (Dimension)lazy.getValue();
    }

    private final Dimension signatureDimensions(List<? extends SignatureChangePresentationModel.TextFragment> fragments, FontRenderContext context2) {
        if (this.verticalMode) {
            Ref.IntRef maxWidth = new Ref.IntRef();
            Ref.IntRef currentLineWidth = new Ref.IntRef();
            Ref.IntRef lines2 = new Ref.IntRef();
            lines2.element = 1;
            SignatureChangePresentationModelKt.forAllFragments(fragments, (Function1<? super SignatureChangePresentationModel.TextFragment, Unit>)((Function1)new Function1<SignatureChangePresentationModel.TextFragment, Unit>(currentLineWidth, this, context2, maxWidth, lines2){
                final /* synthetic */ Ref.IntRef $currentLineWidth;
                final /* synthetic */ SignatureChangePresentation this$0;
                final /* synthetic */ FontRenderContext $context;
                final /* synthetic */ Ref.IntRef $maxWidth;
                final /* synthetic */ Ref.IntRef $lines;
                {
                    this.$currentLineWidth = $currentLineWidth;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$maxWidth = $maxWidth;
                    this.$lines = $lines;
                    super(1);
                }

                public final void invoke(@NotNull SignatureChangePresentationModel.TextFragment fragment) {
                    Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                    SignatureChangePresentationModel.TextFragment textFragment = fragment;
                    if (!(textFragment instanceof SignatureChangePresentationModel.TextFragment.Group)) {
                        if (textFragment instanceof SignatureChangePresentationModel.TextFragment.Leaf) {
                            this.$currentLineWidth.element += SignatureChangePresentationKt.access$ceilToInt(SignatureChangePresentation.access$getFont$p(this.this$0).getStringBounds(((SignatureChangePresentationModel.TextFragment.Leaf)fragment).getText(), this.$context).getWidth());
                        } else if (textFragment instanceof SignatureChangePresentationModel.TextFragment.LineBreak) {
                            this.$maxWidth.element = Math.max(this.$maxWidth.element, this.$currentLineWidth.element);
                            this.$currentLineWidth.element = 0;
                            if (((SignatureChangePresentationModel.TextFragment.LineBreak)fragment).getIndentAfter()) {
                                this.$currentLineWidth.element += MathKt.roundToInt((double)(SignatureChangePresentation.access$getFont$p(this.this$0).getStringBounds(" ", this.$context).getWidth() * (double)4));
                            }
                            int n = this.$lines.element;
                            this.$lines.element = n + 1;
                        }
                    }
                }
            }));
            return new Dimension(maxWidth.element, lines2.element * this.lineHeight(context2));
        }
        Ref.IntRef width = new Ref.IntRef();
        SignatureChangePresentationModelKt.forAllFragments(fragments, (Function1<? super SignatureChangePresentationModel.TextFragment, Unit>)((Function1)new Function1<SignatureChangePresentationModel.TextFragment, Unit>(width, this, context2){
            final /* synthetic */ Ref.IntRef $width;
            final /* synthetic */ SignatureChangePresentation this$0;
            final /* synthetic */ FontRenderContext $context;
            {
                this.$width = $width;
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final void invoke(@NotNull SignatureChangePresentationModel.TextFragment fragment) {
                Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                SignatureChangePresentationModel.TextFragment textFragment = fragment;
                if (!(textFragment instanceof SignatureChangePresentationModel.TextFragment.Group)) {
                    if (textFragment instanceof SignatureChangePresentationModel.TextFragment.Leaf) {
                        this.$width.element += SignatureChangePresentationKt.access$ceilToInt(SignatureChangePresentation.access$getFont$p(this.this$0).getStringBounds(((SignatureChangePresentationModel.TextFragment.Leaf)fragment).getText(), this.$context).getWidth());
                    } else if (textFragment instanceof SignatureChangePresentationModel.TextFragment.LineBreak && ((CharSequence)((SignatureChangePresentationModel.TextFragment.LineBreak)fragment).getSpaceInHorizontalMode()).length() > 0) {
                        this.$width.element += SignatureChangePresentationKt.access$ceilToInt(SignatureChangePresentation.access$getFont$p(this.this$0).getStringBounds(((SignatureChangePresentationModel.TextFragment.LineBreak)fragment).getSpaceInHorizontalMode(), this.$context).getWidth());
                    }
                }
            }
        }));
        return new Dimension(width.element, this.lineHeight(context2));
    }

    public final void paint(@NotNull Graphics2D g, @NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        Intrinsics.checkNotNullExpressionValue((Object)fontRenderContext, (String)"g.fontRenderContext");
        this.renderAll(g, fontRenderContext, bounds);
    }

    private final ConnectionRouter renderAll(Graphics2D g, FontRenderContext fontRenderContext, Rectangle bounds) {
        if (g != null) {
            UISettings.Companion.setupAntialiasing((Graphics)g);
        }
        int lineHeight = this.lineHeight(fontRenderContext);
        Dimension oldSignatureSize = this.signatureDimensions(this.model.getOldSignature(), fontRenderContext);
        Dimension newSignatureSize = this.signatureDimensions(this.model.getNewSignature(), fontRenderContext);
        int oldSignatureTop = 0;
        int newSignatureTop = 0;
        int oldSignatureLeft = 0;
        int newSignatureLeft = 0;
        if (this.verticalMode) {
            newSignatureTop = oldSignatureTop = bounds.y + 14;
            Rectangle $this$left$iv = bounds;
            boolean $i$f$getLeft = false;
            oldSignatureLeft = $this$left$iv.x + 0;
            newSignatureLeft = SignatureChangePresentationKt.access$getRight(bounds) - newSignatureSize.width;
        } else {
            int left;
            oldSignatureTop = bounds.y + 14;
            newSignatureTop = bounds.y + bounds.height - lineHeight - 18;
            int width = Math.max(oldSignatureSize.width, newSignatureSize.width);
            oldSignatureLeft = left = bounds.x + (bounds.width - width) / 2 + 0;
            newSignatureLeft = left;
        }
        Map<SignatureChangePresentationModel.TextFragment, Rectangle> oldFragmentBounds = new SignatureRenderer(g, fontRenderContext, oldSignatureLeft, oldSignatureTop).render(this.model.getOldSignature());
        Map<SignatureChangePresentationModel.TextFragment, Rectangle> newFragmentBounds = new SignatureRenderer(g, fontRenderContext, newSignatureLeft, newSignatureTop).render(this.model.getNewSignature());
        Map newFragmentBoundsById = new LinkedHashMap();
        for (Map.Entry<SignatureChangePresentationModel.TextFragment, Rectangle> object : newFragmentBounds.entrySet()) {
            Object it;
            SignatureChangePresentationModel.TextFragment textFragment = object.getKey();
            Rectangle fragmentBounds = object.getValue();
            if (textFragment.getConnectionId() == null) continue;
            boolean bl = false;
            newFragmentBoundsById.put(it, fragmentBounds);
        }
        List connectedBounds = new ArrayList();
        for (Map.Entry<SignatureChangePresentationModel.TextFragment, Rectangle> entry : oldFragmentBounds.entrySet()) {
            Object it;
            SignatureChangePresentationModel.TextFragment oldFragment = entry.getKey();
            Rectangle oldBounds = entry.getValue();
            if (oldFragment.getConnectionId() == null) continue;
            boolean bl = false;
            Object v = newFragmentBoundsById.get(it);
            Intrinsics.checkNotNull(v);
            Rectangle newBounds = (Rectangle)v;
            connectedBounds.add(TuplesKt.to((Object)oldBounds, (Object)newBounds));
        }
        Graphics2D graphics2D = g;
        if (graphics2D != null) {
            graphics2D.setStroke(this.connectionStroke);
        }
        Graphics2D graphics2D2 = g;
        if (graphics2D2 != null) {
            graphics2D2.setColor(this.connectionColor);
        }
        ConnectionRouter connectionRouter = this.verticalMode ? (ConnectionRouter)new VerticalModeConnectionRouter(g, newSignatureLeft, oldSignatureLeft + oldSignatureSize.width) : (ConnectionRouter)new HorizontalModeConnectionRouter(g, oldSignatureTop + lineHeight, newSignatureTop);
        connectionRouter.drawConnections(connectedBounds);
        return connectionRouter;
    }

    private final int lineHeight(FontRenderContext context2) {
        return SignatureChangePresentationKt.access$ceilToInt(this.font.getMaxCharBounds(context2).getHeight());
    }

    public static final /* synthetic */ Dimension access$signatureDimensions(SignatureChangePresentation $this, List fragments, FontRenderContext context2) {
        return $this.signatureDimensions(fragments, context2);
    }

    public static final /* synthetic */ SignatureChangePresentationModel access$getModel$p(SignatureChangePresentation $this) {
        return $this.model;
    }

    public static final /* synthetic */ FontRenderContext access$getDummyFontRenderContext$p(SignatureChangePresentation $this) {
        return $this.dummyFontRenderContext;
    }

    public static final /* synthetic */ ConnectionRouter access$renderAll(SignatureChangePresentation $this, Graphics2D g, FontRenderContext fontRenderContext, Rectangle bounds) {
        return $this.renderAll(g, fontRenderContext, bounds);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation$ConnectionRouter;", "", "drawConnections", "", "connectedBounds", "", "Lkotlin/Pair;", "Ljava/awt/Rectangle;", "intellij.platform.lang.impl"})
    private static interface ConnectionRouter {
        public void drawConnections(@NotNull List<? extends Pair<? extends Rectangle, ? extends Rectangle>> var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J-\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u001bJ0\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0%2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation$SignatureRenderer;", "", "g", "Ljava/awt/Graphics2D;", "fontRenderContext", "Ljava/awt/font/FontRenderContext;", "left", "", "top", "(Lcom/intellij/refactoring/suggested/SignatureChangePresentation;Ljava/awt/Graphics2D;Ljava/awt/font/FontRenderContext;II)V", "currentX", "currentY", "fragmentBounds", "", "Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel$TextFragment;", "Ljava/awt/Rectangle;", "lineHeight", "backgroundColor", "Ljava/awt/Color;", "effect", "Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel$Effect;", "drawFragments", "", "fragments", "", "inheritedEffect", "inheritedFontStyle", "(Ljava/util/List;Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel$Effect;Ljava/lang/Integer;)V", "drawText", "text", "", "x", "y", "font", "Ljava/awt/Font;", "foregroundColor", "render", "", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nSignatureChangePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentation$SignatureRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,561:1\n1#2:562\n*E\n"})
    private final class SignatureRenderer {
        @Nullable
        private final Graphics2D g;
        @NotNull
        private final FontRenderContext fontRenderContext;
        private final int left;
        private final int top;
        private final int lineHeight;
        private int currentX;
        private int currentY;
        @NotNull
        private final Map<SignatureChangePresentationModel.TextFragment, Rectangle> fragmentBounds;

        public SignatureRenderer(@NotNull Graphics2D g, FontRenderContext fontRenderContext, int left, int top) {
            Intrinsics.checkNotNullParameter((Object)fontRenderContext, (String)"fontRenderContext");
            this.g = g;
            this.fontRenderContext = fontRenderContext;
            this.left = left;
            this.top = top;
            this.lineHeight = SignatureChangePresentation.this.lineHeight(this.fontRenderContext);
            this.currentX = this.left;
            this.currentY = this.top;
            this.fragmentBounds = new LinkedHashMap();
        }

        @NotNull
        public final Map<SignatureChangePresentationModel.TextFragment, Rectangle> render(@NotNull List<? extends SignatureChangePresentationModel.TextFragment> fragments) {
            Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
            this.currentX = this.left;
            this.currentY = this.top;
            this.drawFragments(fragments, SignatureChangePresentationModel.Effect.None, null);
            return this.fragmentBounds;
        }

        private final void drawFragments(List<? extends SignatureChangePresentationModel.TextFragment> fragments, SignatureChangePresentationModel.Effect inheritedEffect, Integer inheritedFontStyle) {
            for (SignatureChangePresentationModel.TextFragment textFragment : fragments) {
                Integer fontStyle;
                Integer n;
                SignatureChangePresentationModel.Effect effect;
                Object object;
                int fragmentStartX = this.currentX;
                int fragmentStartY = this.currentY;
                SignatureChangePresentationModel.Effect it = object = inheritedEffect;
                boolean bl = false;
                SignatureChangePresentationModel.Effect effect2 = it != SignatureChangePresentationModel.Effect.None ? object : null;
                if (effect2 == null) {
                    effect2 = effect = textFragment.getEffect();
                }
                if ((n = inheritedFontStyle) == null) {
                    switch (WhenMappings.$EnumSwitchMapping$0[textFragment.getEffect().ordinal()]) {
                        case 1: {
                            n = 1;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (inheritedEffect != SignatureChangePresentationModel.Effect.None) {
                                n = 1;
                                break;
                            }
                            n = null;
                            break;
                        }
                        default: {
                            n = fontStyle = null;
                        }
                    }
                }
                if ((object = textFragment) instanceof SignatureChangePresentationModel.TextFragment.Leaf) {
                    Font font = fontStyle != null ? SignatureChangePresentation.this.font.deriveFont(fontStyle) : SignatureChangePresentation.this.font;
                    String string2 = ((SignatureChangePresentationModel.TextFragment.Leaf)textFragment).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
                    this.currentX = this.drawText(string2, this.currentX, this.currentY, effect, font);
                } else if (object instanceof SignatureChangePresentationModel.TextFragment.LineBreak) {
                    if (SignatureChangePresentation.this.verticalMode) {
                        this.currentY += this.lineHeight;
                        this.currentX = this.left;
                        if (((SignatureChangePresentationModel.TextFragment.LineBreak)textFragment).getIndentAfter()) {
                            this.currentX += MathKt.roundToInt((double)(SignatureChangePresentation.this.font.getStringBounds(" ", this.fontRenderContext).getWidth() * (double)4));
                        }
                    } else {
                        this.currentX = this.drawText(((SignatureChangePresentationModel.TextFragment.LineBreak)textFragment).getSpaceInHorizontalMode(), this.currentX, this.currentY, effect, SignatureChangePresentation.this.font);
                    }
                } else if (object instanceof SignatureChangePresentationModel.TextFragment.Group) {
                    this.drawFragments(((SignatureChangePresentationModel.TextFragment.Group)textFragment).getChildren(), effect, fontStyle);
                }
                this.fragmentBounds.put(textFragment, new Rectangle(fragmentStartX - 1, fragmentStartY - 1, this.currentX - fragmentStartX + 2, this.currentY - fragmentStartY + this.lineHeight + 2));
            }
        }

        private final int drawText(String text2, int x, int y, SignatureChangePresentationModel.Effect effect, Font font) {
            Color backgroundColor = this.backgroundColor(effect);
            Color color = this.foregroundColor(effect);
            if (color == null) {
                color = SignatureChangePresentation.this.defaultForegroundColor;
            }
            Color foregroundColor = color;
            LineMetrics metrics = font.getLineMetrics(text2, this.fontRenderContext);
            int newX = x + (((CharSequence)text2).length() > 0 ? SignatureChangePresentationKt.access$ceilToInt(font.getStringBounds(text2, this.fontRenderContext).getWidth()) : 0);
            if (this.g != null) {
                if (backgroundColor != null) {
                    this.g.setColor(backgroundColor);
                    this.g.fillRect(x - 1, y - 1, newX - x + 2, this.lineHeight + 2);
                }
                this.g.setColor(foregroundColor);
                this.g.setFont(font);
                this.g.drawString(text2, (float)x, (float)y + metrics.getAscent());
                if (effect == SignatureChangePresentationModel.Effect.Removed) {
                    this.g.setStroke(SignatureChangePresentation.this.crossStroke);
                    this.g.setColor(foregroundColor);
                    int lineY = y + this.lineHeight / 2;
                    this.g.drawLine(x, lineY, newX, lineY);
                }
            }
            return newX;
        }

        private final Color backgroundColor(SignatureChangePresentationModel.Effect effect) {
            return switch (WhenMappings.$EnumSwitchMapping$0[effect.ordinal()]) {
                case 1, 4 -> SignatureChangePresentation.this.modifiedAttributes.getBackgroundColor();
                case 2 -> SignatureChangePresentation.this.addedAttributes.getBackgroundColor();
                default -> null;
            };
        }

        private final Color foregroundColor(SignatureChangePresentationModel.Effect effect) {
            return switch (WhenMappings.$EnumSwitchMapping$0[effect.ordinal()]) {
                case 1, 4 -> SignatureChangePresentation.this.modifiedAttributes.getForegroundColor();
                case 2 -> SignatureChangePresentation.this.addedAttributes.getForegroundColor();
                default -> null;
            };
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SignatureChangePresentationModel.Effect.values().length];
                try {
                    nArray[SignatureChangePresentationModel.Effect.Modified.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureChangePresentationModel.Effect.Added.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureChangePresentationModel.Effect.Removed.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureChangePresentationModel.Effect.Moved.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\"\u0010\r\u001a\u00020\t2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00100\u000fH\u0016J4\u0010\u0011\u001a\u00020\t*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation$VerticalModeConnectionRouter;", "Lcom/intellij/refactoring/suggested/SignatureChangePresentation$ConnectionRouter;", "g", "Ljava/awt/Graphics2D;", "newSignatureLeft", "", "oldSignatureRight", "(Ljava/awt/Graphics2D;II)V", "drawConnection", "", "oldBounds", "Ljava/awt/Rectangle;", "newBounds", "drawConnections", "connectedBounds", "", "Lkotlin/Pair;", "connectedArc", "Ljava/awt/geom/GeneralPath;", "centerX", "", "centerY", "start", "extentWithSign", "radius", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nSignatureChangePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentation$VerticalModeConnectionRouter\n+ 2 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentationKt\n*L\n1#1,561:1\n555#2:562\n555#2:563\n553#2:564\n*S KotlinDebug\n*F\n+ 1 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentation$VerticalModeConnectionRouter\n*L\n479#1:562\n480#1:563\n499#1:564\n*E\n"})
    private static final class VerticalModeConnectionRouter
    implements ConnectionRouter {
        @Nullable
        private final Graphics2D g;
        private final int newSignatureLeft;
        private final int oldSignatureRight;

        public VerticalModeConnectionRouter(@Nullable Graphics2D g, int newSignatureLeft, int oldSignatureRight) {
            this.g = g;
            this.newSignatureLeft = newSignatureLeft;
            this.oldSignatureRight = oldSignatureRight;
        }

        @Override
        public void drawConnections(@NotNull List<? extends Pair<? extends Rectangle, ? extends Rectangle>> connectedBounds) {
            Intrinsics.checkNotNullParameter(connectedBounds, (String)"connectedBounds");
            for (Pair<? extends Rectangle, ? extends Rectangle> pair : connectedBounds) {
                Rectangle oldBounds = (Rectangle)pair.component1();
                Rectangle newBounds = (Rectangle)pair.component2();
                this.drawConnection(oldBounds, newBounds);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void drawConnection(Rectangle oldBounds, Rectangle newBounds) {
            block2: {
                void $this$drawConnection_u24lambda_u240;
                GeneralPath generalPath;
                Rectangle $this$top$iv = oldBounds;
                boolean $i$f$getTop = false;
                double oldY = (double)$this$top$iv.y + (double)oldBounds.height / (double)2;
                Rectangle $this$top$iv2 = newBounds;
                boolean $i$f$getTop2 = false;
                double newY = (double)$this$top$iv2.y + (double)newBounds.height / (double)2;
                Point2D.Double p1 = new Point2D.Double(this.oldSignatureRight + 10, oldY);
                Point2D.Double p2 = new Point2D.Double(this.newSignatureLeft - 10, newY);
                double angle = Math.atan((p1.y - p2.y) / (p2.x - p1.x));
                double angleInDegrees = angle * (double)180 / Math.PI;
                double radius = 4.0 / Math.sin(Math.abs(angle) / (double)2);
                Graphics2D graphics2D = this.g;
                if (graphics2D == null) break block2;
                GeneralPath generalPath2 = generalPath = new GeneralPath();
                Graphics2D graphics2D2 = graphics2D;
                boolean bl = false;
                $this$drawConnection_u24lambda_u240.moveTo((double)SignatureChangePresentationKt.access$getRight(oldBounds), oldY);
                if (angle >= 0.0) {
                    this.connectedArc((GeneralPath)$this$drawConnection_u24lambda_u240, p1.x - 4.0, p1.y - radius, 270.0, angleInDegrees, radius);
                    this.connectedArc((GeneralPath)$this$drawConnection_u24lambda_u240, p2.x + 4.0, p2.y + radius, 90.0 + angleInDegrees, -angleInDegrees, radius);
                } else {
                    this.connectedArc((GeneralPath)$this$drawConnection_u24lambda_u240, p1.x - 4.0, p1.y + radius, 90.0, angleInDegrees, radius);
                    this.connectedArc((GeneralPath)$this$drawConnection_u24lambda_u240, p2.x + 4.0, p2.y - radius, 270.0 + angleInDegrees, -angleInDegrees, radius);
                }
                Rectangle $this$left$iv = newBounds;
                boolean $i$f$getLeft = false;
                $this$drawConnection_u24lambda_u240.lineTo((double)$this$left$iv.x, newY);
                graphics2D2.draw(generalPath);
            }
        }

        private final void connectedArc(GeneralPath $this$connectedArc, double centerX, double centerY, double start, double extentWithSign, double radius) {
            Arc2D.Double arc = new Arc2D.Double(centerX - radius, centerY - radius, radius * (double)2, radius * (double)2, extentWithSign > 0.0 ? start : start + extentWithSign, Math.abs(extentWithSign), 0);
            Point2D startPoint = extentWithSign > 0.0 ? arc.getStartPoint() : arc.getEndPoint();
            Point2D endPoint = extentWithSign > 0.0 ? arc.getEndPoint() : arc.getStartPoint();
            $this$connectedArc.lineTo(startPoint.getX(), startPoint.getY());
            $this$connectedArc.append(arc, false);
            $this$connectedArc.moveTo(endPoint.getX(), endPoint.getY());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002)*B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\"\u0010\u001b\u001a\u00020\u00142\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d0\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0005H\u0002J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d0\u0019H\u0002J2\u0010\"\u001a\u00020\u0014*\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020%2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0014\u0010&\u001a\u00020'*\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006+"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter;", "Lcom/intellij/refactoring/suggested/SignatureChangePresentation$ConnectionRouter;", "g", "Ljava/awt/Graphics2D;", "oldSignatureBottom", "", "newSignatureTop", "(Ljava/awt/Graphics2D;II)V", "connectionsByHSegmentLevel", "", "Lcom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter$ConnectionData;", "hSegmentLevelsRequired", "getHSegmentLevelsRequired", "()I", "maxX", "getMaxX", "(Lcom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter$ConnectionData;)I", "minX", "getMinX", "drawConnection", "", "oldX", "newX", "levelY", "connectors", "", "Lcom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter$VerticalConnectorData;", "drawConnections", "connectedBounds", "Lkotlin/Pair;", "Ljava/awt/Rectangle;", "drawVerticalConnection", "x", "prepareConnectionData", "horizontalSegmentWithInterruptions", "Ljava/awt/geom/GeneralPath;", "y", "", "overlapsHorizontally", "", "other", "ConnectionData", "VerticalConnectorData", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nSignatureChangePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentationKt\n*L\n1#1,561:1\n288#2:562\n2624#2,3:563\n289#2:566\n766#2:572\n857#2,2:573\n1549#2:575\n1620#2,3:576\n2624#2,3:579\n553#3:567\n553#3:568\n553#3:569\n553#3:570\n553#3:571\n*S KotlinDebug\n*F\n+ 1 SignatureChangePresentation.kt\ncom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter\n*L\n308#1:562\n309#1:563,3\n308#1:566\n438#1:572\n438#1:573,2\n439#1:575\n439#1:576,3\n345#1:579,3\n359#1:567\n361#1:568\n366#1:569\n367#1:570\n374#1:571\n*E\n"})
    private static final class HorizontalModeConnectionRouter
    implements ConnectionRouter {
        @Nullable
        private final Graphics2D g;
        private final int oldSignatureBottom;
        private final int newSignatureTop;
        @NotNull
        private final List<List<ConnectionData>> connectionsByHSegmentLevel;

        public HorizontalModeConnectionRouter(@Nullable Graphics2D g, int oldSignatureBottom, int newSignatureTop) {
            this.g = g;
            this.oldSignatureBottom = oldSignatureBottom;
            this.newSignatureTop = newSignatureTop;
            this.connectionsByHSegmentLevel = new ArrayList();
        }

        public final int getHSegmentLevelsRequired() {
            return this.connectionsByHSegmentLevel.size();
        }

        @Override
        public void drawConnections(@NotNull List<? extends Pair<? extends Rectangle, ? extends Rectangle>> connectedBounds) {
            int newX;
            Intrinsics.checkNotNullParameter(connectedBounds, (String)"connectedBounds");
            List<ConnectionData> connections = this.prepareConnectionData(connectedBounds);
            List connectors = new ArrayList();
            for (ConnectionData connection : connections) {
                Object v1;
                Iterable $this$firstOrNull$iv;
                block13: {
                    if (connection.getOldX() == connection.getNewX()) {
                        connectors.add(new VerticalConnectorData(connection.getOldX(), this.oldSignatureBottom, this.newSignatureTop));
                        this.drawVerticalConnection(connection.getOldX());
                        continue;
                    }
                    $this$firstOrNull$iv = this.connectionsByHSegmentLevel;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        block12: {
                            List connectionsInLevel = (List)element$iv;
                            boolean bl2 = false;
                            Iterable $this$none$iv = connectionsInLevel;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Object element$iv2 : $this$none$iv) {
                                    ConnectionData it = (ConnectionData)element$iv2;
                                    boolean bl3 = false;
                                    if (!this.overlapsHorizontally(it, connection)) continue;
                                    bl = false;
                                    break block12;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) continue;
                        v1 = element$iv;
                        break block13;
                    }
                    v1 = null;
                }
                List level = v1;
                if (level != null) {
                    ((Collection)level).add(connection);
                    continue;
                }
                $this$firstOrNull$iv = this.connectionsByHSegmentLevel;
                Object[] $i$f$firstOrNull = new ConnectionData[]{connection};
                $this$firstOrNull$iv.add(CollectionsKt.mutableListOf((Object[])$i$f$firstOrNull));
            }
            if (this.connectionsByHSegmentLevel.isEmpty()) {
                return;
            }
            int firstLevelY = this.oldSignatureBottom + (this.newSignatureTop - this.oldSignatureBottom - (this.connectionsByHSegmentLevel.size() - 1) * 6) / 2;
            Iterator<List<ConnectionData>> iterator2 = this.connectionsByHSegmentLevel.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int level = n++;
                List<ConnectionData> connectionsInLevel = iterator2.next();
                for (ConnectionData connectionData : connectionsInLevel) {
                    int oldX = connectionData.component1();
                    newX = connectionData.component2();
                    int levelY = HorizontalModeConnectionRouter.drawConnections$levelY(firstLevelY, level);
                    connectors.add(new VerticalConnectorData(oldX, this.oldSignatureBottom, levelY));
                    connectors.add(new VerticalConnectorData(newX, levelY, this.newSignatureTop));
                }
            }
            iterator2 = this.connectionsByHSegmentLevel.iterator();
            n = 0;
            while (iterator2.hasNext()) {
                int level = n++;
                List<ConnectionData> connectionsInLevel = iterator2.next();
                for (ConnectionData connectionData : connectionsInLevel) {
                    int oldX = connectionData.component1();
                    newX = connectionData.component2();
                    this.drawConnection(oldX, newX, HorizontalModeConnectionRouter.drawConnections$levelY(firstLevelY, level), connectors);
                }
            }
        }

        private final List<ConnectionData> prepareConnectionData(List<? extends Pair<? extends Rectangle, ? extends Rectangle>> connectedBounds) {
            List occupiedConnectorX = new ArrayList();
            List data2 = new ArrayList();
            for (Pair<? extends Rectangle, ? extends Rectangle> pair : connectedBounds) {
                Rectangle oldBounds = (Rectangle)pair.component1();
                Rectangle newBounds = (Rectangle)pair.component2();
                int oldX = 0;
                int newX = 0;
                int oldXStep = 0;
                int newXStep = 0;
                Rectangle $this$left$iv = newBounds;
                boolean $i$f$getLeft = false;
                if (SignatureChangePresentationKt.access$getRight(oldBounds) <= $this$left$iv.x) {
                    oldX = SignatureChangePresentationKt.access$getRight(oldBounds) - 1;
                    $this$left$iv = newBounds;
                    $i$f$getLeft = false;
                    newX = $this$left$iv.x + 1;
                    oldXStep = -10;
                    newXStep = 10;
                } else {
                    $this$left$iv = oldBounds;
                    $i$f$getLeft = false;
                    if ($this$left$iv.x >= SignatureChangePresentationKt.access$getRight(newBounds)) {
                        $this$left$iv = oldBounds;
                        $i$f$getLeft = false;
                        oldX = $this$left$iv.x + 1;
                        newX = SignatureChangePresentationKt.access$getRight(newBounds) - 1;
                        oldXStep = 10;
                        newXStep = -10;
                    } else {
                        Rectangle $this$left$iv232 = oldBounds;
                        boolean $i$f$getLeft2 = false;
                        int $this$left$iv232 = $this$left$iv232.x;
                        Rectangle $this$left$iv3 = newBounds;
                        boolean $i$f$getLeft3 = false;
                        int n = $this$left$iv3.x;
                        int left = Math.max($this$left$iv232, n);
                        int right = Math.min(SignatureChangePresentationKt.access$getRight(oldBounds), SignatureChangePresentationKt.access$getRight(newBounds));
                        newX = oldX = (left + right) / 2;
                        oldXStep = 0;
                        newXStep = 0;
                    }
                }
                if (oldX != newX) {
                    if (Math.abs(oldX - newX) < 25) {
                        oldX = MathKt.roundToInt((double)oldBounds.getCenterX());
                        newX = MathKt.roundToInt((double)newBounds.getCenterX());
                    }
                    oldX = HorizontalModeConnectionRouter.prepareConnectionData$chooseConnectorX(occupiedConnectorX, oldX, oldXStep);
                    newX = HorizontalModeConnectionRouter.prepareConnectionData$chooseConnectorX(occupiedConnectorX, newX, newXStep);
                }
                ((Collection)data2).add(new ConnectionData(oldX, newX));
            }
            return data2;
        }

        /*
         * WARNING - void declaration
         */
        private final void drawConnection(int oldX, int newX, int levelY, List<VerticalConnectorData> connectors) {
            block2: {
                void $this$drawConnection_u24lambda_u243;
                GeneralPath generalPath;
                double oldXD = oldX;
                double newXD = newX;
                double levelYD = levelY;
                double d = 8.0;
                Graphics2D graphics2D = this.g;
                if (graphics2D == null) break block2;
                GeneralPath generalPath2 = generalPath = new GeneralPath();
                Graphics2D graphics2D2 = graphics2D;
                boolean bl = false;
                $this$drawConnection_u24lambda_u243.moveTo(oldXD, (double)this.oldSignatureBottom);
                $this$drawConnection_u24lambda_u243.lineTo(oldXD, levelYD - d / (double)2);
                if (oldXD < newXD) {
                    $this$drawConnection_u24lambda_u243.append(new Arc2D.Double(oldXD, levelYD - d, d, d, 180.0, 90.0, 0), false);
                    $this$drawConnection_u24lambda_u243.moveTo(oldXD + d / (double)2, levelYD);
                    this.horizontalSegmentWithInterruptions((GeneralPath)$this$drawConnection_u24lambda_u243, levelYD, oldXD + d / (double)2, newXD - d / (double)2, connectors);
                    $this$drawConnection_u24lambda_u243.append(new Arc2D.Double(newXD - d, levelYD, d, d, 0.0, 90.0, 0), false);
                } else {
                    $this$drawConnection_u24lambda_u243.append(new Arc2D.Double(oldXD - d, levelYD - d, d, d, 270.0, 90.0, 0), false);
                    $this$drawConnection_u24lambda_u243.moveTo(oldXD - d / (double)2, levelYD);
                    this.horizontalSegmentWithInterruptions((GeneralPath)$this$drawConnection_u24lambda_u243, levelYD, newXD + d / (double)2, oldXD - d / (double)2, connectors);
                    $this$drawConnection_u24lambda_u243.append(new Arc2D.Double(newXD, levelYD, d, d, 90.0, 90.0, 0), false);
                }
                $this$drawConnection_u24lambda_u243.moveTo(newXD, levelYD + d / (double)2);
                $this$drawConnection_u24lambda_u243.lineTo(newXD, (double)this.newSignatureTop);
                graphics2D2.draw(generalPath);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void drawVerticalConnection(int x) {
            block0: {
                void $this$drawVerticalConnection_u24lambda_u244;
                GeneralPath generalPath;
                Graphics2D graphics2D = this.g;
                if (graphics2D == null) break block0;
                GeneralPath generalPath2 = generalPath = new GeneralPath();
                Graphics2D graphics2D2 = graphics2D;
                boolean bl = false;
                $this$drawVerticalConnection_u24lambda_u244.moveTo((double)x, (double)this.oldSignatureBottom);
                $this$drawVerticalConnection_u24lambda_u244.lineTo((double)x, (double)this.newSignatureTop);
                graphics2D2.draw(generalPath);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void horizontalSegmentWithInterruptions(GeneralPath $this$horizontalSegmentWithInterruptions, double y, double minX, double maxX, List<VerticalConnectorData> connectors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            VerticalConnectorData it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            if (minX >= maxX) {
                return;
            }
            Iterable iterable = connectors;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VerticalConnectorData)element$iv$iv;
                boolean bl = false;
                if (!(minX < (double)it.getX() && (double)it.getX() < maxX && (double)it.getMinY() < y && y < (double)it.getMaxY())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VerticalConnectorData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getX());
            }
            List interruptions = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            double x = minX;
            $this$horizontalSegmentWithInterruptions.moveTo(x, y);
            iterator2 = interruptions.iterator();
            while (iterator2.hasNext()) {
                int interruption = ((Number)iterator2.next()).intValue();
                $this$horizontalSegmentWithInterruptions.lineTo((double)(interruption - 1 - 2), y);
                x = interruption + 1 + 2;
                $this$horizontalSegmentWithInterruptions.moveTo(x, y);
            }
            $this$horizontalSegmentWithInterruptions.lineTo(maxX, y);
        }

        private final int getMinX(ConnectionData $this$minX) {
            return Math.min($this$minX.getOldX(), $this$minX.getNewX());
        }

        private final int getMaxX(ConnectionData $this$maxX) {
            return Math.max($this$maxX.getOldX(), $this$maxX.getNewX());
        }

        private final boolean overlapsHorizontally(ConnectionData $this$overlapsHorizontally, ConnectionData other) {
            if (this.getMinX($this$overlapsHorizontally) > this.getMaxX(other)) {
                return false;
            }
            return this.getMaxX($this$overlapsHorizontally) >= this.getMinX(other);
        }

        private static final int drawConnections$levelY(int firstLevelY, int level) {
            return firstLevelY + level * 6;
        }

        private static final int prepareConnectionData$chooseConnectorX(List<Integer> occupiedConnectorX, int x, int step2) {
            boolean bl;
            block4: {
                Iterable $this$none$iv = occupiedConnectorX;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (!(Math.abs(it - x) < 10)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                occupiedConnectorX.add(x);
                return x;
            }
            return HorizontalModeConnectionRouter.prepareConnectionData$chooseConnectorX(occupiedConnectorX, x + step2, step2);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter$ConnectionData;", "", "oldX", "", "newX", "(II)V", "getNewX", "()I", "getOldX", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
        private static final class ConnectionData {
            private final int oldX;
            private final int newX;

            public ConnectionData(int oldX, int newX) {
                this.oldX = oldX;
                this.newX = newX;
            }

            public final int getOldX() {
                return this.oldX;
            }

            public final int getNewX() {
                return this.newX;
            }

            public final int component1() {
                return this.oldX;
            }

            public final int component2() {
                return this.newX;
            }

            @NotNull
            public final ConnectionData copy(int oldX, int newX) {
                return new ConnectionData(oldX, newX);
            }

            public static /* synthetic */ ConnectionData copy$default(ConnectionData connectionData, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = connectionData.oldX;
                }
                if ((n3 & 2) != 0) {
                    n2 = connectionData.newX;
                }
                return connectionData.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "ConnectionData(oldX=" + this.oldX + ", newX=" + this.newX + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.oldX);
                result2 = result2 * 31 + Integer.hashCode(this.newX);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConnectionData)) {
                    return false;
                }
                ConnectionData connectionData = (ConnectionData)other;
                if (this.oldX != connectionData.oldX) {
                    return false;
                }
                return this.newX == connectionData.newX;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation$HorizontalModeConnectionRouter$VerticalConnectorData;", "", "x", "", "minY", "maxY", "(III)V", "getMaxY", "()I", "getMinY", "getX", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
        private static final class VerticalConnectorData {
            private final int x;
            private final int minY;
            private final int maxY;

            public VerticalConnectorData(int x, int minY, int maxY) {
                this.x = x;
                this.minY = minY;
                this.maxY = maxY;
            }

            public final int getX() {
                return this.x;
            }

            public final int getMinY() {
                return this.minY;
            }

            public final int getMaxY() {
                return this.maxY;
            }

            public final int component1() {
                return this.x;
            }

            public final int component2() {
                return this.minY;
            }

            public final int component3() {
                return this.maxY;
            }

            @NotNull
            public final VerticalConnectorData copy(int x, int minY, int maxY) {
                return new VerticalConnectorData(x, minY, maxY);
            }

            public static /* synthetic */ VerticalConnectorData copy$default(VerticalConnectorData verticalConnectorData, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = verticalConnectorData.x;
                }
                if ((n4 & 2) != 0) {
                    n2 = verticalConnectorData.minY;
                }
                if ((n4 & 4) != 0) {
                    n3 = verticalConnectorData.maxY;
                }
                return verticalConnectorData.copy(n, n2, n3);
            }

            @NotNull
            public String toString() {
                return "VerticalConnectorData(x=" + this.x + ", minY=" + this.minY + ", maxY=" + this.maxY + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.x);
                result2 = result2 * 31 + Integer.hashCode(this.minY);
                result2 = result2 * 31 + Integer.hashCode(this.maxY);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VerticalConnectorData)) {
                    return false;
                }
                VerticalConnectorData verticalConnectorData = (VerticalConnectorData)other;
                if (this.x != verticalConnectorData.x) {
                    return false;
                }
                if (this.minY != verticalConnectorData.minY) {
                    return false;
                }
                return this.maxY == verticalConnectorData.maxY;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangePresentation$Constants;", "", "()V", "backgroundGap", "", "betweenConnectorsHSpace", "betweenHSegmentsVSpace", "betweenSignaturesConnectionStraightPart", "betweenSignaturesHSpace", "betweenSignaturesVSpace", "betweenSignaturesVSpaceWithOneHSegment", "bottomSpace", "connectionLineThickness", "hLineInterruptionGap", "indentInVerticalMode", "leftSpace", "minHSegmentLength", "rectangularConnectionArcR", "", "rightSpace", "topSpace", "verticalModeArcW", "intellij.platform.lang.impl"})
    private static final class Constants {
        private Constants() {
        }

        public /* synthetic */ Constants(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

