/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.RefactoringAvailableGutterIconRenderer;
import com.intellij.refactoring.suggested.RefactoringDisabledGutterIconRenderer;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicator;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0006\u0018\u0000 !2\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013J0\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000f2\b\b\u0001\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "caretListener", "com/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$caretListener$1", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$caretListener$1;", "data", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$Data;", "editorsAndHighlighters", "", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "hasData", "", "getHasData", "()Z", "attachToEditor", "", "editor", "clear", "disable", "show", "document", "Lcom/intellij/openapi/editor/Document;", "markerRange", "Lcom/intellij/openapi/util/TextRange;", "availabilityRange", "refactoringEnabled", "tooltip", "", "updateHighlighter", "Companion", "Data", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSuggestedRefactoringAvailabilityIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestedRefactoringAvailabilityIndicator.kt\ncom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n1#2:297\n*E\n"})
public final class SuggestedRefactoringAvailabilityIndicator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Data data;
    @NotNull
    private final Map<Editor, RangeHighlighter> editorsAndHighlighters;
    @NotNull
    private final caretListener.1 caretListener;
    @NotNull
    private static final String disabledRefactoringTooltip;

    public SuggestedRefactoringAvailabilityIndicator(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.editorsAndHighlighters = new LinkedHashMap();
        this.caretListener = new CaretListener(this){
            final /* synthetic */ SuggestedRefactoringAvailabilityIndicator this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"event.editor");
                SuggestedRefactoringAvailabilityIndicator.access$updateHighlighter(this.this$0, editor2);
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"event.editor");
                this.attachToEditor(editor2);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                editorsAndHighlighters.remove(event.getEditor());
            }
        }, (Disposable)this.project);
    }

    /*
     * WARNING - void declaration
     */
    public final void show(@NotNull Document document, @NotNull TextRange markerRange, @NotNull TextRange availabilityRange, boolean refactoringEnabled, @NlsContexts.Tooltip @NotNull String tooltip) {
        void $this$show_u24lambda_u240;
        RangeMarker rangeMarker;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)markerRange, (String)"markerRange");
        Intrinsics.checkNotNullParameter((Object)availabilityRange, (String)"availabilityRange");
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeMarker rangeMarker2 = document.createRangeMarker(markerRange);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"document.createRangeMarker(markerRange)");
        RangeMarker rangeMarker3 = rangeMarker = document.createRangeMarker(availabilityRange);
        RangeMarker rangeMarker4 = rangeMarker2;
        Document document2 = document;
        boolean bl = false;
        $this$show_u24lambda_u240.setGreedyToLeft(true);
        $this$show_u24lambda_u240.setGreedyToRight(true);
        Unit unit = Unit.INSTANCE;
        RangeMarker rangeMarker5 = rangeMarker;
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker5, (String)"document.createRangeMark\u2026 isGreedyToRight = true }");
        String string2 = tooltip;
        boolean bl2 = refactoringEnabled;
        RangeMarker rangeMarker6 = rangeMarker5;
        RangeMarker rangeMarker7 = rangeMarker4;
        Document document3 = document2;
        Data newData = new Data(document3, rangeMarker7, rangeMarker6, bl2, string2);
        if (Intrinsics.areEqual((Object)newData, (Object)this.data)) {
            return;
        }
        this.clear();
        this.data = newData;
        EditorFactory.getInstance().editors(document, this.project).forEach(arg_0 -> SuggestedRefactoringAvailabilityIndicator.show$lambda$1((Function1)new Function1<Editor, Unit>((Object)this){

            public final void invoke(@NotNull Editor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                SuggestedRefactoringAvailabilityIndicator.access$attachToEditor((SuggestedRefactoringAvailabilityIndicator)this.receiver, p0);
            }
        }, arg_0));
    }

    public final void clear() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.data == null) {
            return;
        }
        this.data = null;
        for (Map.Entry<Editor, RangeHighlighter> entry : this.editorsAndHighlighters.entrySet()) {
            RangeHighlighter it;
            Editor editor2 = entry.getKey();
            RangeHighlighter highlighter = entry.getValue();
            editor2.getCaretModel().removeCaretListener((CaretListener)this.caretListener);
            if (highlighter == null) continue;
            boolean bl = false;
            editor2.getMarkupModel().removeHighlighter(it);
        }
        this.editorsAndHighlighters.clear();
    }

    public final void disable() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Data data2 = this.data;
        if (data2 == null) {
            return;
        }
        Data data3 = data2;
        if (data3.getRefactoringEnabled()) {
            TextRange textRange = UtilsKt.getRange(data3.getHighlighterRangeMarker());
            if (textRange == null) {
                return;
            }
            TextRange textRange2 = UtilsKt.getRange(data3.getAvailabilityRangeMarker());
            if (textRange2 == null) {
                return;
            }
            this.show(data3.getDocument(), textRange, textRange2, false, data3.getTooltip());
        }
    }

    @TestOnly
    public final boolean getHasData() {
        return this.data != null;
    }

    private final void attachToEditor(Editor editor2) {
        Data data2 = this.data;
        if (Intrinsics.areEqual((Object)editor2.getDocument(), (Object)(data2 != null ? data2.getDocument() : null))) {
            editor2.getCaretModel().addCaretListener((CaretListener)this.caretListener);
            this.updateHighlighter(editor2);
        }
    }

    private final void updateHighlighter(Editor editor2) {
        GutterIconRenderer gutterIconRenderer;
        Object object;
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter prevHighlighter = this.editorsAndHighlighters.get(editor2);
        if (prevHighlighter != null) {
            editor2.getMarkupModel().removeHighlighter(prevHighlighter);
            this.editorsAndHighlighters.remove(editor2);
        }
        if ((object = this.data) == null || (object = ((Data)object).getAvailabilityRangeMarker()) == null || (object = UtilsKt.getRange((RangeMarker)object)) == null) {
            return;
        }
        Object range = object;
        if (!((TextRange)range).containsOffset(editor2.getCaretModel().getOffset())) {
            return;
        }
        Data data2 = this.data;
        Intrinsics.checkNotNull((Object)data2);
        TextRange textRange = UtilsKt.getRange(data2.getHighlighterRangeMarker());
        if (textRange == null) {
            return;
        }
        TextRange highlighterRange = textRange;
        RangeHighlighter rangeHighlighter = editor2.getMarkupModel().addRangeHighlighter(highlighterRange.getStartOffset(), highlighterRange.getEndOffset(), 6000, new TextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"editor.markupModel.addRa\u2026getArea.EXACT_RANGE\n    )");
        RangeHighlighter highlighter = rangeHighlighter;
        Data data3 = this.data;
        Intrinsics.checkNotNull((Object)data3);
        if (data3.getRefactoringEnabled()) {
            Data data4 = this.data;
            Intrinsics.checkNotNull((Object)data4);
            gutterIconRenderer = new RefactoringAvailableGutterIconRenderer(data4.getTooltip());
        } else {
            Data data5 = this.data;
            Intrinsics.checkNotNull((Object)data5);
            gutterIconRenderer = new RefactoringDisabledGutterIconRenderer(data5.getTooltip());
        }
        highlighter.setGutterIconRenderer(gutterIconRenderer);
        this.editorsAndHighlighters.put(editor2, highlighter);
    }

    private static final void show$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$updateHighlighter(SuggestedRefactoringAvailabilityIndicator $this, Editor editor2) {
        $this.updateHighlighter(editor2);
    }

    static {
        String string2 = RefactoringBundle.message((String)"suggested.refactoring.disabled.gutter.icon.tooltip");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"suggested.refac\u2026led.gutter.icon.tooltip\")");
        disabledRefactoringTooltip = string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$Data;", "", "document", "Lcom/intellij/openapi/editor/Document;", "highlighterRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "availabilityRangeMarker", "refactoringEnabled", "", "tooltip", "", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/openapi/editor/RangeMarker;ZLjava/lang/String;)V", "getAvailabilityRangeMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getHighlighterRangeMarker", "getRefactoringEnabled", "()Z", "getTooltip", "()Ljava/lang/String;", "equals", "other", "hashCode", "", "intellij.platform.lang.impl"})
    private static final class Data {
        @NotNull
        private final Document document;
        @NotNull
        private final RangeMarker highlighterRangeMarker;
        @NotNull
        private final RangeMarker availabilityRangeMarker;
        private final boolean refactoringEnabled;
        @NotNull
        private final String tooltip;

        public Data(@NotNull Document document, @NotNull RangeMarker highlighterRangeMarker, @NotNull RangeMarker availabilityRangeMarker, boolean refactoringEnabled, @NlsContexts.Tooltip @NotNull String tooltip) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)highlighterRangeMarker, (String)"highlighterRangeMarker");
            Intrinsics.checkNotNullParameter((Object)availabilityRangeMarker, (String)"availabilityRangeMarker");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            this.document = document;
            this.highlighterRangeMarker = highlighterRangeMarker;
            this.availabilityRangeMarker = availabilityRangeMarker;
            this.refactoringEnabled = refactoringEnabled;
            this.tooltip = tooltip;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final RangeMarker getHighlighterRangeMarker() {
            return this.highlighterRangeMarker;
        }

        @NotNull
        public final RangeMarker getAvailabilityRangeMarker() {
            return this.availabilityRangeMarker;
        }

        public final boolean getRefactoringEnabled() {
            return this.refactoringEnabled;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Data && Intrinsics.areEqual((Object)((Data)other).document, (Object)this.document) && Intrinsics.areEqual((Object)UtilsKt.getRange(((Data)other).highlighterRangeMarker), (Object)UtilsKt.getRange(this.highlighterRangeMarker)) && Intrinsics.areEqual((Object)UtilsKt.getRange(((Data)other).availabilityRangeMarker), (Object)UtilsKt.getRange(this.availabilityRangeMarker)) && ((Data)other).refactoringEnabled == this.refactoringEnabled && Intrinsics.areEqual((Object)((Data)other).tooltip, (Object)this.tooltip);
        }

        public int hashCode() {
            return this.tooltip.hashCode();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$Companion;", "", "()V", "disabledRefactoringTooltip", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDisabledRefactoringTooltip", "()Ljava/lang/String;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDisabledRefactoringTooltip() {
            return disabledRefactoringTooltip;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

