/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.SuggestedChangeSignatureData;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicator;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicatorKt;
import com.intellij.refactoring.suggested.SuggestedRefactoringData;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.SuggestedRenameData;
import com.intellij.refactoring.suggested.TextRangeUtilsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a&\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a8\u0006\r"}, d2={"intentionActionShortcutHint", "", "changeSignatureAvailabilityRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "anchor", "Lcom/intellij/psi/PsiElement;", "update", "", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator;", "refactoringData", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringData;", "refactoringSupport", "intellij.platform.lang.impl"})
public final class SuggestedRefactoringAvailabilityIndicatorKt {
    public static final void update(@NotNull SuggestedRefactoringAvailabilityIndicator $this$update, @NotNull PsiElement anchor, @Nullable SuggestedRefactoringData refactoringData, @NotNull SuggestedRefactoringSupport refactoringSupport) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)refactoringSupport, (String)"refactoringSupport");
        PsiFile psiFile = anchor.getContainingFile();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(psiFile.getProject());
        Document document = psiDocumentManager.getDocument(psiFile);
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        if (!psiDocumentManager.isCommitted(document2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        boolean refactoringAvailable = false;
        String tooltip = null;
        TextRange markerRange = null;
        TextRange availabilityRange = null;
        SuggestedRefactoringData suggestedRefactoringData = refactoringData;
        if (suggestedRefactoringData instanceof SuggestedRenameData) {
            refactoringAvailable = true;
            Object[] objectArray = new Object[]{((SuggestedRenameData)refactoringData).getOldName(), ((SuggestedRenameData)refactoringData).getDeclaration().getName(), SuggestedRefactoringAvailabilityIndicatorKt.intentionActionShortcutHint()};
            String string3 = RefactoringBundle.message((String)"suggested.refactoring.rename.gutter.icon.tooltip", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\n        \"sugges\u2026ionShortcutHint()\n      )");
            tooltip = string3;
            TextRange textRange = refactoringSupport.nameRange(((SuggestedRenameData)refactoringData).getDeclaration());
            Intrinsics.checkNotNull((Object)textRange);
            availabilityRange = markerRange = textRange;
        } else if (suggestedRefactoringData instanceof SuggestedChangeSignatureData) {
            refactoringAvailable = true;
            Object[] objectArray = new Object[]{((SuggestedChangeSignatureData)refactoringData).getNameOfStuffToUpdate(), ((SuggestedChangeSignatureData)refactoringData).getOldSignature().getName(), SuggestedRefactoringAvailabilityIndicatorKt.intentionActionShortcutHint()};
            String string4 = RefactoringBundle.message((String)"suggested.refactoring.change.signature.gutter.icon.tooltip", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\n        \"sugges\u2026ionShortcutHint()\n      )");
            tooltip = string4;
            TextRange textRange = refactoringSupport.nameRange(((SuggestedChangeSignatureData)refactoringData).getAnchor());
            Intrinsics.checkNotNull((Object)textRange);
            markerRange = textRange;
            availabilityRange = SuggestedRefactoringAvailabilityIndicatorKt.changeSignatureAvailabilityRange(refactoringSupport, ((SuggestedChangeSignatureData)refactoringData).getAnchor());
        } else if (suggestedRefactoringData == null) {
            refactoringAvailable = false;
            tooltip = SuggestedRefactoringAvailabilityIndicator.Companion.getDisabledRefactoringTooltip();
            TextRange textRange = refactoringSupport.nameRange(anchor);
            Intrinsics.checkNotNull((Object)textRange);
            markerRange = textRange;
            availabilityRange = SuggestedRefactoringAvailabilityIndicatorKt.changeSignatureAvailabilityRange(refactoringSupport, anchor);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            SuggestedRefactoringAvailabilityIndicatorKt.update$doUpdate(availabilityRange, $this$update, document2, markerRange, refactoringAvailable, tooltip);
        } else {
            long modificationStamp = document2.getModificationStamp();
            ApplicationManager.getApplication().invokeLater(() -> SuggestedRefactoringAvailabilityIndicatorKt.update$lambda$0(document2, modificationStamp, availabilityRange, $this$update, markerRange, refactoringAvailable, tooltip));
        }
    }

    private static final String intentionActionShortcutHint() {
        KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowIntentionActions");
        if (keyboardShortcut == null) {
            return "";
        }
        KeyboardShortcut shortcut = keyboardShortcut;
        return "(" + KeymapUtil.getShortcutText((Shortcut)((Shortcut)shortcut)) + ")";
    }

    @Nullable
    public static final TextRange changeSignatureAvailabilityRange(@NotNull SuggestedRefactoringSupport $this$changeSignatureAvailabilityRange, @NotNull PsiElement anchor) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)$this$changeSignatureAvailabilityRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PsiFile file2 = anchor.getContainingFile();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(file2.getProject());
        Document document = psiDocumentManager.getDocument(file2);
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        if (!psiDocumentManager.isCommitted(document2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        TextRange textRange2 = $this$changeSignatureAvailabilityRange.signatureRange(anchor);
        if (textRange2 != null) {
            CharSequence charSequence = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
            textRange = TextRangeUtilsKt.extend(textRange2, charSequence, (Function1<? super Character, Boolean>)((Function1)changeSignatureAvailabilityRange.1.INSTANCE));
        } else {
            textRange = null;
        }
        return textRange;
    }

    private static final void update$doUpdate(TextRange availabilityRange, SuggestedRefactoringAvailabilityIndicator $this_update, Document document, TextRange markerRange, boolean refactoringAvailable, String tooltip) {
        if (availabilityRange != null) {
            $this_update.show(document, markerRange, availabilityRange, refactoringAvailable, tooltip);
        } else {
            $this_update.clear();
        }
    }

    private static final void update$lambda$0(Document $document, long $modificationStamp, TextRange $availabilityRange, SuggestedRefactoringAvailabilityIndicator $this_update, TextRange $markerRange, boolean $refactoringAvailable, String $tooltip) {
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$this_update, (String)"$this_update");
        Intrinsics.checkNotNullParameter((Object)$markerRange, (String)"$markerRange");
        Intrinsics.checkNotNullParameter((Object)$tooltip, (String)"$tooltip");
        if ($document.getModificationStamp() == $modificationStamp) {
            SuggestedRefactoringAvailabilityIndicatorKt.update$doUpdate($availabilityRange, $this_update, $document, $markerRange, $refactoringAvailable, $tooltip);
        }
    }
}

