/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicator;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicatorKt;
import com.intellij.refactoring.suggested.SuggestedRefactoringData;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.suggested.SuggestedRefactoringSignatureWatcher;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u001d\u001a\u00020\u0012H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeCollector;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSignatureWatcher;", "availabilityIndicator", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator;", "(Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator;)V", "value", "", "_amendStateInBackgroundEnabled", "get_amendStateInBackgroundEnabled", "()Z", "set_amendStateInBackgroundEnabled", "(Z)V", "<set-?>", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "state", "getState", "()Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "amendStateInBackground", "", "editingStarted", "declaration", "Lcom/intellij/psi/PsiElement;", "refactoringSupport", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "inconsistentState", "nextSignature", "anchor", "reset", "undoToState", "updateAvailabilityIndicator", "EditingStartedUndoableAction", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSuggestedRefactoringChangeCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestedRefactoringChangeCollector.kt\ncom/intellij/refactoring/suggested/SuggestedRefactoringChangeCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,138:1\n1#2:139\n32#3,2:140\n*S KotlinDebug\n*F\n+ 1 SuggestedRefactoringChangeCollector.kt\ncom/intellij/refactoring/suggested/SuggestedRefactoringChangeCollector\n*L\n76#1:140,2\n*E\n"})
public final class SuggestedRefactoringChangeCollector
implements SuggestedRefactoringSignatureWatcher {
    @NotNull
    private final SuggestedRefactoringAvailabilityIndicator availabilityIndicator;
    @Nullable
    private volatile SuggestedRefactoringState state;
    private boolean _amendStateInBackgroundEnabled;

    public SuggestedRefactoringChangeCollector(@NotNull SuggestedRefactoringAvailabilityIndicator availabilityIndicator) {
        Intrinsics.checkNotNullParameter((Object)availabilityIndicator, (String)"availabilityIndicator");
        this.availabilityIndicator = availabilityIndicator;
        this._amendStateInBackgroundEnabled = !ApplicationManager.getApplication().isUnitTestMode();
    }

    @Nullable
    public final SuggestedRefactoringState getState() {
        return this.state;
    }

    @Override
    public void editingStarted(@NotNull PsiElement declaration, @NotNull SuggestedRefactoringSupport refactoringSupport) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)refactoringSupport, (String)"refactoringSupport");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!declaration.isValid()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.state = refactoringSupport.getStateChanges().createInitialState(declaration);
        this.updateAvailabilityIndicator();
        this.amendStateInBackground();
        Project project2 = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"declaration.project");
        Project project3 = project2;
        Document document = PsiDocumentManager.getInstance(project3).getDocument(declaration.getContainingFile());
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        UndoManager.getInstance(project3).undoableActionPerformed(new EditingStartedUndoableAction(document2, project3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void nextSignature(@NotNull PsiElement anchor, @NotNull SuggestedRefactoringSupport refactoringSupport) {
        SuggestedRefactoringState suggestedRefactoringState;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)refactoringSupport, (String)"refactoringSupport");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!anchor.isValid()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        SuggestedRefactoringChangeCollector suggestedRefactoringChangeCollector = this;
        SuggestedRefactoringState suggestedRefactoringState2 = this.state;
        if (suggestedRefactoringState2 != null) {
            void it;
            SuggestedRefactoringState suggestedRefactoringState3 = suggestedRefactoringState2;
            SuggestedRefactoringChangeCollector suggestedRefactoringChangeCollector2 = suggestedRefactoringChangeCollector;
            boolean bl = false;
            suggestedRefactoringState = refactoringSupport.getStateChanges().updateState((SuggestedRefactoringState)it, anchor);
            suggestedRefactoringChangeCollector = suggestedRefactoringChangeCollector2;
        } else {
            suggestedRefactoringState = null;
        }
        suggestedRefactoringChangeCollector.state = suggestedRefactoringState;
        this.updateAvailabilityIndicator();
        this.amendStateInBackground();
    }

    @Override
    public void inconsistentState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        SuggestedRefactoringState suggestedRefactoringState = this.state;
        this.state = suggestedRefactoringState != null ? suggestedRefactoringState.withErrorLevel(SuggestedRefactoringState.ErrorLevel.INCONSISTENT) : null;
        this.updateAvailabilityIndicator();
    }

    @Override
    public void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.state = null;
        this.updateAvailabilityIndicator();
    }

    public final void undoToState(@NotNull SuggestedRefactoringState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.state = state;
        this.updateAvailabilityIndicator();
        this.amendStateInBackground();
    }

    private final void amendStateInBackground() {
        if (!this._amendStateInBackgroundEnabled) {
            return;
        }
        Ref.ObjectRef initialState = new Ref.ObjectRef();
        SuggestedRefactoringState suggestedRefactoringState = this.state;
        if (suggestedRefactoringState == null) {
            return;
        }
        initialState.element = suggestedRefactoringState;
        Object stateLock = new Object();
        if (!(((SuggestedRefactoringState)initialState.element).getErrorLevel() != SuggestedRefactoringState.ErrorLevel.INCONSISTENT)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        PsiFile psiFile = ((SuggestedRefactoringState)initialState.element).getAnchor().getContainingFile();
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        Project project3 = project2;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project3);
        Document document = psiDocumentManager.getDocument(psiFile);
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> SuggestedRefactoringChangeCollector.amendStateInBackground$lambda$4(initialState, stateLock, psiDocumentManager, document2, this)).coalesceBy(objectArray).inSmartMode(project3).expireWhen(() -> SuggestedRefactoringChangeCollector.amendStateInBackground$lambda$6(stateLock, this, initialState)).expireWith(project3).submit(AppExecutorUtil.getAppExecutorService());
    }

    private final void updateAvailabilityIndicator() {
        SuggestedRefactoringState state = this.state;
        if (state == null || Intrinsics.areEqual((Object)state.getOldSignature(), (Object)state.getNewSignature()) && state.getErrorLevel() == SuggestedRefactoringState.ErrorLevel.NO_ERRORS) {
            this.availabilityIndicator.clear();
            return;
        }
        SuggestedRefactoringSupport refactoringSupport = state.getRefactoringSupport();
        if (!state.getAnchor().isValid() || refactoringSupport.nameRange(state.getAnchor()) == null) {
            this.availabilityIndicator.disable();
            return;
        }
        SuggestedRefactoringData refactoringData = state.getErrorLevel() == SuggestedRefactoringState.ErrorLevel.NO_ERRORS ? refactoringSupport.getAvailability().detectAvailableRefactoring(state) : null;
        SuggestedRefactoringAvailabilityIndicatorKt.update(this.availabilityIndicator, state.getAnchor(), refactoringData, refactoringSupport);
    }

    public final boolean get_amendStateInBackgroundEnabled() {
        return this._amendStateInBackgroundEnabled;
    }

    @TestOnly
    public final void set_amendStateInBackgroundEnabled(boolean value) {
        if (value != this._amendStateInBackgroundEnabled) {
            this._amendStateInBackgroundEnabled = value;
            if (value) {
                SuggestedRefactoringState suggestedRefactoringState = this.state;
                if ((suggestedRefactoringState != null ? suggestedRefactoringState.getErrorLevel() : null) != SuggestedRefactoringState.ErrorLevel.INCONSISTENT) {
                    this.amendStateInBackground();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void amendStateInBackground$lambda$4$lambda$3$lambda$2(Object $stateLock, PsiDocumentManager $psiDocumentManager, Document $document, SuggestedRefactoringChangeCollector this$0, Ref.ObjectRef $initialState, SuggestedRefactoringState $newState) {
        Intrinsics.checkNotNullParameter((Object)$stateLock, (String)"$stateLock");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$initialState, (String)"$initialState");
        Intrinsics.checkNotNullParameter((Object)$newState, (String)"$newState");
        Object object = $stateLock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.state != $initialState.element) {
                return;
            }
            this$0.state = $newState;
            $initialState.element = $newState;
            Unit unit = Unit.INSTANCE;
        }
        if ($psiDocumentManager.isCommitted($document)) {
            this$0.updateAvailabilityIndicator();
        }
    }

    private static final void amendStateInBackground$lambda$4(Ref.ObjectRef $initialState, Object $stateLock, PsiDocumentManager $psiDocumentManager, Document $document, SuggestedRefactoringChangeCollector this$0) {
        Iterator<SuggestedRefactoringState> states;
        Intrinsics.checkNotNullParameter((Object)$initialState, (String)"$initialState");
        Intrinsics.checkNotNullParameter((Object)$stateLock, (String)"$stateLock");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterator<SuggestedRefactoringState> $this$forEach$iv = states = ((SuggestedRefactoringState)$initialState.element).getRefactoringSupport().getAvailability().amendStateInBackground((SuggestedRefactoringState)$initialState.element);
        boolean $i$f$forEach = false;
        Iterator<SuggestedRefactoringState> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            SuggestedRefactoringState element$iv;
            SuggestedRefactoringState newState = element$iv = iterator2.next();
            boolean bl = false;
            ApplicationManager.getApplication().invokeLater(() -> SuggestedRefactoringChangeCollector.amendStateInBackground$lambda$4$lambda$3$lambda$2($stateLock, $psiDocumentManager, $document, this$0, $initialState, newState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean amendStateInBackground$lambda$6(Object $stateLock, SuggestedRefactoringChangeCollector this$0, Ref.ObjectRef $initialState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$stateLock, (String)"$stateLock");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$initialState, (String)"$initialState");
        Object object = $stateLock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this$0.state != $initialState.element;
        }
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeCollector$EditingStartedUndoableAction;", "Lcom/intellij/openapi/command/undo/BasicUndoableAction;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;)V", "redo", "", "undo", "intellij.platform.lang.impl"})
    private static final class EditingStartedUndoableAction
    extends BasicUndoableAction {
        @NotNull
        private final Project project;

        public EditingStartedUndoableAction(@NotNull Document document, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Document[] documentArray = new Document[]{document};
            super(documentArray);
            this.project = project2;
        }

        @Override
        public void undo() {
            SuggestedRefactoringProvider.Companion.getInstance(this.project).reset();
        }

        @Override
        public void redo() {
        }
    }
}

