/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.PerformSuggestedRefactoringKt;
import com.intellij.refactoring.suggested.SuggestedChangeSignatureData;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicatorKt;
import com.intellij.refactoring.suggested.SuggestedRefactoringData;
import com.intellij.refactoring.suggested.SuggestedRefactoringFeatureUsage;
import com.intellij.refactoring.suggested.SuggestedRefactoringProviderImpl;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.SuggestedRenameData;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringIntentionContributor;", "Lcom/intellij/codeInsight/daemon/impl/IntentionMenuContributor;", "()V", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "collectActions", "", "hostEditor", "Lcom/intellij/openapi/editor/Editor;", "hostFile", "Lcom/intellij/psi/PsiFile;", "intentions", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "passIdToShowIntentionsFor", "", "offset", "MyIntention", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSuggestedRefactoringIntentionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestedRefactoringIntentionContributor.kt\ncom/intellij/refactoring/suggested/SuggestedRefactoringIntentionContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class SuggestedRefactoringIntentionContributor
implements IntentionMenuContributor {
    @NotNull
    private final Icon icon;

    public SuggestedRefactoringIntentionContributor() {
        Icon icon2 = AllIcons.Actions.SuggestedRefactoringBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SuggestedRefactoringBulb");
        this.icon = icon2;
    }

    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset2) {
        List<HighlightInfo.IntentionActionDescriptor> list2;
        String string2;
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)hostEditor, (String)"hostEditor");
        Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)intentions, (String)"intentions");
        Project project2 = hostFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"hostFile.project");
        Project project3 = project2;
        if (LightEdit.owns((Project)project3)) {
            return;
        }
        SuggestedRefactoringProviderImpl refactoringProvider = SuggestedRefactoringProviderImpl.Companion.getInstance(project3);
        SuggestedRefactoringState state = refactoringProvider.getState();
        if (state == null) {
            return;
        }
        PsiElement anchor = state.getAnchor();
        if (!anchor.isValid() || state.getErrorLevel() == SuggestedRefactoringState.ErrorLevel.INCONSISTENT) {
            return;
        }
        if (!Intrinsics.areEqual((Object)hostFile, (Object)anchor.getContainingFile())) {
            return;
        }
        SuggestedRefactoringSupport refactoringSupport = state.getRefactoringSupport();
        if (refactoringSupport.getAvailability().shouldSuppressRefactoringForDeclaration(state)) {
            ApplicationManager.getApplication().invokeLater(() -> SuggestedRefactoringIntentionContributor.collectActions$lambda$0(refactoringProvider));
            return;
        }
        if (state.getErrorLevel() != SuggestedRefactoringState.ErrorLevel.NO_ERRORS) {
            return;
        }
        state = refactoringSupport.getAvailability().refineSignaturesWithResolve(state);
        if (state.getErrorLevel() == SuggestedRefactoringState.ErrorLevel.SYNTAX_ERROR || Intrinsics.areEqual((Object)state.getOldSignature(), (Object)state.getNewSignature())) {
            Document document = PsiDocumentManager.getInstance(project3).getDocument(hostFile);
            Intrinsics.checkNotNull((Object)document);
            Document document2 = document;
            long modificationStamp = document2.getModificationStamp();
            ApplicationManager.getApplication().invokeLater(() -> SuggestedRefactoringIntentionContributor.collectActions$lambda$1(document2, modificationStamp, refactoringProvider));
            return;
        }
        SuggestedRefactoringData refactoringData = refactoringSupport.getAvailability().detectAvailableRefactoring(state);
        SuggestedRefactoringAvailabilityIndicatorKt.update(refactoringProvider.getAvailabilityIndicator(), anchor, refactoringData, refactoringSupport);
        SuggestedRefactoringData suggestedRefactoringData = refactoringData;
        if (suggestedRefactoringData instanceof SuggestedRenameData) {
            TextRange textRange2 = refactoringSupport.nameRange(((SuggestedRenameData)refactoringData).getDeclaration());
            textRange = textRange2;
            Intrinsics.checkNotNull((Object)textRange2);
        } else if (suggestedRefactoringData instanceof SuggestedChangeSignatureData) {
            TextRange textRange3 = SuggestedRefactoringAvailabilityIndicatorKt.changeSignatureAvailabilityRange(refactoringSupport, anchor);
            textRange = textRange3;
            Intrinsics.checkNotNull((Object)textRange3);
        } else {
            return;
        }
        TextRange range = textRange;
        if (!range.containsOffset(offset2)) {
            return;
        }
        SuggestedRefactoringFeatureUsage.Companion.refactoringSuggested(refactoringData, state);
        SuggestedRefactoringData suggestedRefactoringData2 = refactoringData;
        if (suggestedRefactoringData2 instanceof SuggestedRenameData) {
            var16_17 = new Object[]{((SuggestedRenameData)refactoringData).getOldName(), ((SuggestedRenameData)refactoringData).getDeclaration().getName()};
            string2 = RefactoringBundle.message((String)"suggested.refactoring.rename.intention.text", (Object[])var16_17);
        } else if (suggestedRefactoringData2 instanceof SuggestedChangeSignatureData) {
            var16_17 = new Object[]{((SuggestedChangeSignatureData)refactoringData).getNameOfStuffToUpdate()};
            string2 = RefactoringBundle.message((String)"suggested.refactoring.change.signature.intention.text", (Object[])var16_17);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when (refactoringData) {\u2026uffToUpdate\n      )\n    }");
        String text2 = string3;
        MyIntention intention = new MyIntention(text2, refactoringData instanceof SuggestedChangeSignatureData);
        List<HighlightInfo.IntentionActionDescriptor> it = list2 = intentions.errorFixesToShow;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue(it, (String)"it");
        List<HighlightInfo.IntentionActionDescriptor> list3 = !((Collection)it).isEmpty() ? list2 : null;
        if (list3 == null) {
            list3 = intentions.inspectionFixesToShow;
        }
        List<HighlightInfo.IntentionActionDescriptor> collectionToAdd = list3;
        collectionToAdd.add(new HighlightInfo.IntentionActionDescriptor(intention, null, null, this.icon, null, null, null));
    }

    private static final void collectActions$lambda$0(SuggestedRefactoringProviderImpl $refactoringProvider) {
        Intrinsics.checkNotNullParameter((Object)$refactoringProvider, (String)"$refactoringProvider");
        $refactoringProvider.suppressForCurrentDeclaration();
    }

    private static final void collectActions$lambda$1(Document $document, long $modificationStamp, SuggestedRefactoringProviderImpl $refactoringProvider) {
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$refactoringProvider, (String)"$refactoringProvider");
        if ($document.getModificationStamp() == $modificationStamp) {
            $refactoringProvider.getAvailabilityIndicator().clear();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0004H\u0017J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\"\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringIntentionContributor$MyIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "text", "", "showReviewBalloon", "", "(Ljava/lang/String;Z)V", "getFamilyName", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "startInWriteAction", "intellij.platform.lang.impl"})
    private static final class MyIntention
    implements IntentionAction,
    PriorityAction {
        @NotNull
        private final String text;
        private final boolean showReviewBalloon;

        public MyIntention(@IntentionName @NotNull String text2, boolean showReviewBalloon) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.showReviewBalloon = showReviewBalloon;
        }

        @Override
        @NotNull
        public PriorityAction.Priority getPriority() {
            return PriorityAction.Priority.TOP;
        }

        @Override
        @NonNls
        @NotNull
        public String getFamilyName() {
            return "Suggested Refactoring";
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @Nullable PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return true;
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void invoke(@NotNull Project project2, @NotNull Editor editor2, @Nullable PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            PerformSuggestedRefactoringKt.performSuggestedRefactoring(project2, editor2, null, null, this.showReviewBalloon, "IntentionMenu");
        }
    }
}

