/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.lang.Language;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.suggested.SuggestedRefactoringProviderImpl;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRefactoringStateChangesKt;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupportKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB]\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringUndoableAction;", "Lcom/intellij/openapi/command/undo/UndoableAction;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "signatureRange", "Lcom/intellij/openapi/util/TextRange;", "oldDeclarationText", "", "oldImportsText", "oldSignature", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;", "newSignature", "disappearedParameters", "", "", "additionalData", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;Ljava/util/Map;Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;)V", "documentReference", "Lcom/intellij/openapi/command/undo/DocumentReference;", "Lorg/jetbrains/annotations/NotNull;", "getAffectedDocuments", "", "()[Lcom/intellij/openapi/command/undo/DocumentReference;", "isGlobal", "", "redo", "", "undo", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSuggestedRefactoringUndoableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestedRefactoringUndoableAction.kt\ncom/intellij/refactoring/suggested/SuggestedRefactoringUndoableAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class SuggestedRefactoringUndoableAction
implements UndoableAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TextRange signatureRange;
    @NotNull
    private final String oldDeclarationText;
    @Nullable
    private final String oldImportsText;
    @NotNull
    private final SuggestedRefactoringSupport.Signature oldSignature;
    @NotNull
    private final SuggestedRefactoringSupport.Signature newSignature;
    @NotNull
    private final Map<String, Object> disappearedParameters;
    @NotNull
    private final SuggestedRefactoringState.AdditionalData additionalData;
    @NotNull
    private final DocumentReference documentReference;

    private SuggestedRefactoringUndoableAction(Document document, Project project2, TextRange signatureRange, String oldDeclarationText, String oldImportsText, SuggestedRefactoringSupport.Signature oldSignature, SuggestedRefactoringSupport.Signature newSignature, Map<String, ? extends Object> disappearedParameters, SuggestedRefactoringState.AdditionalData additionalData) {
        this.project = project2;
        this.signatureRange = signatureRange;
        this.oldDeclarationText = oldDeclarationText;
        this.oldImportsText = oldImportsText;
        this.oldSignature = oldSignature;
        this.newSignature = newSignature;
        this.disappearedParameters = disappearedParameters;
        this.additionalData = additionalData;
        DocumentReference documentReference = DocumentReferenceManager.getInstance().create(document);
        Intrinsics.checkNotNullExpressionValue((Object)documentReference, (String)"getInstance().create(document)");
        this.documentReference = documentReference;
    }

    @Override
    @NotNull
    public DocumentReference[] getAffectedDocuments() {
        DocumentReference[] documentReferenceArray = new DocumentReference[]{this.documentReference};
        return documentReferenceArray;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public void undo() {
        PsiElement psiElement;
        SuggestedRefactoringSupport refactoringSupport;
        block7: {
            block6: {
                PsiElement psiElement2;
                Document document = this.documentReference.getDocument();
                if (document == null) {
                    return;
                }
                Document document2 = document;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(this.project);
                psiDocumentManager.commitAllDocuments();
                PsiFile psiFile = psiDocumentManager.getPsiFile(document2);
                if (psiFile == null) {
                    return;
                }
                PsiFile psiFile2 = psiFile;
                Language language = psiFile2.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"psiFile.language");
                SuggestedRefactoringSupport suggestedRefactoringSupport = SuggestedRefactoringSupport.Companion.forLanguage(language);
                if (suggestedRefactoringSupport == null) {
                    return;
                }
                refactoringSupport = suggestedRefactoringSupport;
                PsiElement psiElement3 = SuggestedRefactoringSupportKt.anchorByOffset(refactoringSupport, psiFile2, this.signatureRange.getStartOffset());
                if (psiElement3 == null) break block6;
                PsiElement it = psiElement2 = psiElement3;
                boolean bl = false;
                PsiElement psiElement4 = psiElement = Intrinsics.areEqual((Object)refactoringSupport.signatureRange(it), (Object)this.signatureRange) ? psiElement2 : null;
                if (psiElement != null) break block7;
            }
            return;
        }
        PsiElement anchor = psiElement;
        SuggestedRefactoringState state = new SuggestedRefactoringState(anchor, refactoringSupport, SuggestedRefactoringState.ErrorLevel.NO_ERRORS, this.oldDeclarationText, this.oldImportsText, this.oldSignature, this.newSignature, SuggestedRefactoringStateChangesKt.parameterMarkers(refactoringSupport.getStateChanges(), anchor, this.newSignature), this.disappearedParameters, 0, this.additionalData, 512, null);
        SuggestedRefactoringProviderImpl.Companion.getInstance(this.project).undoToState(state, this.signatureRange);
    }

    @Override
    public void redo() {
        SuggestedRefactoringProvider.Companion.getInstance(this.project).reset();
    }

    public /* synthetic */ SuggestedRefactoringUndoableAction(Document document, Project project2, TextRange signatureRange, String oldDeclarationText, String oldImportsText, SuggestedRefactoringSupport.Signature oldSignature, SuggestedRefactoringSupport.Signature newSignature, Map disappearedParameters, SuggestedRefactoringState.AdditionalData additionalData, DefaultConstructorMarker $constructor_marker) {
        this(document, project2, signatureRange, oldDeclarationText, oldImportsText, oldSignature, newSignature, disappearedParameters, additionalData);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringUndoableAction$Companion;", "", "()V", "create", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringUndoableAction;", "document", "Lcom/intellij/openapi/editor/Document;", "state", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SuggestedRefactoringUndoableAction create(@NotNull Document document, @NotNull SuggestedRefactoringState state) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            TextRange textRange = state.getRefactoringSupport().signatureRange(state.getAnchor());
            Intrinsics.checkNotNull((Object)textRange);
            TextRange signatureRange = textRange;
            Project project2 = state.getAnchor().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"state.anchor.project");
            return new SuggestedRefactoringUndoableAction(document, project2, signatureRange, state.getOldDeclarationText(), state.getOldImportsText(), state.getOldSignature(), state.getNewSignature(), state.getDisappearedParameters(), state.getAdditionalData(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

