/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RefactoringUIUtil {
    public static final EditorSettingsProvider SELECT_ALL_ON_FOCUS = editor2 -> editor2.addFocusListener(new FocusChangeListener(){

        public void focusGained(@NotNull Editor editor2) {
            if (editor2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (LookupManager.getActiveLookup(editor2) == null) {
                editor2.getSelectionModel().setSelection(0, editor2.getDocument().getTextLength());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/util/RefactoringUIUtil$1", "focusGained"));
        }
    });

    private RefactoringUIUtil() {
    }

    @Nls
    public static String getDescription(@NotNull PsiElement element, boolean includeParent) {
        if (element == null) {
            RefactoringUIUtil.$$$reportNull$$$0(0);
        }
        RefactoringDescriptionLocation location2 = includeParent ? RefactoringDescriptionLocation.WITH_PARENT : RefactoringDescriptionLocation.WITHOUT_PARENT;
        return ElementDescriptionUtil.getElementDescription(element, location2);
    }

    public static void processIncorrectOperation(Project project2, IncorrectOperationException e) {
        int index2;
        String message = e.getMessage();
        int n = index2 = message != null ? message.indexOf("java.io.IOException") : -1;
        if (index2 > 0) {
            message = message.substring(index2 + "java.io.IOException".length());
        }
        String s = message;
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)s, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
    }

    @NotNull
    public static String calculatePsiElementDescriptionList(@NotNull @NotNull PsiElement @NotNull [] elements) {
        if (elements == null) {
            RefactoringUIUtil.$$$reportNull$$$0(1);
        }
        Function<PsiElement, String> presentationFun = e -> UsageViewUtil.getType((PsiElement)e) + " " + DescriptiveNameUtil.getDescriptiveName((PsiElement)e);
        String string2 = StringUtil.join(ContainerUtil.map2LinkedSet(Arrays.asList(elements), presentationFun), ", ");
        if (string2 == null) {
            RefactoringUIUtil.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/RefactoringUIUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/RefactoringUIUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePsiElementDescriptionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculatePsiElementDescriptionList";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

