/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.ProjectTopics;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SemServiceImpl
extends SemService
implements Disposable {
    @ApiStatus.Internal
    public static final Key<CachedValue<IntObjectMap<List<SemElement>>>> SEM_CACHE_KEY = Key.create("SEM");
    private static final CachedValueProvider<IntObjectMap<List<SemElement>>> SEM_CACHE_PROVIDER = () -> CachedValueProvider.Result.create(SemServiceImpl.createSemCache(), PsiModificationTracker.MODIFICATION_COUNT);
    private final Object lock = ObjectUtils.sentinel(this.getClass().getName());
    private volatile MultiMap<SemKey<?>, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> producers;
    private final Project project;
    private final CachedValuesManager myCVManager;

    public SemServiceImpl(Project project2) {
        this.project = project2;
        this.myCVManager = CachedValuesManager.getManager(project2);
        SemContributor.EP_NAME.addChangeListener(() -> {
            this.producers = null;
        }, project2);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect(this);
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SemServiceImpl.this.producers = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/semantic/SemServiceImpl$1", "rootsChanged"));
            }
        });
        messageBusConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void exitDumbMode() {
                SemServiceImpl.this.producers = null;
            }
        });
    }

    private MultiMap<SemKey<?>, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> collectProducers() {
        final MultiMap map2 = new MultiMap();
        SemRegistrar registrar = new SemRegistrar(){

            @Override
            public <T extends SemElement> void registerSemProvider(SemKey<T> key, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<T>> provider2) {
                map2.putValue(key, provider2);
            }
        };
        SemContributor.EP_NAME.processWithPluginDescriptor((contributor, pluginDescriptor) -> {
            SemContributor semContributor;
            try {
                semContributor = (SemContributor)this.project.instantiateClass(contributor.implementation, (PluginDescriptor)pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExtensionNotApplicableException e) {
                return;
            }
            catch (Exception e) {
                Logger.getInstance(SemServiceImpl.class).error(e);
                return;
            }
            if (semContributor.isAvailable(this.project)) {
                semContributor.registerSemProviders(registrar, this.project);
            }
        });
        return map2;
    }

    @Override
    @NotNull
    public <T extends SemElement> List<T> getSemElements(@NotNull SemKey<T> key, @NotNull PsiElement psi) {
        IntObjectMap<List<SemElement>> chunk;
        List<T> cached;
        if (key == null) {
            SemServiceImpl.$$$reportNull$$$0(0);
        }
        if (psi == null) {
            SemServiceImpl.$$$reportNull$$$0(1);
        }
        return (cached = SemServiceImpl.findCached(key, chunk = this.myCVManager.getCachedValue(psi, SEM_CACHE_KEY, SEM_CACHE_PROVIDER, false))) != null ? cached : this.createSemElements(key, psi, chunk);
    }

    @NotNull
    private <T extends SemElement> List<T> createSemElements(@NotNull SemKey<T> key, @NotNull PsiElement psi, IntObjectMap<List<SemElement>> chunk) {
        if (key == null) {
            SemServiceImpl.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            SemServiceImpl.$$$reportNull$$$0(3);
        }
        MultiMap<SemKey<?>, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> currentProducers = this.ensureInitialized();
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        LinkedHashSet<SemElement> result2 = null;
        HashMap map2 = null;
        ProcessingContext processingContext = new ProcessingContext();
        for (SemKey<?> each : key.getInheritors()) {
            List<SemElement> list2 = SemServiceImpl.createSemElements(currentProducers, each, psi, processingContext);
            if (map2 == null) {
                map2 = new HashMap();
                result2 = new LinkedHashSet<SemElement>();
            }
            map2.put(each, list2);
            result2.addAll(list2);
        }
        if (map2 != null && stamp.mayCacheNow()) {
            for (SemKey<Object> semKey : map2.keySet()) {
                SemServiceImpl.putSemElements(chunk, semKey, (List)map2.get(semKey));
            }
        }
        if (result2 == null || result2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                SemServiceImpl.$$$reportNull$$$0(4);
            }
            return list3;
        }
        List list4 = List.copyOf(result2);
        if (list4 == null) {
            SemServiceImpl.$$$reportNull$$$0(5);
        }
        return list4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiMap<SemKey<?>, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> ensureInitialized() {
        MultiMap<SemKey<?>, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> current = this.producers;
        if (current != null) {
            return current;
        }
        Object object = this.lock;
        synchronized (object) {
            current = this.producers;
            if (current != null) {
                return current;
            }
            MultiMap<SemKey<?>, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> newProducers = this.collectProducers();
            this.producers = newProducers;
            return newProducers;
        }
    }

    @NotNull
    private static List<SemElement> createSemElements(MultiMap<SemKey<?>, BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> producers, SemKey<?> key, PsiElement psi, ProcessingContext processingContext) {
        SmartList result2 = null;
        Collection<BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>>> functions = producers.get(key);
        if (!functions.isEmpty()) {
            for (BiFunction<? super PsiElement, ? super ProcessingContext, ? extends Collection<? extends SemElement>> producer : functions) {
                Collection<? extends SemElement> elements = producer.apply(psi, processingContext);
                if (elements == null || elements.isEmpty()) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                ContainerUtil.addAllNotNull(result2, elements);
            }
        }
        SmartList smartList = result2 == null || result2.isEmpty() ? Collections.emptyList() : result2;
        if (smartList == null) {
            SemServiceImpl.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @Override
    public void dispose() {
    }

    @Nullable
    private static <T extends SemElement> List<T> findCached(SemKey<T> key, IntObjectMap<List<SemElement>> chunk) {
        List<SemElement> singleList = null;
        LinkedHashSet<SemElement> result2 = null;
        List<SemKey<?>> inheritors = key.getInheritors();
        for (SemKey<?> inheritor : inheritors) {
            List<SemElement> cached = SemServiceImpl.getSemElements(chunk, inheritor);
            if (cached == null) {
                return null;
            }
            if (cached == Collections.emptyList()) continue;
            if (singleList == null) {
                singleList = cached;
                continue;
            }
            if (result2 == null) {
                result2 = new LinkedHashSet<SemElement>(singleList);
            }
            result2.addAll(cached);
        }
        if (result2 == null) {
            if (singleList != null) {
                return singleList;
            }
            return Collections.emptyList();
        }
        return List.copyOf(result2);
    }

    private static IntObjectMap<List<SemElement>> createSemCache() {
        return ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    }

    private static List<SemElement> getSemElements(IntObjectMap<List<SemElement>> semCache, SemKey<?> key) {
        return semCache.get(key.getUniqueId());
    }

    private static void putSemElements(IntObjectMap<List<SemElement>> semCache, @NotNull SemKey<?> key, @NotNull List<SemElement> elements) {
        if (key == null) {
            SemServiceImpl.$$$reportNull$$$0(7);
        }
        if (elements == null) {
            SemServiceImpl.$$$reportNull$$$0(8);
        }
        semCache.put(key.getUniqueId(), elements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/semantic/SemServiceImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/semantic/SemServiceImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSemElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSemElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSemElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putSemElements";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

