/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceBackwardHandler;
import com.intellij.slicer.SliceForwardHandler;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SliceHandler
implements CodeInsightActionHandler {
    final boolean myDataFlowToThis;

    SliceHandler(boolean dataFlowToThis) {
        this.myDataFlowToThis = dataFlowToThis;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        PsiElement expression;
        if (project2 == null) {
            SliceHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            SliceHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SliceHandler.$$$reportNull$$$0(2);
        }
        if ((expression = this.getExpressionAtCaret(editor2, file2)) == null) {
            HintManager.getInstance().showErrorHint(editor2, LangBundle.message("hint.text.cannot.find.what.to.analyze", new Object[0]));
            return;
        }
        SliceManager sliceManager = SliceManager.getInstance(project2);
        sliceManager.slice(expression, this.myDataFlowToThis, this);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getExpressionAtCaret(@NotNull Editor editor2, @NotNull PsiFile file2) {
        int offset2;
        if (editor2 == null) {
            SliceHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            SliceHandler.$$$reportNull$$$0(4);
        }
        if ((offset2 = TargetElementUtil.adjustOffset(file2, editor2.getDocument(), editor2.getCaretModel().getOffset())) == 0) {
            return null;
        }
        PsiElement atCaret = file2.findElementAt(offset2);
        SliceLanguageSupportProvider provider2 = LanguageSlicing.getProvider(file2);
        if (provider2 == null || atCaret == null) {
            return null;
        }
        PsiElement expression = provider2.getExpressionAtCaret(atCaret, this.myDataFlowToThis);
        if (expression != null && !expression.isPhysical()) {
            return null;
        }
        return expression;
    }

    public abstract SliceAnalysisParams askForParams(@NotNull PsiElement var1, @NotNull SliceManager.StoredSettingsBean var2, @NotNull @NlsContexts.DialogTitle String var3);

    @Contract(value="_ -> new")
    @NotNull
    public static SliceHandler create(boolean dataFlowToThis) {
        return dataFlowToThis ? new SliceBackwardHandler() : new SliceForwardHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/slicer/SliceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionAtCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

