/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.usages.UsageViewSettings;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SliceToTextFileExporter
implements ExporterToTextFile {
    private final SliceTreeBuilder myBuilder;
    @NotNull
    private final UsageViewSettings myUsageViewSettings;
    private final String myLineSeparator;

    public SliceToTextFileExporter(@NotNull SliceTreeBuilder builder2, @NotNull UsageViewSettings usageViewSettings) {
        if (builder2 == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(0);
        }
        if (usageViewSettings == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(1);
        }
        this.myLineSeparator = System.lineSeparator();
        this.myBuilder = builder2;
        this.myUsageViewSettings = usageViewSettings;
    }

    @NotNull
    public String getReportText() {
        StringBuilder buffer = new StringBuilder();
        this.appendChildren(buffer, this.myBuilder.getRootSliceNode(), "");
        String string2 = buffer.toString();
        if (string2 == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private void appendNode(StringBuilder buffer, SliceNode node2, String indent) {
        buffer.append(indent).append(node2.getNodeText()).append(this.myLineSeparator);
        this.appendChildren(buffer, node2, indent + "    ");
    }

    private void appendChildren(StringBuilder buffer, SliceNode node2, String indent) {
        List<SliceNode> cachedChildren = node2.getCachedChildren();
        if (cachedChildren != null) {
            for (SliceNode child : cachedChildren) {
                this.appendNode(buffer, child, indent);
            }
        } else {
            buffer.append(indent).append("...").append(this.myLineSeparator);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        String string2 = this.myUsageViewSettings.getExportFileName();
        if (string2 == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public void exportedTo(@NotNull String filePath) {
        if (filePath == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(4);
        }
        this.myUsageViewSettings.setExportFileName(filePath);
    }

    public boolean canExport() {
        return !this.myBuilder.analysisInProgress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceToTextFileExporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceToTextFileExporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportedTo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

