/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceTreeStructure;
import com.intellij.slicer.SliceUsage;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class SliceTreeBuilder {
    private final SliceTreeStructure sliceTreeStructure;
    public final boolean splitByLeafExpressions;
    public final boolean dataFlowToThis;
    public volatile boolean analysisInProgress;
    public static final Comparator<NodeDescriptor<?>> SLICE_NODE_COMPARATOR = (o1, o2) -> {
        PsiFile file2;
        SliceNode node1;
        block7: {
            block6: {
                if (!(o1 instanceof SliceNode)) break block6;
                node1 = (SliceNode)o1;
                if (o2 instanceof SliceNode) break block7;
            }
            return AlphaComparator.INSTANCE.compare(o1, o2);
        }
        SliceNode node2 = (SliceNode)o2;
        SliceUsage usage1 = (SliceUsage)((Object)((Object)node1.getValue()));
        SliceUsage usage2 = (SliceUsage)((Object)((Object)node2.getValue()));
        PsiElement element1 = usage1 == null ? null : usage1.getElement();
        PsiElement element2 = usage2 == null ? null : usage2.getElement();
        PsiFile file1 = element1 == null ? null : element1.getContainingFile();
        PsiFile psiFile = file2 = element2 == null ? null : element2.getContainingFile();
        if (file1 == null) {
            return file2 == null ? 0 : 1;
        }
        if (file2 == null) {
            return -1;
        }
        if (file1 == file2) {
            return element1.getTextOffset() - element2.getTextOffset();
        }
        return Comparing.compare(file1.getName(), file2.getName());
    };

    SliceTreeBuilder(@NotNull SliceTreeStructure sliceTreeStructure, boolean dataFlowToThis, boolean splitByLeafExpressions) {
        if (sliceTreeStructure == null) {
            SliceTreeBuilder.$$$reportNull$$$0(0);
        }
        this.sliceTreeStructure = sliceTreeStructure;
        this.dataFlowToThis = dataFlowToThis;
        this.splitByLeafExpressions = splitByLeafExpressions;
    }

    public SliceTreeStructure getTreeStructure() {
        return this.sliceTreeStructure;
    }

    public SliceRootNode getRootSliceNode() {
        return this.sliceTreeStructure.getRootElement();
    }

    void switchToGroupedByLeavesNodes() {
        SliceLanguageSupportProvider provider2 = this.getRootSliceNode().getProvider();
        if (provider2 == null) {
            return;
        }
        this.analysisInProgress = true;
        provider2.startAnalyzeLeafValues((AbstractTreeStructure)this.sliceTreeStructure, () -> {
            this.analysisInProgress = false;
        });
    }

    public void switchToLeafNulls() {
        SliceLanguageSupportProvider provider2 = this.getRootSliceNode().getProvider();
        if (provider2 == null) {
            return;
        }
        this.analysisInProgress = true;
        provider2.startAnalyzeNullness((AbstractTreeStructure)this.sliceTreeStructure, () -> {
            this.analysisInProgress = false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sliceTreeStructure", "com/intellij/slicer/SliceTreeBuilder", "<init>"));
    }
}

