/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceUsageTransformer;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SliceUsage
extends UsageInfo2UsageAdapter {
    private final SliceUsage myParent;
    public final SliceAnalysisParams params;

    public SliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent2) {
        if (element == null) {
            SliceUsage.$$$reportNull$$$0(0);
        }
        if (parent2 == null) {
            SliceUsage.$$$reportNull$$$0(1);
        }
        this(element, parent2, parent2.params);
    }

    protected SliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent2, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            SliceUsage.$$$reportNull$$$0(2);
        }
        if (parent2 == null) {
            SliceUsage.$$$reportNull$$$0(3);
        }
        if (params == null) {
            SliceUsage.$$$reportNull$$$0(4);
        }
        super(new UsageInfo(element));
        this.myParent = parent2;
        this.params = params;
    }

    protected SliceUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            SliceUsage.$$$reportNull$$$0(5);
        }
        if (params == null) {
            SliceUsage.$$$reportNull$$$0(6);
        }
        super(new UsageInfo(element));
        this.myParent = null;
        this.params = params;
    }

    @NotNull
    private static Collection<SliceUsage> transformToLanguageSpecificUsage(@NotNull SliceUsage usage2) {
        PsiElement element;
        if (usage2 == null) {
            SliceUsage.$$$reportNull$$$0(7);
        }
        if ((element = usage2.getElement()) == null) {
            List<SliceUsage> list2 = Collections.singletonList(usage2);
            if (list2 == null) {
                SliceUsage.$$$reportNull$$$0(8);
            }
            return list2;
        }
        SliceLanguageSupportProvider provider2 = LanguageSlicing.getProvider(element);
        if (!(provider2 instanceof SliceUsageTransformer)) {
            List<SliceUsage> list3 = Collections.singletonList(usage2);
            if (list3 == null) {
                SliceUsage.$$$reportNull$$$0(9);
            }
            return list3;
        }
        Collection<SliceUsage> transformedUsages = ((SliceUsageTransformer)((Object)provider2)).transform(usage2);
        Collection<SliceUsage> collection = transformedUsages != null ? transformedUsages : Collections.singletonList(usage2);
        if (collection == null) {
            SliceUsage.$$$reportNull$$$0(10);
        }
        return collection;
    }

    public void processChildren(@NotNull Processor<? super SliceUsage> processor) {
        if (processor == null) {
            SliceUsage.$$$reportNull$$$0(11);
        }
        PsiElement element = ReadAction.compute(() -> ((SliceUsage)this).getElement());
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.checkCanceled();
        HashingStrategy<SliceUsage> strategy = new HashingStrategy<SliceUsage>(){

            @Override
            public int hashCode(SliceUsage object) {
                return object.getUsageInfo().hashCode();
            }

            @Override
            public boolean equals(SliceUsage o1, SliceUsage o2) {
                return o1.getUsageInfo().equals(o2.getUsageInfo());
            }
        };
        final class SliceUsageUniqueProcessor
        extends CommonProcessors.UniqueProcessor<SliceUsage> {
            private SliceUsageUniqueProcessor(Processor<? super SliceUsage> processor, HashingStrategy<? super SliceUsage> strategy) {
                if (processor == null) {
                    SliceUsageUniqueProcessor.$$$reportNull$$$0(0);
                }
                super(processor, strategy);
            }

            @Override
            public boolean process(SliceUsage usage2) {
                PsiElement psiElement;
                SliceValueFilter filter2 = usage2.params.valueFilter;
                if (filter2 != null && (psiElement = usage2.getElement()) != null && !filter2.allowed(psiElement)) {
                    return true;
                }
                return ContainerUtil.and(SliceUsage.transformToLanguageSpecificUsage(usage2), x$0 -> super.process(x$0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUsage$1SliceUsageUniqueProcessor", "<init>"));
            }
        }
        SliceUsageUniqueProcessor uniqueProcessor = new SliceUsageUniqueProcessor(processor, (HashingStrategy<? super SliceUsage>)strategy);
        Runnable processUsagesFlow = () -> {
            if (this.params.dataFlowToThis) {
                this.processUsagesFlownDownTo(element, uniqueProcessor);
            } else {
                this.processUsagesFlownFromThe(element, uniqueProcessor);
            }
        };
        ReadAction.nonBlocking(processUsagesFlow).executeSynchronously();
    }

    protected abstract void processUsagesFlownFromThe(PsiElement var1, Processor<? super SliceUsage> var2);

    protected abstract void processUsagesFlownDownTo(PsiElement var1, Processor<? super SliceUsage> var2);

    public SliceUsage getParent() {
        return this.myParent;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.params.scope;
        if (analysisScope == null) {
            SliceUsage.$$$reportNull$$$0(12);
        }
        return analysisScope;
    }

    @NotNull
    protected abstract SliceUsage copy();

    public boolean canBeLeaf() {
        return this.getElement() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceUsage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceUsage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "transformToLanguageSpecificUsage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "transformToLanguageSpecificUsage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9, 10, 12 -> new IllegalStateException(string2);
        };
    }
}

