/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProvider;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.ExecuteRunConfigurationTaskImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/task/impl/ExecutionEnvironmentProviderImpl;", "Lcom/intellij/execution/runners/ExecutionEnvironmentProvider;", "()V", "createExecutionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "executor", "Lcom/intellij/execution/Executor;", "target", "Lcom/intellij/execution/ExecutionTarget;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "configurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nExecutionEnvironmentProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionEnvironmentProviderImpl.kt\ncom/intellij/task/impl/ExecutionEnvironmentProviderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n10#2:82\n*S KotlinDebug\n*F\n+ 1 ExecutionEnvironmentProviderImpl.kt\ncom/intellij/task/impl/ExecutionEnvironmentProviderImpl\n*L\n52#1:82\n*E\n"})
public final class ExecutionEnvironmentProviderImpl
implements ExecutionEnvironmentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project2, @NotNull RunProfile runProfile, @NotNull Executor executor, @NotNull ExecutionTarget target2, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationSettings, @Nullable RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        ExecuteRunConfigurationTask runTask = new ExecuteRunConfigurationTaskImpl(runProfile, target2, runnerSettings, configurationSettings, settings);
        ExecutionEnvironment executionEnvironment = ProjectTaskRunner.EP_NAME.computeSafeIfAny(arg_0 -> ExecutionEnvironmentProviderImpl.createExecutionEnvironment$lambda$0(project2, runTask, executor, arg_0));
        if (executionEnvironment == null) {
            return null;
        }
        ExecutionEnvironment environment = executionEnvironment;
        RunProfile runProfile2 = environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile2, (String)"environment.runProfile");
        RunProfile environmentRunProfile = runProfile2;
        ExecutionManagerImpl.Companion.setDelegatedRunProfile(environmentRunProfile, runProfile);
        ExecutionEnvironmentProviderImpl.Companion.copySettings(settings, environment);
        ExecutionEnvironmentProviderImpl.Companion.copyCommonRunProfileOptions(runProfile, environmentRunProfile);
        return environment;
    }

    private static final ExecutionEnvironment createExecutionEnvironment$lambda$0(Project $project, ExecuteRunConfigurationTask $runTask, Executor $executor, ProjectTaskRunner it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$runTask, (String)"$runTask");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        try {
            if (it.canRun($project, $runTask)) {
                return it.createExecutionEnvironment($project, $runTask, $executor);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Broken project task runner: " + it.getClass().getName(), e);
        }
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExecutionEnvironmentProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001a\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/task/impl/ExecutionEnvironmentProviderImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copyCommonRunProfileOptions", "", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "environmentRunProfile", "copySettings", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void copySettings(RunnerAndConfigurationSettings settings, ExecutionEnvironment environment) {
            if (settings == null) {
                return;
            }
            RunnerAndConfigurationSettings environmentSettings = environment.getRunnerAndConfigurationSettings();
            if (environmentSettings != null && environmentSettings != settings) {
                environmentSettings.setActivateToolWindowBeforeRun(settings.isActivateToolWindowBeforeRun());
                environmentSettings.setEditBeforeRun(settings.isEditBeforeRun());
            }
        }

        private final void copyCommonRunProfileOptions(RunProfile runProfile, RunProfile environmentRunProfile) {
            if (environmentRunProfile instanceof RunConfigurationBase && runProfile instanceof RunConfigurationBase) {
                Object object = ((RunConfigurationBase)runProfile).getState();
                RunConfigurationOptions runConfigurationOptions = object instanceof RunConfigurationOptions ? (RunConfigurationOptions)object : null;
                if (runConfigurationOptions == null) {
                    return;
                }
                RunConfigurationOptions options2 = runConfigurationOptions;
                Object object2 = ((RunConfigurationBase)environmentRunProfile).getState();
                RunConfigurationOptions runConfigurationOptions2 = object2 instanceof RunConfigurationOptions ? (RunConfigurationOptions)object2 : null;
                if (runConfigurationOptions2 == null) {
                    return;
                }
                RunConfigurationOptions environmentOption = runConfigurationOptions2;
                Object $this$copyCommonRunProfileOptions_u24lambda_u240 = object = environmentOption;
                boolean bl = false;
                BaseState.copyFrom$default((BaseState)$this$copyCommonRunProfileOptions_u24lambda_u240.getFileOutput(), (BaseState)options2.getFileOutput(), false, 2, null);
                $this$copyCommonRunProfileOptions_u24lambda_u240.getPredefinedLogFiles().addAll(options2.getPredefinedLogFiles());
                $this$copyCommonRunProfileOptions_u24lambda_u240.setShowConsoleOnStdOut(options2.isShowConsoleOnStdOut());
                $this$copyCommonRunProfileOptions_u24lambda_u240.setShowConsoleOnStdErr(options2.isShowConsoleOnStdErr());
                $this$copyCommonRunProfileOptions_u24lambda_u240.getLogFiles().addAll(options2.getLogFiles());
                $this$copyCommonRunProfileOptions_u24lambda_u240.setAllowRunningInParallel(options2.isAllowRunningInParallel());
                $this$copyCommonRunProfileOptions_u24lambda_u240.setRemoteTarget(options2.getRemoteTarget());
                $this$copyCommonRunProfileOptions_u24lambda_u240.setProjectPathOnTarget(options2.getProjectPathOnTarget());
                $this$copyCommonRunProfileOptions_u24lambda_u240.getSelectedOptions().addAll(options2.getSelectedOptions());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

