/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.concurrency.Semaphore;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public class BombedProgressIndicator
extends AbstractProgressIndicatorBase {
    private final Predicate<? super StackTraceElement[]> myStackCondition;
    private int myRemainingChecks;
    private volatile Thread myThread;

    public BombedProgressIndicator(int checkCanceledCount) {
        this.myRemainingChecks = checkCanceledCount;
        this.myStackCondition = null;
    }

    private BombedProgressIndicator(@NotNull Predicate<? super StackTraceElement[]> stackCondition) {
        if (stackCondition == null) {
            BombedProgressIndicator.$$$reportNull$$$0(0);
        }
        this.myStackCondition = stackCondition;
        this.myRemainingChecks = -1;
    }

    @Override
    public void checkCanceled() throws ProcessCanceledException {
        if (this.myThread == Thread.currentThread()) {
            if (this.myStackCondition != null) {
                if (this.myStackCondition.test((StackTraceElement[])new Throwable().getStackTrace())) {
                    this.cancel();
                }
            } else if (this.myRemainingChecks > 0) {
                --this.myRemainingChecks;
            } else {
                this.cancel();
            }
        }
        super.checkCanceled();
    }

    public boolean runBombed(Runnable runnable) {
        this.myThread = Thread.currentThread();
        Semaphore canStart = new Semaphore();
        canStart.down();
        Semaphore finished = new Semaphore();
        finished.down();
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ProgressIndicatorBase mockIndicator = new ProgressIndicatorBase();
            ProgressManager.getInstance().runProcess(() -> {
                mockIndicator.cancel();
                canStart.up();
                finished.waitFor();
                try {
                    ProgressManager.checkCanceled();
                    TestCase.fail();
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }, (ProgressIndicator)mockIndicator);
        });
        ProgressManager.getInstance().runProcess(() -> {
            canStart.waitFor();
            try {
                runnable.run();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                finished.up();
            }
        }, (ProgressIndicator)this);
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return this.isCanceled();
    }

    public static BombedProgressIndicator explodeOnStack(Predicate<? super StackTraceElement[]> stackCondition) {
        return new BombedProgressIndicator(stackCondition);
    }

    public static BombedProgressIndicator explodeOnStackElement(Predicate<? super StackTraceElement> stackElementCondition) {
        return BombedProgressIndicator.explodeOnStack(stack -> Arrays.stream(stack).anyMatch(stackElementCondition));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackCondition", "com/intellij/testFramework/BombedProgressIndicator", "<init>"));
    }
}

