/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Pair;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class CpuUsageData {
    private static final ThreadMXBean ourThreadMXBean = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> ourGcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static final CompilationMXBean ourCompilationMXBean = ManagementFactory.getCompilationMXBean();
    private static final OperatingSystemMXBean ourOSBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    public final long durationMs;
    private final FreeMemorySnapshot myMemStart;
    private final FreeMemorySnapshot myMemEnd;
    private final long myCompilationTimeMs;
    private final long myProcessTimeMs;
    private final List<Pair<Long, String>> myGcTimes;
    private final List<Pair<Long, String>> myThreadTimes;

    /*
     * WARNING - void declaration
     */
    private CpuUsageData(long durationMs, @NotNull Map<GarbageCollectorMXBean, Long> gcTimes, @NotNull Map<ThreadInfo, Long> threadTimes, long compilationTimeMs, long processTimeMs, @NotNull FreeMemorySnapshot freeMemorySnapshot, @NotNull FreeMemorySnapshot freeMemorySnapshot2) {
        void memEnd;
        void memStart;
        if (gcTimes == null) {
            CpuUsageData.$$$reportNull$$$0(0);
        }
        if (threadTimes == null) {
            CpuUsageData.$$$reportNull$$$0(1);
        }
        if (freeMemorySnapshot == null) {
            CpuUsageData.$$$reportNull$$$0(2);
        }
        if (freeMemorySnapshot2 == null) {
            CpuUsageData.$$$reportNull$$$0(3);
        }
        this.myGcTimes = new ArrayList<Pair<Long, String>>();
        this.myThreadTimes = new ArrayList<Pair<Long, String>>();
        this.durationMs = durationMs;
        this.myMemStart = memStart;
        this.myMemEnd = memEnd;
        this.myCompilationTimeMs = compilationTimeMs;
        this.myProcessTimeMs = processTimeMs;
        gcTimes.forEach((bean, value) -> this.myGcTimes.add(Pair.create(value, bean.getName())));
        threadTimes.forEach((info2, nanos) -> this.myThreadTimes.add(Pair.create(TimeUnit.NANOSECONDS.toMillis((long)nanos), info2.getThreadName())));
        assert (durationMs >= 0L) : durationMs;
        assert (compilationTimeMs >= 0L) : compilationTimeMs;
        assert (processTimeMs >= 0L) : processTimeMs;
    }

    @NotNull
    public String getGcStats() {
        String string2 = CpuUsageData.printLongestNames(this.myGcTimes) + "; free " + this.myMemStart + " -> " + this.myMemEnd + " MB";
        if (string2 == null) {
            CpuUsageData.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    String getProcessCpuStats() {
        long gcTotal = this.myGcTimes.stream().mapToLong(p -> (Long)p.first).sum();
        String string2 = this.myCompilationTimeMs + "ms (" + this.myCompilationTimeMs * 100L / (this.myProcessTimeMs == 0L ? 1000000L : this.myProcessTimeMs) + "%) compilation" + (String)(gcTotal > 0L ? " and " + gcTotal + "ms (" + gcTotal * 100L / (this.myProcessTimeMs == 0L ? 1000000L : this.myProcessTimeMs) + "%) GC" : "") + " of " + this.myProcessTimeMs + "ms total";
        if (string2 == null) {
            CpuUsageData.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public String getThreadStats() {
        return CpuUsageData.printLongestNames(this.myThreadTimes);
    }

    public long getMemDelta() {
        long usedBefore = this.myMemStart.total - this.myMemStart.free;
        long usedAfter = this.myMemEnd.total - this.myMemEnd.free;
        return usedAfter - usedBefore;
    }

    @NotNull
    public String getSummary(@NotNull String indent) {
        if (indent == null) {
            CpuUsageData.$$$reportNull$$$0(6);
        }
        String string2 = indent + "GC: " + this.getGcStats() + "\n" + indent + "Threads: " + this.getThreadStats() + "\n" + indent + "Process: " + this.getProcessCpuStats();
        if (string2 == null) {
            CpuUsageData.$$$reportNull$$$0(7);
        }
        return string2;
    }

    boolean hasAnyActivityBesides(@NotNull Thread thread) {
        if (thread == null) {
            CpuUsageData.$$$reportNull$$$0(8);
        }
        return this.myCompilationTimeMs > 0L || this.myThreadTimes.stream().anyMatch(pair -> (Long)pair.first > 0L && !((String)pair.second).equals(thread.getName())) || this.myGcTimes.stream().anyMatch(pair -> (Long)pair.first > 0L);
    }

    @NotNull
    PerformanceTestInfo.IterationResult getIterationResult(int expectedOnMyMachine) {
        if (this.durationMs < (long)expectedOnMyMachine) {
            PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.ACCEPTABLE;
            if (iterationResult == null) {
                CpuUsageData.$$$reportNull$$$0(9);
            }
            return iterationResult;
        }
        if ((double)this.durationMs < (double)expectedOnMyMachine * 1.1) {
            PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.BORDERLINE;
            if (iterationResult == null) {
                CpuUsageData.$$$reportNull$$$0(10);
            }
            return iterationResult;
        }
        if (this.myCompilationTimeMs >= this.durationMs) {
            PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.DISTRACTED;
            if (iterationResult == null) {
                CpuUsageData.$$$reportNull$$$0(11);
            }
            return iterationResult;
        }
        PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.SLOW;
        if (iterationResult == null) {
            CpuUsageData.$$$reportNull$$$0(12);
        }
        return iterationResult;
    }

    @NotNull
    private static String printLongestNames(@NotNull List<? extends Pair<Long, String>> times) {
        String stats;
        if (times == null) {
            CpuUsageData.$$$reportNull$$$0(13);
        }
        String string2 = (stats = times.stream().sorted(Comparator.comparingLong(p -> (Long)p.first).reversed()).filter(p -> (Long)p.first > 10L).limit(10L).map(p -> "\"" + (String)p.second + "\" took " + p.first + "ms").collect(Collectors.joining(", "))).isEmpty() ? "insignificant" : stats;
        if (string2 == null) {
            CpuUsageData.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @NotNull
    public static <E extends Throwable> CpuUsageData measureCpuUsage(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            CpuUsageData.$$$reportNull$$$0(15);
        }
        FreeMemorySnapshot memStart = new FreeMemorySnapshot();
        HashMap<GarbageCollectorMXBean, Long> gcTimes = new HashMap<GarbageCollectorMXBean, Long>();
        for (GarbageCollectorMXBean bean : ourGcBeans) {
            gcTimes.put(bean, bean.getCollectionTime());
        }
        HashingStrategy<ThreadInfo> byId = new HashingStrategy<ThreadInfo>(){

            @Override
            public int hashCode(ThreadInfo object) {
                return (int)object.getThreadId();
            }

            @Override
            public boolean equals(ThreadInfo o1, ThreadInfo o2) {
                return o1 == null || o2 == null ? o1 == o2 : o1.getThreadId() == o2.getThreadId();
            }
        };
        Map<ThreadInfo, Long> startTimes = CollectionFactory.createCustomHashingStrategyMap(byId);
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            ThreadInfo threadInfo = ourThreadMXBean.getThreadInfo(id);
            long start = ourThreadMXBean.getThreadUserTime(id);
            if (threadInfo == null || start == -1L) continue;
            startTimes.put(threadInfo, start);
        }
        long compStart = CpuUsageData.getTotalCompilationMillis();
        long processStart = ourOSBean.getProcessCpuTime();
        long start = System.nanoTime();
        runnable.run();
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        long processTime = TimeUnit.NANOSECONDS.toMillis(ourOSBean.getProcessCpuTime() - processStart);
        long compilationTime = CpuUsageData.getTotalCompilationMillis() - compStart;
        FreeMemorySnapshot memEnd = new FreeMemorySnapshot();
        Map<ThreadInfo, Long> threadTimes = CollectionFactory.createCustomHashingStrategyMap(startTimes.size(), byId);
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            ThreadInfo info2 = ourThreadMXBean.getThreadInfo(id);
            if (info2 == null) continue;
            Long oldStart = (Long)startTimes.get(info2);
            long end = ourThreadMXBean.getThreadUserTime(id);
            if (oldStart == null || end == -1L) continue;
            threadTimes.put(info2, end - oldStart);
        }
        Object object = ourGcBeans.iterator();
        while (object.hasNext()) {
            GarbageCollectorMXBean bean = (GarbageCollectorMXBean)object.next();
            long time2 = ObjectUtils.notNull((Long)gcTimes.get(bean), 0L);
            gcTimes.put(bean, bean.getCollectionTime() - time2);
        }
        return new CpuUsageData(duration, gcTimes, threadTimes, compilationTime, processTime, memStart, memEnd);
    }

    static long getTotalCompilationMillis() {
        return ourCompilationMXBean.getTotalCompilationTime();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9, 10, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gcTimes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadTimes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memStart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memEnd";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/CpuUsageData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "times";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/CpuUsageData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGcStats";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessCpuStats";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterationResult";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "printLongestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSummary";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyActivityBesides";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "printLongestNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "measureCpuUsage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 7, 9, 10, 11, 12, 14 -> new IllegalStateException(string2);
        };
    }

    private static class FreeMemorySnapshot {
        final long free = FreeMemorySnapshot.toMb(Runtime.getRuntime().freeMemory());
        final long total = FreeMemorySnapshot.toMb(Runtime.getRuntime().totalMemory());

        private FreeMemorySnapshot() {
        }

        private static long toMb(long bytes) {
            return bytes / 1024L / 1024L;
        }

        public String toString() {
            return this.free + "/" + this.total;
        }
    }
}

