/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

@TestOnly
public final class EditorListenerTracker {
    private final Map<Class<? extends EventListener>, List<? extends EventListener>> before;

    public EditorListenerTracker() {
        EncodingManager.getInstance();
        this.before = ((EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster()).getListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkListenersLeak() throws AssertionError {
        try {
            Class aClass;
            EditorEventMulticasterImpl multicaster = (EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster();
            Map after2 = multicaster.getListeners();
            LinkedHashMap leaked = new LinkedHashMap();
            for (Map.Entry entry : after2.entrySet()) {
                aClass = (Class)entry.getKey();
                List<? extends EventListener> beforeList = this.before.get(aClass);
                ArrayList<EventListener> afterList = new ArrayList<EventListener>((Collection)entry.getValue());
                if (beforeList != null) {
                    afterList.removeAll(beforeList);
                }
                afterList.removeIf(listener2 -> {
                    if (listener2 instanceof PsiDocumentManager && ((PsiDocumentManagerBase)listener2).isDefaultProject()) {
                        return true;
                    }
                    String name = listener2.getClass().getName();
                    return name.startsWith("com.intellij.copyright.CopyrightManagerDocumentListener$") || name.startsWith("com.intellij.model.BranchServiceImpl$") || name.startsWith("com.jetbrains.liveEdit.highlighting.ElementHighlighterCaretListener");
                });
                if (afterList.isEmpty()) continue;
                leaked.put(aClass, afterList);
            }
            for (Map.Entry entry : leaked.entrySet()) {
                aClass = (Class)entry.getKey();
                List list2 = (List)entry.getValue();
                Assert.fail((String)("Listeners leaked for " + aClass + ":\n" + list2));
            }
        }
        finally {
            this.before.clear();
        }
    }
}

