/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.AbstractBundle;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ExpectedHighlightingData {
    static final String EXPECTED_DUPLICATION_MESSAGE = "Expected duplication problem. Please remove `ExpectedHighlightingData.expectedDuplicatedHighlighting()` surrounding call, if there is no such problem any more";
    private static final String ERROR_MARKER = "error";
    private static final String WARNING_MARKER = "warning";
    private static final String WEAK_WARNING_MARKER = "weak_warning";
    private static final String INFO_MARKER = "info";
    private static final String TEXT_ATTRIBUTES_MARKER = "text_attr";
    private static final String END_LINE_HIGHLIGHT_MARKER = "EOLError";
    private static final String END_LINE_WARNING_MARKER = "EOLWarning";
    private static final String INJECT_MARKER = "inject";
    private static final String HIGHLIGHT_MARKER = "highlight";
    private static final String INJECTED_SYNTAX_MARKER = "injectedSyntax";
    private static final String SYMBOL_NAME_MARKER = "symbolName";
    private static final String LINE_MARKER = "lineMarker";
    private static final String ANY_TEXT = "*";
    private static final HighlightInfoType WHATEVER = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, HighlighterColors.TEXT);
    private static boolean isDuplicatedCheckDisabled = false;
    private static int failedDuplicationChecks = 0;
    private final Map<String, ExpectedHighlightingSet> myHighlightingTypes;
    private final Map<RangeMarker, LineMarkerInfo<?>> myLineMarkerInfos;
    private final Document myDocument;
    private final String myText;
    private boolean myIgnoreExtraHighlighting;
    private final ResourceBundle[] myMessageBundles;
    private static final SmartPsiElementPointer<PsiElement> NULL_POINTER = new SmartPsiElementPointer<PsiElement>(){

        @Override
        @Nullable
        public PsiElement getElement() {
            return null;
        }

        @Override
        @Nullable
        public PsiFile getContainingFile() {
            return null;
        }

        @Override
        @NotNull
        public Project getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VirtualFile getVirtualFile() {
            return null;
        }

        @Override
        @Nullable
        public Segment getRange() {
            return null;
        }

        @Override
        @Nullable
        public Segment getPsiRange() {
            return null;
        }
    };

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkInfos) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(0);
        }
        this(document, checkWarnings, false, checkInfos);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(1);
        }
        this(document, checkWarnings, checkWeakWarnings, checkInfos, false, new ResourceBundle[0]);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, boolean ignoreExtraHighlighting, ResourceBundle ... messageBundles) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(2);
        }
        this(document, messageBundles);
        this.myIgnoreExtraHighlighting = ignoreExtraHighlighting;
        if (checkWarnings) {
            this.checkWarnings();
        }
        if (checkWeakWarnings) {
            this.checkWeakWarnings();
        }
        if (checkInfos) {
            this.checkInfos();
        }
    }

    public ExpectedHighlightingData(@NotNull Document document, ResourceBundle ... messageBundles) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(3);
        }
        this.myHighlightingTypes = new LinkedHashMap<String, ExpectedHighlightingSet>();
        this.myLineMarkerInfos = new HashMap();
        this.myDocument = document;
        this.myMessageBundles = messageBundles;
        this.myText = document.getText();
        this.registerHighlightingType(ERROR_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, false, true));
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, false));
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, false));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, false));
        this.registerHighlightingType(HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY, false, false));
        this.registerHighlightingType(INJECTED_SYNTAX_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY, false, false));
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, false));
        this.registerHighlightingType(TEXT_ATTRIBUTES_MARKER, new ExpectedHighlightingSet(HighlightSeverity.TEXT_ATTRIBUTES, false, false));
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, false));
        for (SeveritiesProvider provider2 : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (HighlightInfoType type : provider2.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity severity = type.getSeverity(null);
                this.registerHighlightingType(severity.getName(), new ExpectedHighlightingSet(severity, false, true));
            }
        }
        this.registerHighlightingType(END_LINE_HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, true, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, false));
    }

    public boolean hasLineMarkers() {
        return !this.myLineMarkerInfos.isEmpty();
    }

    public void init() {
        WriteCommandAction.runWriteCommandAction(null, () -> {
            DocumentUtil.executeInBulk(this.myDocument, () -> {
                this.extractExpectedLineMarkerSet(this.myDocument);
                this.extractExpectedHighlightsSet(this.myDocument);
            });
            this.refreshLineMarkers();
        });
    }

    public void checkWarnings() {
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, true));
    }

    public void checkWeakWarnings() {
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, true));
    }

    public void checkInfos() {
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, true));
        this.registerHighlightingType(TEXT_ATTRIBUTES_MARKER, new ExpectedHighlightingSet(HighlightSeverity.TEXT_ATTRIBUTES, false, true));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, true));
        this.registerHighlightingType(HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY, false, true));
    }

    public void checkSymbolNames() {
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, true));
    }

    public void registerHighlightingType(@NotNull String key, @NotNull ExpectedHighlightingSet highlightingSet) {
        if (key == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(4);
        }
        if (highlightingSet == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(5);
        }
        this.myHighlightingTypes.put(key, highlightingSet);
    }

    private void refreshLineMarkers() {
        for (Map.Entry<RangeMarker, LineMarkerInfo<?>> entry : this.myLineMarkerInfos.entrySet()) {
            RangeMarker rangeMarker = entry.getKey();
            int startOffset = rangeMarker.getStartOffset();
            int endOffset = rangeMarker.getEndOffset();
            LineMarkerInfo<?> value = entry.getValue();
            TextRange range = new TextRange(startOffset, endOffset);
            String tooltip = value.getLineMarkerTooltip();
            Icon icon2 = value.getIcon();
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(range, GutterIconRenderer.Alignment.RIGHT, tooltip, icon2 != null ? icon2.toString() : null);
            entry.setValue(markerInfo);
        }
    }

    private void extractExpectedLineMarkerSet(Document document) {
        Matcher opening;
        String text2 = document.getText();
        String pat = ".*?((<lineMarker)(?: descr=\"((?:[^\"\\\\]|\\\\\")*)\")?(?: icon=\"((?:[^\"\\\\]|\\\\\")*)\")?>)(.*)";
        Pattern openingTagRx = Pattern.compile(pat, 32);
        Pattern closingTagRx = Pattern.compile("(.*?)(</lineMarker>)(.*)", 32);
        while ((opening = openingTagRx.matcher(text2)).matches()) {
            int startOffset = opening.start(1);
            String descr = opening.group(3) != null ? opening.group(3) : ANY_TEXT;
            String icon2 = opening.group(4) != null ? opening.group(4) : ANY_TEXT;
            String rest = opening.group(5);
            Matcher closing = closingTagRx.matcher(rest);
            if (!closing.matches()) {
                Assert.fail((String)"Cannot find closing </lineMarker>");
            }
            document.replaceString(startOffset, opening.end(1), "");
            String content2 = closing.group(1);
            int endOffset = startOffset + closing.start(3);
            String endTag = closing.group(2);
            document.replaceString(startOffset, endOffset, content2);
            TextRange range = new TextRange(startOffset, endOffset -= endTag.length());
            String tooltip = StringUtil.unescapeStringCharacters(descr);
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(range, GutterIconRenderer.Alignment.RIGHT, tooltip, icon2);
            this.myLineMarkerInfos.put(document.createRangeMarker(startOffset, endOffset), markerInfo);
            text2 = document.getText();
        }
    }

    private void extractExpectedHighlightsSet(Document document) {
        String text2 = document.getText();
        Set<String> markers = this.myHighlightingTypes.keySet();
        String typesRx = "(?:" + StringUtil.join(markers, ")|(?:") + ")";
        String openingTagRx = "<(" + typesRx + ")(?:\\s+descr=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+type=\"([0-9A-Z_]+)\")?(?:\\s+foreground=\"([0-9xa-f]+)\")?(?:\\s+background=\"([0-9xa-f]+)\")?(?:\\s+effectcolor=\"([0-9xa-f]+)\")?(?:\\s+effecttype=\"([A-Z]+)\")?(?:\\s+fonttype=\"([0-9]+)\")?(?:\\s+textAttributesKey=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+bundleMsg=\"((?:[^\"]|\\\\\"|\\\\\\\\\")*)\")?(?:\\s+tooltip=\"((?:[^\"]|\\\\\"|\\\\\\\\\")*)\")?(/)?>";
        Matcher matcher = Pattern.compile(openingTagRx).matcher(text2);
        Ref<Integer> textOffset = Ref.create(0);
        int pos = 0;
        while (matcher.find(pos)) {
            textOffset.set(textOffset.get() + matcher.start() - pos);
            pos = this.extractExpectedHighlight(matcher, text2, document, textOffset);
        }
    }

    private int extractExpectedHighlight(Matcher matcher, String text2, Document document, Ref<Integer> textOffset) {
        int toContinueFrom;
        boolean closed;
        document.deleteString(textOffset.get(), textOffset.get() + matcher.end() - matcher.start());
        int groupIdx = 1;
        String marker = matcher.group(groupIdx++);
        String descr = matcher.group(groupIdx++);
        String typeString = matcher.group(groupIdx++);
        String foregroundColor = matcher.group(groupIdx++);
        String backgroundColor = matcher.group(groupIdx++);
        String effectColor = matcher.group(groupIdx++);
        String effectType = matcher.group(groupIdx++);
        String fontType = matcher.group(groupIdx++);
        String attrKey = matcher.group(groupIdx++);
        String bundleMessage = matcher.group(groupIdx++);
        String tooltip = matcher.group(groupIdx++);
        boolean bl = closed = matcher.group(groupIdx) != null;
        if (descr == null) {
            descr = ANY_TEXT;
        } else if (descr.equals("null")) {
            descr = null;
        }
        if (descr != null) {
            descr = descr.replaceAll("\\\\\\\\\"", "\"");
            descr = descr.replaceAll("\\\\\"", "\"");
        }
        if (tooltip == null) {
            tooltip = ANY_TEXT;
        } else if (tooltip.equals("null")) {
            tooltip = null;
        }
        if (tooltip != null) {
            tooltip = tooltip.replaceAll("\\\\\\\\\"", "\"");
            tooltip = tooltip.replaceAll("\\\\\"", "\"");
        }
        HighlightInfoType type = WHATEVER;
        if (typeString != null) {
            try {
                type = this.getTypeByName(typeString);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (type == null) {
                Assert.fail((String)("Wrong highlight type: " + typeString));
            }
        }
        TextAttributes forcedAttributes = null;
        if (foregroundColor != null) {
            int ft = fontType != null ? Integer.parseInt(fontType) : 0;
            forcedAttributes = new TextAttributes(Color.decode(foregroundColor), backgroundColor != null ? Color.decode(backgroundColor) : null, effectColor != null ? Color.decode(effectColor) : null, effectType != null ? EffectType.valueOf(effectType) : null, ft);
        }
        int rangeStart = textOffset.get();
        if (closed) {
            toContinueFrom = matcher.end();
        } else {
            int pos = matcher.end();
            Matcher closingTagMatcher = Pattern.compile("</" + marker + ">").matcher(text2);
            while (true) {
                int nextTagStart;
                if (!closingTagMatcher.find(pos)) {
                    toContinueFrom = pos;
                    break;
                }
                int n = nextTagStart = matcher.find(pos) ? matcher.start() : text2.length();
                if (closingTagMatcher.start() < nextTagStart) {
                    textOffset.set(textOffset.get() + closingTagMatcher.start() - pos);
                    document.deleteString(textOffset.get(), textOffset.get() + closingTagMatcher.end() - closingTagMatcher.start());
                    toContinueFrom = closingTagMatcher.end();
                    break;
                }
                textOffset.set(textOffset.get() + nextTagStart - pos);
                pos = this.extractExpectedHighlight(matcher, text2, document, textOffset);
            }
        }
        ExpectedHighlightingSet expectedHighlightingSet = this.myHighlightingTypes.get(marker);
        if (expectedHighlightingSet.enabled) {
            TextAttributesKey forcedTextAttributesKey = attrKey == null ? null : TextAttributesKey.createTextAttributesKey(attrKey);
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(type).range(rangeStart, textOffset.get()).severity(expectedHighlightingSet.severity);
            if (forcedAttributes != null) {
                builder2.textAttributes(forcedAttributes);
            }
            if (forcedTextAttributesKey != null) {
                builder2.textAttributes(forcedTextAttributesKey);
            }
            if (bundleMessage != null) {
                descr = this.extractDescrFromBundleMessage(bundleMessage);
            }
            if (descr != null) {
                builder2.description(descr);
            }
            if (tooltip != null) {
                builder2.unescapedToolTip(tooltip);
            }
            if (expectedHighlightingSet.endOfLine) {
                builder2.endOfLine();
            }
            HighlightInfo highlightInfo = builder2.createUnconditionally();
            expectedHighlightingSet.infos.add(highlightInfo);
        }
        return toContinueFrom;
    }

    @NotNull
    private String extractDescrFromBundleMessage(String bundleMessage) {
        String descr = null;
        List<String> split2 = StringUtil.split(bundleMessage, "|");
        String key = split2.get(0);
        List<String> keySplit = StringUtil.split(key, "#");
        ResourceBundle[] bundles = this.myMessageBundles;
        if (keySplit.size() == 2) {
            key = keySplit.get(1);
            bundles = new ResourceBundle[]{ResourceBundle.getBundle(keySplit.get(0))};
        } else {
            Assert.assertEquals((String)"Format for bundleMsg attribute is: [bundleName#] bundleKey [|argument]... ", (long)1L, (long)keySplit.size());
        }
        Assert.assertTrue((String)"messageBundles must be provided for bundleMsg tags in test data", (bundles.length > 0 ? 1 : 0) != 0);
        Object[] params = split2.stream().skip(1L).toArray();
        for (ResourceBundle bundle : bundles) {
            String message = AbstractBundle.messageOrDefault(bundle, key, null, params);
            if (message == null) continue;
            if (descr != null) {
                Assert.fail((String)("Key " + key + " is not unique in bundles for expected highlighting data"));
            }
            descr = message;
        }
        if (descr == null) {
            Assert.fail((String)("Can't find bundle message " + bundleMessage));
        }
        String string2 = descr;
        if (string2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(6);
        }
        return string2;
    }

    protected HighlightInfoType getTypeByName(String typeString) throws Exception {
        Field field = HighlightInfoType.class.getField(typeString);
        return (HighlightInfoType)field.get(null);
    }

    public void checkLineMarkers(@Nullable PsiFile psiFile, @NotNull Collection<? extends LineMarkerInfo> markerInfos, @NotNull String text2) {
        if (markerInfos == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(8);
        }
        String fileName = psiFile == null ? "" : psiFile.getName() + ": ";
        StringBuilder failMessage = new StringBuilder();
        for (LineMarkerInfo lineMarkerInfo : markerInfos) {
            if (this.containsLineMarker(lineMarkerInfo, this.myLineMarkerInfos.values())) continue;
            if (failMessage.length() > 0) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("extra ").append(ExpectedHighlightingData.rangeString(text2, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(this.sanitizedLineMarkerTooltip(lineMarkerInfo)).append('\'');
            Icon icon2 = lineMarkerInfo.getIcon();
            if (icon2 == null || icon2.toString().equals(ANY_TEXT)) continue;
            failMessage.append(" icon='").append(icon2).append('\'');
        }
        for (LineMarkerInfo lineMarkerInfo : this.myLineMarkerInfos.values()) {
            if (!markerInfos.isEmpty() && this.containsLineMarker(lineMarkerInfo, markerInfos)) continue;
            if (failMessage.length() > 0) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("missing ").append(ExpectedHighlightingData.rangeString(text2, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(this.sanitizedLineMarkerTooltip(lineMarkerInfo)).append('\'');
            Icon icon2 = lineMarkerInfo.getIcon();
            if (icon2 == null || icon2.toString().equals(ANY_TEXT)) continue;
            failMessage.append(" icon='").append(icon2).append('\'');
        }
        if (failMessage.length() > 0) {
            VirtualFile virtualFile2;
            String filePath = null;
            if (psiFile != null && (virtualFile2 = psiFile.getVirtualFile()) != null) {
                filePath = virtualFile2.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
            }
            throw new FileComparisonFailure(failMessage.toString(), this.myText, this.getActualLineMarkerFileText(markerInfos), filePath);
        }
    }

    protected String sanitizedLineMarkerTooltip(@NotNull LineMarkerInfo info2) {
        if (info2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(9);
        }
        return info2.getLineMarkerTooltip();
    }

    @NotNull
    private String getActualLineMarkerFileText(@NotNull Collection<? extends LineMarkerInfo> markerInfos) {
        if (markerInfos == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(10);
        }
        StringBuilder result2 = new StringBuilder();
        int index2 = 0;
        ArrayList<Pair> lineMarkerInfos = new ArrayList<Pair>(markerInfos.size() * 2);
        for (LineMarkerInfo lineMarkerInfo : markerInfos) {
            lineMarkerInfos.add(Pair.create(lineMarkerInfo, lineMarkerInfo.startOffset));
        }
        for (LineMarkerInfo lineMarkerInfo : markerInfos) {
            lineMarkerInfos.add(Pair.create(lineMarkerInfo, lineMarkerInfo.endOffset));
        }
        Collections.reverse(lineMarkerInfos.subList(markerInfos.size(), lineMarkerInfos.size()));
        lineMarkerInfos.sort(Comparator.comparingInt(o -> (Integer)o.second));
        String documentText = this.myDocument.getText();
        for (Pair info3 : lineMarkerInfos) {
            LineMarkerInfo expectedLineMarker = (LineMarkerInfo)info3.first;
            result2.append(documentText, index2, (int)((Integer)info3.second));
            if ((Integer)info3.second == expectedLineMarker.startOffset) {
                result2.append("<lineMarker descr=\"").append(this.sanitizedLineMarkerTooltip(expectedLineMarker)).append("\">");
            } else {
                result2.append("</lineMarker>");
            }
            index2 = (Integer)info3.second;
        }
        result2.append(documentText, index2, this.myDocument.getTextLength());
        String string2 = result2.toString();
        if (string2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(11);
        }
        return string2;
    }

    protected boolean containsLineMarker(@NotNull LineMarkerInfo info2, Collection<? extends LineMarkerInfo> where) {
        if (info2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(12);
        }
        Icon icon2 = info2.getIcon();
        for (LineMarkerInfo lineMarkerInfo : where) {
            if (lineMarkerInfo.startOffset != info2.startOffset || lineMarkerInfo.endOffset != info2.endOffset || !this.matchLineMarkersTooltip(info2, lineMarkerInfo) || !ExpectedHighlightingData.matchIcons(icon2, lineMarkerInfo.getIcon())) continue;
            return true;
        }
        return false;
    }

    protected boolean matchLineMarkersTooltip(@NotNull LineMarkerInfo info2, @NotNull LineMarkerInfo markerInfo) {
        if (info2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(13);
        }
        if (markerInfo == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(14);
        }
        return ExpectedHighlightingData.matchDescriptions(false, info2.getLineMarkerTooltip(), markerInfo.getLineMarkerTooltip());
    }

    protected static boolean matchIcons(Icon icon1, Icon icon2) {
        String s2;
        String s1 = String.valueOf(icon1);
        if (Comparing.strEqual(s1, s2 = String.valueOf(icon2))) {
            return true;
        }
        return Comparing.strEqual(ANY_TEXT, s1) || Comparing.strEqual(ANY_TEXT, s2);
    }

    public void checkResult(@Nullable PsiFile psiFile, Collection<? extends HighlightInfo> infos, String text2) {
        this.checkResult(psiFile, infos, text2, null);
    }

    public void checkResult(@Nullable PsiFile psiFile, Collection<? extends HighlightInfo> infos, String text2, @Nullable String filePath) {
        StringBuilder failMessage = new StringBuilder();
        Set<HighlightInfo> expectedFound = CollectionFactory.createCustomHashingStrategySet(new HashingStrategy<HighlightInfo>(){

            @Override
            public int hashCode(HighlightInfo object) {
                return object.hashCode();
            }

            @Override
            public boolean equals(HighlightInfo o1, HighlightInfo o2) {
                return o1 == null || o2 == null ? o1 == o2 : ExpectedHighlightingData.haveSamePresentation(o1, o2, true);
            }
        });
        if (!this.myIgnoreExtraHighlighting) {
            HashMap<ExpectedHighlightingSet, Set<HighlightInfo>> indexed = new HashMap<ExpectedHighlightingSet, Set<HighlightInfo>>();
            for (ExpectedHighlightingSet expectedHighlightingSet : this.myHighlightingTypes.values()) {
                indexed.put(expectedHighlightingSet, ExpectedHighlightingData.indexInfos(expectedHighlightingSet.infos));
            }
            for (HighlightInfo highlightInfo : infos) {
                ThreeState state = this.expectedInfosContainsInfo(highlightInfo, indexed);
                if (state == ThreeState.NO) {
                    ExpectedHighlightingData.reportProblem(psiFile, failMessage, text2, highlightInfo, "extra ");
                    failMessage.append(" [").append(highlightInfo.type).append(']');
                    continue;
                }
                if (state != ThreeState.YES) continue;
                if (expectedFound.contains(highlightInfo)) {
                    if (isDuplicatedCheckDisabled) {
                        ++failedDuplicationChecks;
                    } else {
                        ExpectedHighlightingData.reportProblem(psiFile, failMessage, text2, highlightInfo, "duplicated ");
                    }
                }
                expectedFound.add(highlightInfo);
            }
        }
        Set<HighlightInfo> indexedInfos = ExpectedHighlightingData.indexInfos(infos);
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            Set<HighlightInfo> expInfos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : expInfos) {
                if (indexedInfos.contains(expectedInfo) || !highlightingSet.enabled) continue;
                ExpectedHighlightingData.reportProblem(psiFile, failMessage, text2, expectedInfo, "missing ");
            }
        }
        if (failMessage.length() > 0) {
            VirtualFile virtualFile2;
            if (filePath == null && psiFile != null && (virtualFile2 = psiFile.getVirtualFile()) != null) {
                filePath = virtualFile2.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
            }
            failMessage.append('\n');
            this.compareTexts(infos, text2, failMessage.toString(), filePath);
        }
    }

    @NotNull
    private static Set<HighlightInfo> indexInfos(Collection<? extends HighlightInfo> infos) {
        Set<HighlightInfo> index2 = CollectionFactory.createCustomHashingStrategySet(new HashingStrategy<HighlightInfo>(){

            @Override
            public int hashCode(HighlightInfo object) {
                return object == null ? 0 : Objects.hash(object.startOffset, object.endOffset);
            }

            @Override
            public boolean equals(HighlightInfo o1, HighlightInfo o2) {
                return o1 == null || o2 == null ? o1 == o2 : ExpectedHighlightingData.matchesPattern(o1, o2, false);
            }
        });
        index2.addAll(infos);
        Set<HighlightInfo> set2 = index2;
        if (set2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(15);
        }
        return set2;
    }

    private static void reportProblem(@Nullable PsiFile psiFile, @NotNull StringBuilder failMessage, @NotNull String text2, @NotNull HighlightInfo info2, @NotNull String messageType) {
        if (failMessage == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(17);
        }
        if (info2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(18);
        }
        if (messageType == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(19);
        }
        String fileName = psiFile == null ? "" : psiFile.getName() + ": ";
        int startOffset = info2.startOffset;
        int endOffset = info2.endOffset;
        String s = text2.substring(startOffset, endOffset);
        String desc = info2.getDescription();
        if (failMessage.length() > 0) {
            failMessage.append('\n');
        }
        failMessage.append(fileName).append(messageType).append(ExpectedHighlightingData.rangeString(text2, startOffset, endOffset)).append(": '").append(s).append('\'');
        if (desc != null) {
            failMessage.append(" (").append(desc).append(')');
        }
    }

    private void compareTexts(Collection<? extends HighlightInfo> infos, String text2, String failMessage, @Nullable String filePath) {
        String actual = ExpectedHighlightingData.composeText(this.myHighlightingTypes, infos, text2, this.myMessageBundles);
        if (filePath != null && !this.myText.equals(actual)) {
            throw new FileComparisonFailure(failMessage, this.myText, actual, filePath);
        }
        Assert.assertEquals((String)(failMessage + "\n"), (Object)this.myText, (Object)actual);
        Assert.fail((String)failMessage);
    }

    private static String findTag(Map<String, ExpectedHighlightingSet> types, HighlightInfo info2) {
        Map.Entry entry = (Map.Entry)((Object)ContainerUtil.find(types.entrySet(), e -> ((ExpectedHighlightingSet)e.getValue()).enabled && ((ExpectedHighlightingSet)e.getValue()).severity == info2.getSeverity() && ((ExpectedHighlightingSet)e.getValue()).endOfLine == info2.isAfterEndOfLine()));
        return entry != null ? (String)entry.getKey() : null;
    }

    @NotNull
    public static String composeText(@NotNull Map<String, ExpectedHighlightingSet> types, @NotNull Collection<? extends HighlightInfo> infos, @NotNull String text2, ResourceBundle ... messageBundles) {
        if (types == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(20);
        }
        if (infos == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(22);
        }
        if (messageBundles == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(23);
        }
        List list2 = infos.stream().map(info2 -> Pair.pair(ExpectedHighlightingData.findTag(types, info2), info2)).filter(p -> p.first != null).collect(Collectors.toList());
        boolean showAttributesKeys = types.values().stream().flatMap(set2 -> set2.infos.stream()).anyMatch(i2 -> i2.forcedTextAttributesKey != null);
        String anyWrappedInHtml = XmlStringUtil.wrapInHtml(ANY_TEXT);
        boolean showTooltips = types.values().stream().flatMap(set2 -> set2.infos.stream()).anyMatch(i2 -> !anyWrappedInHtml.equals(i2.getToolTip()));
        list2.sort((o1, o2) -> {
            int bySeverity;
            HighlightInfo i1 = (HighlightInfo)o1.second;
            HighlightInfo i2 = (HighlightInfo)o2.second;
            int byEnds = i2.endOffset - i1.endOffset;
            if (byEnds != 0) {
                return byEnds;
            }
            if (!i1.isAfterEndOfLine() && !i2.isAfterEndOfLine()) {
                int byStarts = i1.startOffset - i2.startOffset;
                if (byStarts != 0) {
                    return byStarts;
                }
            } else {
                int byEOL = Boolean.compare(i2.isAfterEndOfLine(), i1.isAfterEndOfLine());
                if (byEOL != 0) {
                    return byEOL;
                }
            }
            if ((bySeverity = i2.getSeverity().compareTo(i1.getSeverity())) != 0) {
                return bySeverity;
            }
            return Comparing.compare(i1.getDescription(), i2.getDescription());
        });
        StringBuilder sb = new StringBuilder();
        int[] offsets2 = ExpectedHighlightingData.composeText(sb, list2, 0, text2, text2.length(), -1, showAttributesKeys, showTooltips, messageBundles);
        sb.insert(0, text2.substring(0, offsets2[1]));
        String string2 = sb.toString();
        if (string2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(24);
        }
        return string2;
    }

    @Deprecated
    public static void expectedDuplicatedHighlighting(@NotNull Runnable check) {
        if (check == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(25);
        }
        try {
            isDuplicatedCheckDisabled = true;
            failedDuplicationChecks = 0;
            check.run();
        }
        finally {
            isDuplicatedCheckDisabled = false;
        }
        if (failedDuplicationChecks == 0) {
            throw new IllegalStateException(EXPECTED_DUPLICATION_MESSAGE);
        }
    }

    private static int[] composeText(StringBuilder sb, List<? extends Pair<String, ? extends HighlightInfo>> list2, int index2, String text2, int endPos, int startPos, boolean showAttributesKeys, boolean showTooltip2, ResourceBundle ... messageBundles) {
        int i2;
        for (i2 = index2; i2 < list2.size(); ++i2) {
            Pair<String, ? extends HighlightInfo> pair = list2.get(i2);
            HighlightInfo info2 = (HighlightInfo)pair.second;
            if (info2.endOffset <= startPos) break;
            String severity = (String)pair.first;
            HighlightInfo prev = i2 < list2.size() - 1 ? (HighlightInfo)list2.get((int)(i2 + 1)).second : null;
            sb.insert(0, text2.substring(info2.endOffset, endPos));
            sb.insert(0, "</" + severity + ">");
            endPos = info2.endOffset;
            if (prev != null && prev.endOffset > info2.startOffset) {
                int[] offsets2 = ExpectedHighlightingData.composeText(sb, list2, i2 + 1, text2, endPos, info2.startOffset, showAttributesKeys, showTooltip2, messageBundles);
                i2 = offsets2[0] - 1;
                endPos = offsets2[1];
            }
            sb.insert(0, text2.substring(info2.startOffset, endPos));
            StringBuilder str = new StringBuilder().append('<').append(severity);
            String bundleMsg = ExpectedHighlightingData.composeBundleMsg(info2, messageBundles);
            if (bundleMsg != null) {
                str.append(" bundleMsg=\"").append(StringUtil.escapeQuotes(bundleMsg)).append('\"');
            } else if (info2.getSeverity() != HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY) {
                String description = info2.getDescription();
                String toolTip = info2.getToolTip();
                str.append(" descr=\"").append(StringUtil.escapeQuotes(String.valueOf(description))).append('\"');
                if (showTooltip2) {
                    str.append(" tooltip=\"").append(StringUtil.escapeQuotes(String.valueOf(toolTip != null ? XmlStringUtil.stripHtml(toolTip) : null))).append('\"');
                }
            }
            if (showAttributesKeys) {
                str.append(" textAttributesKey=\"").append(info2.forcedTextAttributesKey).append('\"');
            }
            str.append('>');
            sb.insert(0, str);
            endPos = info2.startOffset;
        }
        return new int[]{i2, endPos};
    }

    private static String composeBundleMsg(HighlightInfo info2, ResourceBundle ... messageBundles) {
        Object bundleKey = null;
        Object[] bundleMsgParams = null;
        block0: for (ResourceBundle bundle : messageBundles) {
            Enumeration<String> keys2 = bundle.getKeys();
            while (keys2.hasMoreElements()) {
                boolean matched;
                Object[] parse2;
                String key = keys2.nextElement();
                ParsePosition position = new ParsePosition(0);
                String value = bundle.getString(key);
                if (value.contains("{0")) {
                    parse2 = new MessageFormat(value).parse(info2.getDescription(), position);
                    matched = parse2 != null && info2.getDescription() != null && position.getIndex() == info2.getDescription().length() && position.getErrorIndex() == -1;
                } else {
                    parse2 = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                    matched = value.equals(info2.getDescription());
                }
                if (!matched) continue;
                if (bundleKey != null) {
                    bundleKey = null;
                    continue block0;
                }
                bundleKey = key;
                bundleMsgParams = parse2;
            }
        }
        if (bundleKey == null) {
            return null;
        }
        String bundleMsg = bundleKey;
        if (bundleMsgParams.length > 0) {
            bundleMsg = bundleMsg + "|" + StringUtil.join(ContainerUtil.map(bundleMsgParams, Objects::toString), "|");
        }
        return bundleMsg;
    }

    private ThreeState expectedInfosContainsInfo(HighlightInfo info2, Map<ExpectedHighlightingSet, Set<HighlightInfo>> indexed) {
        if (info2.getTextAttributes(null, null) == TextAttributes.ERASE_MARKER) {
            return ThreeState.UNSURE;
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            if (highlightingSet.severity != info2.getSeverity()) continue;
            if (!highlightingSet.enabled) {
                return ThreeState.UNSURE;
            }
            Set<HighlightInfo> index2 = indexed.get(highlightingSet);
            if (index2 == null || !index2.contains(info2)) continue;
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static boolean matchesPattern(@NotNull HighlightInfo expectedInfo, @NotNull HighlightInfo info2, boolean strictMatch) {
        if (expectedInfo == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(26);
        }
        if (info2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(27);
        }
        if (expectedInfo == info2) {
            return true;
        }
        boolean typeMatches = expectedInfo.type.equals(info2.type) || !strictMatch && (expectedInfo.type == WHATEVER || info2.type == WHATEVER);
        boolean textAttributesMatches = Comparing.equal(expectedInfo.getTextAttributes(null, null), info2.getTextAttributes(null, null)) || !strictMatch && (expectedInfo.forcedTextAttributes == null || info2.forcedTextAttributes == null);
        boolean attributesKeyMatches = !strictMatch && (expectedInfo.forcedTextAttributesKey == null || info2.forcedTextAttributesKey == null) || Objects.equals(expectedInfo.forcedTextAttributesKey, info2.forcedTextAttributesKey);
        return ExpectedHighlightingData.haveSamePresentation(info2, expectedInfo, strictMatch) && info2.getSeverity() == expectedInfo.getSeverity() && typeMatches && textAttributesMatches && attributesKeyMatches;
    }

    private static boolean haveSamePresentation(@NotNull HighlightInfo info1, @NotNull HighlightInfo info2, boolean strictMatch) {
        if (info1 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(28);
        }
        if (info2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(29);
        }
        return info1.startOffset == info2.startOffset && info1.endOffset == info2.endOffset && info1.isAfterEndOfLine() == info2.isAfterEndOfLine() && ExpectedHighlightingData.matchDescriptions(strictMatch, info1.getDescription(), info2.getDescription()) && ExpectedHighlightingData.matchTooltips(strictMatch, info1.getToolTip(), info2.getToolTip());
    }

    protected static boolean matchDescriptions(boolean strictMatch, String d1, String d2) {
        if (Comparing.strEqual(d1, d2)) {
            return true;
        }
        if (strictMatch) {
            return false;
        }
        if (Comparing.strEqual(ANY_TEXT, d1) || Comparing.strEqual(ANY_TEXT, d2)) {
            return true;
        }
        if (d1 != null && d2 != null) {
            if (d1.endsWith("\u2026") && d1.regionMatches(0, d2, 0, d1.length() - 1)) {
                return true;
            }
            if (d2.endsWith("\u2026") && d2.regionMatches(0, d1, 0, d2.length() - 1)) {
                return true;
            }
        }
        return false;
    }

    private static boolean matchTooltips(boolean strictMatch, String t1, String t2) {
        if (Comparing.strEqual(t1, t2)) {
            return true;
        }
        if (strictMatch) {
            return false;
        }
        t1 = t1 != null ? XmlStringUtil.stripHtml(t1) : null;
        t2 = t2 != null ? XmlStringUtil.stripHtml(t2) : null;
        return ExpectedHighlightingData.matchDescriptions(false, t1, t2);
    }

    private static String rangeString(String text2, int startOffset, int endOffset) {
        LineColumn start = StringUtil.offsetToLineColumn(text2, startOffset);
        assert (start != null) : "textLength = " + text2.length() + ", startOffset = " + startOffset;
        LineColumn end = StringUtil.offsetToLineColumn(text2, endOffset);
        assert (end != null) : "textLength = " + text2.length() + ", endOffset = " + endOffset;
        if (start.line == end.line) {
            return String.format("(%d:%d/%d)", start.line + 1, start.column + 1, end.column - start.column);
        }
        return String.format("(%d:%d..%d:%d)", start.line + 1, end.line + 1, start.column + 1, end.column + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 15, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSet";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ExpectedHighlightingData";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerInfos";
                break;
            }
            case 8: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = INFO_MARKER;
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failMessage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBundles";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedInfo";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ExpectedHighlightingData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDescrFromBundleMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualLineMarkerFileText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "indexInfos";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "composeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingType";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 24: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkLineMarkers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sanitizedLineMarkerTooltip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActualLineMarkerFileText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsLineMarker";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchLineMarkersTooltip";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "composeText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expectedDuplicatedHighlighting";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "matchesPattern";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "haveSamePresentation";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 11, 15, 24 -> new IllegalStateException(string2);
        };
    }

    public static class ExpectedHighlightingSet {
        private final HighlightSeverity severity;
        private final boolean endOfLine;
        private final boolean enabled;
        private final Set<HighlightInfo> infos;

        public ExpectedHighlightingSet(@NotNull HighlightSeverity severity, boolean endOfLine, boolean enabled) {
            if (severity == null) {
                ExpectedHighlightingSet.$$$reportNull$$$0(0);
            }
            this.severity = severity;
            this.endOfLine = endOfLine;
            this.enabled = enabled;
            this.infos = new HashSet<HighlightInfo>();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/testFramework/ExpectedHighlightingData$ExpectedHighlightingSet", "<init>"));
        }
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final String myTooltip;

        MyLineMarkerInfo(TextRange range, GutterIconRenderer.Alignment alignment, String tooltip, String iconPath) {
            super(NULL_POINTER, range, (Icon)new PathIcon(iconPath), (Supplier<String>)null, null, null, alignment);
            this.myTooltip = tooltip;
        }

        @Override
        public String getLineMarkerTooltip() {
            return this.myTooltip;
        }
    }

    private static class PathIcon
    implements Icon {
        private final String path;

        private PathIcon(@NotNull String path2) {
            if (path2 == null) {
                PathIcon.$$$reportNull$$$0(0);
            }
            this.path = path2;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof PathIcon && ((PathIcon)obj).path.equals(this.path);
        }

        public String toString() {
            return this.path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/ExpectedHighlightingData$PathIcon", "<init>"));
        }
    }
}

