/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorSplitterState;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.progress.TasksKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.FileEditorManagerTestCase;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.common.RunAllKt;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0004J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0014R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/testFramework/FileEditorManagerTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "manager", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "createFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "content", "", "getFile", "openFiles", "", "femSerialisedText", "setUp", "tearDown", "intellij.platform.testFramework"})
public abstract class FileEditorManagerTestCase
extends BasePlatformTestCase {
    @JvmField
    @Nullable
    protected FileEditorManagerImpl manager;

    @Override
    public void setUp() {
        super.setUp();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        CoroutineScope coroutineScope = this.getProject().getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"project.coroutineScope");
        this.manager = new FileEditorManagerImpl(project2, CoroutineScopeKt.childScope$default(coroutineScope, null, false, 3, null));
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        ComponentManager componentManager = project3;
        FileEditorManagerImpl fileEditorManagerImpl = this.manager;
        Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"testRootDisposable");
        ServiceContainerUtil.replaceService(componentManager, FileEditorManager.class, fileEditorManagerImpl, disposable);
        FileEditorProviderManager fileEditorProviderManager = FileEditorProviderManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)fileEditorProviderManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl");
        ((FileEditorProviderManagerImpl)fileEditorProviderManager).clearSelectedProviders();
        if (!(DockManager.getInstance((Project)this.getProject()).getContainers().size() == 1)) {
            boolean bl = false;
            String string2 = "The previous test didn't clear the state";
            throw new IllegalStateException(string2.toString());
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.getProject();
        Function0[] function0Array = new Function0[]{(Function0)new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileEditorManagerImpl fileEditorManagerImpl = this.this$0.manager;
                Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
                fileEditorManagerImpl.closeAllFiles();
            }
        }, (Function0)new Function0<Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                if (this.$project != null) {
                    Project project2 = this.$project;
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    EditorHistoryManager.Companion.getInstance(project2).removeAllFiles();
                }
            }
        }, tearDown.3.INSTANCE, (Function0)new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileEditorManagerImpl fileEditorManagerImpl = this.this$0.manager;
                Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
                Disposer.dispose((Disposable)fileEditorManagerImpl);
            }
        }, (Function0)new Function0<Unit>(this, project2){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                this.this$0.manager = null;
                if (this.$project != null) {
                    Project project2 = this.$project;
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    ComponentManager $this$serviceIfCreated$iv = project2;
                    boolean $i$f$serviceIfCreated = false;
                    DockManager dockManager = $this$serviceIfCreated$iv.getServiceIfCreated(DockManager.class);
                    Set<E> set2 = dockManager != null ? dockManager.getContainers() : null;
                    if (set2 == null) {
                        set2 = SetsKt.emptySet();
                    }
                    BasePlatformTestCase.assertSize(1, (Collection)set2);
                }
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileEditorManagerTestCase.access$tearDown$s497353094(this.this$0);
            }
        }};
        RunAllKt.runAll((Function0[])function0Array);
    }

    @NotNull
    protected final VirtualFile getFile(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String fullPath = this.getTestDataPath() + path2;
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file2);
        VirtualFile virtualFile2 = file2;
        Intrinsics.checkNotNull((Object)virtualFile2);
        return virtualFile2;
    }

    @NotNull
    protected final VirtualFile createFile(@NotNull String path2, @NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Path io = Path.of(this.getTestDataPath() + path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)io, (String)"io");
        PathKt.write$default(io, content2, 0, 0, 6, null);
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(io);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + io), (Object)file2);
        VirtualFile virtualFile2 = file2;
        Intrinsics.checkNotNull((Object)virtualFile2);
        return virtualFile2;
    }

    protected final void openFiles(@NotNull String femSerialisedText) {
        Intrinsics.checkNotNullParameter((Object)femSerialisedText, (String)"femSerialisedText");
        Element element = JDOMUtil.load(femSerialisedText);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(femSerialisedText)");
        Element rootElement = element;
        ExpandMacroToPathMap map2 = new ExpandMacroToPathMap();
        map2.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map2.substitute(rootElement, true, true);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        TasksKt.runBlockingModalWithRawProgressReporter((Project)project2, (String)"", (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, rootElement, null){
            int label;
            final /* synthetic */ FileEditorManagerTestCase this$0;
            final /* synthetic */ Element $rootElement;
            {
                this.this$0 = $receiver;
                this.$rootElement = $rootElement;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FileEditorManagerImpl fileEditorManagerImpl = this.this$0.manager;
                        Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
                        this.label = 1;
                        Object object3 = fileEditorManagerImpl.getMainSplitters().restoreEditors(new EditorSplitterState(this.$rootElement), false, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ void access$tearDown$s497353094(FileEditorManagerTestCase $this) {
        super.tearDown();
    }
}

