/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.FileStructureTestFixture;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightFixtureTestCase;
import com.intellij.util.PathUtil;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileStructureTestBase
extends CodeInsightFixtureTestCase {
    protected FileStructureTestFixture myPopupFixture;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPopupFixture = new FileStructureTestFixture(this.myFixture);
    }

    protected void configureDefault() {
        this.myFixture.configureByFile(PathUtil.makeFileName(this.getTestName(false), this.getFileExtension()));
    }

    protected abstract String getFileExtension();

    @Override
    public void tearDown() throws Exception {
        try {
            Disposer.dispose(this.myPopupFixture);
            this.myPopupFixture = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkTree(String filter2) {
        this.checkTree(filter2, true);
    }

    protected void checkTree() {
        EdtTestUtilKt.runInEdtAndWait(() -> {
            this.checkTree(null, true);
            return null;
        });
    }

    protected void checkTree(boolean expandAll) {
        this.checkTree(null, expandAll);
    }

    protected void checkTree(@Nullable String filter2, boolean expandAll) {
        this.configureDefault();
        this.myPopupFixture.update();
        if (filter2 != null) {
            this.setSearchFilter(filter2);
        }
        if (expandAll) {
            PlatformTestUtil.expandAll((JTree)this.myPopupFixture.getTree());
        }
        this.checkResult();
    }

    protected void setSearchFilter(@NotNull String filter2) {
        if (filter2 == null) {
            FileStructureTestBase.$$$reportNull$$$0(0);
        }
        this.myPopupFixture.getPopup().setSearchFilterForTests(filter2);
        PlatformTestUtil.waitForPromise(this.myPopupFixture.getPopup().rebuildAndUpdate());
        this.myPopupFixture.getSpeedSearch().findAndSelectElement(filter2);
    }

    protected void checkResult() {
        String expectedFileName = this.getTestDataPath() + "/" + PathUtil.makeFileName(this.getTestName(false), "tree");
        PlatformTestUtil.waitWhileBusy((JTree)this.myPopupFixture.getTree());
        FileStructureTestBase.assertSameLinesWithFile(expectedFileName, PlatformTestUtil.print((JTree)this.myPopupFixture.getTree(), true).trim());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/testFramework/FileStructureTestBase", "setSearchFilter"));
    }
}

