/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J,\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/testFramework/HeavyTestHelper;", "", "()V", "createTempDirectoryForTempDirTestFixture", "Ljava/nio/file/Path;", "dir", "prefix", "", "createTestProjectStructure", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "rootPath", "addProjectRoots", "", "getOrCreateProjectBaseDir", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.testFramework"})
@ApiStatus.Internal
public final class HeavyTestHelper {
    @NotNull
    public static final HeavyTestHelper INSTANCE = new HeavyTestHelper();

    private HeavyTestHelper() {
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile createTestProjectStructure(@Nullable Module module2, @Nullable String rootPath, @NotNull Path dir, boolean addProjectRoots) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(dir);
        if (virtualFile2 == null) {
            throw new IllegalStateException("Cannot find virtual directory by " + dir);
        }
        VirtualFile virtualDir = virtualFile2;
        virtualDir.getChildren();
        virtualDir.refresh(false, true);
        WriteAction.computeAndWait(() -> HeavyTestHelper.createTestProjectStructure$lambda$1(rootPath, virtualDir, addProjectRoots, module2));
        return virtualDir;
    }

    @JvmStatic
    @NotNull
    public static final Path createTempDirectoryForTempDirTestFixture(@Nullable Path dir, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Path path2 = dir;
        if (path2 == null) {
            path2 = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        }
        Path parentDir = path2;
        Files.createDirectories(parentDir, new FileAttribute[0]);
        Path path3 = Files.createTempDirectory(parentDir, prefix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createTempDirectory(parentDir, prefix)");
        return path3;
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile getOrCreateProjectBaseDir(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path path2 = ProjectKt.getStateStore(project2).getProjectBasePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"project.stateStore.getProjectBasePath()");
        Path basePath = path2;
        LocalFileSystem fs = LocalFileSystem.getInstance();
        VirtualFile baseDir = fs.findFileByNioFile(basePath);
        if (baseDir == null) {
            Files.createDirectories(basePath, new FileAttribute[0]);
            VirtualFile virtualFile2 = fs.refreshAndFindFileByNioFile(basePath);
            Intrinsics.checkNotNull((Object)virtualFile2);
            return virtualFile2;
        }
        return baseDir;
    }

    private static final Boolean createTestProjectStructure$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createTestProjectStructure$lambda$1(String $rootPath, VirtualFile $virtualDir, boolean $addProjectRoots, Module $module) {
        Intrinsics.checkNotNullParameter((Object)$virtualDir, (String)"$virtualDir");
        if ($rootPath != null) {
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(StringsKt.replace$default((String)$rootPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
            if (virtualFile2 == null) {
                throw new Exception($rootPath + " not found");
            }
            VirtualFile vDir1 = virtualFile2;
            VfsUtil.copyDirectory(null, vDir1, $virtualDir, null);
        }
        if ($addProjectRoots) {
            Module module2 = $module;
            Intrinsics.checkNotNull((Object)module2);
            ModuleRootModificationUtil.modifyModel(module2, arg_0 -> HeavyTestHelper.createTestProjectStructure$lambda$1$lambda$0((Function1)new Function1<ModifiableRootModel, Boolean>($virtualDir){
                final /* synthetic */ VirtualFile $virtualDir;
                {
                    this.$virtualDir = $virtualDir;
                    super(1);
                }

                public final Boolean invoke(ModifiableRootModel model2) {
                    model2.addContentEntry(this.$virtualDir).addSourceFolder(this.$virtualDir, false);
                    return true;
                }
            }, arg_0));
        }
        return Unit.INSTANCE;
    }
}

