/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.RestartableLexer;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(String text2) {
        this.doTest(text2, null);
    }

    protected void doTest(String text2, @Nullable String expected) {
        this.doTest(text2, expected, this.createLexer());
    }

    protected void doTest(String text2, @Nullable String expected, @NotNull Lexer lexer) {
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(0);
        }
        String result2 = this.printTokens(lexer, text2, 0);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result2);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result2);
        }
    }

    protected String printTokens(Lexer lexer, CharSequence text2, int start) {
        return LexerTestCase.printTokens(text2, start, lexer);
    }

    @NotNull
    protected String getPathToTestDataFile(String extension2) {
        String string2 = IdeaTestExecutionPolicy.getHomePathWithPolicy() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension2;
        if (string2 == null) {
            LexerTestCase.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        return ".txt";
    }

    protected void checkZeroState(String text2, TokenSet tokenTypes) {
        IElementType type;
        Lexer lexer = this.createLexer();
        lexer.start(text2);
        while ((type = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + type + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected String printTokens(String text2, int start) {
        return LexerTestCase.printTokens(text2, start, this.createLexer());
    }

    protected void checkCorrectRestart(@NotNull String text2) {
        IElementType type;
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(2);
        }
        Lexer mainLexer = this.createLexer();
        List<Trinity<IElementType, Integer, Integer>> allTokens = LexerTestCase.tokenize(text2, 0, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start(text2);
        int index2 = 0;
        while ((type = auxLexer.getTokenType()) != null) {
            int state = auxLexer.getState();
            if (state == 0 || auxLexer instanceof RestartableLexer && ((RestartableLexer)((Object)auxLexer)).isRestartableState(state)) {
                int tokenStart = auxLexer.getTokenStart();
                List<Trinity<IElementType, Integer, Integer>> expectedTokens = allTokens.subList(index2, allTokens.size());
                List<Trinity<IElementType, Integer, Integer>> restartedTokens = LexerTestCase.tokenize(text2, tokenStart, state, mainLexer);
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + " - " + auxLexer.getTokenText() + "\nAll tokens <type, offset, lexer state>: " + allTokens + "\n"), (String)expectedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")), (String)restartedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")));
            }
            ++index2;
            auxLexer.advance();
        }
    }

    @NotNull
    private static List<Trinity<IElementType, Integer, Integer>> tokenize(@NotNull String text2, int start, int state, @NotNull Lexer lexer) {
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(3);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(4);
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> allTokens = new ArrayList<Trinity<IElementType, Integer, Integer>>();
        try {
            lexer.start(text2, start, text2.length(), state);
        }
        catch (Throwable t) {
            LOG.error("Restarting impossible from offset " + start, t);
            throw new RuntimeException(t);
        }
        while (lexer.getTokenType() != null) {
            allTokens.add(Trinity.create(lexer.getTokenType(), lexer.getTokenStart(), lexer.getState()));
            lexer.advance();
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> arrayList = allTokens;
        if (arrayList == null) {
            LexerTestCase.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static String printTokens(CharSequence text2, int start, Lexer lexer) {
        IElementType tokenType;
        lexer.start(text2, start, text2.length());
        StringBuilder result2 = new StringBuilder();
        while ((tokenType = lexer.getTokenType()) != null) {
            result2.append(LexerTestCase.printSingleToken(text2, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return result2.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator iterator2) {
        if (iterator2 == null) {
            LexerTestCase.$$$reportNull$$$0(6);
        }
        CharSequence text2 = iterator2.getDocument().getCharsSequence();
        StringBuilder result2 = new StringBuilder();
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            result2.append(LexerTestCase.printSingleToken(text2, tokenType, iterator2.getStart(), iterator2.getEnd()));
            iterator2.advance();
        }
        String string2 = result2.toString();
        if (string2 == null) {
            LexerTestCase.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public static String printSingleToken(CharSequence fileText, IElementType tokenType, int start, int end) {
        return tokenType + " ('" + LexerTestCase.getTokenText(tokenType, fileText, start, end) + "')\n";
    }

    protected void doFileTest(String fileExt) {
        this.doTest(this.loadTestDataFile("." + fileExt));
    }

    @NotNull
    protected String loadTestDataFile(String fileExt) {
        String fileName = this.getPathToTestDataFile(fileExt);
        String text2 = "";
        try {
            String fileText = FileUtil.loadFile(new File(fileName));
            text2 = StringUtil.convertLineSeparators(this.shouldTrim() ? fileText.trim() : fileText);
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        String string2 = text2;
        if (string2 == null) {
            LexerTestCase.$$$reportNull$$$0(8);
        }
        return string2;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String getTokenText(IElementType tokenType, CharSequence sequence, int start, int end) {
        String string2 = tokenType instanceof TokenWrapper ? ((TokenWrapper)tokenType).getValue() : StringUtil.replace(sequence.subSequence(start, end).toString(), "\n", "\\n");
        if (string2 == null) {
            LexerTestCase.$$$reportNull$$$0(9);
        }
        return string2;
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToTestDataFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "printTokens";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestDataFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkCorrectRestart";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "printTokens";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 5, 7, 8, 9 -> new IllegalStateException(string2);
        };
    }
}

