/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.FileBasedTestCaseHelper;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.TestDataPath;
import com.intellij.testFramework.TestIndexingModeSupporter;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase
implements TestIndexingModeSupporter {
    private Editor myEditor;
    private PsiFile myFile;
    private VirtualFile myVFile;
    private TestIndexingModeSupporter.IndexingMode myIndexingMode = TestIndexingModeSupporter.IndexingMode.SMART;
    @Parameterized.Parameter
    public String myFileSuffix;
    @Parameterized.Parameter(value=1)
    public String myTestDataPath;

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(0);
        }
        if (this.isRunInCommand()) {
            Ref e = new Ref();
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
                try {
                    super.runTestRunnable(testRunnable);
                }
                catch (Throwable throwable) {
                    e.set(throwable);
                }
            }, null, null);
            if (!e.isNull()) {
                throw (Throwable)e.get();
            }
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    protected boolean isRunInCommand() {
        return true;
    }

    protected void configureByFile(@TestDataFile @NonNls @NotNull String relativePath) {
        if (relativePath == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(1);
        }
        try {
            String fullPath = this.getTestDataPath() + relativePath;
            File ioFile = new File(fullPath);
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            String fileText = FileUtilRt.loadFile(ioFile, "UTF-8", true);
            this.configureFromFileText(ioFile.getName(), fileText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected String getAnswerFilePath() {
        String string2 = this.getTestDataPath() + this.myFileSuffix + ".txt";
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NonNls
    @NotNull
    protected String getTestDataPath() {
        if (this.myTestDataPath != null) {
            String string2 = this.myTestDataPath;
            if (string2 == null) {
                LightPlatformCodeInsightTestCase.$$$reportNull$$$0(3);
            }
            return string2;
        }
        String string3 = PathManagerEx.getTestDataPath();
        if (string3 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(4);
        }
        return string3;
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(5);
        }
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        LightPlatformCodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        VirtualFile virtualFile2 = vFile;
        if (virtualFile2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(6);
        }
        return virtualFile2;
    }

    @NotNull
    protected Document configureFromFileText(@NonNls @NotNull String fileName, @NonNls @NotNull String fileText) {
        if (fileName == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(7);
        }
        if (fileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(8);
        }
        Document document = this.configureFromFileText(fileName, fileText, false);
        if (document == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(9);
        }
        return document;
    }

    @NotNull
    protected Document configureFromFileText(@NonNls @NotNull String fileName, @NonNls @NotNull String fileText, boolean checkCaret) {
        if (fileName == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(10);
        }
        if (fileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(11);
        }
        Document document = WriteCommandAction.writeCommandAction(null).compute(() -> {
            Document document;
            DocumentImpl fakeDocument = new DocumentImpl(fileText);
            EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            if (checkCaret) {
                LightPlatformCodeInsightTestCase.assertTrue((String)("No caret specified in " + fileName), (boolean)caretsState.hasExplicitCaret());
            }
            String newFileText = fakeDocument.getText();
            try {
                document = this.setupFileEditorAndDocument(fileName, newFileText);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EditorTestUtil.setCaretsAndSelection(this.getEditor(), caretsState);
            this.setupEditorForInjectedLanguage();
            this.getIndexingMode().ensureIndexingStatus(this.getProject());
            return document;
        });
        if (document == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(12);
        }
        return document;
    }

    @NotNull
    protected Editor configureFromFileTextWithoutPSI(@NonNls @NotNull String fileText) {
        if (fileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(13);
        }
        Editor editor2 = WriteCommandAction.writeCommandAction(this.getProject()).compute(() -> {
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            Document document = EditorFactory.getInstance().createDocument((CharSequence)newFileText);
            Editor editor2 = EditorFactory.getInstance().createEditor(document, this.getProject());
            ((EditorImpl)editor2).setCaretActive();
            EditorTestUtil.setCaretsAndSelection(editor2, caretsState);
            this.getIndexingMode().ensureIndexingStatus(this.getProject());
            return editor2;
        });
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(14);
        }
        return editor2;
    }

    @NotNull
    protected Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(15);
        }
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        Editor editor2 = FileEditorManager.getInstance(this.getProject()).openTextEditor(new OpenFileDescriptor(this.getProject(), file2, 0), false);
        DaemonCodeAnalyzer.getInstance(this.getProject()).restart();
        LightPlatformCodeInsightTestCase.assertNotNull((Object)editor2);
        ((EditorImpl)editor2).setCaretActive();
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
        Editor editor3 = editor2;
        if (editor3 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(16);
        }
        return editor3;
    }

    @NotNull
    private Document setupFileEditorAndDocument(@NotNull String relativePath, @NotNull String fileText) throws IOException {
        if (relativePath == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(17);
        }
        if (fileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(18);
        }
        EncodingProjectManager.getInstance(this.getProject()).setEncoding(null, StandardCharsets.UTF_8);
        PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
        this.deleteVFile();
        this.myEditor = this.createSaveAndOpenFile(relativePath, fileText);
        this.myVFile = FileDocumentManager.getInstance().getFile(this.getEditor().getDocument());
        this.myFile = this.getPsiManager().findFile(this.myVFile);
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
        Document document = this.getEditor().getDocument();
        if (document == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(19);
        }
        return document;
    }

    @NotNull
    protected Editor createSaveAndOpenFile(@NotNull String relativePath, @NotNull String fileText) {
        if (relativePath == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(20);
        }
        if (fileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(21);
        }
        Editor editor2 = this.createEditor(VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), relativePath, fileText));
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
        Editor editor3 = editor2;
        if (editor3 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(22);
        }
        return editor3;
    }

    @NotNull
    protected static VirtualFile createAndSaveFile(@NotNull String relativePath, @NotNull String fileText) {
        if (relativePath == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(23);
        }
        if (fileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(24);
        }
        VirtualFile virtualFile2 = VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), relativePath, fileText);
        if (virtualFile2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(25);
        }
        return virtualFile2;
    }

    protected void setupEditorForInjectedLanguage() {
        if (this.getEditor() != null) {
            Editor hostEditor = this.getEditor() instanceof EditorWindow ? ((EditorWindow)this.getEditor()).getDelegate() : this.getEditor();
            PsiFile hostFile = this.myFile == null ? null : InjectedLanguageManager.getInstance(this.getProject()).getTopLevelFile(this.myFile);
            Ref editorWindowRef = new Ref();
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                Editor editor2 = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(hostEditor, hostFile);
                if (caret == hostEditor.getCaretModel().getPrimaryCaret() && editor2 instanceof EditorWindow) {
                    editorWindowRef.set((EditorWindow)editor2);
                }
            });
            if (!editorWindowRef.isNull()) {
                this.myEditor = (Editor)editorWindowRef.get();
                this.myFile = ((EditorWindow)editorWindowRef.get()).getInjectedFile();
                this.myVFile = this.myFile.getVirtualFile();
            }
        }
    }

    private void deleteVFile() throws IOException {
        if (this.myVFile != null) {
            if (this.myVFile instanceof VirtualFileWindow) {
                this.myVFile = ((VirtualFileWindow)((Object)this.myVFile)).getDelegate();
            }
            if (this.myVFile.isWritable() && !this.myVFile.getFileSystem().isReadOnly()) {
                WriteAction.run(() -> {
                    PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
                    FileEditorManager.getInstance(this.getProject()).closeFile(this.myVFile);
                    this.myVFile.delete(this.getProject());
                });
            }
            this.getIndexingMode().ensureIndexingStatus(this.getProject());
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getIndexingMode().setUpTest(this.getProject(), this.getTestRootDisposable());
    }

    @Before
    public void before() throws Throwable {
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            Project project2 = this.getProject();
            if (this.myIndexingMode != null && project2 != null) {
                this.myIndexingMode.tearDownTest(project2);
                FileEditorManager editorManager = FileEditorManager.getInstance(project2);
                for (VirtualFile openFile : editorManager.getOpenFiles()) {
                    editorManager.closeFile(openFile);
                }
            }
            this.deleteVFile();
            this.myEditor = null;
            this.myFile = null;
            this.myVFile = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkResultByFile(@TestDataFile @NonNls @NotNull String expectedFilePath) {
        if (expectedFilePath == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(26);
        }
        this.checkResultByFile(null, expectedFilePath, false);
    }

    protected void checkResultByFile(@Nullable String message, @TestDataFile @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) {
        String fileText;
        if (expectedFilePath == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(27);
        }
        this.bringRealEditorBack();
        PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            Editor editor2 = this.getEditor();
            TrailingSpacesStripper.strip((Document)editor2.getDocument(), (boolean)false, (boolean)true);
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)editor2);
        }
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + expectedFilePath;
        File ioFile = new File(fullPath);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message), (boolean)ioFile.exists());
        try {
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            fileText = FileUtil.loadFile(ioFile, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.checkResultByText(message, StringUtil.convertLineSeparators(fileText), ignoreTrailingSpaces, this.getTestDataPath() + "/" + expectedFilePath);
    }

    protected void checkResultByText(@NonNls @NotNull String expectedFileText) {
        if (expectedFileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(28);
        }
        this.checkResultByText(null, expectedFileText, false, null);
    }

    protected void checkResultByText(@Nullable String message, @NotNull String expectedFileText, boolean ignoreTrailingSpaces) {
        if (expectedFileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(29);
        }
        this.checkResultByText(message, expectedFileText, ignoreTrailingSpaces, null);
    }

    protected void checkResultByText(@Nullable String message, @NotNull String expectedFileText, boolean ignoreTrailingSpaces, @Nullable String filePath) {
        if (expectedFileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(30);
        }
        this.bringRealEditorBack();
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = EditorFactory.getInstance().createDocument((CharSequence)expectedFileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
            String newFileText = document.getText();
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
            String fileText1 = this.myFile.getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(this.getEditor(), carets, message);
        });
    }

    protected void checkResultByTextWithoutPSI(@Nullable String message, @NotNull Editor editor2, @NotNull String fileText, boolean ignoreTrailingSpaces, @Nullable String filePath) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(31);
        }
        if (fileText == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(32);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)fakeDocument).stripTrailingSpaces(this.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            String fileText1 = editor2.getDocument().getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(editor2, carets, message);
        });
    }

    @NotNull
    private static String getMessage(@NonNls @NotNull String engineMessage, @Nullable String userMessage) {
        if (engineMessage == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(33);
        }
        if (userMessage == null) {
            String string2 = engineMessage;
            if (string2 == null) {
                LightPlatformCodeInsightTestCase.$$$reportNull$$$0(34);
            }
            return string2;
        }
        String string3 = userMessage + " [" + engineMessage + "]";
        if (string3 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(35);
        }
        return string3;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    protected PsiFile getFile() {
        return this.myFile;
    }

    protected VirtualFile getVFile() {
        return this.myVFile;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        if (this.getEditor() instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.getEditor().getDocument()).getDelegate();
            this.myFile = PsiDocumentManager.getInstance(this.getProject()).getPsiFile(document);
            this.myEditor = ((EditorWindow)this.getEditor()).getDelegate();
            this.myVFile = this.myFile.getVirtualFile();
        }
    }

    protected void caretRight() {
        this.caretRight(this.getEditor());
    }

    public void caretRight(@NotNull Editor editor2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(36);
        }
        this.executeAction("EditorRight", editor2);
    }

    protected void caretUp() {
        this.caretUp(this.getEditor());
    }

    public void caretUp(@NotNull Editor editor2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(37);
        }
        this.executeAction("EditorUp", editor2);
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(this.getEditor(), this.getProject());
    }

    public static void deleteLine(@NotNull Editor editor2, @Nullable Project project2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(38);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteLine", editor2, project2);
    }

    protected void type(@NonNls @NotNull String s) {
        if (s == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(39);
        }
        for (char c2 : s.toCharArray()) {
            this.type(c2);
        }
    }

    protected void type(char c2) {
        LightPlatformCodeInsightTestCase.type(c2, this.getEditor(), this.getProject());
    }

    public static void type(char c2, @NotNull Editor editor2, @Nullable Project project2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(40);
        }
        if (c2 == '\n') {
            LightPlatformCodeInsightTestCase.executeAction("EditorEnter", editor2, project2);
        } else {
            DataContext dataContext2 = DataManager.getInstance().getDataContext();
            TypedAction action2 = TypedAction.getInstance();
            action2.actionPerformed(editor2, c2, dataContext2);
        }
    }

    protected void backspace() {
        LightPlatformCodeInsightTestCase.backspace(this.getEditor(), this.getProject());
    }

    public static void backspace(@NotNull Editor editor2, @Nullable Project project2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(41);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorBackSpace", editor2, project2);
    }

    protected void ctrlShiftF7() {
        HighlightUsagesHandler.invoke(this.getProject(), this.getEditor(), this.getFile());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(this.getEditor(), this.getProject());
    }

    public static void ctrlW(@NotNull Editor editor2, Project project2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(42);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectWord", editor2, project2);
    }

    public void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(this.getEditor(), this.getProject());
    }

    public static void ctrlD(@NotNull Editor editor2, Project project2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(43);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDuplicate", editor2, project2);
    }

    protected void delete() {
        LightPlatformCodeInsightTestCase.delete(this.getEditor(), this.getProject());
    }

    public static void delete(@NotNull Editor editor2, Project project2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(44);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDelete", editor2, project2);
    }

    protected void home() {
        this.executeAction("EditorLineStart");
    }

    protected void end() {
        this.executeAction("EditorLineEnd");
    }

    protected void homeWithSelection() {
        this.executeAction("EditorLineStartWithSelection");
    }

    protected void endWithSelection() {
        this.executeAction("EditorLineEndWithSelection");
    }

    protected void copy() {
        this.executeAction("EditorCopy");
    }

    protected void paste() {
        this.executeAction("EditorPaste");
    }

    protected void moveCaretToPreviousWordWithSelection() {
        this.executeAction("EditorPreviousWordWithSelection");
    }

    protected void moveCaretToNextWordWithSelection() {
        this.executeAction("EditorNextWordWithSelection");
    }

    protected void previousWord() {
        this.executeAction("EditorPreviousWord");
    }

    protected void nextWord() {
        this.executeAction("EditorNextWord");
    }

    protected void cutLineBackward() {
        this.executeAction("EditorCutLineBackward");
    }

    protected void cutToLineEnd() {
        this.executeAction("EditorCutLineEnd");
    }

    protected void deleteToLineStart() {
        this.executeAction("EditorDeleteToLineStart");
    }

    protected void deleteToLineEnd() {
        this.executeAction("EditorDeleteToLineEnd");
    }

    protected void killToWordStart() {
        this.executeAction("EditorKillToWordStart");
    }

    protected void killToWordEnd() {
        this.executeAction("EditorKillToWordEnd");
    }

    protected void killRegion() {
        this.executeAction("EditorKillRegion");
    }

    protected void killRingSave() {
        this.executeAction("EditorKillRingSave");
    }

    protected void unindent() {
        this.executeAction("EditorUnindentSelection");
    }

    protected void selectLine() {
        this.executeAction("EditorSelectLine");
    }

    protected void left() {
        this.executeAction("EditorLeft");
    }

    protected void right() {
        this.executeAction("EditorRight");
    }

    protected void leftWithSelection() {
        this.executeAction("EditorLeftWithSelection");
    }

    protected void rightWithSelection() {
        this.executeAction("EditorRightWithSelection");
    }

    protected void up() {
        this.executeAction("EditorUp");
    }

    protected void down() {
        this.executeAction("EditorDown");
    }

    protected void lineComment() {
        this.executeAction("CommentByLineComment");
    }

    protected void executeAction(@NonNls @NotNull String actionId) {
        if (actionId == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(45);
        }
        this.executeAction(actionId, this.getEditor());
    }

    protected void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor2) {
        if (actionId == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(46);
        }
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(47);
        }
        LightPlatformCodeInsightTestCase.executeAction(actionId, editor2, this.getProject());
    }

    public static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor2, @Nullable Project project2) {
        if (actionId == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(48);
        }
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(49);
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> EditorTestUtil.executeAction(editor2, actionId, true), "", null, editor2.getDocument());
    }

    @NotNull
    protected DataContext getCurrentEditorDataContext() {
        DataContext defaultContext = DataManager.getInstance().getDataContext();
        DataContext dataContext2 = dataId -> {
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return this.getEditor();
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.getProject();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                return this.getFile();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                PsiFile file2 = this.getFile();
                if (file2 == null) {
                    return null;
                }
                Editor editor2 = this.getEditor();
                if (editor2 == null) {
                    return null;
                }
                return file2.findElementAt(editor2.getCaretModel().getOffset());
            }
            return defaultContext.getData(dataId);
        };
        if (dataContext2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(50);
        }
        return dataContext2;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() {
        return Collections.emptyList();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params(@NotNull Class<?> klass) throws Throwable {
        Object testDataPath;
        Object testCase;
        if (klass == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(51);
        }
        if (!((testCase = klass.newInstance()) instanceof FileBasedTestCaseHelper)) {
            LightPlatformCodeInsightTestCase.fail((String)"Parameterized test should implement FileBasedTestCaseHelper");
        }
        try {
            PathManagerEx.replaceLookupStrategy(klass, Parameterized.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FileBasedTestCaseHelper fileBasedTestCase = (FileBasedTestCaseHelper)testCase;
        if (testCase instanceof LightPlatformCodeInsightTestCase) {
            testDataPath = ((LightPlatformCodeInsightTestCase)testCase).getTestDataPath();
        } else {
            try {
                Method dataPath = klass.getDeclaredMethod("getTestDataPath", new Class[0]);
                dataPath.setAccessible(true);
                testDataPath = (String)dataPath.invoke((Object)fileBasedTestCase, new Object[0]);
            }
            catch (Throwable e) {
                testDataPath = PathManagerEx.getTestDataPath();
            }
        }
        File testDir = null;
        if (fileBasedTestCase instanceof FileBasedTestCaseHelperEx) {
            testDir = new File((String)testDataPath, ((FileBasedTestCaseHelperEx)fileBasedTestCase).getRelativeBasePath());
        } else {
            TestDataPath annotation = klass.getAnnotation(TestDataPath.class);
            if (annotation == null) {
                LightPlatformCodeInsightTestCase.fail((String)"TestCase should implement com.intellij.testFramework.FileBasedTestCaseHelperEx or be annotated with com.intellij.testFramework.TestDataPath");
            } else {
                String trimmedRoot = StringUtil.trimStart(StringUtil.trimStart(annotation.value(), "$CONTENT_ROOT"), "$PROJECT_ROOT");
                String lastPathComponent = new File((String)testDataPath).getName();
                int idx = trimmedRoot.indexOf(lastPathComponent);
                testDataPath = ((String)testDataPath).replace(File.separatorChar, '/') + (idx > 0 ? trimmedRoot.substring(idx + lastPathComponent.length()) : trimmedRoot);
                testDir = new File((String)testDataPath);
            }
        }
        File[] files2 = testDir.listFiles();
        if (files2 == null) {
            LightPlatformCodeInsightTestCase.fail((String)("Test files not found in " + testDir.getPath()));
        }
        HashSet<String> beforeFileSuffixes = new HashSet<String>();
        HashSet<String> afterFileSuffixes = new HashSet<String>();
        ArrayList<Object[]> result2 = new ArrayList<Object[]>();
        for (File file2 : files2) {
            String fileSuffix = fileBasedTestCase.getFileSuffix(file2.getName());
            String fileAfterSuffix = fileBasedTestCase.getBaseName(file2.getName());
            if (fileAfterSuffix != null) {
                afterFileSuffixes.add(fileAfterSuffix);
            }
            if (fileSuffix == null) continue;
            beforeFileSuffixes.add(fileSuffix);
            result2.add(new Object[]{fileSuffix, testDataPath});
        }
        afterFileSuffixes.removeAll(beforeFileSuffixes);
        if (!afterFileSuffixes.isEmpty()) {
            LightPlatformCodeInsightTestCase.fail((String)("'After' file has no corresponding 'before' file: " + String.join((CharSequence)", ", afterFileSuffixes)));
        }
        return result2;
    }

    public String getName() {
        if (this.myFileSuffix != null) {
            return "test" + this.myFileSuffix;
        }
        return super.getName();
    }

    protected void setEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(52);
        }
        this.myEditor = editor2;
    }

    protected void setFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(53);
        }
        this.myFile = file2;
    }

    protected void setVFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(54);
        }
        this.myVFile = virtualFile2;
    }

    @Override
    public void setIndexingMode(@NotNull TestIndexingModeSupporter.IndexingMode mode) {
        if (mode == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(55);
        }
        this.myIndexingMode = mode;
    }

    @Override
    @NotNull
    public TestIndexingModeSupporter.IndexingMode getIndexingMode() {
        TestIndexingModeSupporter.IndexingMode indexingMode = this.myIndexingMode;
        if (indexingMode == null) {
            LightPlatformCodeInsightTestCase.$$$reportNull$$$0(56);
        }
        return indexingMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 9, 12, 14, 16, 19, 22, 25, 34, 35, 50, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 1: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 34: 
            case 35: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightPlatformCodeInsightTestCase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 15: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFilePath";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFileText";
                break;
            }
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineMessage";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 45: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightPlatformCodeInsightTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnswerFilePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "configureFromFileText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "configureFromFileTextWithoutPSI";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setupFileEditorAndDocument";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSaveAndOpenFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndSaveFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditorDataContext";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 34: 
            case 35: 
            case 50: 
            case 56: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureFromFileText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configureFromFileTextWithoutPSI";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupFileEditorAndDocument";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createSaveAndOpenFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createAndSaveFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByTextWithoutPSI";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "caretRight";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "caretUp";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "deleteLine";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "backspace";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "ctrlW";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "ctrlD";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "params";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setFile";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setVFile";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setIndexingMode";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 6, 9, 12, 14, 16, 19, 22, 25, 34, 35, 50, 56 -> new IllegalStateException(string2);
        };
    }
}

