/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ThreeState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent;
    private Language myLanguage;
    private long myCachedLength;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NlsSafe @NotNull String name) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(0);
        }
        this(name, "");
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @NotNull CharSequence content2) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(1);
        }
        if (content2 == null) {
            LightVirtualFile.$$$reportNull$$$0(2);
        }
        this(name, null, content2, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, FileType fileType, @NotNull CharSequence text2) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(4);
        }
        this(name, fileType, text2, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull VirtualFile original, @NotNull CharSequence text2, long modificationStamp) {
        if (original == null) {
            LightVirtualFile.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(6);
        }
        this(original.getName(), original.getFileType(), text2, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NotNull CharSequence text2, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(8);
        }
        this(name, fileType, text2, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text2), modificationStamp);
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NlsSafe @NotNull CharSequence text2, Charset charset, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(10);
        }
        super(name, fileType, modificationStamp);
        this.myCachedLength = Long.MIN_VALUE;
        this.setContentImpl(text2);
        this.setCharset(charset);
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @NotNull Language language, @NlsSafe @NotNull CharSequence text2) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(11);
        }
        if (language == null) {
            LightVirtualFile.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(13);
        }
        super(name, null, LocalTimeCounter.currentTime());
        this.myCachedLength = Long.MIN_VALUE;
        this.setContentImpl(text2);
        this.setLanguage(language);
        this.setCharset(StandardCharsets.UTF_8);
    }

    @Override
    protected void storeCharset(Charset charset) {
        super.storeCharset(charset);
        this.myCachedLength = Long.MIN_VALUE;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            LightVirtualFile.$$$reportNull$$$0(14);
        }
        this.myLanguage = language;
        FileType type = language.getAssociatedFileType();
        if (type == null) {
            type = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getNameSequence());
        }
        this.setFileType(type);
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
        if (inputStream == null) {
            LightVirtualFile.$$$reportNull$$$0(15);
        }
        return inputStream;
    }

    @Override
    public long getLength() {
        if (this.myCachedLength == Long.MIN_VALUE) {
            this.myCachedLength = super.getLength();
        }
        return this.myCachedLength;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (LightVirtualFile.this.isWritable());
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    LightVirtualFile.this.setContentImpl(this.toString(LightVirtualFile.this.getCharset().name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream == null) {
            LightVirtualFile.$$$reportNull$$$0(16);
        }
        return outputStream;
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        byte[] byArray = s.getBytes(charset);
        if (byArray == null) {
            LightVirtualFile.$$$reportNull$$$0(17);
        }
        return byArray;
    }

    public void setContent(Object requestor, @NotNull CharSequence content2, boolean fireEvent) {
        if (content2 == null) {
            LightVirtualFile.$$$reportNull$$$0(18);
        }
        this.assertWritable();
        this.setContentImpl(content2);
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void setContentImpl(@NotNull CharSequence content2) {
        if (content2 == null) {
            LightVirtualFile.$$$reportNull$$$0(19);
        }
        this.myContent = content2;
        this.myCachedLength = Long.MIN_VALUE;
    }

    @NotNull
    public CharSequence getContent() {
        CharSequence charSequence = this.myContent;
        if (charSequence == null) {
            LightVirtualFile.$$$reportNull$$$0(20);
        }
        return charSequence;
    }

    @NotNull
    public ThreeState isTooLargeForIntelligence() {
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            LightVirtualFile.$$$reportNull$$$0(21);
        }
        return threeState;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightVirtualFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "isTooLargeForIntelligence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setLanguage";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setContentImpl";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

