/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockProjectEx;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTracker;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTrackerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.ExtensionTestUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.testFramework.ParsingTestUtil;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;

public abstract class ParsingTestCase
extends UsefulTestCase {
    private PluginDescriptor myPluginDescriptor;
    private MockApplication myApp;
    protected MockProjectEx myProject;
    protected String myFilePrefix;
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager myPsiManager;
    private PsiFileFactoryImpl myFileFactory;
    protected Language myLanguage;
    private final ParserDefinition[] myDefinitions;
    private final boolean myLowercaseFirstLetter;
    private ExtensionPointImpl<KeyedLazyInstance<ParserDefinition>> myLangParserDefinition;

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(0);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(1);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(2);
        }
        this(dataPath, fileExt, false, definitions);
    }

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, boolean lowercaseFirstLetter, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(3);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(4);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(5);
        }
        this.myFilePrefix = "";
        this.myDefinitions = definitions;
        this.myFullDataPath = this.getTestDataPath() + "/" + dataPath;
        this.myFileExt = fileExt;
        this.myLowercaseFirstLetter = lowercaseFirstLetter;
    }

    @NotNull
    protected MockApplication getApplication() {
        MockApplication mockApplication = this.myApp;
        if (mockApplication == null) {
            ParsingTestCase.$$$reportNull$$$0(6);
        }
        return mockApplication;
    }

    @Override
    protected void setUp() throws Exception {
        MockApplication app;
        super.setUp();
        this.myApp = app = MockApplication.setUp(this.getTestRootDisposable());
        MutablePicoContainer appContainer = app.getPicoContainer();
        ComponentAdapter component2 = appContainer.getComponentAdapter(ProgressManager.class.getName());
        if (component2 == null) {
            appContainer.registerComponentInstance(ProgressManager.class.getName(), new ProgressManagerImpl());
        }
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        this.myProject = new MockProjectEx(this.getTestRootDisposable());
        this.myPsiManager = new MockPsiManager(this.myProject);
        this.myFileFactory = new PsiFileFactoryImpl(this.myPsiManager);
        appContainer.registerComponentInstance(MessageBus.class, app.getMessageBus());
        appContainer.registerComponentInstance(SchemeManagerFactory.class, new MockSchemeManagerFactory());
        MockEditorFactory editorFactory = new MockEditorFactory();
        appContainer.registerComponentInstance(EditorFactory.class, (Object)editorFactory);
        app.registerService(FileDocumentManager.class, new MockFileDocumentManagerImpl(FileDocumentManagerBase.HARD_REF_TO_DOCUMENT_KEY, editorFactory::createDocument));
        app.registerService(PluginUtil.class, new PluginUtilImpl());
        app.registerService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        app.registerService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        app.registerService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.myProject.registerService(PsiDocumentManager.class, new MockPsiDocumentManager());
        this.myProject.registerService(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(TreeAspect.class, new TreeAspect());
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myProject)));
        this.myProject.registerService(StartupManager.class, new StartupManagerImpl((Project)this.myProject, this.myProject.getCoroutineScope()));
        this.registerExtensionPoint(app.getExtensionArea(), FileTypeFactory.FILE_TYPE_FACTORY_EP, FileTypeFactory.class);
        this.registerExtensionPoint(app.getExtensionArea(), MetaLanguage.EP_NAME, MetaLanguage.class);
        this.myLangParserDefinition = app.getExtensionArea().registerFakeBeanPoint(LanguageParserDefinitions.INSTANCE.getName(), this.getPluginDescriptor());
        if (this.myDefinitions.length > 0) {
            this.configureFromParserDefinition(this.myDefinitions[0], this.myFileExt);
            int length = this.myDefinitions.length;
            for (int i2 = 1; i2 < length; ++i2) {
                this.registerParserDefinition(this.myDefinitions[i2]);
            }
        }
        this.myProject.registerService(PomModel.class, new PomModelImpl(this.myProject));
        Registry.markAsLoaded();
    }

    protected final void registerParserDefinition(final @NotNull ParserDefinition definition) {
        if (definition == null) {
            ParsingTestCase.$$$reportNull$$$0(7);
        }
        final Language language = definition.getFileNodeType().getLanguage();
        this.myLangParserDefinition.registerExtension(new KeyedLazyInstance<ParserDefinition>(){

            @Override
            public String getKey() {
                return language.getID();
            }

            @Override
            @NotNull
            public ParserDefinition getInstance() {
                ParserDefinition parserDefinition = definition;
                if (parserDefinition == null) {
                    1.$$$reportNull$$$0(0);
                }
                return parserDefinition;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/ParsingTestCase$1", "getInstance"));
            }
        });
        LanguageParserDefinitions.INSTANCE.clearCache(language);
        this.disposeOnTearDown(() -> LanguageParserDefinitions.INSTANCE.clearCache(language));
    }

    public void configureFromParserDefinition(@NotNull ParserDefinition definition, String extension2) {
        if (definition == null) {
            ParsingTestCase.$$$reportNull$$$0(8);
        }
        this.myLanguage = definition.getFileNodeType().getLanguage();
        this.myFileExt = extension2;
        this.registerParserDefinition(definition);
        this.myApp.registerService(FileTypeManager.class, new MockFileTypeManager(new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected final <T> void registerExtension(@NotNull ExtensionPointName<T> name, @NotNull T extension2) {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(9);
        }
        if (extension2 == null) {
            ParsingTestCase.$$$reportNull$$$0(10);
        }
        this.registerExtensions(name, extension2.getClass(), Collections.singletonList(extension2));
    }

    protected final <T> void registerExtensions(@NotNull ExtensionPointName<T> name, @NotNull Class<T> extensionClass, @NotNull List<? extends T> extensions2) {
        ExtensionsAreaImpl area;
        ExtensionPointImpl<T> point;
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(11);
        }
        if (extensionClass == null) {
            ParsingTestCase.$$$reportNull$$$0(12);
        }
        if (extensions2 == null) {
            ParsingTestCase.$$$reportNull$$$0(13);
        }
        if ((point = (area = this.myApp.getExtensionArea()).getExtensionPointIfRegistered(name.getName())) == null) {
            point = this.registerExtensionPoint(area, name, extensionClass);
        }
        for (T extension2 : extensions2) {
            point.registerExtension(extension2);
        }
    }

    protected final <T> void addExplicitExtension(@NotNull LanguageExtension<T> collector2, @NotNull Language language, @NotNull T object) {
        if (collector2 == null) {
            ParsingTestCase.$$$reportNull$$$0(14);
        }
        if (language == null) {
            ParsingTestCase.$$$reportNull$$$0(15);
        }
        if (object == null) {
            ParsingTestCase.$$$reportNull$$$0(16);
        }
        ExtensionsAreaImpl area = this.myApp.getExtensionArea();
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
        if (!area.hasExtensionPoint(collector2.getName())) {
            area.registerFakeBeanPoint(collector2.getName(), pluginDescriptor);
        }
        LanguageExtensionPoint<T> extension2 = new LanguageExtensionPoint<T>(language.getID(), object);
        extension2.setPluginDescriptor(pluginDescriptor);
        ExtensionTestUtil.addExtension(area, collector2, extension2);
    }

    protected final <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        if (extensionPointName == null) {
            ParsingTestCase.$$$reportNull$$$0(17);
        }
        if (aClass == null) {
            ParsingTestCase.$$$reportNull$$$0(18);
        }
        this.registerExtensionPoint(this.myApp.getExtensionArea(), extensionPointName, aClass);
    }

    protected <T> ExtensionPointImpl<T> registerExtensionPoint(@NotNull ExtensionsAreaImpl extensionArea, @NotNull BaseExtensionPointName<T> extensionPointName, @NotNull Class<T> extensionClass) {
        String name;
        if (extensionArea == null) {
            ParsingTestCase.$$$reportNull$$$0(19);
        }
        if (extensionPointName == null) {
            ParsingTestCase.$$$reportNull$$$0(20);
        }
        if (extensionClass == null) {
            ParsingTestCase.$$$reportNull$$$0(21);
        }
        if (extensionArea.hasExtensionPoint(name = extensionPointName.getName())) {
            return extensionArea.getExtensionPoint(name);
        }
        return extensionArea.registerPoint(name, extensionClass, this.getPluginDescriptor(), false);
    }

    @NotNull
    private PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.myPluginDescriptor;
        if (pluginDescriptor == null) {
            this.myPluginDescriptor = pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId(((Object)((Object)this)).getClass().getName() + "." + this.getName()), ParsingTestCase.class.getClassLoader());
        }
        PluginDescriptor pluginDescriptor2 = pluginDescriptor;
        if (pluginDescriptor2 == null) {
            ParsingTestCase.$$$reportNull$$$0(22);
        }
        return pluginDescriptor2;
    }

    @NotNull
    public MockProjectEx getProject() {
        MockProjectEx mockProjectEx = this.myProject;
        if (mockProjectEx == null) {
            ParsingTestCase.$$$reportNull$$$0(23);
        }
        return mockProjectEx;
    }

    public MockPsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFile = null;
        this.myProject = null;
        this.myPsiManager = null;
        this.myFileFactory = null;
        super.tearDown();
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    public final String getTestName() {
        String string2 = this.getTestName(this.myLowercaseFirstLetter);
        if (string2 == null) {
            ParsingTestCase.$$$reportNull$$$0(24);
        }
        return string2;
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void ensureNoErrorElements() {
        ParsingTestUtil.ensureNoErrorElements(this.myFile);
    }

    protected void doTest(boolean checkResult) {
        this.doTest(checkResult, false);
    }

    protected void doTest(boolean checkResult, boolean ensureNoErrorElements) {
        String name = this.getTestName();
        try {
            this.parseFile(name, this.loadFile(name + "." + this.myFileExt));
            if (checkResult) {
                this.checkResult(name, this.myFile);
                if (ensureNoErrorElements) {
                    this.ensureNoErrorElements();
                }
            } else {
                ParsingTestCase.toParseTreeText(this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected PsiFile parseFile(String name, String text2) {
        this.myFile = this.createPsiFile(name, text2);
        ParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)text2, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
        ParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)text2, (Object)LoadTextUtil.loadText(this.myFile.getVirtualFile()));
        ParsingTestCase.assertEquals((String)"doc text mismatch", (String)text2, (String)Objects.requireNonNull(this.myFile.getViewProvider().getDocument()).getText());
        if (this.checkAllPsiRoots()) {
            for (PsiFile root : this.myFile.getViewProvider().getAllFiles()) {
                ParsingTestCase.doSanityChecks(root);
            }
        } else {
            ParsingTestCase.doSanityChecks(this.myFile);
        }
        return this.myFile;
    }

    private static void doSanityChecks(PsiFile root) {
        ParsingTestCase.assertEquals((String)"psi text mismatch", (String)root.getViewProvider().getContents().toString(), (String)root.getText());
        ParsingTestCase.ensureParsed(root);
        ParsingTestCase.ensureCorrectReparse(root);
        ParsingTestCase.checkRangeConsistency(root);
    }

    private static void checkRangeConsistency(final PsiFile file2) {
        file2.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof ForeignLeafPsiElement) {
                    return;
                }
                try {
                    this.ensureNodeRangeConsistency(element, file2);
                }
                catch (Throwable e) {
                    throw new AssertionError("In " + element + " of " + element.getClass(), e);
                }
                super.visitElement(element);
            }

            private void ensureNodeRangeConsistency(PsiElement parent2, PsiFile file22) {
                int parentOffset = parent2.getTextRange().getStartOffset();
                int childOffset = 0;
                ASTNode child = parent2.getNode().getFirstChildNode();
                if (child != null) {
                    while (child != null) {
                        int childLength = this.checkChildRangeConsistency(file22, parentOffset, childOffset, child);
                        childOffset += childLength;
                        child = child.getTreeNext();
                    }
                    TestCase.assertEquals((int)childOffset, (int)parent2.getTextLength());
                }
            }

            private int checkChildRangeConsistency(PsiFile file22, int parentOffset, int childOffset, ASTNode child) {
                TestCase.assertEquals((int)child.getStartOffsetInParent(), (int)childOffset);
                TestCase.assertEquals((int)child.getStartOffset(), (int)(childOffset + parentOffset));
                int childLength = child.getTextLength();
                TestCase.assertEquals((Object)TextRange.from(childOffset + parentOffset, childLength), (Object)child.getTextRange());
                if (!(child.getPsi() instanceof ForeignLeafPsiElement)) {
                    TestCase.assertEquals((String)child.getTextRange().substring(file22.getText()), (String)child.getText());
                }
                return childLength;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/ParsingTestCase$2", "visitElement"));
            }
        });
    }

    protected void doTest(String suffix) throws IOException {
        String name = this.getTestName();
        String text2 = this.loadFile(name + "." + this.myFileExt);
        this.myFile = this.createPsiFile(name, text2);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)text2, (String)this.myFile.getText());
        this.checkResult(name + suffix, this.myFile);
    }

    protected void doCodeTest(@NotNull String code) throws IOException {
        if (code == null) {
            ParsingTestCase.$$$reportNull$$$0(25);
        }
        String name = this.getTestName();
        this.myFile = this.createPsiFile("a", code);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)code, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + name, this.myFile);
    }

    protected PsiFile createPsiFile(@NotNull String name, @NotNull String text2) {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(26);
        }
        if (text2 == null) {
            ParsingTestCase.$$$reportNull$$$0(27);
        }
        return this.createFile(name + "." + this.myFileExt, text2);
    }

    protected PsiFile createFile(@NotNull String name, @NotNull String text2) {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(28);
        }
        if (text2 == null) {
            ParsingTestCase.$$$reportNull$$$0(29);
        }
        LightVirtualFile virtualFile2 = new LightVirtualFile(name, this.myLanguage, (CharSequence)text2);
        virtualFile2.setCharset(StandardCharsets.UTF_8);
        return this.createFile(virtualFile2);
    }

    protected PsiFile createFile(@NotNull LightVirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            ParsingTestCase.$$$reportNull$$$0(30);
        }
        return this.myFileFactory.trySetupPsiForFile(virtualFile2, this.myLanguage, true, false);
    }

    protected void checkResult(@NotNull @TestDataFile String targetDataName, @NotNull PsiFile file2) throws IOException {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(31);
        }
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(32);
        }
        ParsingTestCase.doCheckResult(this.myFullDataPath, file2, this.checkAllPsiRoots(), targetDataName, this.skipSpaces(), this.includeRanges(), this.allTreesInSingleFile());
        if (SystemProperties.getBooleanProperty("dumpAstTypeNames", false)) {
            this.printAstTypeNamesTree(targetDataName, file2);
        }
    }

    private void printAstTypeNamesTree(@NotNull @TestDataFile String targetDataName, @NotNull PsiFile file2) {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(33);
        }
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(34);
        }
        StringBuffer buffer = new StringBuffer();
        Arrays.stream(file2.getNode().getChildren(TokenSet.ANY)).forEach(it -> ParsingTestCase.printAstTypeNamesTree(it, buffer, 0));
        try {
            Files.writeString(Paths.get(this.myFullDataPath, targetDataName + ".fleet.txt"), (CharSequence)buffer, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printAstTypeNamesTree(ASTNode node2, StringBuffer buffer, int indent) {
        buffer.append(" ".repeat(indent));
        buffer.append(node2.getElementType()).append("\n");
        indent += 2;
        for (ASTNode childNode = node2.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            ParsingTestCase.printAstTypeNamesTree(childNode, buffer, indent);
        }
    }

    protected boolean allTreesInSingleFile() {
        return false;
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file2, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges) {
        if (testDataDir == null) {
            ParsingTestCase.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(36);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(37);
        }
        ParsingTestCase.doCheckResult(testDataDir, file2, checkAllPsiRoots, targetDataName, skipSpaces, printRanges, false);
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file2, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges, boolean allTreesInSingleFile) {
        if (testDataDir == null) {
            ParsingTestCase.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(39);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(40);
        }
        FileViewProvider provider2 = file2.getViewProvider();
        Set<Language> languages = provider2.getLanguages();
        if (!checkAllPsiRoots || languages.size() == 1) {
            ParsingTestCase.doCheckResult(testDataDir, targetDataName + ".txt", ParsingTestCase.toParseTreeText(file2, skipSpaces, printRanges).trim());
            return;
        }
        if (allTreesInSingleFile) {
            String expectedName = targetDataName + ".txt";
            StringBuilder sb = new StringBuilder();
            ArrayList<Language> languagesList = new ArrayList<Language>(languages);
            ContainerUtil.sort(languagesList, Comparator.comparing(Language::getID));
            for (Language language : languagesList) {
                sb.append("Subtree: ").append(language.getDisplayName()).append(" (").append(language.getID()).append(")").append("\n").append(ParsingTestCase.toParseTreeText(provider2.getPsi(language), skipSpaces, printRanges).trim()).append("\n").append(StringUtil.repeat("-", 80)).append("\n");
            }
            ParsingTestCase.doCheckResult(testDataDir, expectedName, sb.toString());
        } else {
            for (Language language : languages) {
                PsiFile root = provider2.getPsi(language);
                ParsingTestCase.assertNotNull((String)("FileViewProvider " + provider2 + " didn't return PSI root for language " + language.getID()), (Object)root);
                String expectedName = targetDataName + "." + language.getID() + ".txt";
                ParsingTestCase.doCheckResult(testDataDir, expectedName, ParsingTestCase.toParseTreeText(root, skipSpaces, printRanges).trim());
            }
        }
    }

    protected void checkResult(@NotNull String actual) {
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(41);
        }
        String name = this.getTestName();
        ParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + name + ".txt", actual);
    }

    protected void checkResult(@NotNull @TestDataFile String targetDataName, @NotNull String actual) {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(42);
        }
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(43);
        }
        ParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, actual);
    }

    public static void doCheckResult(@NotNull String fullPath, @NotNull String targetDataName, @NotNull String actual) {
        if (fullPath == null) {
            ParsingTestCase.$$$reportNull$$$0(44);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(45);
        }
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(46);
        }
        String expectedFileName = fullPath + File.separatorChar + targetDataName;
        UsefulTestCase.assertSameLinesWithFile(expectedFileName, actual);
    }

    protected static String toParseTreeText(@NotNull PsiElement file2, boolean skipSpaces, boolean printRanges) {
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(47);
        }
        return DebugUtil.psiToString(file2, !skipSpaces, printRanges);
    }

    protected String loadFile(@NotNull @TestDataFile String name) throws IOException {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(48);
        }
        return ParsingTestCase.loadFileDefault(this.myFullDataPath, name);
    }

    public static String loadFileDefault(@NotNull String dir, @NotNull String name) throws IOException {
        if (dir == null) {
            ParsingTestCase.$$$reportNull$$$0(49);
        }
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(50);
        }
        return FileUtil.loadFile(new File(dir, name), "UTF-8", true).trim();
    }

    public static void ensureParsed(@NotNull PsiFile file2) {
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(51);
        }
        file2.accept(new PsiElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                element.acceptChildren(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/ParsingTestCase$3", "visitElement"));
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile file2) {
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(52);
        }
        String psiToStringDefault = DebugUtil.psiToString(file2, true, false);
        DebugUtil.performPsiModification("ensureCorrectReparse", () -> {
            String fileText = file2.getText();
            DiffLog diffLog = new BlockSupportImpl().reparseRange(file2, file2.getNode(), TextRange.allOf(fileText), fileText, new EmptyProgressIndicator(), fileText);
            diffLog.performActualPsiChange(file2);
        });
        ParsingTestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString(file2, true, false));
    }

    public void registerMockInjectedLanguageManager() {
        this.registerExtensionPoint(this.myProject.getExtensionArea(), MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME, MultiHostInjector.class);
        this.registerExtensionPoint(this.myApp.getExtensionArea(), LanguageInjector.EXTENSION_POINT_NAME, LanguageInjector.class);
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
        this.getApplication().registerService(EditorWindowTracker.class, new EditorWindowTrackerImpl());
        this.myProject.registerService(InjectedLanguageManager.class, new InjectedLanguageManagerImpl(this.myProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 6: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 9: 
            case 11: 
            case 26: 
            case 28: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionArea";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 31: 
            case 33: 
            case 37: 
            case 40: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDataName";
                break;
            }
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 47: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataDir";
                break;
            }
            case 41: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplication";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerParserDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureFromParserDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doCodeTest";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 31: 
            case 32: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "printAstTypeNamesTree";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doCheckResult";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "toParseTreeText";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "loadFileDefault";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "ensureParsed";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectReparse";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 22, 23, 24 -> new IllegalStateException(string2);
        };
    }
}

