/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParsingTestUtil {
    private static final String SEPARATOR = "---------------";
    private static final String NL_SEPARATOR_NL = "\n---------------\n";

    private ParsingTestUtil() {
    }

    public static void ensureNoErrorElementsInAllSubTrees(@NotNull PsiFile file2) {
        if (file2 == null) {
            ParsingTestUtil.$$$reportNull$$$0(0);
        }
        for (PsiFile subTree : file2.getViewProvider().getAllFiles()) {
            ParsingTestUtil.ensureNoErrorElements(subTree);
        }
    }

    public static void ensureNoErrorElements(final @NotNull PsiFile file2) {
        if (file2 == null) {
            ParsingTestUtil.$$$reportNull$$$0(1);
        }
        file2.accept(new PsiRecursiveElementVisitor(){
            private static final int TAB_WIDTH = 8;

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                String text2 = file2.getText();
                String[] lines2 = StringUtil.splitByLinesKeepSeparators(text2);
                int offset2 = element.getTextOffset();
                LineColumn position = StringUtil.offsetToLineColumn(text2, offset2);
                int lineNumber = position != null ? position.line : -1;
                int column = position != null ? position.column : 0;
                String line = StringUtil.trimTrailing(lines2[lineNumber]);
                int numIndentTabs = StringUtil.countChars(line.subSequence(0, column), '\t', 0, true);
                int indentedColumn = column + numIndentTabs * 7;
                String lineWithNoTabs = StringUtil.repeat(" ", numIndentTabs * 8) + line.substring(numIndentTabs).replace('\t', ' ');
                String errorUnderline = StringUtil.repeat(" ", indentedColumn) + StringUtil.repeat("^", Math.max(1, element.getTextLength()));
                TestCase.fail((String)String.format("Unexpected error element: %s:%d:%d\n\n%s\n%s\n%s", file2.getName(), lineNumber + 1, column, lineWithNoTabs, errorUnderline, element.getErrorDescription()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/ParsingTestUtil$1", "visitErrorElement"));
            }
        });
    }

    @NotNull
    public static String psiFileToString(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ParsingTestUtil.$$$reportNull$$$0(2);
        }
        StringBuilder result2 = new StringBuilder();
        for (PsiFile subTree : psiFile.getViewProvider().getAllFiles()) {
            result2.append("Language: ").append(subTree.getLanguage()).append("\n").append(DebugUtil.psiToString(subTree, true, false));
        }
        String string2 = result2.toString();
        if (string2 == null) {
            ParsingTestUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public static void testIncrementalParsing(@NotNull PsiFile psiFile, @NotNull CharSequence newFileText, @NotNull String answersFilePath, boolean checkInitialTreeForErrors, boolean checkFinalTreeForErrors) {
        if (psiFile == null) {
            ParsingTestUtil.$$$reportNull$$$0(4);
        }
        if (newFileText == null) {
            ParsingTestUtil.$$$reportNull$$$0(5);
        }
        if (answersFilePath == null) {
            ParsingTestUtil.$$$reportNull$$$0(6);
        }
        if (checkInitialTreeForErrors) {
            ParsingTestUtil.ensureNoErrorElements(psiFile);
        }
        Project project2 = psiFile.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project2);
        Document fileDocument = psiDocumentManager.getDocument(psiFile);
        TestCase.assertNotNull((Object)fileDocument);
        psiDocumentManager.commitDocument(fileDocument);
        CharSequence originalText = fileDocument.getCharsSequence();
        StringBuilder result2 = new StringBuilder("Original text:").append(NL_SEPARATOR_NL).append(originalText).append(NL_SEPARATOR_NL);
        List<PsiFile> allFiles = psiFile.getViewProvider().getAllFiles();
        ContainerUtil.sort(allFiles, Comparator.comparing(it -> it.getLanguage().getID()));
        for (PsiFile subTree : allFiles) {
            UsefulTestCase.assertInstanceOf(subTree, PsiFileImpl.class);
            PsiFileImpl subTreeFile = (PsiFileImpl)subTree;
            TextRange changedRange = ChangedPsiRangeUtil.getChangedPsiRange(subTreeFile, Objects.requireNonNull(subTreeFile.getTreeElement()), newFileText);
            TestCase.assertNotNull((String)"No changes found", (Object)changedRange);
            Couple<ASTNode> reparseableRoots = BlockSupportImpl.findReparseableRoots(subTreeFile, subTree.getNode(), changedRange, newFileText);
            result2.append("Subtree: ").append(subTree.getLanguage()).append(NL_SEPARATOR_NL);
            ParsingTestUtil.serializeReparseableRoots(reparseableRoots, result2, newFileText);
            result2.append(NL_SEPARATOR_NL);
        }
        WriteAction.run(() -> fileDocument.setText(newFileText));
        psiDocumentManager.commitDocument(fileDocument);
        String psiBeforeCommit = ParsingTestUtil.psiFileToString(psiFile);
        WriteCommandAction.runWriteCommandAction(project2, () -> {
            fileDocument.setText("");
            psiDocumentManager.commitDocument(fileDocument);
            fileDocument.setText(newFileText);
            psiDocumentManager.commitDocument(fileDocument);
        });
        TestCase.assertEquals((String)"Reparsing error", (String)ParsingTestUtil.psiFileToString(psiFile), (String)psiBeforeCommit);
        if (checkFinalTreeForErrors) {
            ParsingTestUtil.ensureNoErrorElementsInAllSubTrees(psiFile);
        }
        UsefulTestCase.assertSameLinesWithFile(answersFilePath, result2.toString(), false);
    }

    private static void serializeReparseableRoots(@Nullable Couple<ASTNode> reparseableRoots, @NotNull StringBuilder result2, @NotNull CharSequence newText) {
        if (result2 == null) {
            ParsingTestUtil.$$$reportNull$$$0(7);
        }
        if (newText == null) {
            ParsingTestUtil.$$$reportNull$$$0(8);
        }
        TextRange reparsedRange = reparseableRoots == null ? TextRange.create(0, newText.length()) : TextRange.from(((ASTNode)reparseableRoots.first).getStartOffset(), ((ASTNode)reparseableRoots.second).getTextLength());
        result2.append(newText, 0, reparsedRange.getStartOffset());
        result2.append("<reparse>");
        result2.append(newText, reparsedRange.getStartOffset(), reparsedRange.getEndOffset());
        result2.append("</reparse>");
        result2.append(newText, reparsedRange.getEndOffset(), newText.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answersFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "psiFileToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureNoErrorElementsInAllSubTrees";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "ensureNoErrorElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToString";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "testIncrementalParsing";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serializeReparseableRoots";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

