/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class TempFiles {
    private final Collection<Path> myFilesToDelete;

    public TempFiles(@NotNull Collection<Path> filesToDelete) {
        if (filesToDelete == null) {
            TempFiles.$$$reportNull$$$0(0);
        }
        this.myFilesToDelete = filesToDelete;
    }

    @NotNull
    public VirtualFile createVFile(@NotNull String prefix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile2 = TempFiles.getVFileByFile(this.createTempFile(prefix));
        if (virtualFile2 == null) {
            TempFiles.$$$reportNull$$$0(2);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createVFile(@NotNull String prefix, String postfix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile2 = TempFiles.getVFileByFile(this.createTempFile(prefix, postfix));
        if (virtualFile2 == null) {
            TempFiles.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    @NotNull
    public File createTempFile(@NotNull String prefix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(5);
        }
        File file2 = this.createTempFile(prefix, null);
        if (file2 == null) {
            TempFiles.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(7);
        }
        File file2 = this.createTempFile(prefix, suffix, true);
        if (file2 == null) {
            TempFiles.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix, boolean isRefreshVfs) {
        File file2;
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(9);
        }
        try {
            File tempFile = FileUtilRt.createTempFile(prefix, suffix, false);
            this.tempFileCreated(tempFile.toPath());
            if (isRefreshVfs) {
                TempFiles.getVFileByFile(tempFile);
            }
            file2 = tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file2 == null) {
            TempFiles.$$$reportNull$$$0(10);
        }
        return file2;
    }

    private void tempFileCreated(@NotNull Path tempFile) {
        if (tempFile == null) {
            TempFiles.$$$reportNull$$$0(11);
        }
        this.myFilesToDelete.add(tempFile);
    }

    public static VirtualFile getVFileByFile(@NotNull File tempFile) {
        if (tempFile == null) {
            TempFiles.$$$reportNull$$$0(12);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
    }

    @NotNull
    public File createTempDir() {
        return this.createTempDir("dir");
    }

    @NotNull
    private File createTempDir(@NotNull String prefix) {
        File file2;
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(13);
        }
        try {
            File dir = FileUtil.createTempDirectory(prefix, "test", false);
            this.tempFileCreated(dir.toPath());
            HeavyPlatformTestCase.synchronizeTempDirVfs(TempFiles.getVFileByFile(dir));
            file2 = dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file2 == null) {
            TempFiles.$$$reportNull$$$0(14);
        }
        return file2;
    }

    @NotNull
    public VirtualFile createTempVDir() {
        VirtualFile virtualFile2 = this.createTempVDir("dir");
        if (virtualFile2 == null) {
            TempFiles.$$$reportNull$$$0(15);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createTempVDir(@NotNull String prefix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(16);
        }
        VirtualFile virtualFile2 = TempFiles.getVFileByFile(this.createTempDir(prefix));
        if (virtualFile2 == null) {
            TempFiles.$$$reportNull$$$0(17);
        }
        return virtualFile2;
    }

    public void deleteAll() {
        for (Path file2 : this.myFilesToDelete) {
            PathKt.delete(file2);
        }
    }

    @NotNull
    public VirtualFile createVFile(final @NotNull VirtualFile parentDir, final @NotNull String name, final @NotNull String text2) {
        if (parentDir == null) {
            TempFiles.$$$reportNull$$$0(18);
        }
        if (name == null) {
            TempFiles.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            TempFiles.$$$reportNull$$$0(20);
        }
        VirtualFile virtualFile2 = ApplicationManager.getApplication().runWriteAction(new Computable<VirtualFile>(){

            @Override
            public VirtualFile compute() {
                try {
                    VirtualFile virtualFile2 = parentDir.createChildData(this, name);
                    VfsUtil.saveText(virtualFile2, text2 + "\n");
                    return virtualFile2;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile2 == null) {
            TempFiles.$$$reportNull$$$0(21);
        }
        return virtualFile2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 14, 15, 17, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/TempFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/TempFiles";
                break;
            }
            case 2: 
            case 4: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createVFile";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createVFile";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 21: {
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tempFileCreated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVFileByFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTempDir";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTempVDir";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 6, 8, 10, 14, 15, 17, 21 -> new IllegalStateException(string2);
        };
    }
}

