/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.io.Ksuid;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001f\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u001f\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"generateName", "", "fileName", "refreshVfs", "", "Ljava/nio/file/Path;", "relativePath", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "data", "", "intellij.platform.testFramework"})
public final class TemporaryDirectoryKt {
    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $this$writeChild, @NotNull String relativePath, @NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        VirtualFile virtualFile2 = VfsTestUtil.createFile($this$writeChild, relativePath, data2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createFile(this, relativePath, data)");
        return virtualFile2;
    }

    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $this$writeChild, @NotNull String relativePath, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        VirtualFile virtualFile2 = VfsTestUtil.createFile($this$writeChild, relativePath, data2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createFile(this, relativePath, data)");
        return virtualFile2;
    }

    public static final void refreshVfs(@NotNull Path $this$refreshVfs) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshVfs, (String)"<this>");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            return;
        }
        VirtualFile virtualFile2 = localFileSystem.refreshAndFindFileByNioFile($this$refreshVfs);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile3};
        VfsUtil.markDirtyAndRefresh(false, true, true, virtualFileArray);
    }

    public static final void refreshVfs(@NotNull Path $this$refreshVfs, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshVfs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        TemporaryDirectoryKt.refreshVfs(NioPathUtil.getResolvedPath($this$refreshVfs, relativePath));
    }

    private static final String generateName(String fileName) {
        StringBuilder nameBuilder = new StringBuilder(fileName.length() + 1 + 27);
        int extIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (((CharSequence)fileName).length() > 0 && extIndex != 0) {
            if (extIndex == -1) {
                nameBuilder.append(fileName);
            } else {
                nameBuilder.append(fileName, 0, extIndex);
            }
            nameBuilder.append('_');
        }
        nameBuilder.append(Ksuid.generate());
        if (extIndex != -1) {
            nameBuilder.append(fileName, extIndex, fileName.length());
        }
        String string2 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nameBuilder.toString()");
        return string2;
    }

    public static final /* synthetic */ String access$generateName(String fileName) {
        return TemporaryDirectoryKt.generateName(fileName);
    }
}

