/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.testFramework.common.ThreadLeakTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class ThreadTracker {
    private static final Logger LOG = Logger.getInstance(ThreadTracker.class);
    private final Map<String, Thread> before = ThreadLeakTracker.getThreads();
    private final boolean myDefaultProjectInitialized = ProjectManagerEx.getInstanceEx().isDefaultProjectInitialized();

    @TestOnly
    public ThreadTracker() {
    }

    @TestOnly
    public void checkLeak() throws AssertionError {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((FileBasedIndexEx)FileBasedIndex.getInstance()).waitUntilIndicesAreInitialized();
        ((StubIndexImpl)StubIndex.getInstance()).waitUntilStubIndexedInitialized();
        ThreadLeakTracker.awaitQuiescence();
        try {
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceExIfCreated();
            if (projectManager != null && this.myDefaultProjectInitialized != projectManager.isDefaultProjectInitialized()) {
                return;
            }
            ThreadLeakTracker.checkLeak(this.before);
        }
        finally {
            this.before.clear();
        }
    }

    public static void awaitJDIThreadsTermination(int timeout, @NotNull TimeUnit unit) {
        Thread jdiThread;
        if (unit == null) {
            ThreadTracker.$$$reportNull$$$0(0);
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + unit.toMillis(timeout) && (jdiThread = (Thread)((Object)ContainerUtil.find(ThreadLeakTracker.getThreads().values(), thread -> {
            ThreadGroup group2 = thread.getThreadGroup();
            return group2 != null && group2.getParent() != null && "JDI main".equals(group2.getParent().getName());
        }))) != null) {
            try {
                long timeLeft = start + unit.toMillis(timeout) - System.currentTimeMillis();
                LOG.debug("Waiting for the " + jdiThread + " for " + timeLeft + "ms");
                jdiThread.join(timeLeft);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/testFramework/ThreadTracker", "awaitJDIThreadsTermination"));
    }
}

