/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.GlobalState;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UITestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.common.Cleanup;
import com.intellij.testFramework.common.TestApplicationKt;
import com.intellij.testFramework.common.TestEnvironmentKt;
import com.intellij.testFramework.common.ThreadUtil;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.CoreIconManager;
import com.intellij.ui.IconManager;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class UsefulTestCase
extends TestCase {
    @ApiStatus.Internal
    public static final boolean IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
    @ApiStatus.Internal
    public static final boolean IS_UNDER_SAFE_PUSH = IS_UNDER_TEAMCITY && "true".equals(System.getenv("SAFE_PUSH"));
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
    private static final String ORIGINAL_TEMP_DIR = FileUtilRt.getTempDirectory();
    private static final ObjectIntMap<String> TOTAL_SETUP_COST_MILLIS = new ObjectIntHashMap<String>();
    private static final ObjectIntMap<String> TOTAL_SETUP_COUNT = new ObjectIntHashMap<String>();
    private static final ObjectIntMap<String> TOTAL_TEARDOWN_COST_MILLIS = new ObjectIntHashMap<String>();
    private static final ObjectIntMap<String> TOTAL_TEARDOWN_COUNT = new ObjectIntHashMap<String>();
    protected static final Logger LOG = Logger.getInstance(UsefulTestCase.class);
    @Nullable
    private Disposable myTestRootDisposable;
    @Nullable
    private List<Path> myPathsToKeep;
    @Nullable
    private Path myTempDir;
    private static final CodeInsightSettings defaultSettings = new CodeInsightSettings();
    @Rule
    @NotNull
    public TestRule runBareTestRule;
    private List<Throwable> mySuppressedExceptions;

    @NotNull
    protected <R extends TestRule> R asOuterRule(@NotNull R rule) {
        if (rule == null) {
            UsefulTestCase.$$$reportNull$$$0(0);
        }
        this.runBareTestRule = RuleChain.outerRule(rule).around(this.runBareTestRule);
        R r = rule;
        if (r == null) {
            UsefulTestCase.$$$reportNull$$$0(1);
        }
        return r;
    }

    protected void addSuppressedException(@NotNull Throwable e) {
        List<Throwable> list2;
        if (e == null) {
            UsefulTestCase.$$$reportNull$$$0(2);
        }
        if ((list2 = this.mySuppressedExceptions) == null) {
            this.mySuppressedExceptions = list2 = new SmartList<Throwable>();
        }
        list2.add(e);
    }

    public UsefulTestCase() {
        this.runBareTestRule = (base, description) -> new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName();
                name = StringUtil.notNullize(StringUtil.substringBefore(name, "["), name);
                UsefulTestCase.this.setName(name);
                UsefulTestCase.this.checkShouldRunTest();
                UsefulTestCase.this.runBare(() -> ((Statement)base).evaluate());
            }
        };
    }

    public UsefulTestCase(@NotNull String name) {
        if (name == null) {
            UsefulTestCase.$$$reportNull$$$0(3);
        }
        super(name);
        this.runBareTestRule = (base, description) -> new /* invalid duplicate definition of identical inner class */;
    }

    protected void checkShouldRunTest() throws AssumptionViolatedException {
        Assume.assumeTrue((String)"skipped: shouldRunTest() returned false", (boolean)this.shouldRunTest());
    }

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        GlobalState.checkSystemStreams();
        this.setupTempDir();
        boolean isStressTest = this.isStressTest();
        ApplicationManagerEx.setInStressTest(isStressTest);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode(!isStressTest);
        if (this.isIconRequired()) {
            try {
                IconManager.activate((IconManager)new CoreIconManager());
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final void setupTempDir() throws IOException {
        if (this.myTempDir == null && this.shouldContainTempFiles()) {
            this.myTempDir = this.createGlobalTempDirectory();
        }
    }

    @ApiStatus.Internal
    @NotNull
    Path createGlobalTempDirectory() throws IOException {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        String testName = null;
        if (policy != null) {
            testName = policy.getPerTestTempDirName();
        }
        if (testName == null) {
            testName = FileUtil.sanitizeFileName(this.getTestName(true));
        }
        Path result2 = TemporaryDirectory.generateTemporaryPath(TEMP_DIR_MARKER + testName);
        Files.createDirectories(result2, new FileAttribute[0]);
        FileUtil.resetCanonicalTempPathCache(result2.toString());
        Path path2 = result2;
        if (path2 == null) {
            UsefulTestCase.$$$reportNull$$$0(4);
        }
        return path2;
    }

    @ApiStatus.Internal
    void removeGlobalTempDirectory(@NotNull Path dir) throws Exception {
        if (dir == null) {
            UsefulTestCase.$$$reportNull$$$0(5);
        }
        if (this.myPathsToKeep == null || this.myPathsToKeep.isEmpty()) {
            PathKt.delete(dir);
        } else {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
                for (Path file2 : directoryStream) {
                    if (this.shouldKeepTmpFile(file2)) continue;
                    FileUtil.delete(file2);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
    }

    protected boolean isIconRequired() {
        return false;
    }

    protected void tearDown() throws Exception {
        new RunAll(new ThrowableRunnable[]{() -> {
            if (this.isIconRequired()) {
                IconManager.deactivate();
                IconLoader.clearCacheInTests();
            }
        }, () -> this.disposeRootDisposable(), () -> GlobalState.checkSystemStreams(), () -> Cleanup.cleanupSwingDataStructures(), () -> Disposer.setDebugMode(true), () -> {
            if (this.myTempDir != null) {
                FileUtil.resetCanonicalTempPathCache(ORIGINAL_TEMP_DIR);
                try {
                    this.removeGlobalTempDirectory(this.myTempDir);
                }
                catch (Throwable e) {
                    ThreadUtil.printThreadDump();
                    throw e;
                }
            }
        }, () -> UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS), () -> UsefulTestCase.clearFields((Object)this)}).run(this.mySuppressedExceptions);
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose(this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull Path file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(6);
        }
        if (this.myPathsToKeep == null) {
            this.myPathsToKeep = new ArrayList<Path>();
        }
        this.myPathsToKeep.add(file2.toAbsolutePath());
    }

    private boolean shouldKeepTmpFile(@NotNull Path file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(7);
        }
        return this.myPathsToKeep != null && this.myPathsToKeep.contains(file2);
    }

    static void doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        if (oldCodeStyleSettings == null) {
            UsefulTestCase.$$$reportNull$$$0(8);
        }
        if (currentCodeStyleSettings == null) {
            UsefulTestCase.$$$reportNull$$$0(9);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[]{() -> {
            try {
                UsefulTestCase.checkCodeInsightSettingsNotOverwritten(settings);
            }
            catch (AssertionError error2) {
                UsefulTestCase.restoreCodeInsightSettingsToAvoidInducedErrors(settings);
                throw error2;
            }
        }, () -> {
            currentCodeStyleSettings.getIndentOptions(FileTypeManager.getInstance().getStdFileType("JAVA"));
            try {
                UsefulTestCase.checkCodeStyleSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }}).run();
    }

    private static void restoreCodeInsightSettingsToAvoidInducedErrors(@NotNull CodeInsightSettings settings) {
        if (settings == null) {
            UsefulTestCase.$$$reportNull$$$0(10);
        }
        CodeInsightSettings clean = new CodeInsightSettings();
        for (Field field : clean.getClass().getFields()) {
            try {
                ReflectionUtil.copyFieldValue(clean, settings, field);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.myTestRootDisposable;
        if (disposable == null) {
            this.myTestRootDisposable = disposable = new TestDisposable();
        }
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            UsefulTestCase.$$$reportNull$$$0(11);
        }
        return disposable2;
    }

    @Deprecated
    protected final void runTest() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Use runTestRunnable() to override the way tests are executed");
    }

    protected boolean shouldRunTest() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && !policy.canRun(((Object)((Object)this)).getClass())) {
            return false;
        }
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(12);
        }
        testRunnable.run();
    }

    protected void defaultRunBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(13);
        }
        try (AutoCloseable ignored = this::invokeTearDown;){
            this.invokeSetUp();
            this.runTestRunnable(testRunnable);
        }
    }

    protected final void invokeSetUp() throws Exception {
        long setupStart = System.nanoTime();
        this.setUp();
        long setupCost = (System.nanoTime() - setupStart) / 1000000L;
        this.logPerClassCost((int)setupCost, TOTAL_SETUP_COST_MILLIS, TOTAL_SETUP_COUNT);
    }

    protected void invokeTearDown() throws Exception {
        long teardownStart = System.nanoTime();
        this.tearDown();
        long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
        this.logPerClassCost((int)teardownCost, TOTAL_TEARDOWN_COST_MILLIS, TOTAL_TEARDOWN_COUNT);
    }

    private void logPerClassCost(int cost, @NotNull ObjectIntMap<String> costMap, @NotNull ObjectIntMap<String> countMap) {
        int storedCost;
        String name;
        if (costMap == null) {
            UsefulTestCase.$$$reportNull$$$0(14);
        }
        if (countMap == null) {
            UsefulTestCase.$$$reportNull$$$0(15);
        }
        costMap.put(name, ((storedCost = costMap.get(name = ((Object)((Object)this)).getClass().getSuperclass().getName())) == -1 ? 0 : storedCost) + cost);
        int storedCount = countMap.get(name);
        countMap.put(name, storedCount == -1 ? 1 : storedCount + 1);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (ObjectIntMap.Entry<String> entry : TOTAL_SETUP_COST_MILLIS.entries()) {
            String name = entry.getKey();
            int cost = entry.getValue();
            long count2 = TOTAL_SETUP_COUNT.get(name);
            System.out.printf("  %s: %d ms for %d executions%n", name, cost, count2);
            totalSetup += (long)cost;
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (ObjectIntMap.Entry<String> entry : TOTAL_TEARDOWN_COST_MILLIS.entries()) {
            String name = entry.getKey();
            int cost = entry.getValue();
            long count3 = TOTAL_TEARDOWN_COUNT.get(name);
            System.out.printf("  %s: %d ms for %d executions%n", name, cost, count3);
            totalTeardown += (long)cost;
        }
        System.out.printf("Total overhead: setup %d ms, teardown %d ms%n", totalSetup, totalTeardown);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']%n", totalSetup);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']%n", totalTeardown);
    }

    public final void runBare() throws Throwable {
        if (this.shouldRunTest()) {
            this.runBare(() -> super.runTest());
        }
    }

    protected void runBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(16);
        }
        ThrowableRunnable<Throwable> wrappedRunnable = this.wrapTestRunnable(testRunnable);
        if (this.runInDispatchThread()) {
            UITestUtil.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait(() -> this.defaultRunBare(wrappedRunnable));
        } else {
            this.defaultRunBare(wrappedRunnable);
        }
    }

    @NotNull
    protected ThrowableRunnable<Throwable> wrapTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(17);
        }
        Description testDescription = Description.createTestDescription(((Object)((Object)this)).getClass(), (String)this.getName());
        ThrowableRunnable<Throwable> throwableRunnable = () -> {
            boolean success = false;
            TestLoggerFactory.onTestStarted();
            try {
                testRunnable.run();
                success = true;
            }
            catch (AssumptionViolatedException e) {
                success = true;
                throw e;
            }
            catch (Throwable t) {
                TestLoggerFactory.logTestFailure((Throwable)t);
                throw t;
            }
            finally {
                TestLoggerFactory.onTestFinished((boolean)success, (Description)testDescription);
            }
        };
        if (throwableRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(18);
        }
        return throwableRunnable;
    }

    protected boolean runInDispatchThread() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            return policy.runInDispatchThread();
        }
        return true;
    }

    protected static <T extends Throwable> void edt(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(19);
        }
        EdtTestUtil.runInEdtAndWait(runnable);
    }

    @NotNull
    public static String toString(@NotNull Iterable<?> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(20);
        }
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder2 = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof Set) {
                builder2.append(new TreeSet((Set)o));
            } else {
                builder2.append(o);
            }
            builder2.append('\n');
            if (builder2.length() <= 1000000) continue;
            builder2.append("...\n");
            break;
        }
        String string2 = builder2.toString();
        if (string2 == null) {
            UsefulTestCase.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(T @NotNull [] actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(22);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(23);
        }
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(24);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(25);
        }
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static void assertOrderedEquals(byte @NotNull [] actual, byte @NotNull [] expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(26);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(27);
        }
        UsefulTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i2 = 0; i2 < actual.length; ++i2) {
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (byte)expected[i2], (byte)actual[i2]);
        }
    }

    public static void assertOrderedEquals(int @NotNull [] actual, int @NotNull [] expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(28);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(29);
        }
        if (actual.length != expected.length) {
            UsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual)));
        }
        for (int i2 = 0; i2 < actual.length; ++i2) {
            int a = actual[i2];
            int e = expected[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, T ... expected) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(30);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(31);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(32);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(33);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(34);
        }
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(35);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(36);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(37);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, expected, Objects::equals);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected, @NotNull BiPredicate<? super T, ? super T> predicate2) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(38);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(39);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(40);
        }
        if (predicate2 == null) {
            UsefulTestCase.$$$reportNull$$$0(41);
        }
        if (!UsefulTestCase.equals(actual, expected, predicate2)) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    private static <T> boolean equals(@NotNull Iterable<? extends T> a1, @NotNull Iterable<? extends T> a2, @NotNull BiPredicate<? super T, ? super T> predicate2) {
        if (a1 == null) {
            UsefulTestCase.$$$reportNull$$$0(42);
        }
        if (a2 == null) {
            UsefulTestCase.$$$reportNull$$$0(43);
        }
        if (predicate2 == null) {
            UsefulTestCase.$$$reportNull$$$0(44);
        }
        Iterator<T> it1 = a1.iterator();
        Iterator<T> it2 = a2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (it1.hasNext() && it2.hasNext() && predicate2.test(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(T @NotNull [] collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(45);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(46);
        }
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(T @NotNull [] actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(47);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(48);
        }
        UsefulTestCase.assertSameElements(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(49);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(50);
        }
        UsefulTestCase.assertSameElements(actual, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(51);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(52);
        }
        UsefulTestCase.assertSameElements("", actual, expected);
    }

    public static <T> void assertSameElements(@NotNull String message, @NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        if (message == null) {
            UsefulTestCase.$$$reportNull$$$0(53);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(54);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(55);
        }
        if (actual.size() != expected.size() || !new LinkedHashSet<T>(expected).equals(new LinkedHashSet<T>(actual))) {
            Assert.assertEquals((String)message, new LinkedHashSet<T>(expected), new LinkedHashSet<T>(actual));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(56);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(57);
        }
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(58);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(59);
        }
        PeekableIteratorWrapper<T> expectedIt = new PeekableIteratorWrapper<T>(expected.iterator());
        PeekableIteratorWrapper<T> actualIt = new PeekableIteratorWrapper<T>(collection.iterator());
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            Object actualElem;
            Object expectedElem = expectedIt.peek();
            if (expectedElem.equals(actualElem = actualIt.peek())) {
                expectedIt.next();
            }
            actualIt.next();
        }
        if (expectedIt.hasNext()) {
            throw new ComparisonFailure("", UsefulTestCase.toString(expected), UsefulTestCase.toString(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(60);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(61);
        }
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(62);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(63);
        }
        ArrayList<T> copy2 = new ArrayList<T>(collection);
        copy2.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy2, expected);
    }

    @NotNull
    public static String toString(Object @NotNull [] collection, @NotNull String separator) {
        if (separator == null) {
            UsefulTestCase.$$$reportNull$$$0(64);
        }
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(65);
        }
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(66);
        }
        if (notExpected == null) {
            UsefulTestCase.$$$reportNull$$$0(67);
        }
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> notExpected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(68);
        }
        if (notExpected == null) {
            UsefulTestCase.$$$reportNull$$$0(69);
        }
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(70);
        }
        if (separator == null) {
            UsefulTestCase.$$$reportNull$$$0(71);
        }
        List<String> list2 = ContainerUtil.sorted(ContainerUtil.map2List(collection, String::valueOf));
        StringBuilder builder2 = new StringBuilder();
        boolean flag2 = false;
        for (String o : list2) {
            if (flag2) {
                builder2.append(separator);
            }
            builder2.append(o);
            flag2 = true;
        }
        String string2 = builder2.toString();
        if (string2 == null) {
            UsefulTestCase.$$$reportNull$$$0(72);
        }
        return string2;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(73);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(74);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i2 = 0;
        for (T actual : collection) {
            try {
                checkers[i2].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i2 + ": " + actual);
                throw e;
            }
            ++i2;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(T @NotNull [] collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(75);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(76);
        }
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(77);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(78);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        Set<Consumer<T>> checkerSet = ContainerUtil.set(checkers);
        int i2 = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag2 = true;
            for (Consumer<? super T> consumer2 : checkerSet) {
                Throwable error2 = UsefulTestCase.accepts(consumer2, actual);
                if (error2 == null) {
                    checkerSet.remove(consumer2);
                    flag2 = false;
                    break;
                }
                lastError = error2;
            }
            if (flag2) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i2 + "): " + actual));
            }
            ++i2;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<? super T> condition, T actual) {
        if (condition == null) {
            UsefulTestCase.$$$reportNull$$$0(79);
        }
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        Object t;
        if (aClass == null) {
            UsefulTestCase.$$$reportNull$$$0(80);
        }
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: null"), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object object = t = o;
        if (object == null) {
            UsefulTestCase.$$$reportNull$$$0(81);
        }
        return (T)object;
    }

    public static <T> T assertOneElement(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(82);
        }
        if (collection.size() != 1) {
            Assert.assertEquals((String)collection.toString(), (long)1L, (long)collection.size());
        }
        return collection.iterator().next();
    }

    public static <T> T assertOneElement(T @NotNull [] ts) {
        if (ts == null) {
            UsefulTestCase.$$$reportNull$$$0(83);
        }
        if (ts.length != 1) {
            Assert.assertEquals((String)Arrays.toString(ts), (long)1L, (long)ts.length);
        }
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values2) {
        if (values2 == null) {
            UsefulTestCase.$$$reportNull$$$0(84);
        }
        for (T v : values2) {
            if (!Objects.equals(value, v)) continue;
            return;
        }
        Assert.fail((String)(value + " should be equal to one of " + Arrays.toString(values2)));
    }

    public static void assertEmpty(Object @NotNull [] array) {
        if (array == null) {
            UsefulTestCase.$$$reportNull$$$0(85);
        }
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertFalse((boolean)collection.isEmpty());
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(86);
        }
        if (!collection.isEmpty()) {
            UsefulTestCase.assertEmpty(collection.toString(), collection);
        }
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty("", collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty(s));
    }

    public static <T> void assertEmpty(@NotNull String errorMsg, @NotNull Collection<? extends T> collection) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(87);
        }
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(88);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, Object @NotNull [] array) {
        if (array == null) {
            UsefulTestCase.$$$reportNull$$$0(89);
        }
        if (array.length != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
        }
    }

    public static void assertSize(int expectedSize, @NotNull Collection<?> c2) {
        if (c2 == null) {
            UsefulTestCase.$$$reportNull$$$0(90);
        }
        if (c2.size() != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c2), (int)expectedSize, (int)c2.size());
        }
    }

    @NotNull
    protected <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        if (disposable == null) {
            UsefulTestCase.$$$reportNull$$$0(91);
        }
        Disposer.register(this.getTestRootDisposable(), disposable);
        T t = disposable;
        if (t == null) {
            UsefulTestCase.$$$reportNull$$$0(92);
        }
        return t;
    }

    public static void assertSameLines(@NotNull String expected, @NotNull String actual) {
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(93);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(94);
        }
        UsefulTestCase.assertSameLines(null, expected, actual);
    }

    public static void assertSameLines(@Nullable String message, @NotNull String expected, @NotNull String actual) {
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(95);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(96);
        }
        String expectedText = StringUtil.convertLineSeparators(expected.trim());
        String actualText = StringUtil.convertLineSeparators(actual.trim());
        Assert.assertEquals((String)message, (Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(97);
        }
        UsefulTestCase.assertTrue((String)("File should exist " + file2), (boolean)file2.exists());
    }

    public static void assertDoesntExist(@NotNull File file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(98);
        }
        UsefulTestCase.assertFalse((String)("File should not exist " + file2), (boolean)file2.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        return UsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
    }

    @NotNull
    public static String getTestName(@Nullable String name, boolean lowercaseFirstLetter) {
        String string2 = name == null ? "" : PlatformTestUtil.getTestName(name, lowercaseFirstLetter);
        if (string2 == null) {
            UsefulTestCase.$$$reportNull$$$0(99);
        }
        return string2;
    }

    @NotNull
    protected String getTestDirectoryName() {
        String string2 = this.getTestName(true).replaceAll("_.*", "");
        if (string2 == null) {
            UsefulTestCase.$$$reportNull$$$0(100);
        }
        return string2;
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText) {
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(101);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(102);
        }
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, @NotNull Supplier<String> messageProducer) {
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(103);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(104);
        }
        if (messageProducer == null) {
            UsefulTestCase.$$$reportNull$$$0(105);
        }
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true, messageProducer);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing) {
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(106);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(107);
        }
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, trimBeforeComparing, null);
    }

    protected static void checkCaseSensitiveFS(@NotNull String fullOrRelativePath, @NotNull File ioFile) throws IOException {
        if (fullOrRelativePath == null) {
            UsefulTestCase.$$$reportNull$$$0(108);
        }
        if (ioFile == null) {
            UsefulTestCase.$$$reportNull$$$0(109);
        }
        fullOrRelativePath = FileUtil.toSystemDependentName(FileUtil.toCanonicalPath(fullOrRelativePath));
        String canonicalPath = ioFile.getCanonicalPath();
        if (!canonicalPath.endsWith(fullOrRelativePath) && StringUtil.endsWithIgnoreCase(canonicalPath, fullOrRelativePath)) {
            throw new RuntimeException("Queried for: " + fullOrRelativePath + "; but found: " + canonicalPath);
        }
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing, @Nullable Supplier<String> messageProducer) {
        String fileText;
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(110);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(111);
        }
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath, actualText, trimBeforeComparing);
                System.out.println("File " + filePath + " created.");
            }
            File file2 = new File(filePath);
            UsefulTestCase.checkCaseSensitiveFS(filePath, file2);
            fileText = FileUtil.loadFile(file2, StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators(trimBeforeComparing ? fileText.trim() : fileText);
        String actual = StringUtil.convertLineSeparators(trimBeforeComparing ? actualText.trim() : actualText);
        if (!Objects.equals(expected, actual)) {
            throw new FileComparisonFailure(messageProducer == null ? null : messageProducer.get(), expected, actual, filePath);
        }
    }

    public static void assertTextEquals(@NotNull String expectedText, @NotNull String actualText) {
        if (expectedText == null) {
            UsefulTestCase.$$$reportNull$$$0(112);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(113);
        }
        UsefulTestCase.assertTextEquals(null, expectedText, actualText);
    }

    public static void assertTextEquals(@Nullable String message, @NotNull String expectedText, @NotNull String actualText) {
        if (expectedText == null) {
            UsefulTestCase.$$$reportNull$$$0(114);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(115);
        }
        if (!expectedText.equals(actualText)) {
            throw new FileComparisonFailure(Strings.notNullize(message), expectedText, actualText, null);
        }
    }

    protected static void clearFields(@NotNull Object test) throws IllegalAccessException {
        if (test == null) {
            UsefulTestCase.$$$reportNull$$$0(116);
        }
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(@NotNull Object test, @NotNull Class<?> aClass) throws IllegalAccessException {
        if (test == null) {
            UsefulTestCase.$$$reportNull$$$0(117);
        }
        if (aClass == null) {
            UsefulTestCase.$$$reportNull$$$0(118);
        }
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    private static void checkCodeStyleSettingsEqual(@NotNull CodeStyleSettings expected, @NotNull CodeStyleSettings settings) {
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(119);
        }
        if (settings == null) {
            UsefulTestCase.$$$reportNull$$$0(120);
        }
        if (!expected.equals((Object)settings)) {
            Element oldS = new Element("temp");
            expected.writeExternal(oldS);
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            String newString = JDOMUtil.writeElement(newS);
            String oldString = JDOMUtil.writeElement(oldS);
            Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
        }
    }

    private static void checkCodeInsightSettingsNotOverwritten(@NotNull CodeInsightSettings settings) {
        if (settings == null) {
            UsefulTestCase.$$$reportNull$$$0(121);
        }
        if (!settings.equals(defaultSettings)) {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            String DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement(oldS);
            Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement(newS));
        }
    }

    public final boolean isPerformanceTest() {
        return TestFrameworkUtil.isPerformanceTest((String)this.getName(), (String)((Object)((Object)this)).getClass().getSimpleName());
    }

    public final boolean isStressTest() {
        String className;
        String testName = this.getName();
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)(className = ((Object)((Object)this)).getClass().getSimpleName())) || UsefulTestCase.containsStressWords(testName) || UsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name) {
        return name != null && (name.contains("Stress") || name.contains("Slow"));
    }

    public static void doPostponedFormatting(@NotNull Project project2) {
        if (project2 == null) {
            UsefulTestCase.$$$reportNull$$$0(122);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance(project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    public static void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<?> runnable) {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(123);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(124);
        }
        UsefulTestCase.assertThrows(exceptionClass, null, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsgPart, @NotNull ThrowableRunnable<?> runnable) {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(125);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(126);
        }
        boolean wasThrown = false;
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause instanceof TestLoggerFactory.TestLoggerAssertionError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            wasThrown = true;
            if (!exceptionClass.isInstance(cause)) {
                throw new AssertionError("Expected instance of: " + exceptionClass + " actual: " + cause.getClass(), cause);
            }
            if (expectedErrorMsgPart != null) {
                UsefulTestCase.assertTrue((String)(cause.getClass() + " message was expected to contain '" + expectedErrorMsgPart + "', but got: '" + cause.getMessage() + "'"), (boolean)cause.getMessage().contains(expectedErrorMsgPart));
            }
        }
        finally {
            if (!wasThrown) {
                UsefulTestCase.fail((String)("'" + exceptionClass.getName() + "' must have been thrown, but the computation completed successfully instead"));
            }
        }
    }

    protected static <T extends Throwable> void assertNoException(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(127);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(128);
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause instanceof TestLoggerFactory.TestLoggerAssertionError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (exceptionClass.equals(cause.getClass())) {
                System.out.println();
                e.printStackTrace(System.out);
                UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + cause.getMessage()));
            }
            throw e;
        }
    }

    protected void assertNoThrowable(@NotNull Runnable closure) {
        if (closure == null) {
            UsefulTestCase.$$$reportNull$$$0(129);
        }
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            UsefulTestCase.$$$reportNull$$$0(130);
        }
        String methodName = ObjectUtils.notNull(this.getName(), "");
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method2;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method2 = ReflectionUtil.getDeclaredMethod(aClass, methodName, new Class[0])) == null) continue;
            if (method2.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    @NotNull
    protected String getHomePath() {
        String string2 = PathManager.getHomePath().replace(File.separatorChar, '/');
        if (string2 == null) {
            UsefulTestCase.$$$reportNull$$$0(131);
        }
        return string2;
    }

    public static void refreshRecursively(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(132);
        }
        VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                file2.getChildren();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase$2", "visitFile"));
            }
        });
        file2.refresh(false, true);
    }

    public static VirtualFile refreshAndFindFile(@NotNull File file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(133);
        }
        return UIUtil.invokeAndWaitIfNeeded(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
    }

    /*
     * WARNING - void declaration
     */
    public static void waitForAppLeakingThreads(long timeout, @NotNull TimeUnit timeUnit) {
        void timeUnit2;
        if (timeUnit == null) {
            UsefulTestCase.$$$reportNull$$$0(134);
        }
        EdtTestUtil.runInEdtAndWait(() -> UsefulTestCase.lambda$waitForAppLeakingThreads$16(timeout, (TimeUnit)timeUnit2));
    }

    protected void setRegistryPropertyForTest(@NotNull String property, @NotNull String value) {
        if (property == null) {
            UsefulTestCase.$$$reportNull$$$0(135);
        }
        if (value == null) {
            UsefulTestCase.$$$reportNull$$$0(136);
        }
        Registry.get(property).setValue(value);
        Disposer.register(this.getTestRootDisposable(), () -> Registry.get(property).resetToDefault());
    }

    protected void allowAccessToDirsIfExists(String ... dirNames) {
        if (dirNames == null) {
            UsefulTestCase.$$$reportNull$$$0(137);
        }
        for (String dirName : dirNames) {
            Path usrShareDir = Paths.get(dirName, new String[0]);
            if (Files.exists(usrShareDir, new LinkOption[0])) {
                String absolutePath = usrShareDir.toAbsolutePath().toString();
                LOG.debug(usrShareDir.toString(), " exists, adding to the list of allowed root: ", absolutePath);
                VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{absolutePath});
                continue;
            }
            LOG.debug(usrShareDir.toString(), " does not exists");
        }
    }

    private static /* synthetic */ void lambda$waitForAppLeakingThreads$16(long timeout, TimeUnit timeUnit) throws RuntimeException {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            TestApplicationKt.waitForAppLeakingThreads((Application)app, (long)timeout, (TimeUnit)timeUnit);
        }
    }

    static {
        TestEnvironmentKt.initializeTestEnvironment();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 11, 18, 21, 72, 81, 92, 99, 100, 131 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 18: 
            case 21: 
            case 72: 
            case 81: 
            case 92: 
            case 99: 
            case 100: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: 
            case 7: 
            case 97: 
            case 98: 
            case 132: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCodeStyleSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCodeStyleSettings";
                break;
            }
            case 10: 
            case 120: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "costMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countMap";
                break;
            }
            case 19: 
            case 124: 
            case 126: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 20: 
            case 45: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 73: 
            case 75: 
            case 77: 
            case 82: 
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 93: 
            case 95: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 30: 
            case 35: 
            case 38: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMsg";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 46: 
            case 74: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 64: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notExpected";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 80: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ts";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 101: 
            case 103: 
            case 106: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 102: 
            case 104: 
            case 107: 
            case 111: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProducer";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullOrRelativePath";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 123: 
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asOuterRule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalTempDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapTestRunnable";
                break;
            }
            case 21: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "assertInstanceOf";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "disposeOnTearDown";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDirectoryName";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "asOuterRule";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 18: 
            case 21: 
            case 72: 
            case 81: 
            case 92: 
            case 99: 
            case 100: 
            case 131: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressedException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeGlobalTempDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTmpFileToKeep";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldKeepTmpFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCheckForSettingsDamage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "restoreCodeInsightSettingsToAvoidInducedErrors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defaultRunBare";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "logPerClassCost";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runBare";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapTestRunnable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "edt";
                break;
            }
            case 20: 
            case 64: 
            case 65: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedEquals";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 45: 
            case 46: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedCollection";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertSameElements";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsOrdered";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsElements";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntContain";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "assertUnorderedCollection";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "assertInstanceOf";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "assertOneElement";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "assertOneOf";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "assertEmpty";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "assertSize";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "disposeOnTearDown";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "assertSameLines";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "assertExists";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntExist";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "assertSameLinesWithFile";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "checkCaseSensitiveFS";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "assertTextEquals";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "clearFields";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "clearDeclaredFields";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "checkCodeStyleSettingsEqual";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "checkCodeInsightSettingsNotOverwritten";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedFormatting";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "assertNoException";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "assertNoThrowable";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "annotatedWith";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "refreshRecursively";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFile";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "waitForAppLeakingThreads";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "setRegistryPropertyForTest";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "allowAccessToDirsIfExists";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 11, 18, 21, 72, 81, 92, 99, 100, 131 -> new IllegalStateException(string2);
        };
    }

    protected final class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        @Override
        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (String)(StringUtil.isEmpty(testName) ? "" : ".test" + testName);
        }
    }
}

