/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HierarchyViewTestFixture {
    private static final String NODE_ELEMENT_NAME = "node";
    private static final String ANY_NODES_ELEMENT_NAME = "any";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String BASE_ATTR_NAME = "base";

    public static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(0);
        }
        if (expectedStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(1);
        }
        HierarchyViewTestFixture.doHierarchyTest(treeStructure, expectedStructure, null, null);
    }

    public static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull File expectedFile) throws IOException {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(2);
        }
        if (expectedFile == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(3);
        }
        HierarchyViewTestFixture.doHierarchyTest(treeStructure, null, expectedFile);
    }

    public static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, @NotNull File expectedFile) throws IOException {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(4);
        }
        if (expectedFile == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(5);
        }
        HierarchyViewTestFixture.doHierarchyTest(treeStructure, FileUtil.loadFile(expectedFile), comparator, expectedFile);
    }

    private static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, @Nullable File expectedFile) {
        Element element;
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(6);
        }
        if (expectedStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(7);
        }
        try {
            element = JDOMUtil.load(expectedStructure);
        }
        catch (Throwable e) {
            String actual = HierarchyViewTestFixture.dump(treeStructure, null, comparator, 0);
            if (!expectedStructure.equals(actual)) {
                throw new FileComparisonFailure("XML structure comparison for your convenience, actual failure details BELOW", expectedStructure, actual, expectedFile == null ? null : expectedFile.getAbsolutePath());
            }
            throw new RuntimeException(e);
        }
        HierarchyViewTestFixture.checkHierarchyTreeStructure(treeStructure, element, comparator);
    }

    @NotNull
    public static String dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor2, @Nullable Comparator<? super NodeDescriptor<?>> comparator, int level) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(8);
        }
        StringBuilder s = new StringBuilder();
        HierarchyViewTestFixture.dump(treeStructure, descriptor2, comparator, level, s);
        String string2 = s.toString();
        if (string2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private static void dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor2, @Nullable Comparator<? super NodeDescriptor<?>> comparator, int level, @NotNull StringBuilder b) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(10);
        }
        if (b == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(11);
        }
        if (level > 10) {
            b.append("  ".repeat(level));
            b.append("<Probably infinite part skipped>\n");
            return;
        }
        if (descriptor2 == null) {
            descriptor2 = (HierarchyNodeDescriptor)((Object)treeStructure.getRootElement());
        }
        b.append("  ".repeat(level));
        descriptor2.update();
        b.append("<node text=\"").append(descriptor2.getHighlightedText().getText()).append("\"").append(treeStructure.getBaseDescriptor() == descriptor2 ? " base=\"true\"" : "");
        Object[] children2 = HierarchyViewTestFixture.getSortedChildren(treeStructure, descriptor2, comparator);
        if (children2.length > 0) {
            b.append(">\n");
            for (Object o : children2) {
                HierarchyNodeDescriptor d = (HierarchyNodeDescriptor)((Object)o);
                HierarchyViewTestFixture.dump(treeStructure, d, comparator, level + 1, b);
            }
            b.append("  ".repeat(level));
            b.append("</node>\n");
        } else {
            b.append("/>\n");
        }
    }

    @NotNull
    private static @NotNull Object @NotNull [] getSortedChildren(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @Nullable Comparator<? super NodeDescriptor<?>> comparator) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(13);
        }
        Object[] children2 = treeStructure.getChildElements((Object)descriptor2);
        if (comparator == null) {
            comparator = Comparator.comparingInt(NodeDescriptor::getIndex);
        }
        Arrays.sort(children2, comparator);
        if (children2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(14);
        }
        return children2;
    }

    private static void checkHierarchyTreeStructure(@NotNull HierarchyTreeStructure treeStructure, @Nullable Element rootElement, @Nullable Comparator<? super NodeDescriptor<?>> comparator) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(15);
        }
        HierarchyNodeDescriptor rootNodeDescriptor = (HierarchyNodeDescriptor)((Object)treeStructure.getRootElement());
        rootNodeDescriptor.update();
        if (rootElement == null || !NODE_ELEMENT_NAME.equals(rootElement.getName())) {
            throw new IllegalArgumentException("Incorrect root element in verification resource");
        }
        HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, rootNodeDescriptor, rootElement, comparator);
    }

    private static void checkNodeDescriptorRecursively(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement, @Nullable Comparator<? super NodeDescriptor<?>> comparator) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(16);
        }
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(17);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(18);
        }
        HierarchyViewTestFixture.checkBaseNode(treeStructure, descriptor2, expectedElement);
        HierarchyViewTestFixture.checkContent(descriptor2, expectedElement);
        HierarchyViewTestFixture.checkChildren(treeStructure, descriptor2, expectedElement, comparator);
    }

    private static void checkBaseNode(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(19);
        }
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(20);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(21);
        }
        String baseAttrValue = expectedElement.getAttributeValue(BASE_ATTR_NAME);
        HierarchyNodeDescriptor baseDescriptor = treeStructure.getBaseDescriptor();
        boolean mustBeBase = "true".equalsIgnoreCase(baseAttrValue);
        TestCase.assertEquals((String)"Incorrect base node", (boolean)mustBeBase, (baseDescriptor == descriptor2 ? 1 : 0) != 0);
    }

    private static void checkContent(@NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(22);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(23);
        }
        TestCase.assertEquals((String)("parent: " + descriptor2.getParentDescriptor()), (String)expectedElement.getAttributeValue(TEXT_ATTR_NAME), (String)descriptor2.getHighlightedText().getText());
    }

    private static void checkChildren(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element element, @Nullable Comparator<? super NodeDescriptor<?>> comparator) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(24);
        }
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(25);
        }
        if (element == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(26);
        }
        if (element.getChild(ANY_NODES_ELEMENT_NAME) != null) {
            return;
        }
        Object[] children2 = HierarchyViewTestFixture.getSortedChildren(treeStructure, descriptor2, comparator);
        ArrayList<Element> expectedChildren = new ArrayList<Element>(element.getChildren(NODE_ELEMENT_NAME));
        StringBuilder messageBuilder = new StringBuilder("Actual children of [" + descriptor2.getHighlightedText().getText() + "]:\n");
        for (Object child2 : children2) {
            HierarchyNodeDescriptor nodeDescriptor = (HierarchyNodeDescriptor)((Object)child2);
            nodeDescriptor.update();
            messageBuilder.append("    [").append(nodeDescriptor.getHighlightedText().getText()).append("]\n");
        }
        TestCase.assertEquals((String)messageBuilder.toString(), (int)expectedChildren.size(), (int)children2.length);
        Arrays.sort(children2, Comparator.comparing(child -> ((HierarchyNodeDescriptor)((Object)((Object)child))).getHighlightedText().getText()));
        expectedChildren.sort(Comparator.comparing(child -> child.getAttributeValue(TEXT_ATTR_NAME)));
        Iterator iterator2 = expectedChildren.iterator();
        for (Object child3 : children2) {
            HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, (HierarchyNodeDescriptor)((Object)child3), (Element)iterator2.next(), comparator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedStructure";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/codeInsight/hierarchy/HierarchyViewTestFixture";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/codeInsight/hierarchy/HierarchyViewTestFixture";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doHierarchyTest";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 9: 
            case 14: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSortedChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkHierarchyTreeStructure";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeDescriptorRecursively";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkBaseNode";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkContent";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkChildren";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 14 -> new IllegalStateException(string2);
        };
    }
}

