/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ItemWithPresentation;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

public final class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text2) {
        if (actions == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(1);
        }
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.equals(text2)) continue;
            return intentionAction;
        }
        return null;
    }

    @Nullable
    public static IntentionAction findIntentionByPartialText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text2) {
        if (actions == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(3);
        }
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.contains(text2)) continue;
            return intentionAction;
        }
        return null;
    }

    @TestOnly
    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file2, @NonNls String actionText) {
        String extension2 = FileUtilRt.getExtension(file2);
        file2 = FileUtilRt.getNameWithoutExtension(file2);
        if (extension2.isEmpty()) {
            extension2 = "xml";
        }
        CodeInsightTestUtil.doIntentionTest(fixture, actionText, file2 + "." + extension2, file2 + "_after." + extension2);
    }

    @TestOnly
    public static void doIntentionTest(@NotNull CodeInsightTestFixture fixture, @NonNls String action2, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(4);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(5);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(6);
        }
        fixture.configureByFile(before);
        List<IntentionAction> availableIntentions = fixture.getAvailableIntentions();
        IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(availableIntentions, action2);
        if (intentionAction == null) {
            PsiElement element = fixture.getFile().findElementAt(fixture.getCaretOffset());
            Assert.fail((String)("Action not found: " + action2 + " in place: " + element + " among " + availableIntentions));
        }
        fixture.launchAction(intentionAction);
        fixture.checkResultByFile(after2, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture fixture, @TestDataFile @NotNull String before, String ... after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(7);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(8);
        }
        EdtTestUtil.runInEdtAndWait(() -> {
            assert (after2 != null && after2.length > 0);
            fixture.configureByFile(before);
            for (String file2 : after2) {
                fixture.performEditorAction("EditorSelectWord");
                fixture.checkResultByFile(file2, false);
            }
        });
    }

    public static void doWordSelectionTestOnDirectory(@NotNull CodeInsightTestFixture fixture, @TestDataFile @NotNull String directoryName, @NotNull String filesExtension) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(9);
        }
        if (directoryName == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(10);
        }
        if (filesExtension == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(11);
        }
        EdtTestUtil.runInEdtAndWait(() -> {
            fixture.copyDirectoryToProject(directoryName, directoryName);
            fixture.configureByFile(directoryName + "/before." + filesExtension);
            int i2 = 1;
            while (true) {
                String fileName = directoryName + "/after" + i2 + "." + filesExtension;
                if (!new File(fixture.getTestDataPath() + "/" + fileName).exists()) break;
                fixture.performEditorAction("EditorSelectWord");
                fixture.checkResultByFile(fileName);
                ++i2;
            }
            junit.framework.Assert.assertTrue((String)"At least one 'after'-file required", (i2 > 1 ? 1 : 0) != 0);
        });
    }

    public static void doSurroundWithTest(@NotNull CodeInsightTestFixture fixture, @NotNull Surrounder surrounder, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(12);
        }
        if (surrounder == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(13);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(14);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(15);
        }
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction(fixture.getProject()).run(() -> SurroundWithHandler.invoke(fixture.getProject(), fixture.getEditor(), fixture.getFile(), surrounder));
        fixture.checkResultByFile(after2, false);
    }

    public static void doLiveTemplateTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(16);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(17);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(18);
        }
        fixture.configureByFile(before);
        new ListTemplatesAction().actionPerformedImpl(fixture.getProject(), fixture.getEditor());
        LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(fixture.getEditor());
        assert (lookup2 != null);
        lookup2.finishLookup('\n');
        fixture.checkResultByFile(after2, false);
    }

    public static void doSmartEnterTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(19);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(20);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(21);
        }
        fixture.configureByFile(before);
        List processors = SmartEnterProcessors.INSTANCE.allForLanguage(fixture.getFile().getLanguage());
        WriteCommandAction.writeCommandAction(fixture.getProject()).run(() -> {
            Editor editor2 = fixture.getEditor();
            for (SmartEnterProcessor processor : processors) {
                processor.process(fixture.getProject(), editor2, fixture.getFile());
            }
        });
        fixture.checkResultByFile(after2, false);
    }

    public static void doFormattingTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(22);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(23);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(24);
        }
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction(fixture.getProject()).run(() -> CodeStyleManager.getInstance(fixture.getProject()).reformat(fixture.getFile()));
        fixture.checkResultByFile(after2, false);
    }

    public static void doInlineRename(VariableInplaceRenameHandler handler2, String newName2, CodeInsightTestFixture fixture) {
        PsiElement elementAtCaret = fixture.getElementAtCaret();
        Editor editorForElement = CodeInsightTestUtil.openEditorFor(elementAtCaret);
        CodeInsightTestUtil.doInlineRename(handler2, newName2, editorForElement, elementAtCaret);
    }

    @NotNull
    public static Editor openEditorFor(@NotNull PsiElement elementAtCaret) {
        Editor editorForElement;
        if (elementAtCaret == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(25);
        }
        if ((editorForElement = PsiEditorUtil.getInstance().findEditorByPsiElement(elementAtCaret)) == null) {
            PsiFile containingFile = elementAtCaret.getContainingFile();
            VirtualFile virtualFile2 = containingFile.getVirtualFile();
            Project project2 = containingFile.getProject();
            editorForElement = FileEditorManager.getInstance(project2).openTextEditor(new OpenFileDescriptor(project2, virtualFile2), false);
            editorForElement.getCaretModel().moveToOffset(elementAtCaret.getTextOffset());
        }
        Editor editor2 = editorForElement;
        if (editor2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(26);
        }
        return editor2;
    }

    public static void doInlineRename(VariableInplaceRenameHandler handler2, String newName2, @NotNull Editor editor2, PsiElement elementAtCaret) {
        if (editor2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(27);
        }
        if (!CodeInsightTestUtil.tryInlineRename(handler2, newName2, editor2, elementAtCaret)) {
            Assert.fail((String)"Inline refactoring wasn't performed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static boolean tryInlineRename(VariableInplaceRenameHandler handler2, String newName2, @NotNull Editor editor2, PsiElement elementAtCaret) {
        if (editor2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(28);
        }
        Project project2 = editor2.getProject();
        Disposable disposable = Disposer.newDisposable();
        try {
            TemplateState state;
            TemplateManagerImpl.setTemplateTesting(disposable);
            InplaceRefactoring renamer = handler2.doRename(elementAtCaret, editor2, DataManager.getInstance().getDataContext((Component)editor2.getComponent()));
            if (editor2 instanceof EditorWindow) {
                editor2 = ((EditorWindow)editor2).getDelegate();
            }
            if ((state = TemplateManagerImpl.getTemplateState(editor2)) == null) {
                if (renamer != null) {
                    renamer.finish(false);
                }
                boolean bl = false;
                return bl;
            }
            TextRange range = state.getCurrentVariableRange();
            assert (range != null);
            Editor finalEditor = editor2;
            WriteCommandAction.writeCommandAction(project2).run(() -> finalEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), newName2));
            state = TemplateManagerImpl.getTemplateState(editor2);
            assert (state != null);
            state.gotoEnd(false);
        }
        finally {
            Disposer.dispose(disposable);
        }
        return true;
    }

    @TestOnly
    public static void doInlineRenameTest(VariableInplaceRenameHandler handler2, String file2, String extension2, String newName2, CodeInsightTestFixture fixture) {
        fixture.configureByFile(file2 + "." + extension2);
        CodeInsightTestUtil.doInlineRename(handler2, newName2, fixture);
        fixture.checkResultByFile(file2 + "_after." + extension2);
    }

    public static void doActionTest(AnAction action2, String file2, CodeInsightTestFixture fixture) {
        String extension2 = FileUtilRt.getExtension(file2);
        String name = FileUtilRt.getNameWithoutExtension(file2);
        fixture.configureByFile(file2);
        fixture.testAction(action2);
        fixture.checkResultByFile(name + "_after." + extension2);
    }

    public static void addTemplate(final Template template, Disposable parentDisposable) {
        final TemplateSettings settings = TemplateSettings.getInstance();
        settings.addTemplate(template);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                settings.removeTemplate(template);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @TestOnly
    public static GotoTargetHandler.GotoData gotoImplementation(Editor editor2, PsiFile file2) {
        GotoTargetHandler.GotoData data2 = new GotoImplementationHandler().getSourceAndTargetElements(editor2, file2);
        data2.initPresentations();
        if (data2.listUpdaterTask != null) {
            JBList list2 = new JBList();
            CollectionListModel model2 = new CollectionListModel(new ArrayList());
            list2.setModel((ListModel)new NameFilteringListModel(model2, Functions.identity(), Conditions.alwaysFalse(), String::new));
            JBPopup popup2 = new ComponentPopupBuilderImpl((JComponent)list2, null).createPopup();
            data2.listUpdaterTask.init(popup2, (GenericListComponentUpdater<ItemWithPresentation>)new JBListUpdater(list2), new Ref());
            data2.listUpdaterTask.queue();
            try {
                while (!data2.listUpdaterTask.isFinished()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            finally {
                Disposer.dispose((Disposable)popup2);
            }
        }
        GotoTargetHandler.GotoData gotoData = data2;
        if (gotoData == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(29);
        }
        return gotoData;
    }

    @NotNull
    public static <In, Out> List<Annotation> runExternalAnnotator(@NotNull ExternalAnnotator<In, Out> annotator, @NotNull PsiFile psiFile, In in, @NotNull Consumer<? super Out> resultChecker) {
        if (annotator == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(30);
        }
        if (psiFile == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(31);
        }
        if (resultChecker == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(32);
        }
        Object result2 = annotator.doAnnotate(in);
        resultChecker.accept(result2);
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(psiFile), false);
        ApplicationManager.getApplication().runReadAction(() -> annotationHolder.applyExternalAnnotatorWithContext(psiFile, annotator, result2));
        annotationHolder.assertAllAnnotationsCreated();
        ImmutableList<Annotation> immutableList = ContainerUtil.immutableList(annotationHolder);
        if (immutableList == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(33);
        }
        return immutableList;
    }

    @NotNull
    public static List<Annotation> testAnnotator(@NotNull Annotator annotator, PsiElement ... elements) {
        if (annotator == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(34);
        }
        if (elements == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(35);
        }
        PsiFile file2 = elements[0].getContainingFile();
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2), false);
        for (PsiElement element : elements) {
            annotationHolder.runAnnotatorWithContext(element, annotator);
        }
        annotationHolder.assertAllAnnotationsCreated();
        ImmutableList<Annotation> immutableList = ContainerUtil.immutableList(annotationHolder);
        if (immutableList == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(36);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 26, 29, 33, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesExtension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surrounder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtCaret";
                break;
            }
            case 26: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultChecker";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditorFor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "gotoImplementation";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "runExternalAnnotator";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "testAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIntentionByText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findIntentionByPartialText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doIntentionTest";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTest";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTestOnDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doSurroundWithTest";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doLiveTemplateTest";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doSmartEnterTest";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doFormattingTest";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "openEditorFor";
                break;
            }
            case 26: 
            case 29: 
            case 33: 
            case 36: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doInlineRename";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "tryInlineRename";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runExternalAnnotator";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "testAnnotator";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 26, 29, 33, 36 -> new IllegalStateException(string2);
        };
    }
}

