/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPassFactory;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.find.FindManager;
import com.intellij.find.actions.SearchTarget2UsageTarget;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.mock.MockProgressIndicator;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.RenameKt;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.TreeNodeTester;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.EditorTestFixture;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import junit.framework.ComparisonFailure;
import kotlin.UninitializedPropertyAccessException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

@TestOnly
public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    private static final Logger LOG = Logger.getInstance(CodeInsightTestFixtureImpl.class);
    private static final com.intellij.util.Function<IntentionAction, String> INTENTION_NAME_FUN = intentionAction -> "\"" + intentionAction.getText() + "\"";
    private static final String RAINBOW = "rainbow";
    private static final String FOLD = "fold";
    private final IdeaProjectTestFixture myProjectFixture;
    private final TempDirTestFixture myTempDirFixture;
    private PsiManagerImpl myPsiManager;
    private VirtualFile myFile;
    private PsiFile myPsiFile;
    private PsiFile[] myAllPsiFiles;
    private Editor myEditor;
    private EditorTestFixture myEditorTestFixture;
    private String myTestDataPath;
    private VirtualFileFilter myVirtualFileFilter;
    private boolean myAllowDirt;
    private boolean myCaresAboutInjection;
    private boolean myReadEditorMarkupModel;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private LibraryTableTracker myLibraryTableTracker;
    private ResourceBundle[] myMessageBundles;

    public CodeInsightTestFixtureImpl(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirTestFixture) {
        if (projectFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(0);
        }
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(1);
        }
        this.myVirtualFileFilter = new FileTreeAccessFilter();
        this.myCaresAboutInjection = true;
        this.myMessageBundles = new ResourceBundle[0];
        this.myProjectFixture = projectFixture;
        this.myTempDirFixture = tempDirTestFixture;
    }

    private void setFileAndEditor(@NotNull VirtualFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(3);
        }
        this.myFile = file2;
        this.myEditor = editor2;
        this.myEditorTestFixture = new EditorTestFixture(this.getProject(), editor2, file2);
        this.myPsiFile = ReadAction.compute(() -> PsiManager.getInstance(this.getProject()).findFile(this.myFile));
    }

    private void clearFileAndEditor() {
        this.myFile = null;
        this.myEditor = null;
        this.myEditorTestFixture = null;
        this.myPsiFile = null;
        this.myAllPsiFiles = null;
    }

    private static void addGutterIconRenderer(GutterMark renderer, int offset2, @NotNull Map<? super Integer, List<GutterMark>> result2) {
        if (result2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(4);
        }
        if (renderer == null) {
            return;
        }
        List renderers = result2.computeIfAbsent((Integer)offset2, __ -> new SmartList());
        renderers.add(renderer);
    }

    private static void removeDuplicatedRangesForInjected(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(5);
        }
        infos.sort((o1, o2) -> {
            int i2 = o1.startOffset - o2.startOffset;
            return i2 != 0 ? i2 : o1.getSeverity().myVal - o2.getSeverity().myVal;
        });
        HighlightInfo prevInfo = null;
        Iterator<? extends HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info2 = it.next();
            if (prevInfo != null && info2.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info2.getDescription() == null && info2.startOffset == prevInfo.startOffset && info2.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info2.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info2 : null;
        }
    }

    @NotNull
    @TestOnly
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file2, @NotNull Editor editor2, int @NotNull [] toIgnore, boolean canChangeDocument) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(7);
        }
        if (toIgnore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(8);
        }
        return CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor2, toIgnore, canChangeDocument, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @TestOnly
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile psiFile, @NotNull Editor editor2, int @NotNull [] toIgnore, boolean canChangeDocument, boolean readEditorMarkupModel) {
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(9);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(10);
        }
        if (toIgnore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(11);
        }
        Project project2 = psiFile.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        if (!ReadAction.compute(() -> ProblemHighlightFilter.shouldHighlightFile(psiFile)).booleanValue()) {
            boolean inSource = ReadAction.compute(() -> ProjectRootManager.getInstance(project2).getFileIndex().isInSource(virtualFile2));
            throw new IllegalStateException("ProblemHighlightFilter.shouldHighlightFile('" + psiFile + "') == false, so can't highlight it." + (String)(inSource ? "" : " Maybe it's because " + virtualFile2 + " is outside source folders? (source folders: " + ReadAction.compute(() -> Arrays.toString(ProjectRootManager.getInstance(project2).getContentSourceRoots())) + ")"));
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        ProjectInspectionProfileManager.getInstance(project2);
        ProcessCanceledException exception = null;
        int retries = 1000;
        for (int i2 = 0; i2 < retries; ++i2) {
            ArrayList<HighlightInfo> arrayList;
            int oldDelay = settings.getAutoReparseDelay();
            try {
                settings.setAutoReparseDelay(0);
                ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
                EdtTestUtil.runInEdtAndWait(() -> {
                    codeAnalyzer.runPasses(psiFile, editor2.getDocument(), textEditor, toIgnore, canChangeDocument, null);
                    IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
                    if (policy != null) {
                        policy.waitForHighlighting(project2, editor2);
                    }
                    IdentifierHighlighterPassFactory.waitForIdentifierHighlighting();
                    infos.addAll(DaemonCodeAnalyzerImpl.getHighlights(editor2.getDocument(), null, project2));
                    if (readEditorMarkupModel) {
                        MarkupModelEx markupModel = (MarkupModelEx)editor2.getMarkupModel();
                        DaemonCodeAnalyzerEx.processHighlights(markupModel, project2, null, 0, editor2.getDocument().getTextLength(), Processors.cancelableCollectProcessor(infos));
                    }
                });
                infos.addAll(DaemonCodeAnalyzerEx.getInstanceEx(project2).getFileLevelHighlights(project2, psiFile));
                ArrayList<HighlightInfo> arrayList2 = infos;
                arrayList = arrayList2;
            }
            catch (ProcessCanceledException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause.getClass() != Throwable.class) {
                    throw e;
                }
                EdtTestUtil.runInEdtAndWait(() -> {
                    PsiDocumentManager.getInstance(project2).commitAllDocuments();
                    UIUtil.dispatchAllInvocationEvents();
                });
                exception = e;
                continue;
            }
            finally {
                settings.setAutoReparseDelay(oldDelay);
            }
            if (arrayList == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(12);
            }
            return arrayList;
        }
        throw new AssertionError("Unable to highlight after " + retries + " retries", exception);
    }

    public static void ensureIndexesUpToDate(@NotNull Project project2) {
        if (project2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(13);
        }
        if (!DumbService.isDumb(project2)) {
            ReadAction.run(() -> {
                for (FileBasedIndexExtension extension2 : FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()) {
                    FileBasedIndex.getInstance().ensureUpToDate(extension2.getName(), project2, null);
                }
            });
        }
    }

    @NotNull
    @TestOnly
    public static List<IntentionAction> getAvailableIntentions(@NotNull Editor editor2, @NotNull PsiFile file2) {
        IdeaTestExecutionPolicy current;
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(15);
        }
        if ((current = IdeaTestExecutionPolicy.current()) != null) {
            current.waitForHighlighting(file2.getProject(), editor2);
        }
        CodeInsightTestFixtureImpl.waitForUnresolvedReferencesQuickFixesUnderCaret(file2, editor2);
        List list2 = ReadAction.compute(() -> CodeInsightTestFixtureImpl.doGetAvailableIntentions(editor2, file2));
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    private static List<IntentionAction> doGetAvailableIntentions(@NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(18);
        }
        ShowIntentionsPass.IntentionsInfo intentions = ShowIntentionsPass.getActionsToShow(editor2, file2, false);
        ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
        IntentionListStep intentionListStep = new IntentionListStep(null, editor2, file2, file2.getProject(), CachedIntentions.create(file2.getProject(), file2, editor2, intentions));
        for (Map.Entry<IntentionAction, List<IntentionAction>> entry : intentionListStep.getActionsWithSubActions().entrySet()) {
            result2.add(entry.getKey());
            result2.addAll((Collection)entry.getValue());
        }
        List<HighlightInfo> infos = DaemonCodeAnalyzerEx.getInstanceEx(file2.getProject()).getFileLevelHighlights(file2.getProject(), file2);
        for (HighlightInfo info2 : infos) {
            info2.findRegisteredQuickFix((descriptor2, range) -> {
                if (descriptor2.getAction().isAvailable(file2.getProject(), editor2, file2)) {
                    result2.add(descriptor2.getAction());
                    for (IntentionAction intentionAction : descriptor2.getOptions(file2, editor2)) {
                        if (!intentionAction.isAvailable(file2.getProject(), editor2, file2)) continue;
                        result2.add(intentionAction);
                    }
                }
                return null;
            });
        }
        ArrayList<IntentionAction> arrayList = result2;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public static void waitForUnresolvedReferencesQuickFixesUnderCaret(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(20);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "must not call under write action";
            Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (!ReadAction.compute(() -> file2.getProject().isDisposed() || editor2.isDisposed()).booleanValue()) {
                    DaemonCodeAnalyzerImpl.waitForUnresolvedReferencesQuickFixesUnderCaret(file2, editor2);
                }
            });
            try {
                while (!future.isDone()) {
                    try {
                        future.get(10L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    UIUtil.dispatchAllInvocationEvents();
                }
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        DaemonCodeAnalyzerImpl.waitForUnresolvedReferencesQuickFixesUnderCaret(file2, editor2);
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string2 = this.myTempDirFixture.getTempDirPath();
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @Override
    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        TempDirTestFixture tempDirTestFixture = this.myTempDirFixture;
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(23);
        }
        return tempDirTestFixture;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath) {
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(24);
        }
        VirtualFile virtualFile2 = this.copyFileToProject(sourcePath, sourcePath);
        if (virtualFile2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(25);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        File candidate;
        String testDataPath;
        File sourceFile;
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(26);
        }
        if (targetPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(27);
        }
        if (!(sourceFile = new File(testDataPath = this.getTestDataPath(), FileUtil.toSystemDependentName(sourcePath))).exists() && (candidate = new File(sourcePath)).isAbsolute()) {
            sourceFile = candidate;
            if (FileUtil.pathsEqual(targetPath, sourcePath)) {
                Path testDataPathObj = Paths.get(testDataPath, new String[0]);
                Path targetPathObj = Paths.get(targetPath, new String[0]);
                if (targetPathObj.startsWith(testDataPathObj) && !targetPathObj.equals(testDataPathObj)) {
                    targetPath = testDataPathObj.relativize(targetPathObj).toString();
                } else {
                    throw new IllegalArgumentException("Cannot guess target path for '" + sourcePath + "'; please specify explicitly");
                }
            }
        }
        targetPath = FileUtil.toSystemIndependentName(targetPath);
        VirtualFile targetFile = this.myTempDirFixture.getFile(targetPath);
        if (!sourceFile.exists() && targetFile != null && targetPath.equals(sourcePath)) {
            VirtualFile virtualFile2 = targetFile;
            if (virtualFile2 == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(28);
            }
            return virtualFile2;
        }
        CodeInsightTestFixtureImpl.assertFileEndsWithCaseSensitivePath(sourceFile);
        Assert.assertTrue((String)("Cannot find source file: " + sourceFile + "; test data path: " + testDataPath + "; sourcePath: " + sourcePath), (boolean)sourceFile.exists());
        Assert.assertTrue((String)("Not a file: " + sourceFile), (boolean)sourceFile.isFile());
        if (targetFile == null) {
            targetFile = this.myTempDirFixture.createFile(targetPath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(targetFile, sourcePath);
            targetFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, sourceFile.getAbsolutePath());
        }
        CodeInsightTestFixtureImpl.copyContent(sourceFile, targetFile);
        VirtualFile virtualFile3 = targetFile;
        if (virtualFile3 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(29);
        }
        return virtualFile3;
    }

    private static void assertFileEndsWithCaseSensitivePath(@NotNull File sourceFile) {
        if (sourceFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(30);
        }
        try {
            String sourceName = sourceFile.getPath();
            File realFile = sourceFile.getCanonicalFile();
            String realFileName = realFile.getPath();
            if (!sourceName.equals(realFileName) && sourceName.equalsIgnoreCase(realFileName)) {
                Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + sourceFile.getPath() + "\nreal path " + realFile.getPath()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("sourceFile=" + sourceFile, e);
        }
    }

    private static void copyContent(@NotNull File sourceFile, @NotNull VirtualFile targetFile) {
        if (sourceFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(31);
        }
        if (targetFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(32);
        }
        try {
            WriteAction.runAndWait(() -> {
                targetFile.setBinaryContent(FileUtil.loadFileBytes(sourceFile));
                FileDocumentManager.getInstance().reloadFiles(targetFile);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(33);
        }
        if (targetPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(34);
        }
        String testDataPath = this.getTestDataPath();
        File fromFile = new File(testDataPath + "/" + sourcePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile virtualFile2 = this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
            if (virtualFile2 == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(35);
            }
            return virtualFile2;
        }
        File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
        try {
            FileUtil.copyDir(fromFile, targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
        Assert.assertNotNull((Object)file2);
        file2.refresh(false, true);
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            PsiDirectory directory = ReadAction.compute(() -> PsiManager.getInstance(this.getProject()).findDirectory(file2));
            Assert.assertNotNull((Object)directory);
            policy.testDirectoryConfigured(directory);
        }
        VirtualFile virtualFile3 = file2;
        if (virtualFile3 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(36);
        }
        return virtualFile3;
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(37);
        }
        this.assertInitialized();
        InspectionsKt.enableInspectionTools(this.getProject(), this.myProjectFixture.getTestRootDisposable(), inspections);
    }

    @Override
    @SafeVarargs
    public final void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(38);
        }
        this.enableInspections(Arrays.asList(inspections));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(39);
        }
        List<InspectionProfileEntry> tools = InspectionTestUtil.instantiateTools(inspections);
        this.enableInspections(tools.toArray(new InspectionProfileEntry[0]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(40);
        }
        InspectionsKt.disableInspections(this.getProject(), inspections);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        if (providers == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(41);
        }
        List<Class<? extends LocalInspectionTool>> classes = Stream.of(providers).flatMap(p -> Stream.of(p.getInspectionClasses())).filter(LocalInspectionTool.class::isAssignableFrom).collect(Collectors.toList());
        this.enableInspections(classes);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(42);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... paths2) {
        if (paths2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(43);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(paths2).map(this::copyFileToProject));
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files2) {
        if (files2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(44);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(files2));
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull Stream<? extends VirtualFile> files2) {
        if (files2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(45);
        }
        record FileHighlighting(PsiFile file, Editor editor, ExpectedHighlightingData data) {
        }
        List<FileHighlighting> data2 = files2.map(file2 -> {
            PsiFile psiFile = this.myPsiManager.findFile((VirtualFile)file2);
            Assert.assertNotNull((Object)psiFile);
            Document document = PsiDocumentManager.getInstance(this.getProject()).getDocument(psiFile);
            Assert.assertNotNull((Object)document);
            ExpectedHighlightingData datum = new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, false, this.myMessageBundles);
            datum.init();
            return new FileHighlighting(psiFile, this.createEditor((VirtualFile)file2), datum);
        }).toList();
        long elapsed = 0L;
        for (FileHighlighting highlighting : data2) {
            this.setFileAndEditor(highlighting.file().getVirtualFile(), highlighting.editor());
            elapsed += this.collectAndCheckHighlighting(highlighting.data());
        }
        return elapsed;
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, ignoreExtraHighlighting);
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(46);
        }
        return this.testHighlighting(true, false, true, filePaths);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(47);
        }
        this.openFileInEditor(file2);
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    @NotNull
    public HighlightTestInfo testFile(String ... filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(48);
        }
        return new HighlightTestInfo(this.myProjectFixture.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData data2 = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, false, CodeInsightTestFixtureImpl.this.myMessageBundles);
                if (this.checkSymbolNames) {
                    data2.checkSymbolNames();
                }
                data2.init();
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlighting(data2);
                return this;
            }
        };
    }

    @Override
    public void openFileInEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(49);
        }
        this.setFileAndEditor(file2, this.createEditor(file2));
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (testDir == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(50);
        }
        if (toolWrapper == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(51);
        }
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "");
        PsiDirectory psiDirectory = this.getPsiManager().findDirectory(sourceDir);
        Assert.assertNotNull((Object)psiDirectory);
        AnalysisScope scope = new AnalysisScope(psiDirectory);
        scope.invalidate();
        GlobalInspectionContextForTests globalContext = InspectionsKt.createGlobalContextForTool(scope, this.getProject(), Collections.singletonList(toolWrapper));
        InspectionTestUtil.runTool(toolWrapper, scope, globalContext);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)globalContext, toolWrapper, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @Override
    @NotNull
    public PsiSymbolReference findSingleReferenceAtCaret() {
        PsiFile file2 = this.getFile();
        Assert.assertNotNull((Object)file2);
        PsiSymbolReference psiSymbolReference = UsefulTestCase.assertOneElement(ReferencesKt.referencesAt(file2, this.getCaretOffset()));
        if (psiSymbolReference == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(52);
        }
        return psiSymbolReference;
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(53);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return ReadAction.compute(() -> this.getFile().findReferenceAt(this.myEditor.getCaretModel().getOffset()));
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(54);
        }
        PsiReference reference2 = this.getReferenceAtCaretPosition(filePaths);
        Assert.assertNotNull((String)("no reference found at " + this.myEditor.getCaretModel().getLogicalPosition()), (Object)reference2);
        PsiReference psiReference = reference2;
        if (psiReference == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(55);
        }
        return psiReference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(56);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        List<IntentionAction> list2 = this.getAvailableIntentions();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(57);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(58);
        }
        if (filePaths.length != 0) {
            this.configureByFilesInner(filePaths);
        }
        List<IntentionAction> list2 = this.myEditorTestFixture.getAllQuickFixes();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(59);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        return CodeInsightTestFixtureImpl.getAvailableIntentions(ReadAction.compute(() -> this.getHostEditor()), ReadAction.compute(() -> this.getHostFileAtCaret()));
    }

    @NotNull
    private Editor getHostEditor() {
        Editor editor2 = InjectedLanguageEditorUtil.getTopLevelEditor(this.getEditor());
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(60);
        }
        return editor2;
    }

    @NotNull
    private PsiFile getHostFileAtCaret() {
        PsiFile psiFile = Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor(this.getHostEditor(), this.getProject()));
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(61);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public List<IntentionAction> filterAvailableIntentions(@NotNull String hint) {
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(62);
        }
        List<IntentionAction> list2 = ContainerUtil.filter(this.getAvailableIntentions(), action2 -> action2.getText().startsWith(hint));
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(63);
        }
        return list2;
    }

    @Override
    @NotNull
    public IntentionAction findSingleIntention(@NotNull String hint) {
        List<IntentionAction> list2;
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(64);
        }
        if ((list2 = this.filterAvailableIntentions(hint)).isEmpty()) {
            Assert.fail((String)("\"" + hint + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, ", ") + "]"));
        } else if (list2.size() > 1) {
            Assert.fail((String)("Too many intentions found for \"" + hint + "\": [" + StringUtil.join(list2, INTENTION_NAME_FUN, ", ") + "]"));
        }
        IntentionAction intentionAction = UsefulTestCase.assertOneElement(list2);
        if (intentionAction == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(65);
        }
        return intentionAction;
    }

    @Override
    public IntentionAction getAvailableIntention(@NotNull String intentionName, String ... filePaths) {
        List<IntentionAction> intentions;
        IntentionAction action2;
        if (intentionName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(66);
        }
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(67);
        }
        if ((action2 = CodeInsightTestUtil.findIntentionByText(intentions = this.getAvailableIntentions(filePaths), intentionName)) == null) {
            LOG.debug(intentionName + " not found among " + StringUtil.join(intentions, IntentionAction::getText, ","));
        }
        return action2;
    }

    @Override
    public void checkPreviewAndLaunchAction(@NotNull IntentionAction action2) {
        if (action2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(68);
        }
        if (CodeInsightTestFixtureImpl.skipPreview(action2)) {
            this.launchAction(action2);
        } else {
            String text2 = this.getIntentionPreviewText(action2);
            Assert.assertNotNull((String)action2.getText(), (Object)text2);
            this.launchAction(action2);
            Assert.assertEquals((String)action2.getText(), (Object)this.getFile().getText(), (Object)text2);
        }
    }

    private static boolean skipPreview(@NotNull IntentionAction action2) {
        if (action2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(69);
        }
        return IntentionActionDelegate.unwrap(action2) instanceof CleanupInspectionIntention;
    }

    @Override
    @Nullable
    public String getIntentionPreviewText(@NotNull IntentionAction action2) {
        if (action2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(70);
        }
        try {
            return (String)ReadAction.nonBlocking(() -> IntentionPreviewPopupUpdateProcessor.getPreviewText(this.getProject(), action2, this.getFile(), this.getEditor())).submit(AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkIntentionPreviewHtml(@NotNull IntentionAction action2, @NotNull @Language(value="HTML") String expected) {
        IntentionPreviewInfo info2;
        if (action2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(71);
        }
        if (expected == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(72);
        }
        try {
            info2 = (IntentionPreviewInfo)ReadAction.nonBlocking(() -> IntentionPreviewPopupUpdateProcessor.getPreviewInfo(this.getProject(), action2, this.getFile(), this.getEditor())).submit(AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((String)action2.getText(), (boolean)(info2 instanceof IntentionPreviewInfo.Html));
        Assert.assertEquals((String)action2.getText(), (Object)expected, (Object)((IntentionPreviewInfo.Html)info2).content().toString());
    }

    @Override
    public void launchAction(@NotNull IntentionAction action2) {
        if (action2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(73);
        }
        EdtTestUtil.runInEdtAndWait(() -> CodeInsightTestFixtureImpl.invokeIntention(action2, this.getHostFileAtCaret(), this.getHostEditor()));
    }

    @Override
    public void testCompletion(String @NotNull [] filesBefore, @NotNull @TestDataFile String fileAfter) {
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(74);
        }
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(75);
        }
        this.testCompletionTyping(filesBefore, "", fileAfter);
    }

    @Override
    public void testCompletionTyping(String @NotNull [] filesBefore, @NotNull String toType, @NotNull String fileAfter) {
        if (toType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(76);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(77);
        }
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(78);
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        this.complete(CompletionType.BASIC);
        this.type(toType);
        try {
            this.checkResultByFile(fileAfter);
        }
        catch (RuntimeException e) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw e;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)this.myPsiManager);
    }

    @Override
    public void testCompletion(@NotNull String fileBefore, @NotNull String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(79);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(80);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(81);
        }
        this.testCompletionTyping(fileBefore, "", fileAfter, additionalFiles);
    }

    @Override
    public void testCompletionTyping(@NotNull @TestDataFile String fileBefore, @NotNull String toType, @NotNull @TestDataFile String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(82);
        }
        if (toType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(83);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(84);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(85);
        }
        this.testCompletionTyping(ArrayUtil.reverseArray(ArrayUtil.append(additionalFiles, fileBefore)), toType, fileAfter);
    }

    @Override
    public void testCompletionVariants(@NotNull String fileBefore, String ... expectedItems) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(86);
        }
        if (expectedItems == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(87);
        }
        this.assertInitialized();
        List<String> result2 = this.getCompletionVariants(fileBefore);
        Assert.assertNotNull(result2);
        UsefulTestCase.assertSameElements(result2, expectedItems);
    }

    @Override
    public List<String> getCompletionVariants(String ... filesBefore) {
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(88);
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items2 = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items2);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        return this.myEditorTestFixture.getLookupElementStrings();
    }

    @Override
    public void finishLookup(char completionChar) {
        this.myEditorTestFixture.finishLookup(completionChar);
    }

    @Override
    public void testRename(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName2, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(89);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(90);
        }
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(91);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(92);
        }
        this.assertInitialized();
        this.configureByFiles(ArrayUtil.reverseArray(ArrayUtil.append(additionalFiles, fileBefore)));
        this.testRename(fileAfter, newName2);
    }

    @Override
    public void testRenameUsingHandler(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName2, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(93);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(94);
        }
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(95);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(96);
        }
        this.assertInitialized();
        this.configureByFiles(ArrayUtil.reverseArray(ArrayUtil.append(additionalFiles, fileBefore)));
        this.testRenameUsingHandler(fileAfter, newName2);
    }

    @Override
    public void testRenameUsingHandler(@NotNull String fileAfter, @NotNull String newName2) {
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(97);
        }
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(98);
        }
        this.renameElementAtCaretUsingHandler(newName2);
        this.checkResultByFile(fileAfter);
    }

    @Override
    public void testRename(@NotNull String fileAfter, @NotNull String newName2) {
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(99);
        }
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(100);
        }
        this.renameElementAtCaret(newName2);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        PsiElement psiElement = this.myEditorTestFixture.getElementAtCaret();
        if (psiElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(101);
        }
        return psiElement;
    }

    @Override
    public void renameElementAtCaret(@NotNull String newName2) {
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(102);
        }
        this.renameElement(this.getElementAtCaret(), newName2);
    }

    @Override
    public void renameElementAtCaretUsingHandler(@NotNull String newName2) {
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(103);
        }
        DataContext editorContext = ((EditorEx)this.myEditor).getDataContext();
        DataContext context2 = dataId -> PsiElementRenameHandler.DEFAULT_NAME.is(dataId) ? newName2 : editorContext.getData(dataId);
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context2);
        Assert.assertNotNull((String)"No handler for this context", (Object)renameHandler);
        renameHandler.invoke(this.getProject(), this.myEditor, this.getFile(), context2);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName2) {
        if (element == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(104);
        }
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(105);
        }
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName2, false, false);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName2, boolean searchInComments, boolean searchTextOccurrences) {
        PsiElement substitution;
        if (element == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(106);
        }
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(107);
        }
        if ((substitution = RenamePsiElementProcessor.forElement(element).substituteElementToRename(element, this.myEditor)) == null) {
            return;
        }
        new RenameProcessor(this.getProject(), substitution, newName2, searchInComments, searchTextOccurrences).run();
    }

    @Override
    public void renameTarget(@NotNull RenameTarget renameTarget, @NotNull String newName2) {
        if (renameTarget == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(108);
        }
        if (newName2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(109);
        }
        RenameKt.renameAndWait(this.getProject(), renameTarget, newName2);
    }

    @Override
    public <T extends PsiElement> T findElementByText(@NotNull String text2, @NotNull Class<T> elementClass) {
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(110);
        }
        if (elementClass == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(111);
        }
        return this.myEditorTestFixture.findElementByText(text2, elementClass);
    }

    @Override
    public void type(char c2) {
        this.assertInitialized();
        this.myEditorTestFixture.type(c2);
    }

    @Override
    public void type(@NotNull String s) {
        if (s == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(112);
        }
        this.myEditorTestFixture.type(s);
    }

    @Override
    public void performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(113);
        }
        this.assertInitialized();
        EdtTestUtil.runInEdtAndWait(() -> this.myEditorTestFixture.performEditorAction(actionId));
    }

    @Override
    @NotNull
    public Presentation testAction(@NotNull AnAction action2) {
        AnActionEvent e;
        if (action2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(114);
        }
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)(e = TestActionEvent.createTestEvent(action2)), (boolean)true)) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)e);
        }
        Presentation presentation2 = e.getPresentation();
        if (presentation2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(115);
        }
        return presentation2;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        if (fileNames == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(116);
        }
        this.assertInitialized();
        if (fileNames.length > 0) {
            this.configureByFiles(fileNames);
        }
        int flags = 3;
        PsiElement targetElement = TargetElementUtil.findTargetElement(this.getEditor(), flags);
        Assert.assertNotNull((String)"Cannot find referenced element", (Object)targetElement);
        Collection<UsageInfo> collection = this.findUsages(targetElement);
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(117);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<Usage> testFindUsagesUsingAction(String ... fileNames) {
        if (fileNames == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(118);
        }
        this.assertInitialized();
        if (fileNames.length > 0) {
            this.configureByFiles(fileNames);
        }
        EdtTestUtil.runInEdtAndWait(() -> this.myEditorTestFixture.performEditorAction("FindUsages"));
        Disposer.register(this.getTestRootDisposable(), () -> {
            Content selectedContent;
            UsageViewContentManager usageViewManager = UsageViewContentManager.getInstance((Project)this.getProject());
            while ((selectedContent = usageViewManager.getSelectedContent()) != null) {
                usageViewManager.closeContent(selectedContent);
            }
        });
        Collection collection = (Collection)EdtTestUtil.runInEdtAndGet(() -> {
            UsageView view;
            long startMillis = System.currentTimeMillis();
            boolean viewWasInitialized = false;
            while ((view = UsageViewManager.getInstance((Project)this.getProject()).getSelectedUsageView()) == null || view.isSearchInProgress()) {
                IdeEventQueue.getInstance().flushQueue();
                if ((viewWasInitialized |= view != null) || System.currentTimeMillis() - startMillis <= TimeUnit.SECONDS.toMillis(10L)) continue;
                Assert.fail((String)"UsageView wasn't shown");
                return Collections.emptyList();
            }
            return view.getUsages();
        });
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(119);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(120);
        }
        Collection<UsageInfo> collection = this.findUsages(targetElement, null);
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(121);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull Collection<? extends UsageInfo> usages) {
        if (usages == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(122);
        }
        UsageViewImpl usageView = (UsageViewImpl)UsageViewManager.getInstance((Project)this.getProject()).createUsageView(UsageTarget.EMPTY_ARRAY, ContainerUtil.map(usages, usage2 -> new UsageInfo2UsageAdapter(usage2)).toArray(Usage.EMPTY_ARRAY), new UsageViewPresentation(), null);
        String string2 = this.getUsageViewTreeTextRepresentation(usageView);
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(123);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull List<UsageTarget> usageTargets, @NotNull Collection<? extends Usage> usages) {
        if (usageTargets == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(124);
        }
        if (usages == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(125);
        }
        UsageViewImpl usageView = (UsageViewImpl)UsageViewManager.getInstance((Project)this.getProject()).createUsageView(usageTargets.toArray(UsageTarget.EMPTY_ARRAY), usages.toArray(Usage.EMPTY_ARRAY), new UsageViewPresentation(), null);
        String string2 = this.getUsageViewTreeTextRepresentation(usageView);
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(126);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(127);
        }
        FindUsagesManager usagesManager = ((FindManagerImpl)FindManager.getInstance((Project)this.getProject())).getFindUsagesManager();
        FindUsagesHandler handler2 = usagesManager.getFindUsagesHandler(targetElement, false);
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler2);
        UsageViewImpl usageView = (UsageViewImpl)usagesManager.doFindUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, handler2.getFindUsagesOptions(), false);
        String string2 = this.getUsageViewTreeTextRepresentation(usageView);
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(128);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull SearchTarget target2) {
        if (target2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(129);
        }
        Project project2 = this.getProject();
        SearchScope searchScope2 = ObjectUtils.coalesce(target2.getMaximalSearchScope(), GlobalSearchScope.allScope(project2));
        AllSearchOptions allOptions = new AllSearchOptions(UsageOptions.createOptions(searchScope2), true);
        List<UsageTarget> usageTargets = List.of(new SearchTarget2UsageTarget(project2, target2, allOptions));
        Collection<? extends Usage> usages = ImplKt.buildUsageViewQuery(this.getProject(), target2, allOptions).findAll();
        String string2 = this.getUsageViewTreeTextRepresentation(usageTargets, usages);
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(130);
        }
        return string2;
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(131);
        }
        Project project2 = this.getProject();
        FindUsagesHandler handler2 = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(Collections.synchronizedList(new ArrayList()));
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler2);
        PsiElement[] psiElements = ArrayUtil.mergeArrays(handler2.getPrimaryElements(), handler2.getSecondaryElements());
        FindUsagesOptions options2 = handler2.getFindUsagesOptions(null);
        if (scope != null) {
            options2.searchScope = scope;
        }
        for (PsiElement psiElement : psiElements) {
            handler2.processElementUsages(psiElement, processor, options2);
        }
        Collection<UsageInfo> collection = processor.getResults();
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(132);
        }
        return collection;
    }

    @Override
    public RangeHighlighter @NotNull [] testHighlightUsages(String ... files2) {
        if (files2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(133);
        }
        this.configureByFiles(files2);
        this.testAction(new HighlightUsagesAction());
        Editor editor2 = this.getEditor();
        RangeHighlighter[] rangeHighlighterArray = editor2.getMarkupModel().getAllHighlighters();
        if (rangeHighlighterArray == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(134);
        }
        return rangeHighlighterArray;
    }

    @Override
    public void moveFile(@NotNull String filePath, @NotNull String to, String ... additionalFiles) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(135);
        }
        if (to == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(136);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(137);
        }
        this.assertInitialized();
        Project project2 = this.getProject();
        this.configureByFiles(ArrayUtil.reverseArray(ArrayUtil.append(additionalFiles, filePath)));
        VirtualFile file2 = this.findFileInTempDir(to);
        Assert.assertNotNull((String)("Directory " + to + " not found"), (Object)file2);
        Assert.assertTrue((String)(to + " is not a directory"), (boolean)file2.isDirectory());
        PsiDirectory directory = this.myPsiManager.findDirectory(file2);
        new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{this.getFile()}, directory, false, false, null, null).run();
    }

    @Override
    @Nullable
    public GutterMark findGutter(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(138);
        }
        this.configureByFilesInner(filePath);
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.myEditor, this.getProject(), processor);
        return (GutterMark)processor.getFoundValue();
    }

    @Override
    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.myEditor, this.getProject(), processor);
        return new ArrayList<GutterMark>(processor.getResults());
    }

    public static boolean processGuttersAtCaret(Editor editor2, Project project2, @NotNull Processor<? super GutterMark> processor) {
        RangeHighlighter[] highlighters;
        if (processor == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(139);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)project2, (boolean)true).getAllHighlighters()) {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer == null || editor2.getDocument().getLineNumber(offset2) != editor2.getDocument().getLineNumber(highlighter.getStartOffset()) || processor.process((GutterMark)renderer)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(140);
        }
        this.configureByFilesInner(filePath);
        List<GutterMark> list2 = this.findAllGutters();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(141);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters() {
        RangeHighlighter[] highlighters;
        Project project2 = this.getProject();
        TreeMap result2 = new TreeMap();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info2 : infos) {
            CodeInsightTestFixtureImpl.addGutterIconRenderer(info2.getGutterIconRenderer(), info2.startOffset, result2);
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument((Document)this.myEditor.getDocument(), (Project)project2, (boolean)true).getAllHighlighters()) {
            if (!highlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.addGutterIconRenderer((GutterMark)highlighter.getGutterIconRenderer(), highlighter.getStartOffset(), result2);
        }
        List<GutterMark> list2 = ContainerUtil.concat(result2.values());
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(142);
        }
        return list2;
    }

    @Override
    public PsiFile addFileToProject(@NotNull String relativePath, @NotNull String fileText) {
        if (relativePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(143);
        }
        if (fileText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(144);
        }
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(@NotNull String rootPath, @NotNull String relativePath, @NotNull String fileText) {
        if (rootPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(145);
        }
        if (relativePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(146);
        }
        if (fileText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(147);
        }
        try {
            VirtualFile file2 = WriteCommandAction.runWriteCommandAction(this.getProject(), () -> {
                try {
                    VirtualFile f = this.myTempDirFixture instanceof LightTempDirTestFixtureImpl ? this.myTempDirFixture.createFile(relativePath, fileText) : (this.myProjectFixture instanceof HeavyIdeaTestFixture ? ((HeavyIdeaTestFixture)this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText).getViewProvider().getVirtualFile() : this.myTempDirFixture.createFile(relativePath, fileText));
                    this.prepareVirtualFile(f);
                    VirtualFile virtualFile2 = f;
                    return virtualFile2;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    PsiManager.getInstance(this.getProject()).dropPsiCaches();
                }
            });
            return ReadAction.compute(() -> PsiManager.getInstance(this.getProject()).findFile(file2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> epName, @NotNull T extension2) {
        if (area == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(148);
        }
        if (epName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(149);
        }
        if (extension2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(150);
        }
        this.assertInitialized();
        area.getExtensionPoint(epName).registerExtension(extension2, this.myProjectFixture.getTestRootDisposable());
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManagerImpl psiManagerImpl = this.myPsiManager;
        if (psiManagerImpl == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(151);
        }
        return psiManagerImpl;
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type) {
        if (type == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(152);
        }
        return this.myEditorTestFixture.complete(type);
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        if (type == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(153);
        }
        this.assertInitialized();
        return this.myEditorTestFixture.complete(type, invocationCount);
    }

    @Override
    public LookupElement @Nullable [] completeBasic() {
        return this.myEditorTestFixture.completeBasic();
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        List<LookupElement> list2 = this.myEditorTestFixture.completeBasicAllCarets(charToTypeAfterCompletion);
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(154);
        }
        return list2;
    }

    @Override
    public void saveText(@NotNull VirtualFile file2, @NotNull String text2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(155);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(156);
        }
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText(file2, text2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LookupElement @Nullable [] getLookupElements() {
        return this.myEditorTestFixture.getLookupElements();
    }

    @Override
    public void checkResult(@NotNull String expectedText) {
        if (expectedText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(157);
        }
        this.checkResult(expectedText, false);
    }

    @Override
    public void checkResult(@NotNull String expectedText, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy;
        if (expectedText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(158);
        }
        if ((policy = IdeaTestExecutionPolicy.current()) != null) {
            policy.beforeCheckResult(this.getFile());
        }
        WriteCommandAction.runWriteCommandAction(this.getProject(), () -> {
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.getHostEditor());
            this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(expectedText), this.getHostFile().getText());
        });
    }

    @Override
    public void checkResult(@NotNull String filePath, @NotNull String expectedText, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy;
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(159);
        }
        if (expectedText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(160);
        }
        if ((policy = IdeaTestExecutionPolicy.current()) != null) {
            policy.beforeCheckResult(this.getFile());
        }
        WriteCommandAction.runWriteCommandAction(this.getProject(), () -> {
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
            PsiFile psiFile = this.getFileToCheck(filePath);
            this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(expectedText), psiFile.getText());
        });
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(161);
        }
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(162);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> this.checkResultByFile(expectedFile, this.getHostFile(), ignoreTrailingWhitespaces));
    }

    @Override
    public void checkResultByFile(@NotNull String filePath, @NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(163);
        }
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(164);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> this.checkResultByFile(expectedFile, this.getFileToCheck(filePath), ignoreTrailingWhitespaces));
    }

    private PsiFile getFileToCheck(String filePath) {
        String path2 = filePath.replace(File.separatorChar, '/');
        VirtualFile copy2 = this.findFileInTempDir(path2);
        Assert.assertNotNull((String)("could not find results file " + path2), (Object)copy2);
        PsiFile psiFile = this.myPsiManager.findFile(copy2);
        Assert.assertNotNull((String)copy2.getPath(), (Object)psiFile);
        return psiFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        EdtTestUtil.runInEdtAndWait(() -> {
            this.myProjectFixture.setUp();
            this.myTempDirFixture.setUp();
            VirtualFile tempDir = this.myTempDirFixture.getFile("");
            Assert.assertNotNull((Object)tempDir);
            HeavyPlatformTestCase.synchronizeTempDirVfs(tempDir);
            this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance(this.getProject());
            InspectionsKt.configureInspections(LocalInspectionTool.EMPTY_ARRAY, this.getProject(), this.myProjectFixture.getTestRootDisposable());
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(this.getProject());
            daemonCodeAnalyzer.prepareForTest();
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
            CodeInsightTestFixtureImpl.ensureIndexesUpToDate(this.getProject());
            CodeStyle.setTemporarySettings((Project)this.getProject(), (CodeStyleSettings)CodeStyle.createTestSettings());
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            if (policy != null) {
                policy.setUp(this.getProject(), this.getTestRootDisposable(), this.getTestDataPath());
            }
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)new EmptyAction(true), (AnActionEvent)AnActionEvent.createFromDataContext((String)"", null, (DataContext)DataContext.EMPTY_CONTEXT));
        });
        for (Module module2 : ModuleManager.getInstance(this.getProject()).getModules()) {
            ModuleRootManager.getInstance(module2).orderEntries().getAllLibrariesAndSdkClassesRoots();
        }
        if (this.shouldTrackVirtualFilePointers()) {
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        }
        this.myLibraryTableTracker = new LibraryTableTracker();
    }

    protected boolean shouldTrackVirtualFilePointers() {
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        AtomicReference projectRootManagerComponentRef = new AtomicReference();
        RunAll.runAll((ThrowableRunnable[])new ThrowableRunnable[]{() -> EdtTestUtil.runInEdtAndWait(() -> {
            DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings;
            Project project2;
            if (ApplicationManager.getApplication() == null) {
                return;
            }
            try {
                project2 = this.myProjectFixture.getProject();
            }
            catch (AssertionError | UninitializedPropertyAccessException ignore) {
                project2 = null;
            }
            if (project2 != null) {
                CodeStyle.dropTemporarySettings((Project)project2);
                AutoPopupController autoPopupController = project2.getServiceIfCreated(AutoPopupController.class);
                if (autoPopupController != null) {
                    autoPopupController.cancelAllRequests();
                }
            }
            if ((daemonCodeAnalyzerSettings = ApplicationManager.getApplication().getServiceIfCreated(DaemonCodeAnalyzerSettings.class)) != null) {
                daemonCodeAnalyzerSettings.setImportHintEnabled(true);
            }
            if (project2 != null) {
                this.closeOpenFiles();
                ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2)).cleanupAfterTest();
                ((ProjectRootManagerImpl)ProjectRootManager.getInstance(project2)).clearScopesCachesForModules();
                projectRootManagerComponentRef.set(ObjectUtils.tryCast(ProjectRootManager.getInstance(project2), ProjectRootManagerComponent.class));
            }
        }), () -> {
            this.clearFileAndEditor();
            this.myPsiManager = null;
        }, () -> this.disposeRootDisposable(), () -> EdtTestUtil.runInEdtAndWait(() -> this.myProjectFixture.tearDown()), () -> EdtTestUtil.runInEdtAndWait(() -> this.myTempDirFixture.tearDown()), () -> super.tearDown(), () -> {
            ProjectRootManagerComponent projectRootManagerComponent = projectRootManagerComponentRef.getAndSet(null);
            if (projectRootManagerComponent != null) {
                projectRootManagerComponent.disposeVirtualFilePointersAfterTest();
            }
            if (this.myVirtualFilePointerTracker != null) {
                this.myVirtualFilePointerTracker.assertPointersAreDisposed();
            }
        }, () -> {
            if (this.myLibraryTableTracker != null) {
                this.myLibraryTableTracker.assertDisposed();
            }
        }});
    }

    private void closeOpenFiles() {
        Project project2 = this.getProject();
        if (project2 == null) {
            return;
        }
        LookupManager.hideActiveLookup(project2);
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        FileEditorManagerEx.getInstanceEx((Project)project2).closeAllFiles();
        EditorHistoryManager.getInstance((Project)project2).removeAllFiles();
    }

    private PsiFile @NotNull [] configureByFilesInner(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(165);
        }
        this.assertInitialized();
        this.clearFileAndEditor();
        this.myAllPsiFiles = new PsiFile[filePaths.length];
        for (int i2 = filePaths.length - 1; i2 >= 0; --i2) {
            this.myAllPsiFiles[i2] = this.configureByFileInner(filePaths[i2]);
        }
        if (this.myAllPsiFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(166);
        }
        return this.myAllPsiFiles;
    }

    @Override
    public PsiFile configureByFile(@NotNull String file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(167);
        }
        this.configureByFilesInner(file2);
        return this.getFile();
    }

    @Override
    public PsiFile @NotNull [] configureByFiles(String ... files2) {
        if (files2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(168);
        }
        return this.configureByFilesInner(files2);
    }

    @Override
    public PsiFile configureByText(@NotNull FileType fileType, @NotNull String text2) {
        if (fileType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(169);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(170);
        }
        this.assertInitialized();
        String extension2 = fileType.getDefaultExtension();
        CodeInsightTestFixtureImpl.associateExtensionTemporarily(fileType, extension2, this.getTestRootDisposable());
        String fileName = "aaa." + extension2;
        return this.configureByText(fileName, text2);
    }

    public static void associateExtensionTemporarily(@NotNull FileType fileType, @NotNull String extension2, @NotNull Disposable parentDisposable) {
        FileTypeManager fileTypeManager;
        if (fileType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(171);
        }
        if (extension2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(172);
        }
        if (parentDisposable == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(173);
        }
        if (!fileType.equals((fileTypeManager = FileTypeManager.getInstance()).getFileTypeByExtension(extension2))) {
            WriteAction.runAndWait(() -> fileTypeManager.associateExtension(fileType, extension2));
            Disposer.register(parentDisposable, () -> WriteAction.runAndWait(() -> fileTypeManager.removeAssociatedExtension(fileType, extension2)));
        }
    }

    @Override
    public PsiFile configureByText(@NotNull String fileName, @NotNull String text2) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(174);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(175);
        }
        this.assertInitialized();
        VirtualFile vFile = this.createFile(fileName, text2);
        this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile));
        return this.getFile();
    }

    @Override
    public VirtualFile createFile(@NotNull String fileName, @NotNull String text2) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(176);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(177);
        }
        this.assertInitialized();
        try {
            return WriteCommandAction.writeCommandAction(this.getProject()).compute(() -> {
                VirtualFile file2;
                if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                    VirtualFile root = LightPlatformTestCase.getSourceRoot();
                    root.refresh(false, false);
                    file2 = root.findOrCreateChildData(this, fileName);
                    Assert.assertNotNull((String)(fileName + " not found in " + root.getPath()), (Object)file2);
                } else if (this.myTempDirFixture instanceof TempDirTestFixtureImpl) {
                    Path tempFile = ((TempDirTestFixtureImpl)this.myTempDirFixture).createTempFile(fileName);
                    file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName(tempFile.toString()));
                    Assert.assertNotNull((String)(tempFile + " not found"), (Object)file2);
                } else {
                    file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.getTempDirPath(), fileName));
                    Assert.assertNotNull((String)(fileName + " not found in " + this.getTempDirPath()), (Object)file2);
                }
                this.prepareVirtualFile(file2);
                Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
                if (document != null) {
                    PsiDocumentManager.getInstance(this.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                VfsUtil.saveText(file2, text2);
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document getDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(178);
        }
        this.assertInitialized();
        return PsiDocumentManager.getInstance(this.getProject()).getDocument(file2);
    }

    private PsiFile configureByFileInner(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(179);
        }
        this.assertInitialized();
        VirtualFile file2 = this.copyFileToProject(filePath);
        return this.configureByFileInner(file2);
    }

    @Override
    public PsiFile configureFromTempProjectFile(@NotNull String filePath) {
        VirtualFile fileInTempDir;
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(180);
        }
        if ((fileInTempDir = this.findFileInTempDir(filePath)) == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + filePath);
        }
        return this.configureByFileInner(fileInTempDir);
    }

    @Override
    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(181);
        }
        this.configureByFileInner(virtualFile2);
    }

    private PsiFile configureByFileInner(@NotNull VirtualFile copy2) {
        if (copy2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(182);
        }
        return this.configureInner(copy2, SelectionAndCaretMarkupLoader.fromFile(copy2));
    }

    private PsiFile configureInner(@NotNull VirtualFile copy2, @NotNull SelectionAndCaretMarkupLoader loader) {
        if (copy2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(183);
        }
        if (loader == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(184);
        }
        this.assertInitialized();
        EdtTestUtilKt.runInEdtAndWait(() -> {
            IdeaTestExecutionPolicy policy;
            if (!copy2.getFileType().isBinary()) {
                try {
                    WriteAction.run(() -> copy2.setBinaryContent(loader.newFileText.getBytes(copy2.getCharset())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setFileAndEditor(copy2, this.createEditor(copy2));
            if (this.myEditor == null) {
                Assert.fail((String)("editor couldn't be created for: " + copy2.getPath() + ", use copyFileToProject() instead of configureByFile()"));
            }
            EditorTestUtil.setCaretsAndSelection(this.myEditor, loader.caretState);
            Module module2 = this.getModule();
            if (module2 != null) {
                for (Facet facet : FacetManager.getInstance((Module)module2).getAllFacets()) {
                    FacetManager.getInstance((Module)module2).facetConfigurationChanged(facet);
                }
            }
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
            if (this.myCaresAboutInjection) {
                this.setupEditorForInjectedLanguage();
            }
            if ((policy = IdeaTestExecutionPolicy.current()) != null) {
                policy.testFileConfigured(this.getFile());
            }
            return null;
        });
        return this.getFile();
    }

    protected void prepareVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(185);
        }
    }

    private void setupEditorForInjectedLanguage() {
        Editor editor2 = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
        if (editor2 instanceof EditorWindow) {
            this.setFileAndEditor(((EditorWindow)editor2).getInjectedFile().getViewProvider().getVirtualFile(), editor2);
        }
    }

    @Override
    public VirtualFile findFileInTempDir(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(186);
        }
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        Assert.assertNotNull((String)("file " + fullPath + " not found"), (Object)copy2);
        VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(copy2, filePath);
        return copy2;
    }

    @NotNull
    protected Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(187);
        }
        Project project2 = this.getProject();
        FileEditorManager instance2 = FileEditorManager.getInstance(project2);
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        Editor editor2 = instance2.openTextEditor(new OpenFileDescriptor(project2, file2), false);
        UIUtil.markAsFocused(editor2.getContentComponent(), true);
        EditorTestUtil.waitForLoading(editor2);
        DaemonCodeAnalyzer.getInstance(this.getProject()).restart();
        Editor editor3 = editor2;
        if (editor3 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(188);
        }
        return editor3;
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        if (this.myEditor == null) {
            throw new IllegalStateException("Fixture is not configured. Call something like configureByFile() or configureByText()");
        }
        ExpectedHighlightingData data2 = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, ignoreExtraHighlighting, this.myMessageBundles);
        data2.init();
        return this.collectAndCheckHighlighting(data2);
    }

    private PsiFile getHostFile() {
        VirtualFile hostVFile = this.myFile instanceof VirtualFileWindow ? ((VirtualFileWindow)((Object)this.myFile)).getDelegate() : this.myFile;
        return ReadAction.compute(() -> PsiManager.getInstance(this.getProject()).findFile(hostVFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long collectAndCheckHighlighting(@NotNull ExpectedHighlightingData data2) {
        List<HighlightInfo> infos;
        if (data2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(189);
        }
        Project project2 = this.getProject();
        EdtTestUtil.runInEdtAndWait(() -> PsiDocumentManager.getInstance(project2).commitAllDocuments());
        PsiFileImpl file2 = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file2.calcTreeElement();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        long start = System.currentTimeMillis();
        VirtualFileFilter fileTreeAccessFilter = this.myVirtualFileFilter;
        Disposable disposable = Disposer.newDisposable();
        if (fileTreeAccessFilter != null) {
            PsiManagerEx.getInstanceEx(project2).setAssertOnFileLoadingFilter(fileTreeAccessFilter, disposable);
        }
        try {
            infos = this.doHighlighting();
            CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            Disposer.dispose(disposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        data2.checkResult(file2, infos, file2.getText());
        if (data2.hasLineMarkers()) {
            Document document = this.getDocument(this.getFile());
            data2.checkLineMarkers(file2, DaemonCodeAnalyzerImpl.getLineMarkers(document, this.getProject()), document.getText());
        }
        Reference.reachabilityFence(hardRefToFileElement);
        return elapsed;
    }

    public void setVirtualFileFilter(@Nullable VirtualFileFilter filter2) {
        this.myVirtualFileFilter = filter2;
    }

    public void setMessageBundles(ResourceBundle ... messageBundles) {
        if (messageBundles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(190);
        }
        this.myMessageBundles = messageBundles;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting() {
        List<HighlightInfo> list2 = this.myEditorTestFixture.doHighlighting(this.myAllowDirt, this.myReadEditorMarkupModel);
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(191);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minimalSeverity) {
        if (minimalSeverity == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(192);
        }
        List<HighlightInfo> list2 = ContainerUtil.filter(this.doHighlighting(), info2 -> info2.getSeverity().compareTo(minimalSeverity) >= 0);
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(193);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getTestDataPath() {
        String string2 = this.myTestDataPath;
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(194);
        }
        return string2;
    }

    @Override
    public void setTestDataPath(@NotNull String dataPath) {
        if (dataPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(195);
        }
        this.myTestDataPath = dataPath;
    }

    @Override
    public final Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public int getCaretOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.myFile != null ? ReadAction.compute(() -> PsiManager.getInstance(this.getProject()).findFile(this.myFile)) : null;
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(196);
        }
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file2);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NotNull String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy;
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(197);
        }
        if (originalFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(198);
        }
        if ((policy = IdeaTestExecutionPolicy.current()) != null) {
            policy.beforeCheckResult(this.getFile());
        }
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.getHostEditor());
        }
        String fileText = originalFile.getText();
        String path2 = this.getTestDataPath() + "/" + expectedFile;
        String charset = Optional.ofNullable(originalFile.getVirtualFile()).map(f -> f.getCharset().name()).orElse(null);
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(path2, charset), fileText);
    }

    private void checkResult(@NotNull String expectedFile, boolean stripTrailingSpaces, @NotNull SelectionAndCaretMarkupLoader loader, @NotNull String actualText) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(199);
        }
        if (loader == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(200);
        }
        if (actualText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(201);
        }
        this.assertInitialized();
        Project project2 = this.getProject();
        Editor editor2 = this.getEditor();
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        UsefulTestCase.doPostponedFormatting(this.getProject());
        if (stripTrailingSpaces) {
            actualText = this.stripTrailingSpaces(actualText);
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        String expectedText = loader.newFileText;
        if (stripTrailingSpaces) {
            expectedText = this.stripTrailingSpaces(expectedText);
        }
        if (!Objects.equals(expectedText, actualText = StringUtil.convertLineSeparators(actualText))) {
            if (loader.filePath == null) {
                throw new ComparisonFailure(expectedFile, expectedText, actualText);
            }
            if (loader.caretState.hasExplicitCaret()) {
                int offset2 = editor2.getCaretModel().getOffset();
                if (offset2 > -1) {
                    actualText = new StringBuilder(actualText).insert(offset2, "<caret>").toString();
                }
                expectedText = loader.fileText;
                if (stripTrailingSpaces) {
                    expectedText = this.stripTrailingSpaces(expectedText);
                }
            }
            throw new FileComparisonFailure(expectedFile, expectedText, actualText, loader.filePath);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor2, loader.caretState, expectedFile);
    }

    @NotNull
    private String stripTrailingSpaces(@NotNull String actualText) {
        if (actualText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(202);
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        String string2 = actualText = document.getText();
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(203);
        }
        return string2;
    }

    public void canChangeDocumentDuringHighlighting(boolean canI) {
        this.myAllowDirt = canI;
    }

    @NotNull
    public String getFoldingDescription(boolean withCollapseStatus) {
        Editor topEditor = this.getHostEditor();
        String string2 = (String)EdtTestUtil.runInEdtAndGet(() -> {
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            if (policy != null) {
                policy.waitForHighlighting(this.getProject(), topEditor);
            }
            CodeFoldingManager.getInstance(this.getProject()).buildInitialFoldings(topEditor);
            return CodeInsightTestFixtureImpl.getFoldingData(topEditor, withCollapseStatus);
        });
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(204);
        }
        return string2;
    }

    @NotNull
    public static String getFoldingData(Editor topEditor, boolean withCollapseStatus) {
        return CodeInsightTestFixtureImpl.getTagsFromSegments(topEditor.getDocument().getText(), Arrays.asList(topEditor.getFoldingModel().getAllFoldRegions()), FOLD, foldRegion -> "text='" + foldRegion.getPlaceholderText() + "'" + (String)(withCollapseStatus ? " expand='" + foldRegion.isExpanded() + "'" : ""));
    }

    @NotNull
    public static <T extends Segment> String getTagsFromSegments(@NotNull String text2, @NotNull Collection<? extends T> segments, @NotNull String tagName, @Nullable com.intellij.util.Function<? super T, String> attrCalculator) {
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(205);
        }
        if (segments == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(206);
        }
        if (tagName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(207);
        }
        List borders = segments.stream().flatMap(region -> Stream.of(new Border(true, region.getStartOffset(), attrCalculator == null ? null : (String)attrCalculator.fun((Object)region)), new Border(false, region.getEndOffset(), ""))).sorted().toList();
        StringBuilder result2 = new StringBuilder(text2);
        for (Border border : borders) {
            StringBuilder info2 = new StringBuilder();
            info2.append('<');
            if (border.isLeftBorder) {
                info2.append(tagName);
                if (border.text != null) {
                    info2.append(' ').append(border.text);
                }
            } else {
                info2.append('/').append(tagName);
            }
            info2.append('>');
            result2.insert(border.offset, info2);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(208);
        }
        return string2;
    }

    private void testFoldingRegions(@NotNull String verificationFileName, @Nullable String destinationFileName, boolean doCheckCollapseStatus) {
        String expectedContent;
        File verificationFile;
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(209);
        }
        try {
            verificationFile = new File(verificationFileName);
            expectedContent = FileUtil.loadFile(verificationFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)expectedContent);
        expectedContent = StringUtil.replace(expectedContent, "\r", "");
        String cleanContent = CodeInsightTestFixtureImpl.removeFoldingMarkers(expectedContent);
        if (destinationFileName == null) {
            String fileName = PathUtil.getFileName(verificationFileName);
            this.configureByText(fileName, cleanContent);
        } else {
            try {
                String tempDirPrefix = this.myTempDirFixture.getFile("").getUrl();
                if (destinationFileName.startsWith(tempDirPrefix)) {
                    VirtualFile file2 = this.myTempDirFixture.createFile(destinationFileName.substring(tempDirPrefix.length()), cleanContent);
                    Assert.assertNotNull((Object)file2);
                    this.configureFromExistingVirtualFile(file2);
                } else {
                    FileUtil.writeToFile(new File(destinationFileName), cleanContent);
                    VirtualFile file3 = LocalFileSystem.getInstance().refreshAndFindFileByPath(destinationFileName);
                    Assert.assertNotNull((Object)file3);
                    this.configureFromExistingVirtualFile(file3);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String actual = this.getFoldingDescription(doCheckCollapseStatus);
        if (!expectedContent.equals(actual)) {
            throw new FileComparisonFailure(verificationFile.getName(), expectedContent, actual, verificationFile.getPath());
        }
    }

    @NotNull
    public static String removeFoldingMarkers(String expectedContent) {
        String string2 = expectedContent.replaceAll("<fold\\stext='[^']*'(\\sexpand='[^']*')*>", "").replace("</fold>", "");
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(210);
        }
        return string2;
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(211);
        }
        this.testFoldingRegions(verificationFileName, null, true);
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName, @Nullable String destinationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(212);
        }
        this.testFoldingRegions(verificationFileName, destinationFileName, true);
    }

    @Override
    public void testFolding(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(213);
        }
        this.testFoldingRegions(verificationFileName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRainbow(@NotNull String fileName, @NotNull String text2, boolean isRainbowOn, boolean withColor) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(214);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(215);
        }
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean isRainbowOnInScheme = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)globalScheme, null);
        try {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, isRainbowOn);
            this.configureByText(fileName, text2.replaceAll("<rainbow(\\scolor='[^']*')?>", "").replace("</rainbow>", ""));
            List<HighlightInfo> highlighting = ContainerUtil.filter(this.doHighlighting(), info2 -> info2.type == RainbowHighlighter.RAINBOW_ELEMENT);
            Assert.assertEquals((Object)text2, (Object)CodeInsightTestFixtureImpl.getTagsFromSegments(this.myEditor.getDocument().getText(), highlighting, RAINBOW, highlightInfo -> {
                if (!withColor) {
                    return null;
                }
                TextAttributes attributes = highlightInfo.getTextAttributes(null, null);
                String color = attributes == null ? "null" : (attributes.getForegroundColor() == null ? "null" : Integer.toHexString(attributes.getForegroundColor().getRGB()));
                return "color='" + color + "'";
            }));
        }
        finally {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, isRainbowOnInScheme);
        }
    }

    @Override
    public void testInlays() {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkParameterHints();
        }
        finally {
            checker.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testInlays(Function<? super Inlay<?>, String> inlayPresenter2, Predicate<? super Inlay<?>> inlayFilter2) {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkInlays(inlayPresenter2::apply, inlayFilter2::test);
        }
        finally {
            checker.tearDown();
        }
    }

    @Override
    public void checkResultWithInlays(String text2) {
        DocumentImpl checkDocument = new DocumentImpl(text2);
        InlayHintsChecker checker = new InlayHintsChecker(this);
        CaretAndInlaysInfo inlaysAndCaretInfo = checker.extractInlaysAndCaretInfo(checkDocument);
        this.checkResult(checkDocument.getText());
        checker.verifyInlaysAndCaretInfo(inlaysAndCaretInfo, text2);
    }

    @Override
    public void assertPreferredCompletionItems(int selected, String ... expected) {
        if (expected == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(216);
        }
        this.myEditorTestFixture.assertPreferredCompletionItems(selected, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(@NotNull Consumer<? super StructureViewComponent> consumer2) {
        if (consumer2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(217);
        }
        Assert.assertNotNull((String)"configure first", (Object)this.myFile);
        FileEditor fileEditor = FileEditorManager.getInstance(this.getProject()).getSelectedEditor(this.myFile);
        Assert.assertNotNull((String)("editor not opened for " + this.myFile), (Object)this.myFile);
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.getFile());
        Assert.assertNotNull((String)("no builder for " + this.myFile), (Object)builder2);
        StructureViewComponent component2 = null;
        try {
            component2 = (StructureViewComponent)builder2.createStructureView(fileEditor, this.getProject());
            PlatformTestUtil.waitForPromise(component2.rebuildAndUpdate());
            consumer2.consume(component2);
            if (component2 == null) return;
        }
        catch (Throwable throwable) {
            if (component2 == null) throw throwable;
            Disposer.dispose(component2);
            throw throwable;
        }
        Disposer.dispose((Disposable)((Object)component2));
    }

    @Override
    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.myCaresAboutInjection = caresAboutInjection;
    }

    @Override
    public void setReadEditorMarkupModel(boolean readEditorMarkupModel) {
        this.myReadEditorMarkupModel = readEditorMarkupModel;
    }

    @Override
    public LookupImpl getLookup() {
        return this.myEditorTestFixture.getLookup();
    }

    @Override
    @NotNull
    public List<Object> getGotoClassResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        if (pattern == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(218);
        }
        SearchEverywhereContributor<Object> contributor = this.createMockClassSearchEverywhereContributor(searchEverywhere);
        ArrayList<Object> results = new ArrayList<Object>();
        contributor.fetchElements(pattern, (ProgressIndicator)new MockProgressIndicator(), new CommonProcessors.CollectProcessor(results));
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(219);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Object> getGotoSymbolResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        if (pattern == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(220);
        }
        SearchEverywhereContributor<Object> contributor = this.createMockSymbolSearchEverywhereContributor(searchEverywhere);
        ArrayList<Object> results = new ArrayList<Object>();
        contributor.fetchElements(pattern, (ProgressIndicator)new MockProgressIndicator(), new CommonProcessors.CollectProcessor(results));
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(221);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Crumb> getBreadcrumbsAtCaret() {
        List<Crumb> list2 = this.myEditorTestFixture.getBreadcrumbsAtCaret();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(222);
        }
        return list2;
    }

    private SearchEverywhereContributor<Object> createMockClassSearchEverywhereContributor(final boolean everywhere) {
        DataContext dataContext2 = SimpleDataContext.getProjectContext((Project)this.getProject());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2);
        ClassSearchEverywhereContributor contributor = new ClassSearchEverywhereContributor(event){
            {
                super(arg0);
                this.myScopeDescriptor = new ScopeDescriptor(FindSymbolParameters.searchScopeFor(this.myProject, everywhere));
            }
        };
        Disposer.register(this.getProjectDisposable(), contributor);
        return contributor;
    }

    private SearchEverywhereContributor<Object> createMockSymbolSearchEverywhereContributor(final boolean everywhere) {
        DataContext dataContext2 = SimpleDataContext.getProjectContext((Project)this.getProject());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2);
        SymbolSearchEverywhereContributor contributor = new SymbolSearchEverywhereContributor(event){
            {
                super(arg0);
                this.myScopeDescriptor = new ScopeDescriptor(FindSymbolParameters.searchScopeFor(this.myProject, everywhere));
            }
        };
        Disposer.register(this.getProjectDisposable(), contributor);
        return contributor;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        if (this.myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.myEditor.getDocument()).getDelegate();
            this.setFileAndEditor(FileDocumentManager.getInstance().getFile(document), ((EditorWindow)this.myEditor).getDelegate());
        }
    }

    public static boolean invokeIntention(@NotNull IntentionAction action2, @NotNull PsiFile file2, @NotNull Editor editor2) {
        if (action2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(223);
        }
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(224);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(225);
        }
        Project project2 = file2.getProject();
        VirtualFile vFile = Objects.requireNonNull(InjectedLanguageManager.getInstance(project2).getTopLevelFile(file2)).getVirtualFile();
        AtomicBoolean result2 = new AtomicBoolean();
        CodeInsightTestFixtureImpl.withReadOnlyFile(vFile, project2, () -> {
            try {
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        result2.set(ShowIntentionActionsHandler.chooseActionAndInvoke(file2, editor2, action2, action2.getText()));
                    }
                    catch (StubTextInconsistencyException e) {
                        PsiTestUtil.compareStubTexts(e);
                    }
                });
                UIUtil.dispatchAllInvocationEvents();
                CodeInsightTestFixtureImpl.checkPsiTextConsistency(project2, vFile);
            }
            catch (AssertionError e) {
                ExceptionUtil.rethrowUnchecked(ExceptionUtil.getRootCause((Throwable)((Object)e)));
                throw e;
            }
        });
        return result2.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean withReadOnlyFile(VirtualFile vFile, Project project2, Runnable action2) {
        boolean writable;
        ReadonlyStatusHandlerImpl handler2 = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance(project2);
        CodeInsightTestFixtureImpl.setReadOnly(vFile, true);
        handler2.setClearReadOnlyInTests(true);
        try {
            action2.run();
        }
        finally {
            writable = vFile.isWritable();
            handler2.setClearReadOnlyInTests(false);
            CodeInsightTestFixtureImpl.setReadOnly(vFile, false);
        }
        return writable;
    }

    private static void checkPsiTextConsistency(@NotNull Project project2, @NotNull VirtualFile vFile) {
        PsiFile topLevelPsi;
        if (project2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(226);
        }
        if (vFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(227);
        }
        PsiFile psiFile = topLevelPsi = vFile.isValid() ? PsiManager.getInstance(project2).findFile(vFile) : null;
        if (topLevelPsi != null) {
            if (Registry.is("ide.check.structural.psi.text.consistency.in.tests")) {
                PsiTestUtil.checkPsiStructureWithCommit(topLevelPsi, PsiTestUtil::checkPsiMatchesTextIgnoringNonCode);
            } else {
                PsiTestUtil.checkStubsMatchText(topLevelPsi);
            }
        }
    }

    private static void setReadOnly(VirtualFile vFile, boolean readOnlyStatus) {
        try {
            WriteAction.runAndWait(() -> ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)vFile, (boolean)readOnlyStatus));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull UsageViewImpl usageView) {
        if (usageView == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(228);
        }
        Disposer.register(this.getTestRootDisposable(), (Disposable)usageView);
        usageView.expandAll();
        String string2 = TreeNodeTester.forNode((TreeNode)usageView.getRoot()).withPresenter(arg_0 -> ((UsageViewImpl)usageView).getNodeText(arg_0)).constructTextRepresentation();
        if (string2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(229);
        }
        return string2;
    }

    @Override
    @NotNull
    public Disposable getProjectDisposable() {
        Disposable disposable = this.myProjectFixture.getTestRootDisposable();
        if (disposable == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(230);
        }
        return disposable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16, 19, 22, 23, 25, 28, 29, 35, 36, 52, 55, 57, 59, 60, 61, 63, 65, 101, 115, 117, 119, 121, 123, 126, 128, 130, 132, 134, 141, 142, 151, 154, 166, 188, 191, 193, 194, 203, 204, 208, 210, 219, 221, 222, 229, 230 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirTestFixture";
                break;
            }
            case 2: 
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 47: 
            case 49: 
            case 155: 
            case 167: 
            case 178: 
            case 185: 
            case 187: 
            case 196: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 101: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 141: 
            case 142: 
            case 151: 
            case 154: 
            case 166: 
            case 188: 
            case 191: 
            case 193: 
            case 194: 
            case 203: 
            case 204: 
            case 208: 
            case 210: 
            case 219: 
            case 221: 
            case 222: 
            case 229: 
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 13: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 42: 
            case 46: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 67: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 44: 
            case 45: 
            case 133: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 48: 
            case 135: 
            case 138: 
            case 140: 
            case 159: 
            case 163: 
            case 179: 
            case 180: 
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionName";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 114: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 72: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 74: 
            case 77: 
            case 80: 
            case 84: 
            case 90: 
            case 94: 
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAfter";
                break;
            }
            case 75: 
            case 78: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesBefore";
                break;
            }
            case 76: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 79: 
            case 82: 
            case 86: 
            case 89: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBefore";
                break;
            }
            case 81: 
            case 85: 
            case 92: 
            case 96: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFiles";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedItems";
                break;
            }
            case 91: 
            case 95: 
            case 98: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameTarget";
                break;
            }
            case 110: 
            case 156: 
            case 170: 
            case 175: 
            case 177: 
            case 205: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 116: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 120: 
            case 127: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 122: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTargets";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 143: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 144: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 150: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 152: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 157: 
            case 158: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 161: 
            case 162: 
            case 164: 
            case 197: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 169: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 174: 
            case 176: 
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 182: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 184: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBundles";
                break;
            }
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimalSeverity";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 201: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 209: 
            case 211: 
            case 212: 
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verificationFileName";
                break;
            }
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 218: 
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateAndRun";
                break;
            }
            case 16: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetAvailableIntentions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirFixture";
                break;
            }
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDirectoryToProject";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "findSingleReferenceAtCaret";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQuickFixes";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostEditor";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostFileAtCaret";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableIntentions";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "findSingleIntention";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAtCaret";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "testAction";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "testFindUsages";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "testFindUsagesUsingAction";
                break;
            }
            case 121: 
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageViewTreeTextRepresentation";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "testHighlightUsages";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGutters";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByFilesInner";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 191: 
            case 193: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingSpaces";
                break;
            }
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingDescription";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagsFromSegments";
                break;
            }
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFoldingMarkers";
                break;
            }
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoClassResults";
                break;
            }
            case 221: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoSymbolResults";
                break;
            }
            case 222: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAtCaret";
                break;
            }
            case 230: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFileAndEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addGutterIconRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedRangesForInjected";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instantiateAndRun";
                break;
            }
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 101: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 141: 
            case 142: 
            case 151: 
            case 154: 
            case 166: 
            case 188: 
            case 191: 
            case 193: 
            case 194: 
            case 203: 
            case 204: 
            case 208: 
            case 210: 
            case 219: 
            case 221: 
            case 222: 
            case 229: 
            case 230: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureIndexesUpToDate";
                break;
            }
            case 14: 
            case 15: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntentions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetAvailableIntentions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "waitForUnresolvedReferencesQuickFixesUnderCaret";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyFileToProject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "assertFileEndsWithCaseSensitivePath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyDirectoryToProject";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "enableInspections";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "disableInspections";
                break;
            }
            case 42: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "testHighlighting";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightingAllFiles";
                break;
            }
            case 45: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "collectAndCheckHighlighting";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "testFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "openFileInEditor";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "testInspection";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPosition";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAllQuickFixes";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "filterAvailableIntentions";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "findSingleIntention";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntention";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "checkPreviewAndLaunchAction";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "skipPreview";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionPreviewText";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "checkIntentionPreviewHtml";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "launchAction";
                break;
            }
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "testCompletion";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionTyping";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionVariants";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "testRename";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "testRenameUsingHandler";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaret";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaretUsingHandler";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "renameTarget";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "testAction";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "testFindUsages";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "testFindUsagesUsingAction";
                break;
            }
            case 120: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 129: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "getUsageViewTreeTextRepresentation";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightUsages";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "findGutter";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "processGuttersAtCaret";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "findAllGutters";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 199: 
            case 200: 
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "configureByFilesInner";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "configureByFiles";
                break;
            }
            case 169: 
            case 170: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "configureByText";
                break;
            }
            case 171: 
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "associateExtensionTemporarily";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 179: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "configureByFileInner";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "configureFromTempProjectFile";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "configureFromExistingVirtualFile";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "configureInner";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "prepareVirtualFile";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "findFileInTempDir";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "setMessageBundles";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "doHighlighting";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "setTestDataPath";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "allowTreeAccessForFile";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingSpaces";
                break;
            }
            case 205: 
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "getTagsFromSegments";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingRegions";
                break;
            }
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingWithCollapseStatus";
                break;
            }
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "testFolding";
                break;
            }
            case 214: 
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "testRainbow";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "testStructureView";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "getGotoClassResults";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "getGotoSymbolResults";
                break;
            }
            case 223: 
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "invokeIntention";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiTextConsistency";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 16, 19, 22, 23, 25, 28, 29, 35, 36, 52, 55, 57, 59, 60, 61, 63, 65, 101, 115, 117, 119, 121, 123, 126, 128, 130, 132, 134, 141, 142, 151, 154, 166, 188, 191, 193, 194, 203, 204, 208, 210, 219, 221, 222, 229, 230 -> new IllegalStateException(string2);
        };
    }

    private static final class SelectionAndCaretMarkupLoader {
        private final String fileText;
        private final String filePath;
        private final String newFileText;
        private final EditorTestUtil.CaretAndSelectionState caretState;

        private SelectionAndCaretMarkupLoader(@NotNull String fileText, String filePath) {
            if (fileText == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(0);
            }
            this.fileText = fileText;
            this.filePath = filePath;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            this.caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.newFileText = document.getText();
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull String path2, String charset) {
            if (path2 == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(1);
            }
            return SelectionAndCaretMarkupLoader.fromIoSource(() -> FileUtil.loadFile(new File(path2), charset), path2);
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(2);
            }
            return SelectionAndCaretMarkupLoader.fromIoSource(() -> VfsUtilCore.loadText(file2), file2.getPath());
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromIoSource(@NotNull ThrowableComputable<String, IOException> source, String path2) {
            if (source == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(3);
            }
            try {
                return new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators(source.compute()), path2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromText(@NotNull String text2) {
            if (text2 == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(4);
            }
            return new SelectionAndCaretMarkupLoader(text2, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromIoSource";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record Border(boolean isLeftBorder, int offset, @Nullable String text) implements Comparable<Border>
    {
        @Override
        public int compareTo(@NotNull Border o) {
            if (o == null) {
                Border.$$$reportNull$$$0(0);
            }
            return this.offset < o.offset ? 1 : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$Border", "compareTo"));
        }
    }
}

