/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LexerTestCase;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.junit.Assert;

public class CheckHighlighterConsistency
extends ActionOnFile {
    @NotNull
    public static final Function<PsiFile, Generator<? extends MadTestingAction>> randomEditsWithHighlighterChecks = file2 -> {
        FileEditorManager.getInstance(file2.getProject()).openFile(file2.getVirtualFile(), true);
        return Generator.sampledFrom((Object[])new ActionOnFile[]{new CheckHighlighterConsistency((PsiFile)file2), new InsertString((PsiFile)file2), new DeleteRange((PsiFile)file2)});
    };

    public CheckHighlighterConsistency(@NotNull PsiFile file2) {
        if (file2 == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(0);
        }
        super(file2);
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(1);
        }
        env.logMessage(this.toString());
        Editor editor2 = FileEditorManager.getInstance(this.getProject()).getSelectedTextEditor();
        assert (editor2.getDocument() == this.getDocument());
        CheckHighlighterConsistency.performCheck(editor2);
    }

    public static void performCheck(@NotNull Editor editor2) {
        if (editor2 == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(2);
        }
        LexerEditorHighlighter highlighter = (LexerEditorHighlighter)editor2.getHighlighter();
        CharSequence text2 = editor2.getDocument().getImmutableCharSequence();
        String incremental = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text2);
        highlighter.setText((CharSequence)"");
        highlighter.setText(text2);
        String full = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text2);
        if (!full.equals(incremental)) {
            Assert.assertEquals((Object)("Full lexer highlighter:\n" + full), (Object)("Incremental lexer highlighter:\n" + incremental));
        }
    }

    @NotNull
    private static String dumpHighlighterTokens(LexerEditorHighlighter highlighter, CharSequence text2) {
        StringBuilder tokens = new StringBuilder();
        HighlighterIterator iterator2 = highlighter.createIterator(0);
        while (!iterator2.atEnd()) {
            tokens.append(iterator2.getStart()).append(" ").append(LexerTestCase.printSingleToken(text2, iterator2.getTokenType(), iterator2.getStart(), iterator2.getEnd()));
            iterator2.advance();
        }
        String string2 = tokens.toString();
        if (string2 == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/CheckHighlighterConsistency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/CheckHighlighterConsistency";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpHighlighterTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performCheck";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

