/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.CheckPsiReadAccessors;
import com.intellij.testFramework.propertyBased.CheckPsiTextConsistency;
import com.intellij.testFramework.propertyBased.CommitDocumentAction;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import com.intellij.testFramework.propertyBased.ResolveAllReferences;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.GenerationEnvironment;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.jetbrains.jetCheck.PropertyChecker;

public final class MadTestingUtil {
    private static final Logger LOG = Logger.getInstance(MadTestingUtil.class);
    private static final boolean USE_ROULETTE_WHEEL = true;

    public static void restrictChangesToDocument(Document document, Runnable r) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r::run, event -> {
            VirtualFile file2;
            Document changed2 = event.getDocument();
            if (changed2 != document && (file2 = FileDocumentManager.getInstance().getFile(changed2)) != null && file2.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed2));
            }
        });
    }

    private static void letSaveAllDocumentsPassIfAny() {
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void prohibitDocumentChanges(Runnable r) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r::run, event -> {
            Document changed2 = event.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(changed2);
            if (file2 != null && file2.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed2));
            }
        });
    }

    private static <E extends Throwable> void watchDocumentChanges(ThrowableRunnable<E> r, final Consumer<? super DocumentEvent> eventHandler) throws E {
        Disposable disposable = Disposer.newDisposable();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                eventHandler.accept(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/testFramework/propertyBased/MadTestingUtil$1", "documentChanged"));
            }
        }, disposable);
        try {
            r.run();
        }
        finally {
            Disposer.dispose(disposable);
        }
    }

    public static void changeAndRevert(Project project2, Runnable r) {
        Label label2 = LocalHistory.getInstance().putUserLabel(project2, "changeAndRevert");
        boolean failed = false;
        try {
            r.run();
        }
        catch (Throwable e) {
            failed = true;
            throw e;
        }
        finally {
            MadTestingUtil.restoreEverything(label2, failed, project2);
        }
    }

    private static void restoreEverything(Label label2, boolean failed, Project project2) {
        try {
            WriteAction.run(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
                new RunAll(new ThrowableRunnable[]{() -> PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting(), () -> FileEditorManagerEx.getInstanceEx((Project)project2).closeAllFiles(), () -> EditorHistoryManager.getInstance((Project)project2).removeAllFiles(), () -> FileDocumentManager.getInstance().saveAllDocuments(), () -> MadTestingUtil.revertVfs(label2, project2), () -> documentManager.commitAllDocuments(), () -> UsefulTestCase.assertEmpty(documentManager.getUncommittedDocuments()), () -> UsefulTestCase.assertEmpty(FileDocumentManager.getInstance().getUnsavedDocuments())}).run();
            });
        }
        catch (Throwable e) {
            if (failed) {
                LOG.info("Exceptions while restoring state", e);
            }
            throw e;
        }
    }

    private static void revertVfs(Label label2, Project project2) throws LocalHistoryException {
        MadTestingUtil.watchDocumentChanges(() -> label2.revert(project2, PlatformTestUtil.getOrCreateProjectBaseDir(project2)), __ -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
            if (documentManager.getUncommittedDocuments().length > 3) {
                documentManager.commitAllDocuments();
            }
        });
    }

    public static void enableAllInspections(@NotNull Project project2, @NotNull Language fileLanguage, String ... except) {
        if (project2 == null) {
            MadTestingUtil.$$$reportNull$$$0(0);
        }
        if (fileLanguage == null) {
            MadTestingUtil.$$$reportNull$$$0(1);
        }
        if (except == null) {
            MadTestingUtil.$$$reportNull$$$0(2);
        }
        InspectionProfileImpl.INIT_INSPECTIONS = true;
        InspectionProfileImpl profile = new InspectionProfileImpl("allEnabled");
        profile.enableAllTools(project2);
        MadTestingUtil.disableInspection(project2, profile, "HighlightVisitorInternal");
        for (String shortId : except) {
            MadTestingUtil.disableInspection(project2, profile, shortId);
        }
        MadTestingUtil.replaceProfile(project2, profile, fileLanguage);
    }

    public static void enableDefaultInspections(@NotNull Project project2, @NotNull Language fileLanguage) {
        if (project2 == null) {
            MadTestingUtil.$$$reportNull$$$0(3);
        }
        if (fileLanguage == null) {
            MadTestingUtil.$$$reportNull$$$0(4);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl("defaultInspections");
        InspectionsKt.runInInitMode(() -> {
            MadTestingUtil.replaceProfile(project2, profile, fileLanguage);
            return null;
        });
    }

    private static void replaceProfile(@NotNull Project project2, @NotNull InspectionProfileImpl profile, @NotNull Language fileLanguage) {
        if (project2 == null) {
            MadTestingUtil.$$$reportNull$$$0(5);
        }
        if (profile == null) {
            MadTestingUtil.$$$reportNull$$$0(6);
        }
        if (fileLanguage == null) {
            MadTestingUtil.$$$reportNull$$$0(7);
        }
        profile.getAllEnabledInspectionTools(project2).forEach(state -> {
            InspectionToolWrapper<?, ?> wrapper2 = state.getTool();
            String inspectionLanguage = wrapper2.getLanguage();
            if (inspectionLanguage == null || fileLanguage.isKindOf(inspectionLanguage)) {
                wrapper2.getTool();
            }
        });
        ProjectInspectionProfileManager manager = (ProjectInspectionProfileManager)InspectionProjectProfileManager.getInstance(project2);
        manager.addProfile(profile);
        InspectionProfileImpl prev = manager.getCurrentProfile();
        manager.setCurrentProfile(profile);
        Disposer.register(((ProjectEx)project2).getEarlyDisposable(), () -> {
            InspectionProfileImpl.INIT_INSPECTIONS = false;
            manager.setCurrentProfile(prev);
            manager.deleteProfile(profile);
        });
    }

    private static void disableInspection(Project project2, InspectionProfileImpl profile, String shortId) {
        ToolsImpl tools = profile.getToolsOrNull(shortId, project2);
        if (tools != null) {
            tools.setEnabled(false);
        }
    }

    public static Generator<File> randomFiles(String rootPath, FileFilter fileFilter) {
        return MadTestingUtil.randomFiles(rootPath, fileFilter, true);
    }

    private static Generator<File> randomFiles(final String rootPath, FileFilter fileFilter, boolean useRouletteWheel) {
        FileFilter interestingIdeaFiles = child -> {
            String name = child.getName();
            if (name.startsWith(".")) {
                return false;
            }
            if (child.isDirectory()) {
                return MadTestingUtil.shouldGoInsiderDir(name);
            }
            return !FileTypeManager.getInstance().getFileTypeByFileName(name).isBinary() && fileFilter.accept(child) && child.length() < 500000L;
        };
        File root = new File(rootPath);
        Function<GenerationEnvironment, File> generator = useRouletteWheel ? new RouletteWheelFileGenerator(root, interestingIdeaFiles) : new FileGenerator(root, interestingIdeaFiles);
        return Generator.from((Function)generator).suchThat((Predicate)new Predicate<File>(){

            @Override
            public boolean test(File file2) {
                return file2 != null;
            }

            public String toString() {
                return "can find a file under " + rootPath + " satisfying given filters";
            }
        }).noShrink();
    }

    @NotNull
    public static Supplier<MadTestingAction> actionsOnFileContents(CodeInsightTestFixture fixture, String rootPath, FileFilter fileFilter, Function<? super PsiFile, ? extends Generator<? extends MadTestingAction>> actions) {
        return MadTestingUtil.performOnFileContents(fixture, rootPath, fileFilter, (env, vFile) -> env.executeCommands(Generator.from(data2 -> (MadTestingAction)data2.generate((Generator)actions.apply(fixture.getPsiManager().findFile((VirtualFile)vFile))))));
    }

    @NotNull
    public static Supplier<MadTestingAction> performOnFileContents(CodeInsightTestFixture fixture, String rootPath, FileFilter fileFilter, BiConsumer<? super ImperativeCommand.Environment, ? super VirtualFile> action2) {
        Generator<File> randomFiles = MadTestingUtil.randomFiles(rootPath, fileFilter);
        Supplier<MadTestingAction> supplier2 = () -> env -> new RunAll(new ThrowableRunnable[]{() -> {
            File ioFile = (File)env.generateValue(randomFiles, "Working with %s");
            VirtualFile vFile = MadTestingUtil.copyFileToProject(ioFile, fixture, rootPath);
            PsiFile psiFile = fixture.getPsiManager().findFile(vFile);
            if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiPlainTextFile) {
                System.err.println("Can't check " + vFile + " due to incorrect file type: " + psiFile + " of " + psiFile.getClass());
                return;
            }
            action2.accept(env, vFile);
        }, () -> WriteAction.run(() -> {
            for (VirtualFile file2 : Objects.requireNonNull(fixture.getTempDirFixture().getFile("")).getChildren()) {
                file2.delete(fixture);
            }
        }), () -> PsiDocumentManager.getInstance(fixture.getProject()).commitAllDocuments(), () -> UIUtil.dispatchAllInvocationEvents()}).run();
        if (supplier2 == null) {
            MadTestingUtil.$$$reportNull$$$0(8);
        }
        return supplier2;
    }

    private static boolean shouldGoInsiderDir(@NotNull String name) {
        if (name == null) {
            MadTestingUtil.$$$reportNull$$$0(9);
        }
        return !name.equals("gen") && !name.equals("reports") && !name.equals("android") && MadTestingUtil.canContainSources(name) && !name.endsWith("system") && !name.endsWith("config") && !name.equals("build");
    }

    private static boolean canContainSources(@NotNull String name) {
        if (name == null) {
            MadTestingUtil.$$$reportNull$$$0(10);
        }
        return !name.equals("jdk") && !name.equals("jre") && !name.equals("lib") && !name.equals("bin") && !name.equals("out") && !name.startsWith(".");
    }

    @NotNull
    private static VirtualFile copyFileToProject(File ioFile, CodeInsightTestFixture fixture, String rootPath) {
        VirtualFile virtualFile2;
        try {
            VirtualFile existing;
            String path2 = FileUtil.getRelativePath(FileUtil.toCanonicalPath(rootPath), FileUtil.toSystemIndependentName(ioFile.getPath()), '/');
            assert (path2 != null);
            Matcher rootPackageMatcher = Pattern.compile("/com/|/org/|/onair/").matcher(path2);
            if (rootPackageMatcher.find()) {
                path2 = path2.substring(rootPackageMatcher.start() + 1);
            }
            if ((existing = fixture.getTempDirFixture().getFile(path2)) != null) {
                WriteAction.run(() -> existing.delete(fixture));
            }
            virtualFile2 = fixture.addFileToProject(path2, FileUtil.loadFile(ioFile)).getVirtualFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile2 == null) {
            MadTestingUtil.$$$reportNull$$$0(11);
        }
        return virtualFile2;
    }

    @NotNull
    public static Generator<MadTestingAction> randomEditsWithReparseChecks(@NotNull PsiFile file2) {
        if (file2 == null) {
            MadTestingUtil.$$$reportNull$$$0(12);
        }
        Generator generator = Generator.sampledFrom((Object[])new MadTestingAction[]{new InsertString(file2), new DeleteRange(file2), new CommitDocumentAction(file2), new CheckPsiTextConsistency(file2)});
        if (generator == null) {
            MadTestingUtil.$$$reportNull$$$0(13);
        }
        return generator;
    }

    @NotNull
    public static Function<PsiFile, Generator<? extends MadTestingAction>> randomEditsWithPsiAccessorChecks(@NotNull Condition<? super Method> skipCondition) {
        if (skipCondition == null) {
            MadTestingUtil.$$$reportNull$$$0(14);
        }
        Function<PsiFile, Generator<? extends MadTestingAction>> function = file2 -> Generator.sampledFrom((Object[])new ActionOnFile[]{new InsertString((PsiFile)file2), new DeleteRange((PsiFile)file2), new CommitDocumentAction((PsiFile)file2), new CheckPsiReadAccessors((PsiFile)file2, skipCondition), new ResolveAllReferences((PsiFile)file2)});
        if (function == null) {
            MadTestingUtil.$$$reportNull$$$0(15);
        }
        return function;
    }

    public static boolean isAfterError(PsiFile file2, int offset2) {
        return SyntaxTraverser.psiTraverser(file2).filter(PsiErrorElement.class).find(e -> e.getTextRange().getStartOffset() <= offset2) != null;
    }

    public static boolean containsErrorElements(FileViewProvider viewProvider) {
        return ContainerUtil.exists(viewProvider.getAllFiles(), file2 -> SyntaxTraverser.psiTraverser(file2).filter(PsiErrorElement.class).isNotEmpty());
    }

    @NotNull
    public static String getPositionDescription(int offset2, Document document) {
        int line = document.getLineNumber(offset2);
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        int column = offset2 - start;
        Object prefix = document.getText(new TextRange(start, offset2)).trim();
        if (((String)prefix).length() > 30) {
            prefix = "..." + ((String)prefix).substring(((String)prefix).length() - 30);
        }
        String suffix = StringUtil.shortenTextWithEllipsis(document.getText(new TextRange(offset2, end)), 30, 0);
        String text2 = (String)prefix + "|" + suffix;
        String string2 = offset2 + "(" + (line + 1) + ":" + (column + 1) + ") [" + text2 + "]";
        if (string2 == null) {
            MadTestingUtil.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @NotNull
    static String getIntentionDescription(IntentionAction action2) {
        return MadTestingUtil.getIntentionDescription(action2.getText(), action2);
    }

    @NotNull
    static String getIntentionDescription(String intentionName, IntentionAction action2) {
        IntentionAction actual = IntentionActionDelegate.unwrap(action2);
        String family = actual.getFamilyName();
        Class<?> aClass = actual.getClass();
        if (actual instanceof QuickFixWrapper) {
            LocalQuickFix fix2 = ((QuickFixWrapper)actual).getFix();
            family = fix2.getFamilyName();
            aClass = fix2.getClass();
        }
        String string2 = "'" + intentionName + "' (family: '" + family + "'; class: '" + aClass.getName() + "')";
        if (string2 == null) {
            MadTestingUtil.$$$reportNull$$$0(17);
        }
        return string2;
    }

    public static void testFileGenerator(File root, FileFilter filter2, int iterationCount, PrintStream out) {
        for (boolean roulette : new boolean[]{true, false}) {
            out.println("Testing " + (roulette ? "roulette" : "plain") + " generator");
            ObjectIntHashMap fileMap = new ObjectIntHashMap();
            Generator<File> generator = MadTestingUtil.randomFiles(root.getPath(), filter2, roulette);
            MadTestingAction action2 = env -> {
                long lastTime;
                long startTime = lastTime = System.nanoTime();
                for (int iteration = 1; iteration <= iterationCount; ++iteration) {
                    File file2 = (File)env.generateValue(generator, null);
                    assert (filter2.accept(file2));
                    fileMap.put(file2.getPath(), fileMap.getOrDefault(file2.getPath(), 0) + 1);
                    long curTime = System.nanoTime();
                    if (iteration <= 10) {
                        out.print("#" + iteration + " = " + (curTime - lastTime) / 1000000L + "ms");
                        if (iteration == 10) {
                            out.println();
                        } else {
                            out.print("; ");
                        }
                        lastTime = curTime;
                    }
                    if (iteration != iterationCount && curTime - lastTime <= TimeUnit.SECONDS.toNanos(5L)) continue;
                    lastTime = curTime;
                    out.println(MadTestingUtil.getHistogramReport(fileMap, iteration));
                }
                out.println("Total time: " + (System.nanoTime() - startTime) / 1000000L + "ms");
            };
            PropertyChecker.customized().withIterationCount(1).checkScenarios(() -> action2);
        }
    }

    @NotNull
    private static String getHistogramReport(ObjectIntMap<String> fileMap, int iteration) {
        long[] stops = new long[]{1L, 2L, 3L, 5L, 10L, 20L, 30L, 50L, 100L, 200L, Long.MAX_VALUE};
        int[] histogram = new int[stops.length];
        for (ObjectIntMap.Entry<String> entry : fileMap.entries()) {
            int count2 = entry.getValue();
            int pos = Arrays.binarySearch(stops, (long)count2);
            if (pos < 0) {
                pos = -pos - 1;
            }
            int n = pos;
            histogram[n] = histogram[n] + 1;
        }
        StringBuilder report = new StringBuilder();
        for (int i2 = 0; i2 < stops.length; ++i2) {
            String range = i2 == 0 || stops[i2 - 1] == stops[i2] - 1L ? String.valueOf(stops[i2]) : stops[i2 - 1] + 1L + (String)(stops[i2] == Long.MAX_VALUE ? "+" : ".." + stops[i2]);
            report.append(String.format(Locale.ENGLISH, "%s: %-5d| ", range, histogram[i2]));
        }
        String string2 = String.format(Locale.ENGLISH, "#%-5d: sum = %5d [%s]", iteration, Arrays.stream(histogram).sum(), report.toString().replaceFirst("[\\s|]+$", ""));
        if (string2 == null) {
            MadTestingUtil.$$$reportNull$$$0(18);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 13, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "except";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "performOnFileContents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "randomEditsWithReparseChecks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "randomEditsWithPsiAccessorChecks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionDescription";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionDescription";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistogramReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enableAllInspections";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enableDefaultInspections";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceProfile";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldGoInsiderDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canContainSources";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "randomEditsWithReparseChecks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "randomEditsWithPsiAccessorChecks";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 11, 13, 15, 16, 17, 18 -> new IllegalStateException(string2);
        };
    }

    private static final class RouletteWheelFileGenerator
    implements Function<GenerationEnvironment, File> {
        private final File myRoot;
        private final FileFilter myFilter;
        private static final File[] EMPTY_DIRECTORY = new File[0];
        private final SoftFactoryMap<File, File[]> myChildrenCache;

        private RouletteWheelFileGenerator(@NotNull File root, @NotNull FileFilter filter2) {
            if (root == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(0);
            }
            if (filter2 == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(1);
            }
            this.myChildrenCache = new SoftFactoryMap<File, File[]>(){

                @Override
                protected File[] create(@NotNull File f) {
                    File[] files2;
                    if (f == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((files2 = f.listFiles(child -> myFilter.accept(child) && (child.isFile() || FileGenerator.containsAtLeastOneFileDeep(child)))) == null) {
                        return null;
                    }
                    if (files2.length == 0) {
                        return EMPTY_DIRECTORY;
                    }
                    return files2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/testFramework/propertyBased/MadTestingUtil$RouletteWheelFileGenerator$1", "create"));
                }
            };
            this.myRoot = root;
            this.myFilter = filter2;
        }

        @Override
        public File apply(GenerationEnvironment data2) {
            return this.generateRandomFile(data2, this.myRoot, new HashSet<File>());
        }

        @Nullable
        private File generateRandomFile(GenerationEnvironment data2, File file2, Set<File> exhausted) {
            File[] children2 = this.myChildrenCache.get(file2);
            if (children2 == null) {
                return file2;
            }
            if (children2 == EMPTY_DIRECTORY) {
                return null;
            }
            Arrays.sort(children2, Comparator.comparing(File::getName));
            while (true) {
                int index2;
                int[] weights = Arrays.stream(children2).mapToInt(child -> this.estimateWeight((File)child, exhausted)).toArray();
                try {
                    index2 = RouletteWheelFileGenerator.spin(data2, weights);
                }
                catch (RuntimeException e) {
                    if ("org.jetbrains.jetCheck.CannotRestoreValue".equals(e.getClass().getName())) {
                        throw new RuntimeException("Directory structure changed in " + file2 + " or its direct children?", e);
                    }
                    throw e;
                }
                if (index2 == -1) {
                    return null;
                }
                File chosen = children2[index2];
                File generated = this.generateRandomFile(data2, chosen, exhausted);
                if (generated != null) {
                    return generated;
                }
                exhausted.add(chosen);
            }
        }

        private static int spin(@NotNull GenerationEnvironment data2, int @NotNull [] weights) {
            int totalWeight;
            if (data2 == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(2);
            }
            if (weights == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(3);
            }
            if ((totalWeight = Arrays.stream(weights).sum()) == 0) {
                return -1;
            }
            int value = (Integer)data2.generate(Generator.integers((int)0, (int)totalWeight));
            for (int i2 = 0; i2 < weights.length; ++i2) {
                if ((value -= weights[i2]) >= 0) continue;
                return i2;
            }
            return -1;
        }

        private int estimateWeight(File file2, @NotNull Set<File> exhausted) {
            if (exhausted == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(4);
            }
            if (exhausted.contains(file2)) {
                return 0;
            }
            File[] children2 = this.myChildrenCache.get(file2);
            if (children2 == null) {
                return 1;
            }
            return Stream.of(children2).mapToInt(f -> exhausted.contains(f) ? 0 : (f.isDirectory() ? 5 : 1)).sum();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "weights";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exhausted";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/propertyBased/MadTestingUtil$RouletteWheelFileGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "spin";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "estimateWeight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FileGenerator
    implements Function<GenerationEnvironment, File> {
        private static final com.intellij.util.Function<File, JBIterable<File>> FS_TRAVERSAL = TreeTraversal.PRE_ORDER_DFS.traversal(f -> f.isDirectory() ? Arrays.asList(Objects.requireNonNull(f.listFiles())) : Collections.emptyList());
        private final File myRoot;
        private final FileFilter myFilter;

        private FileGenerator(File root, FileFilter filter2) {
            this.myRoot = root;
            this.myFilter = filter2;
        }

        @Override
        public File apply(GenerationEnvironment data2) {
            return this.generateRandomFile(data2, this.myRoot, new HashSet());
        }

        @Nullable
        private File generateRandomFile(GenerationEnvironment data2, File file2, Set<? super File> exhausted) {
            List<File> toChoose;
            File chosen;
            File generated;
            do {
                File[] children2;
                if ((children2 = file2.listFiles(f -> !exhausted.contains(f) && FileGenerator.containsAtLeastOneFileDeep(f) && this.myFilter.accept(f))) == null) {
                    return file2;
                }
                if (children2.length == 0) {
                    exhausted.add(file2);
                    return null;
                }
                toChoose = FileGenerator.preferDirs(data2, children2);
                toChoose.sort(Comparator.comparing(File::getName));
            } while ((generated = this.generateRandomFile(data2, chosen = (File)data2.generate(Generator.sampledFrom(toChoose)), exhausted)) == null);
            return generated;
        }

        private static boolean containsAtLeastOneFileDeep(File root) {
            return FS_TRAVERSAL.fun(root).find(f -> f.isFile()) != null;
        }

        private static List<File> preferDirs(GenerationEnvironment data2, File[] children2) {
            ArrayList files2 = new ArrayList();
            ArrayList<File> dirs = new ArrayList<File>();
            for (File child : children2) {
                (child.isDirectory() ? dirs : files2).add(child);
            }
            if (files2.isEmpty() || dirs.isEmpty()) {
                return Arrays.asList(children2);
            }
            int ratio = Math.max(100, dirs.size() / files2.size());
            return (Integer)data2.generate(Generator.integers((int)0, (int)(ratio - 1))) != 0 ? dirs : files2;
        }
    }
}

