/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.ImperativeCommand;

public class StripTestDataMarkup
extends ActionOnFile {
    private static final String[] MARKUP = new String[]{"<caret>", "<ref>", "<selection>", "</selection>"};

    public StripTestDataMarkup(@NotNull PsiFile file2) {
        if (file2 == null) {
            StripTestDataMarkup.$$$reportNull$$$0(0);
        }
        super(file2);
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            StripTestDataMarkup.$$$reportNull$$$0(1);
        }
        env.logMessage(this.toString());
        WriteCommandAction.runWriteCommandAction(this.getProject(), () -> {
            Document document = this.getDocument();
            try {
                new ExpectedHighlightingData(document, true, true, true, true, new ResourceBundle[0]).init();
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            for (String s : MARKUP) {
                StripTestDataMarkup.removeMarkup(document, s);
            }
        });
        PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
    }

    private static void removeMarkup(Document document, String marker) {
        document.setText(StringUtil.replace(document.getText(), marker, ""));
    }

    public String toString() {
        return "Strip markup: " + Arrays.toString(MARKUP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/propertyBased/StripTestDataMarkup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

