/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.Synthetic;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.testFramework.DisposableRule;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RuleChain;
import com.intellij.testFramework.rules.ProjectModelRule;
import com.intellij.testFramework.rules.TempDirectory;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001rB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806JK\u00109\u001a\u0002H:\"\u000e\b\u0000\u0010:*\b\u0012\u0004\u0012\u0002H<0;\"\b\b\u0001\u0010<*\u00020=2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u0002H<0A2\b\b\u0002\u0010B\u001a\u0002H<\u00a2\u0006\u0002\u0010CJ,\u0010D\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010E\u001a\u00020\u001c2\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806J,\u0010F\u001a\u0002022\u0006\u0010>\u001a\u00020?2\u0006\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806J$\u0010G\u001a\u0002022\u0006\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806J\u000e\u0010H\u001a\u0002082\u0006\u0010I\u001a\u00020JJ&\u0010H\u001a\u00020J2\b\b\u0002\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020806J\"\u0010L\u001a\u00020M2\u0006\u0010>\u001a\u00020?2\u0006\u0010N\u001a\u0002042\n\u0010O\u001a\u0006\u0012\u0002\b\u00030PJ\u0018\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020R2\u0006\u0010T\u001a\u00020UH\u0016J\u0016\u0010V\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010W\u001a\u00020XJ\u0010\u0010Y\u001a\u00020?2\b\b\u0002\u00103\u001a\u000204J\u0016\u0010Y\u001a\u00020?2\u0006\u00103\u001a\u0002042\u0006\u0010Z\u001a\u00020[J&\u0010\\\u001a\u00020J2\b\b\u0002\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020806J\u0010\u0010]\u001a\u0002082\u0006\u0010^\u001a\u000202H\u0002J\u0018\u0010_\u001a\n `*\u0004\u0018\u00010\"0\"2\u0006\u00103\u001a\u000204H\u0002J\"\u0010a\u001a\u0002082\u0006\u0010^\u001a\u00020b2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806J\"\u0010d\u001a\u0002082\u0006\u0010I\u001a\u00020J2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020806J\u0012\u0010e\u001a\u0002082\n\u0010f\u001a\u0006\u0012\u0002\b\u00030;J\u000e\u0010g\u001a\u0002082\u0006\u0010>\u001a\u00020?J\u0016\u0010h\u001a\u0002082\u0006\u0010^\u001a\u00020b2\u0006\u0010i\u001a\u000204J\u0016\u0010j\u001a\u0002082\u0006\u0010>\u001a\u00020?2\u0006\u0010i\u001a\u000204J\u001f\u0010k\u001a\u0002082\u0012\u0010l\u001a\n\u0012\u0006\b\u0001\u0012\u0002040m\"\u000204\u00a2\u0006\u0002\u0010nJ\u0010\u0010o\u001a\u0002082\u0006\u0010p\u001a\u000204H\u0004J\b\u0010q\u001a\u000208H\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00060 R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006s"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule;", "Lorg/junit/rules/TestRule;", "()V", "baseProjectDir", "Lcom/intellij/testFramework/rules/TempDirectory;", "getBaseProjectDir", "()Lcom/intellij/testFramework/rules/TempDirectory;", "disposableRule", "Lcom/intellij/testFramework/DisposableRule;", "getDisposableRule", "()Lcom/intellij/testFramework/DisposableRule;", "filePointerTracker", "Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;", "getFilePointerTracker", "()Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;", "setFilePointerTracker", "(Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;)V", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "getModuleManager", "()Lcom/intellij/openapi/module/ModuleManager;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "projectLibraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "getProjectLibraryTable", "()Lcom/intellij/openapi/roots/libraries/LibraryTable;", "projectResource", "Lcom/intellij/testFramework/rules/ProjectModelRule$ProjectResource;", "projectRootDir", "Ljava/nio/file/Path;", "getProjectRootDir", "()Ljava/nio/file/Path;", "setProjectRootDir", "(Ljava/nio/file/Path;)V", "projectRootManager", "Lcom/intellij/openapi/roots/ProjectRootManager;", "getProjectRootManager", "()Lcom/intellij/openapi/roots/ProjectRootManager;", "ruleChain", "Lcom/intellij/testFramework/RuleChain;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "addApplicationLevelLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "name", "", "setup", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "", "addFacet", "F", "Lcom/intellij/facet/Facet;", "C", "Lcom/intellij/facet/FacetConfiguration;", "module", "Lcom/intellij/openapi/module/Module;", "type", "Lcom/intellij/facet/FacetType;", "configuration", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/facet/FacetType;Lcom/intellij/facet/FacetConfiguration;)Lcom/intellij/facet/Facet;", "addLibrary", "libraryTable", "addModuleLevelLibrary", "addProjectLevelLibrary", "addSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "addSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "rootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "createLibraryAndDisposeOnTearDown", "model", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "createModule", "moduleModel", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "createSdk", "disposeOnTearDown", "library", "generateImlPath", "kotlin.jvm.PlatformType", "modifyLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "action", "modifySdk", "removeFacet", "facet", "removeModule", "renameLibrary", "newName", "renameModule", "setUnloadedModules", "moduleName", "", "([Ljava/lang/String;)V", "setUp", "methodName", "tearDown", "ProjectResource", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nProjectModelRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModelRule.kt\ncom/intellij/testFramework/rules/ProjectModelRule\n+ 2 readWriteActionsInTests.kt\ncom/intellij/openapi/application/ReadWriteActionsInTestsKt\n+ 3 FixtureRule.kt\ncom/intellij/testFramework/DisposableRule\n*L\n1#1,258:1\n11#2:259\n11#2:260\n11#2:261\n11#2:268\n11#2:269\n11#2:270\n11#2:271\n628#3,6:262\n*S KotlinDebug\n*F\n+ 1 ProjectModelRule.kt\ncom/intellij/testFramework/rules/ProjectModelRule\n*L\n77#1:259\n122#1:260\n144#1:261\n184#1:268\n190#1:269\n194#1:270\n208#1:271\n160#1:262,6\n*E\n"})
public class ProjectModelRule
implements TestRule {
    @NotNull
    private final TempDirectory baseProjectDir = new TempDirectory();
    @NotNull
    private final DisposableRule disposableRule = new DisposableRule();
    public Project project;
    public Path projectRootDir;
    public VirtualFilePointerTracker filePointerTracker;
    @NotNull
    private final ProjectResource projectResource = new ProjectResource();
    @NotNull
    private final RuleChain ruleChain;

    public ProjectModelRule() {
        TestRule[] testRuleArray = new TestRule[]{(TestRule)this.baseProjectDir, (TestRule)this.projectResource, (TestRule)this.disposableRule};
        this.ruleChain = new RuleChain(testRuleArray);
    }

    @NotNull
    public final TempDirectory getBaseProjectDir() {
        return this.baseProjectDir;
    }

    @NotNull
    public final DisposableRule getDisposableRule() {
        return this.disposableRule;
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.project;
        if (project2 != null) {
            return project2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"<set-?>");
        this.project = project2;
    }

    @NotNull
    public final Path getProjectRootDir() {
        Path path2 = this.projectRootDir;
        if (path2 != null) {
            return path2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"projectRootDir");
        return null;
    }

    public final void setProjectRootDir(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"<set-?>");
        this.projectRootDir = path2;
    }

    @NotNull
    public final VirtualFilePointerTracker getFilePointerTracker() {
        VirtualFilePointerTracker virtualFilePointerTracker = this.filePointerTracker;
        if (virtualFilePointerTracker != null) {
            return virtualFilePointerTracker;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"filePointerTracker");
        return null;
    }

    public final void setFilePointerTracker(@NotNull VirtualFilePointerTracker virtualFilePointerTracker) {
        Intrinsics.checkNotNullParameter((Object)virtualFilePointerTracker, (String)"<set-?>");
        this.filePointerTracker = virtualFilePointerTracker;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.ruleChain.apply(base, description);
    }

    @NotNull
    public final Module createModule(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path imlFile = this.generateImlPath(name);
        ModuleManager manager = this.getModuleManager();
        boolean $i$f$runWriteActionAndWait = false;
        return (Module)WriteAction.computeAndWait(new ThrowableComputable(manager, imlFile){
            final /* synthetic */ ModuleManager $manager$inlined;
            final /* synthetic */ Path $imlFile$inlined;
            {
                this.$manager$inlined = moduleManager;
                this.$imlFile$inlined = path2;
            }

            public final T compute() {
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.$imlFile$inlined, (String)"imlFile");
                return (T)this.$manager$inlined.newModule(this.$imlFile$inlined, "EMPTY_MODULE");
            }
        });
    }

    public static /* synthetic */ Module createModule$default(ProjectModelRule projectModelRule, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createModule");
        }
        if ((n & 1) != 0) {
            string2 = "module";
        }
        return projectModelRule.createModule(string2);
    }

    @NotNull
    public final Module createModule(@NotNull String name, @NotNull ModifiableModuleModel moduleModel) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)moduleModel, (String)"moduleModel");
        Module module2 = moduleModel.newModule(this.generateImlPath(name), "EMPTY_MODULE");
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"moduleModel.newModule(ge\u2026yModuleType.EMPTY_MODULE)");
        return module2;
    }

    @NotNull
    public final VirtualFile addSourceRoot(@NotNull Module module2, @NotNull String relativePath, @NotNull JpsModuleSourceRootType<?> rootType) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(rootType, (String)"rootType");
        VirtualFile srcRoot = this.baseProjectDir.newVirtualDirectory(module2.getName() + "/" + relativePath);
        ModuleRootModificationUtil.updateModel(module2, arg_0 -> ProjectModelRule.addSourceRoot$lambda$1((Function1)new Function1<ModifiableRootModel, Unit>(this, module2, srcRoot, rootType){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ VirtualFile $srcRoot;
            final /* synthetic */ JpsModuleSourceRootType<?> $rootType;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                this.$srcRoot = $srcRoot;
                this.$rootType = $rootType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ModifiableRootModel model2) {
                boolean bl;
                VirtualFile virtualFile2;
                ContentEntry contentEntry;
                block5: {
                    void $this$none$iv;
                    ContentEntry contentEntry2;
                    Object object;
                    Synthetic it;
                    String contentRootUrl;
                    block4: {
                        Path path2 = this.this$0.getProjectRootDir().resolve(this.$module.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectRootDir.resolve(module.name)");
                        String string2 = VfsUtil.pathToUrl(PathKt.getSystemIndependentPath(path2));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathToUrl(projectRootDir\u2026e).systemIndependentPath)");
                        contentRootUrl = string2;
                        ContentEntry[] contentEntryArray = model2.getContentEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"model.contentEntries");
                        for (Object object2 : (Object[])contentEntryArray) {
                            it = (ContentEntry)object2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)contentRootUrl)) continue;
                            object = object2;
                            break block4;
                        }
                        object = null;
                    }
                    if ((contentEntry2 = (ContentEntry)object) == null) {
                        ContentEntry contentEntry3 = model2.addContentEntry(contentRootUrl);
                        contentEntry2 = contentEntry3;
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntry3, (String)"model.addContentEntry(contentRootUrl)");
                    }
                    contentEntry = contentEntry2;
                    SourceFolder[] sourceFolderArray = contentEntry.getSourceFolders();
                    Intrinsics.checkNotNullExpressionValue((Object)sourceFolderArray, (String)"contentEntry.sourceFolders");
                    Object[] objectArray = sourceFolderArray;
                    virtualFile2 = this.$srcRoot;
                    boolean $i$f$none = false;
                    for (void element$iv : $this$none$iv) {
                        it = (SourceFolder)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)virtualFile2.getUrl())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                boolean bl4 = bl;
                virtualFile2 = this.$srcRoot;
                if (!bl4) {
                    boolean bl5 = false;
                    String string3 = "Source folder " + virtualFile2 + " already exists";
                    throw new IllegalArgumentException(string3.toString());
                }
                contentEntry.addSourceFolder(this.$srcRoot, this.$rootType);
            }
        }, arg_0));
        return srcRoot;
    }

    private final Path generateImlPath(String name) {
        return this.getProjectRootDir().resolve(name + "/" + name + ".iml");
    }

    @NotNull
    public final Sdk createSdk(@NotNull String name, @NotNull Function1<? super SdkModificator, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(name, this.getSdkType());
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"getInstance().createSdk(name, sdkType)");
        Sdk sdk3 = sdk2;
        this.modifySdk(sdk3, setup);
        return sdk3;
    }

    public static /* synthetic */ Sdk createSdk$default(ProjectModelRule projectModelRule, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSdk");
        }
        if ((n & 1) != 0) {
            string2 = "sdk";
        }
        if ((n & 2) != 0) {
            function1 = createSdk.1.INSTANCE;
        }
        return projectModelRule.createSdk(string2, (Function1<? super SdkModificator, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void modifySdk(@NotNull Sdk sdk2, @NotNull Function1<? super SdkModificator, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        SdkModificator sdkModificator = sdk2.getSdkModificator();
        Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"sdk.sdkModificator");
        SdkModificator sdkModificator2 = sdkModificator;
        try {
            setup.invoke((Object)sdkModificator2);
        }
        finally {
            sdkModificator2.commitChanges();
        }
    }

    @NotNull
    public final Sdk addSdk(@NotNull String name, @NotNull Function1<? super SdkModificator, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Sdk sdk2 = this.createSdk(name, setup);
        this.addSdk(sdk2);
        return sdk2;
    }

    public static /* synthetic */ Sdk addSdk$default(ProjectModelRule projectModelRule, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSdk");
        }
        if ((n & 1) != 0) {
            string2 = "sdk";
        }
        if ((n & 2) != 0) {
            function1 = addSdk.1.INSTANCE;
        }
        return projectModelRule.addSdk(string2, (Function1<? super SdkModificator, Unit>)function1);
    }

    public final void addSdk(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(sdk2, this){
            final /* synthetic */ Sdk $sdk$inlined;
            final /* synthetic */ ProjectModelRule this$0;
            {
                this.$sdk$inlined = sdk2;
                this.this$0 = projectModelRule;
            }

            public final T compute() {
                boolean bl = false;
                ProjectJdkTable.getInstance().addJdk(this.$sdk$inlined, this.this$0.getDisposableRule().getDisposable());
                return (T)Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final LibraryEx addProjectLevelLibrary(@NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        return this.addLibrary(name, this.getProjectLibraryTable(), setup);
    }

    public static /* synthetic */ LibraryEx addProjectLevelLibrary$default(ProjectModelRule projectModelRule, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addProjectLevelLibrary");
        }
        if ((n & 2) != 0) {
            function1 = addProjectLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addProjectLevelLibrary(string2, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addModuleLevelLibrary(@NotNull Module module2, @NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Ref<LibraryEx> ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue(ref, (String)"create<LibraryEx>()");
        Ref<LibraryEx> library = ref;
        ModuleRootModificationUtil.updateModel(module2, arg_0 -> ProjectModelRule.addModuleLevelLibrary$lambda$3((Function1)new Function1<ModifiableRootModel, Unit>(library, this, name, setup){
            final /* synthetic */ Ref<LibraryEx> $library;
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Function1<LibraryEx.ModifiableModelEx, Unit> $setup;
            {
                this.$library = $library;
                this.this$0 = $receiver;
                this.$name = $name;
                this.$setup = $setup;
                super(1);
            }

            public final void invoke(ModifiableRootModel model2) {
                LibraryTable libraryTable = model2.getModuleLibraryTable();
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"model.moduleLibraryTable");
                this.$library.set(this.this$0.addLibrary(this.$name, libraryTable, this.$setup));
            }
        }, arg_0));
        LibraryEx libraryEx = library.get();
        Intrinsics.checkNotNullExpressionValue((Object)libraryEx, (String)"library.get()");
        return libraryEx;
    }

    public static /* synthetic */ LibraryEx addModuleLevelLibrary$default(ProjectModelRule projectModelRule, Module module2, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addModuleLevelLibrary");
        }
        if ((n & 4) != 0) {
            function1 = addModuleLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addModuleLevelLibrary(module2, string2, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addLibrary(@NotNull String name, @NotNull LibraryTable libraryTable, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        LibraryTable.ModifiableModel modifiableModel = libraryTable.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"libraryTable.modifiableModel");
        LibraryTable.ModifiableModel model2 = modifiableModel;
        Library library = model2.createLibrary(name);
        Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        LibraryEx library2 = (LibraryEx)library;
        LibraryEx.ModifiableModelEx modifiableModelEx = library2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"library.modifiableModel");
        LibraryEx.ModifiableModelEx libraryModel = modifiableModelEx;
        setup.invoke((Object)libraryModel);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(libraryModel, model2){
            final /* synthetic */ LibraryEx.ModifiableModelEx $libraryModel$inlined;
            final /* synthetic */ LibraryTable.ModifiableModel $model$inlined;
            {
                this.$libraryModel$inlined = modifiableModelEx;
                this.$model$inlined = modifiableModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$libraryModel$inlined.commit();
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        Object[] objectArray = new String[]{"module", "project"};
        if (!SetsKt.setOf((Object[])objectArray).contains(libraryTable.getTableLevel())) {
            this.disposeOnTearDown(library2);
        }
        return library2;
    }

    public static /* synthetic */ LibraryEx addLibrary$default(ProjectModelRule projectModelRule, String string2, LibraryTable libraryTable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addLibrary");
        }
        if ((n & 4) != 0) {
            function1 = addLibrary.1.INSTANCE;
        }
        return projectModelRule.addLibrary(string2, libraryTable, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addApplicationLevelLibrary(@NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getInstance().libraryTable");
        LibraryTable libraryTable2 = libraryTable;
        return this.addLibrary(name, libraryTable2, setup);
    }

    public static /* synthetic */ LibraryEx addApplicationLevelLibrary$default(ProjectModelRule projectModelRule, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addApplicationLevelLibrary");
        }
        if ((n & 2) != 0) {
            function1 = addApplicationLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addApplicationLevelLibrary(string2, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    private final void disposeOnTearDown(LibraryEx library) {
        DisposableRule this_$iv = this.disposableRule;
        boolean $i$f$register = false;
        Disposer.register(this_$iv.getDisposable(), new Disposable(library){
            final /* synthetic */ LibraryEx $library$inlined;
            {
                this.$library$inlined = libraryEx;
            }

            public void dispose() {
                boolean bl = false;
                boolean $i$f$runWriteActionAndWait = false;
                WriteAction.computeAndWait(new ThrowableComputable(this.$library$inlined){
                    final /* synthetic */ LibraryEx $library$inlined;
                    {
                        this.$library$inlined = libraryEx;
                    }

                    public final T compute() {
                        boolean bl = false;
                        if (!this.$library$inlined.isDisposed()) {
                            LibraryTable libraryTable = this.$library$inlined.getTable();
                            String string2 = this.$library$inlined.getName();
                            Intrinsics.checkNotNull((Object)string2);
                            if (Intrinsics.areEqual((Object)libraryTable.getLibraryByName(string2), (Object)this.$library$inlined)) {
                                this.$library$inlined.getTable().removeLibrary(this.$library$inlined);
                            }
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        });
    }

    @NotNull
    public final LibraryEx createLibraryAndDisposeOnTearDown(@NotNull String name, @NotNull LibraryTable.ModifiableModel model2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Library library = model2.createLibrary(name);
        Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        LibraryEx library2 = (LibraryEx)library;
        this.disposeOnTearDown(library2);
        return library2;
    }

    public final void renameLibrary(@NotNull Library library, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        this.modifyLibrary(library, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)((Function1)new Function1<LibraryEx.ModifiableModelEx, Unit>(newName2){
            final /* synthetic */ String $newName;
            {
                this.$newName = $newName;
                super(1);
            }

            public final void invoke(@NotNull LibraryEx.ModifiableModelEx it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setName(this.$newName);
            }
        }));
    }

    public final void modifyLibrary(@NotNull Library library, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        Intrinsics.checkNotNull((Object)modifiableModel, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
        LibraryEx.ModifiableModelEx model2 = (LibraryEx.ModifiableModelEx)modifiableModel;
        action2.invoke((Object)model2);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(model2){
            final /* synthetic */ LibraryEx.ModifiableModelEx $model$inlined;
            {
                this.$model$inlined = modifiableModelEx;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void renameModule(@NotNull Module module2, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        ModifiableModuleModel model2 = (ModifiableModuleModel)ActionsKt.runReadAction((Function0)new Function0<ModifiableModuleModel>(this){
            final /* synthetic */ ProjectModelRule this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ModifiableModuleModel invoke() {
                return this.this$0.getModuleManager().getModifiableModel();
            }
        });
        model2.renameModule(module2, newName2);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(model2){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void removeModule(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(this, module2){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Module $module$inlined;
            {
                this.this$0 = projectModelRule;
                this.$module$inlined = module2;
            }

            public final T compute() {
                boolean bl = false;
                this.this$0.getModuleManager().disposeModule(this.$module$inlined);
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void setUnloadedModules(String ... moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        ProjectUtilKt.runUnderModalProgressIfIsEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, moduleName, null){
            int label;
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ String[] $moduleName;
            {
                this.this$0 = $receiver;
                this.$moduleName = $moduleName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getModuleManager().setUnloadedModules(ArraysKt.toList((Object[])this.$moduleName), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final <F extends Facet<C>, C extends FacetConfiguration> F addFacet(@NotNull Module module2, @NotNull FacetType<F, C> type, @NotNull C configuration) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        FacetManager facetManager = FacetManager.getInstance((Module)module2);
        ModifiableFacetModel modifiableFacetModel = facetManager.createModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableFacetModel, (String)"facetManager.createModifiableModel()");
        ModifiableFacetModel model2 = modifiableFacetModel;
        Facet facet = facetManager.createFacet(type, type.getDefaultFacetName(), configuration, null);
        Intrinsics.checkNotNullExpressionValue((Object)facet, (String)"facetManager.createFacet\u2026ame, configuration, null)");
        Facet facet2 = facet;
        model2.addFacet(facet2);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(model2){
            final /* synthetic */ ModifiableFacetModel $model$inlined;
            {
                this.$model$inlined = modifiableFacetModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return (F)facet2;
    }

    public static /* synthetic */ Facet addFacet$default(ProjectModelRule projectModelRule, Module module2, FacetType facetType, FacetConfiguration facetConfiguration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addFacet");
        }
        if ((n & 4) != 0) {
            FacetConfiguration facetConfiguration2 = facetType.createDefaultConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)facetConfiguration2, (String)"type.createDefaultConfiguration()");
            facetConfiguration = facetConfiguration2;
        }
        return projectModelRule.addFacet(module2, facetType, facetConfiguration);
    }

    public final void removeFacet(@NotNull Facet<?> facet) {
        Intrinsics.checkNotNullParameter(facet, (String)"facet");
        FacetUtil.deleteFacet(facet);
    }

    protected final void setUp(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        this.baseProjectDir.before(methodName);
        this.projectResource.before();
    }

    protected final void tearDown() {
        this.disposableRule.after();
        this.projectResource.after();
        this.baseProjectDir.after();
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)simpleJavaSdkType, (String)"getInstance()");
        return (SdkTypeId)simpleJavaSdkType;
    }

    @NotNull
    public final ProjectRootManager getProjectRootManager() {
        ProjectRootManager projectRootManager2 = ProjectRootManager.getInstance(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager2, (String)"getInstance(project)");
        return projectRootManager2;
    }

    @NotNull
    public final ModuleManager getModuleManager() {
        return ModuleManager.Companion.getInstance(this.getProject());
    }

    @NotNull
    public final LibraryTable getProjectLibraryTable() {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getInstance().getLibraryTable(project)");
        return libraryTable;
    }

    private static final void addSourceRoot$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addModuleLevelLibrary$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule$ProjectResource;", "Lorg/junit/rules/ExternalResource;", "(Lcom/intellij/testFramework/rules/ProjectModelRule;)V", "after", "", "before", "intellij.platform.testFramework"})
    public final class ProjectResource
    extends ExternalResource {
        public void before() {
            Path path2 = ProjectModelRule.this.getBaseProjectDir().getRoot().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"baseProjectDir.root.toPath()");
            ProjectModelRule.this.setProjectRootDir(path2);
            Project project2 = PlatformTestUtil.loadAndOpenProject(ProjectModelRule.this.getProjectRootDir(), ProjectModelRule.this.getDisposableRule().getDisposable());
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"loadAndOpenProject(proje\u2026isposableRule.disposable)");
            ProjectModelRule.this.setProject(project2);
            ProjectModelRule.this.setFilePointerTracker(new VirtualFilePointerTracker());
        }

        public void after() {
            PlatformTestUtil.forceCloseProjectWithoutSaving(ProjectModelRule.this.getProject());
            ProjectModelRule.this.getFilePointerTracker().assertPointersAreDisposed();
        }
    }
}

