/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.codeVision;

import com.intellij.codeInsight.codeVision.CodeVisionHost;
import com.intellij.codeInsight.codeVision.CodeVisionInitializer;
import com.intellij.codeInsight.codeVision.CodeVisionProvider;
import com.intellij.codeInsight.codeVision.settings.CodeVisionSettings;
import com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer;
import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.codeVision.CodeVisionTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J1\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\bH\u0004\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/testFramework/utils/codeVision/CodeVisionTestCase;", "Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase;", "()V", "onlyCodeVisionHintsAllowed", "", "getOnlyCodeVisionHintsAllowed", "()Z", "dumpCodeVisionHints", "", "sourceText", "setUp", "", "testProviders", "expectedText", "fileName", "enabledProviderIds", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nCodeVisionTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionTestCase.kt\ncom/intellij/testFramework/utils/codeVision/CodeVisionTestCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1855#2,2:63\n1855#2,2:65\n*S KotlinDebug\n*F\n+ 1 CodeVisionTestCase.kt\ncom/intellij/testFramework/utils/codeVision/CodeVisionTestCase\n*L\n31#1:63,2\n40#1:65,2\n*E\n"})
public abstract class CodeVisionTestCase
extends InlayHintsProviderTestCase {
    protected boolean getOnlyCodeVisionHintsAllowed() {
        return false;
    }

    @Override
    protected void setUp() {
        Registry.get("editor.codeVision.new").setValue(true, this.getTestRootDisposable());
        TestModeFlags.set(CodeVisionHost.Companion.isCodeVisionTestKey(), true, this.getTestRootDisposable());
        CodeVisionHost.Companion.isCodeVisionTestKey();
        super.setUp();
    }

    protected final void testProviders(@NotNull String expectedText, @NotNull String fileName, String ... enabledProviderIds) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)enabledProviderIds, (String)"enabledProviderIds");
        CodeVisionSettings settings = CodeVisionSettings.Companion.instance();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        CodeVisionHost codeVisionHost = CodeVisionInitializer.Companion.getInstance(project2).getCodeVisionHost();
        Iterable $this$forEach$iv = codeVisionHost.getProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeVisionProvider it = (CodeVisionProvider)element$iv;
            boolean bl = false;
            settings.setProviderEnabled(it.getId(), ArraysKt.contains((Object[])enabledProviderIds, (Object)it.getId()));
        }
        String sourceText = InlayDumpUtil.INSTANCE.removeHints(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        Editor editor2 = this.myFixture.getEditor();
        this.getProject().putUserData(CodeVisionHost.Companion.isCodeVisionTestKey(), true);
        Iterable $this$forEach$iv2 = codeVisionHost.getProviders();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CodeVisionProvider it = (CodeVisionProvider)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)"vcs.code.vision") || !ArraysKt.contains((Object[])enabledProviderIds, (Object)it.getId())) continue;
            Editor editor3 = this.myFixture.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"myFixture.editor");
            PsiFile psiFile = this.myFixture.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"myFixture.file");
            it.preparePreview(editor3, psiFile);
        }
        this.myFixture.doHighlighting();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"testRootDisposable");
        codeVisionHost.calculateCodeVisionSync(editor2, disposable);
        String actualText = this.dumpCodeVisionHints(sourceText);
        BasePlatformTestCase.assertEquals((String)expectedText, (String)actualText);
    }

    private final String dumpCodeVisionHints(String sourceText) {
        Function1 function1 = new Function1<Inlay<?>, Boolean>(this){
            final /* synthetic */ CodeVisionTestCase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Inlay<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                boolean rendererSupported = it.getRenderer() instanceof CodeVisionRenderer;
                if (this.this$0.getOnlyCodeVisionHintsAllowed() && !rendererSupported) {
                    throw new IllegalStateException("renderer not supported".toString());
                }
                return rendererSupported;
            }
        };
        Function2 function2 = dumpCodeVisionHints.2.INSTANCE;
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myFixture.editor");
        PsiFile psiFile2 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Document document = this.myFixture.getDocument(psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"myFixture.getDocument(myFixture.file!!)");
        return InlayDumpUtil.dumpHintsInternal$default(InlayDumpUtil.INSTANCE, sourceText, function1, function2, psiFile, editor2, document, 0, 64, null);
    }
}

