/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays.declarative;

import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayProviderPassInfo;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeHintsPreviewProvider;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPass;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPassFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import com.intellij.testFramework.utils.inlays.declarative.DeclarativeInlayHintsProviderTestCase;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J.\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ>\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/testFramework/utils/inlays/declarative/DeclarativeInlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "applyPassAndCheckResult", "", "pass", "Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPass;", "previewText", "", "expectedText", "doTestOptionPreview", "providerId", "provider", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "language", "Lcom/intellij/lang/Language;", "optionId", "doTestPreview", "doTestProvider", "fileName", "enabledOptions", "", "", "verifyHintsPresence", "intellij.platform.testFramework"})
public abstract class DeclarativeInlayHintsProviderTestCase
extends BasePlatformTestCase {
    public final void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider provider2, @NotNull Map<String, Boolean> enabledOptions, boolean verifyHintsPresence) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter(enabledOptions, (String)"enabledOptions");
        if (verifyHintsPresence) {
            InlayHintsProviderTestCase.Companion.verifyHintsPresence(expectedText);
        }
        String sourceText = InlayDumpUtil.INSTANCE.removeHints(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Editor editor2 = this.myFixture.getEditor();
        InlayProviderPassInfo providerInfo = new InlayProviderPassInfo(provider2, "provider.id", enabledOptions);
        PsiElement psiElement = file2;
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        DeclarativeInlayHintsPass pass2 = new DeclarativeInlayHintsPass(psiElement, editor2, CollectionsKt.listOf((Object)providerInfo), false, false, 16, null);
        this.applyPassAndCheckResult(pass2, sourceText, expectedText);
    }

    public static /* synthetic */ void doTestProvider$default(DeclarativeInlayHintsProviderTestCase declarativeInlayHintsProviderTestCase, String string2, String string3, InlayHintsProvider inlayHintsProvider, Map map2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestProvider");
        }
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        declarativeInlayHintsProviderTestCase.doTestProvider(string2, string3, inlayHintsProvider, map2, bl);
    }

    public final void doTestPreview(@NotNull String expectedText, @NotNull String providerId, @NotNull InlayHintsProvider provider2, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string2 = DeclarativeHintsPreviewProvider.INSTANCE.getPreview(language, providerId, provider2);
        if (string2 == null) {
            throw new IllegalStateException(("Preview not found for provider: " + providerId).toString());
        }
        String previewText = string2;
        Object object = language.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            throw new IllegalStateException("language must have extension".toString());
        }
        String fileName = "preview." + (String)object;
        this.myFixture.configureByText(fileName, previewText);
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"myFixture.file");
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myFixture.editor");
        DeclarativeInlayHintsPass pass2 = DeclarativeInlayHintsPassFactory.Companion.createPassForPreview(psiFile, editor2, provider2, providerId, MapsKt.emptyMap(), false);
        this.applyPassAndCheckResult(pass2, previewText, expectedText);
    }

    public final void doTestOptionPreview(@NotNull String expectedText, @NotNull String providerId, @NotNull InlayHintsProvider provider2, @NotNull Language language, @NotNull String optionId) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        String string2 = DeclarativeHintsPreviewProvider.INSTANCE.getOptionPreview(language, providerId, optionId, provider2);
        if (string2 == null) {
            throw new IllegalStateException(("Preview not found for provider: " + providerId + " and option " + optionId).toString());
        }
        String previewText = string2;
        Object object = language.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            throw new IllegalStateException("language must have extension".toString());
        }
        String fileName = "preview." + (String)object;
        this.myFixture.configureByText(fileName, previewText);
        Map options2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)optionId, (Object)true));
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"myFixture.file");
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myFixture.editor");
        DeclarativeInlayHintsPass pass2 = DeclarativeInlayHintsPassFactory.Companion.createPassForPreview(psiFile, editor2, provider2, providerId, options2, false);
        this.applyPassAndCheckResult(pass2, previewText, expectedText);
    }

    private final void applyPassAndCheckResult(DeclarativeInlayHintsPass pass2, String previewText, String expectedText) {
        pass2.doCollectInformation(new EmptyProgressIndicator());
        pass2.applyInformationToEditor();
        Function2 function2 = applyPassAndCheckResult.dump.1.INSTANCE;
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myFixture.editor");
        PsiFile psiFile2 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Document document = this.myFixture.getDocument(psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"myFixture.getDocument(myFixture.file!!)");
        String dump2 = InlayDumpUtil.dumpHintsInternal$default(InlayDumpUtil.INSTANCE, previewText, null, function2, psiFile, editor2, document, 0, 66, null);
        BasePlatformTestCase.assertEquals((String)((Object)StringsKt.trim((CharSequence)expectedText)).toString(), (String)((Object)StringsKt.trim((CharSequence)dump2)).toString());
    }
}

