/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.io;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\t\u001a\u00020\n*\u00020\u00022\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f\u001a&\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f\u001a\n\u0010\u000e\u001a\u00020\n*\u00020\u0002\u001a\u0012\u0010\u000e\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"children", "", "Ljava/nio/file/Path;", "getChildren", "(Ljava/nio/file/Path;)Ljava/util/List;", "createDirectory", "relativePath", "", "createFile", "deleteChildrenRecursively", "", "predicate", "Lkotlin/Function1;", "", "deleteRecursively", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nNioPathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioPathUtil.kt\ncom/intellij/testFramework/utils/io/NioPathUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1855#3,2:60\n*S KotlinDebug\n*F\n+ 1 NioPathUtil.kt\ncom/intellij/testFramework/utils/io/NioPathUtilKt\n*L\n47#1:60,2\n*E\n"})
public final class NioPathUtilKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> getChildren(@NotNull Path $this$children) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$children, (String)"<this>");
        Closeable closeable = Files.newDirectoryStream($this$children);
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            list2 = CollectionsKt.toList((Iterable)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list2;
    }

    @NotNull
    public static final Path createFile(@NotNull Path $this$createFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($this$createFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("File already exists: " + $this$createFile);
        }
        return NioPathUtil.findOrCreateFile($this$createFile);
    }

    @NotNull
    public static final Path createDirectory(@NotNull Path $this$createDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($this$createDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Directory already exists: " + $this$createDirectory);
        }
        return NioPathUtil.findOrCreateDirectory($this$createDirectory);
    }

    @NotNull
    public static final Path createFile(@NotNull Path $this$createFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return NioPathUtilKt.createFile(NioPathUtil.getResolvedPath($this$createFile, relativePath));
    }

    @NotNull
    public static final Path createDirectory(@NotNull Path $this$createDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return NioPathUtilKt.createDirectory(NioPathUtil.getResolvedPath($this$createDirectory, relativePath));
    }

    public static final void deleteRecursively(@NotNull Path $this$deleteRecursively) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        NioFiles.deleteRecursively($this$deleteRecursively);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteChildrenRecursively(@NotNull Path $this$deleteChildrenRecursively, @NotNull Function1<? super Path, Boolean> predicate2) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        DirectoryStream.Filter<Path> filter2 = arg_0 -> NioPathUtilKt.deleteChildrenRecursively$lambda$1(predicate2, arg_0);
        Closeable closeable = Files.newDirectoryStream($this$deleteChildrenRecursively, filter2);
        Throwable throwable = null;
        try {
            DirectoryStream stream = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            Iterable $this$forEach$iv = stream;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                NioPathUtilKt.deleteRecursively(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void deleteRecursively(@NotNull Path $this$deleteRecursively, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        NioPathUtilKt.deleteRecursively(NioPathUtil.getResolvedPath($this$deleteRecursively, relativePath));
    }

    public static final void deleteChildrenRecursively(@NotNull Path $this$deleteChildrenRecursively, @NotNull String relativePath, @NotNull Function1<? super Path, Boolean> predicate2) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        NioPathUtilKt.deleteChildrenRecursively(NioPathUtil.getResolvedPath($this$deleteChildrenRecursively, relativePath), predicate2);
    }

    private static final boolean deleteChildrenRecursively$lambda$1(Function1 $tmp0, Path p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }
}

