/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTestOrCodeHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.testOrCode";
    }

    @Override
    @Nullable
    protected GotoTargetHandler.GotoData getSourceAndTargetElements(final Editor editor2, final PsiFile file2) {
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor2, file2);
        PsiElement sourceElement = TestFinderHelper.findSourceElement(selectedElement);
        if (sourceElement == null) {
            return null;
        }
        SmartList<GotoTargetHandler.AdditionalAction> actions = new SmartList<GotoTargetHandler.AdditionalAction>();
        List candidates = Collections.synchronizedList(new ArrayList());
        if (TestFinderHelper.isTest(selectedElement)) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                Collection classes = ReadAction.compute(() -> TestFinderHelper.findClassesForTest(selectedElement));
                candidates.addAll(classes);
            }, TestFinderHelper.getSearchingForClassesForTestProgressTitle(selectedElement), true, file2.getProject())) {
                return null;
            }
        } else {
            Ref<Boolean> navigateToTestImmediatelyRef = new Ref<Boolean>(false);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                Collection tests = ReadAction.compute(() -> TestFinderHelper.findTestsForClass(selectedElement));
                candidates.addAll(tests);
                navigateToTestImmediatelyRef.set(candidates.size() == 1 && TestFinderHelper.navigateToTestImmediately((PsiElement)candidates.get(0)));
            }, TestFinderHelper.getSearchingForTestsForClassProgressTitle(selectedElement), true, file2.getProject())) {
                return null;
            }
            if (!navigateToTestImmediatelyRef.get().booleanValue()) {
                for (final TestCreator creator : LanguageTestCreators.INSTANCE.allForLanguage(file2.getLanguage())) {
                    if (!creator.isAvailable(file2.getProject(), editor2, file2)) continue;
                    actions.add(new GotoTargetHandler.AdditionalAction(){

                        @Override
                        @NotNull
                        public String getText() {
                            String text2 = creator instanceof ItemPresentation ? ((ItemPresentation)((Object)creator)).getPresentableText() : null;
                            String string2 = ObjectUtils.notNull(text2, LangBundle.message("action.create.new.test.text", new Object[0]));
                            if (string2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string2;
                        }

                        @Override
                        public Icon getIcon() {
                            Icon icon2 = creator instanceof ItemPresentation ? ((ItemPresentation)((Object)creator)).getIcon(false) : null;
                            return ObjectUtils.notNull(icon2, AllIcons.Actions.IntentionBulb);
                        }

                        @Override
                        public void execute() {
                            creator.createTest(file2.getProject(), editor2, file2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler$1", "getText"));
                        }
                    });
                }
            }
        }
        return new GotoTargetHandler.GotoData(sourceElement, PsiUtilCore.toPsiElementArray(candidates), actions);
    }

    @NotNull
    public static PsiElement getSelectedElement(Editor editor2, PsiFile file2) {
        PsiElement psiElement = PsiUtilCore.getElementAtOffset(file2, editor2.getCaretModel().getOffset());
        if (psiElement == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Override
    protected boolean shouldSortTargets() {
        return false;
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished) {
        String suffix;
        if (sourceElement == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(1);
        }
        String string2 = suffix = finished ? "" : " so far";
        if (TestFinderHelper.isTest(sourceElement)) {
            String string3 = CodeInsightBundle.message("goto.test.chooserTitle.subject", name, length, suffix);
            if (string3 == null) {
                GotoTestOrCodeHandler.$$$reportNull$$$0(2);
            }
            return string3;
        }
        String string4 = CodeInsightBundle.message("goto.test.chooserTitle.test", name, length, suffix);
        if (string4 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(3);
        }
        return string4;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(4);
        }
        if (TestFinderHelper.isTest(sourceElement)) {
            String string2 = CodeInsightBundle.message("goto.test.findUsages.subject.title", name);
            if (string2 == null) {
                GotoTestOrCodeHandler.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String string3 = CodeInsightBundle.message("goto.test.findUsages.test.title", name);
        if (string3 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(6);
        }
        return string3;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(9);
        }
        String string2 = CodeInsightBundle.message("goto.test.notFound", new Object[0]);
        if (string2 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @Nullable
    protected String getAdText(PsiElement source, int length) {
        Shortcut shortcut;
        if (length > 0 && !TestFinderHelper.isTest(source) && (shortcut = KeymapUtil.getPrimaryShortcut((String)DefaultRunExecutor.getRunExecutorInstance().getContextActionId())) != null) {
            return LangBundle.message("popup.advertisement.press.to.run.selected.tests", KeymapUtil.getShortcutText((Shortcut)shortcut));
        }
        return null;
    }

    @Override
    protected boolean useEditorFont() {
        return false;
    }

    @Override
    protected void navigateToElement(@NotNull Navigatable element) {
        if (element == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(11);
        }
        if (element instanceof PsiElement) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)((Object)element), true);
        } else {
            element.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 7, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/GotoTestOrCodeHandler";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElement";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/GotoTestOrCodeHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoundMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "navigateToElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 4, 7, 8, 9, 11 -> new IllegalArgumentException(string2);
        };
    }
}

