/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestFinderHelper {
    public static PsiElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            TestFinderHelper.$$$reportNull$$$0(0);
        }
        for (TestFinder each : TestFinderHelper.getFinders()) {
            PsiElement result2 = each.findSourceElement(from);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        if (element == null) {
            TestFinderHelper.$$$reportNull$$$0(1);
        }
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result2.addAll(each.findTestsForClass(element));
        }
        return result2;
    }

    public static Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            TestFinderHelper.$$$reportNull$$$0(2);
        }
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result2.addAll(each.findClassesForTest(element));
        }
        return result2;
    }

    public static boolean isTest(PsiElement element) {
        if (element == null) {
            return false;
        }
        for (TestFinder each : TestFinderHelper.getFinders()) {
            if (!each.isTest(element)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    public static boolean navigateToTestImmediately(@NotNull PsiElement element) {
        if (element == null) {
            TestFinderHelper.$$$reportNull$$$0(3);
        }
        for (TestFinder each : TestFinderHelper.getFinders()) {
            if (!each.navigateToTestImmediately(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NlsContexts.ProgressTitle
    public static String getSearchingForTestsForClassProgressTitle(@NotNull PsiElement element) {
        if (element == null) {
            TestFinderHelper.$$$reportNull$$$0(4);
        }
        List<TestFinder> finders = TestFinderHelper.getFinders();
        Set<String> titles = ContainerUtil.map2SetNotNull(finders, finder -> finder.getSearchingForTestsForClassProgressTitle(element));
        String string2 = ContainerUtil.getOnlyItem(titles, LangBundle.message("progress.title.searching.for.tests.for.class", new Object[0]));
        if (string2 == null) {
            TestFinderHelper.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.ProgressTitle
    public static String getSearchingForClassesForTestProgressTitle(@NotNull PsiElement element) {
        if (element == null) {
            TestFinderHelper.$$$reportNull$$$0(6);
        }
        List<TestFinder> finders = TestFinderHelper.getFinders();
        Set<String> titles = ContainerUtil.map2SetNotNull(finders, finder -> finder.getSearchingForClassesForTestProgressTitle(element));
        String string2 = ContainerUtil.getOnlyItem(titles, LangBundle.message("progress.title.searching.for.classes.for.test", new Object[0]));
        if (string2 == null) {
            TestFinderHelper.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public static List<TestFinder> getFinders() {
        return TestFinder.EP_NAME.getExtensionList();
    }

    public static Integer calcTestNameProximity(String className, String testName) {
        int posProximity = testName.indexOf(className);
        int sizeProximity = testName.length() - className.length();
        return posProximity + sizeProximity;
    }

    public static List<PsiElement> getSortedElements(List<? extends Pair<? extends PsiNamedElement, Integer>> elementsWithWeights, boolean weightsAscending) {
        return TestFinderHelper.getSortedElements(elementsWithWeights, weightsAscending, null);
    }

    public static List<PsiElement> getSortedElements(List<? extends Pair<? extends PsiNamedElement, Integer>> elementsWithWeights, boolean weightsAscending, @Nullable Comparator<? super PsiElement> sameNameComparator) {
        elementsWithWeights.sort((o1, o2) -> {
            int result2;
            int n = result2 = weightsAscending ? ((Integer)o1.second).compareTo((Integer)o2.second) : ((Integer)o2.second).compareTo((Integer)o1.second);
            if (result2 == 0) {
                result2 = Comparing.compare(((PsiNamedElement)o1.first).getName(), ((PsiNamedElement)o2.first).getName());
            }
            if (result2 == 0 && sameNameComparator != null) {
                result2 = sameNameComparator.compare((PsiElement)o1.first, (PsiElement)o2.first);
            }
            return result2;
        });
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elementsWithWeights.size());
        for (Pair<? extends PsiNamedElement, Integer> pair : elementsWithWeights) {
            result2.add((PsiElement)pair.first);
        }
        return result2;
    }

    public static List<Pair<String, Integer>> collectPossibleClassNamesWithWeights(String testName) {
        String[] words = NameUtilCore.splitNameIntoWords(testName);
        ArrayList<Pair<String, Integer>> result2 = new ArrayList<Pair<String, Integer>>();
        for (int from = 0; from < words.length; ++from) {
            for (int to = from; to < words.length; ++to) {
                result2.add(new Pair<String, Integer>(StringUtil.join(words, from, to + 1, ""), words.length - from + to));
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/TestFinderHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/TestFinderHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchingForTestsForClassProgressTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchingForClassesForTestProgressTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigateToTestImmediately";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSearchingForTestsForClassProgressTitle";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSearchingForClassesForTestProgressTitle";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 7 -> new IllegalStateException(string2);
        };
    }
}

