/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExternalToolsGroup<T extends Tool>
extends DefaultActionGroup
implements DumbAware {
    protected BaseExternalToolsGroup() {
        this.updateGroups(true);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = event.getPresentation();
        this.removeAll();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        this.updateGroups(false);
        presentation2.setEnabled(true);
        presentation2.setVisible(this.getChildrenCount() > 0);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    protected void updateGroups(boolean registerActions) {
        List<ToolsGroup<T>> groups2 = this.getToolsGroups();
        for (ToolsGroup<T> group2 : groups2) {
            String groupName = group2.getName();
            if (!StringUtil.isEmptyOrSpaces(groupName)) {
                DefaultActionGroup subgroup = new DefaultActionGroup();
                subgroup.getTemplatePresentation().setText(groupName, false);
                subgroup.setPopup(true);
                this.fillGroup(groupName, subgroup);
                if (subgroup.getChildrenCount() <= 0) continue;
                this.add((AnAction)subgroup);
                if (!registerActions) continue;
                ActionManager.getInstance().registerAction(this.getGroupIdPrefix() + groupName, (AnAction)subgroup);
                continue;
            }
            this.fillGroup(null, this);
        }
    }

    @NonNls
    @NotNull
    protected abstract String getGroupIdPrefix();

    protected abstract List<ToolsGroup<T>> getToolsGroups();

    private void fillGroup(@Nullable String groupName, @NotNull DefaultActionGroup group2) {
        if (group2 == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(2);
        }
        List<T> tools = this.getToolsByGroupName(groupName);
        for (Tool tool : tools) {
            if (!tool.isEnabled()) continue;
            this.addToolToGroup(tool, group2);
        }
    }

    private void addToolToGroup(@NotNull T tool, @NotNull DefaultActionGroup group2) {
        if (tool == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(3);
        }
        if (group2 == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(4);
        }
        String id = ((Tool)tool).getActionId();
        AnAction action2 = ActionManager.getInstance().getAction(id);
        if (action2 == null) {
            action2 = this.createToolAction(tool);
            ActionManager.getInstance().registerAction(id, action2);
        }
        group2.add(action2);
    }

    protected abstract List<T> getToolsByGroupName(String var1);

    protected abstract ToolAction createToolAction(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/BaseExternalToolsGroup";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/BaseExternalToolsGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillGroup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToolToGroup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

