/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolManager<T extends Tool>
implements Disposable {
    private final SchemeManagerFactory myFactory;
    private final SchemeManager<ToolsGroup<T>> mySchemeManager;

    public BaseToolManager(@NotNull SchemeManagerFactory factory2, @NotNull String schemePath, @NotNull String presentableName) {
        if (factory2 == null) {
            BaseToolManager.$$$reportNull$$$0(0);
        }
        if (schemePath == null) {
            BaseToolManager.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            BaseToolManager.$$$reportNull$$$0(2);
        }
        this.myFactory = factory2;
        this.mySchemeManager = factory2.create(schemePath, this.createProcessor(), presentableName, RoamingType.DEFAULT, (Function1<? super String, String>)((Function1)name -> FileUtil.sanitizeFileName(name, false)), null, null, true, SettingsCategory.OTHER);
        this.mySchemeManager.loadSchemes();
    }

    protected abstract SchemeProcessor<ToolsGroup<T>, ToolsGroup<T>> createProcessor();

    @Nullable
    protected ActionManagerEx getActionManager() {
        return ActionManagerEx.getInstanceEx();
    }

    @Nullable
    public static String convertString(String s) {
        return StringUtil.nullize(s, true);
    }

    public List<T> getTools() {
        SmartList result2 = new SmartList();
        for (ToolsGroup<T> group2 : this.mySchemeManager.getAllSchemes()) {
            result2.addAll(group2.getElements());
        }
        return result2;
    }

    @NotNull
    public List<T> getTools(@NotNull String group2) {
        ToolsGroup<T> groupByName;
        if (group2 == null) {
            BaseToolManager.$$$reportNull$$$0(3);
        }
        if ((groupByName = this.mySchemeManager.findSchemeByName(group2)) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                BaseToolManager.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List list3 = groupByName.getElements();
        if (list3 == null) {
            BaseToolManager.$$$reportNull$$$0(5);
        }
        return list3;
    }

    public List<ToolsGroup<T>> getGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    public void setTools(@NotNull List<ToolsGroup<T>> tools) {
        if (tools == null) {
            BaseToolManager.$$$reportNull$$$0(6);
        }
        this.mySchemeManager.setSchemes(tools);
        this.registerActions((ActionManager)this.getActionManager());
    }

    protected final void registerActions(@Nullable ActionManager actionManager) {
        if (actionManager == null) {
            return;
        }
        this.unregisterActions(actionManager);
        HashSet<String> registeredIds = new HashSet<String>();
        for (Tool tool : this.getTools()) {
            String actionId = tool.getActionId();
            if (!registeredIds.add(actionId)) continue;
            actionManager.registerAction(actionId, (AnAction)this.createToolAction(tool));
        }
    }

    @NotNull
    protected ToolAction createToolAction(@NotNull T tool) {
        if (tool == null) {
            BaseToolManager.$$$reportNull$$$0(7);
        }
        return new ToolAction((Tool)tool);
    }

    protected abstract String getActionIdPrefix();

    protected void unregisterActions(@Nullable ActionManager actionManager) {
        if (actionManager == null) {
            return;
        }
        for (String oldId : actionManager.getActionIdList(this.getActionIdPrefix())) {
            actionManager.unregisterAction(oldId);
        }
    }

    @Override
    public void dispose() {
        this.myFactory.dispose(this.mySchemeManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/BaseToolManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/BaseToolManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTools";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTools";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createToolAction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5 -> new IllegalStateException(string2);
        };
    }
}

