/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ScanSourceCommentsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ScanSourceCommentsAction.class);
    private final Map<String, CommentDescriptor> myComments = new HashMap<String, CommentDescriptor>();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ScanSourceCommentsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project p;
        String file2;
        if (e == null) {
            ScanSourceCommentsAction.$$$reportNull$$$0(1);
        }
        if ((file2 = Messages.showInputDialog((Project)(p = e.getProject()), (String)"Enter path to the file comments will be extracted to", (String)"Comments File Path", (Icon)Messages.getQuestionIcon())) == null) {
            return;
        }
        try (PrintStream stream = new PrintStream(file2);){
            stream.println("Comments in " + p.getName());
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                ProjectRootManager.getInstance(p).getFileIndex().iterateContent(fileOrDir -> {
                    if (fileOrDir.isDirectory()) {
                        indicator.setText("Extracting comments");
                        indicator.setText2(fileOrDir.getPresentableUrl());
                    }
                    this.scanCommentsInFile(p, fileOrDir);
                    return true;
                });
                indicator.setText2("");
                int count2 = 1;
                for (CommentDescriptor descriptor2 : this.myComments.values()) {
                    stream.println("#" + count2 + " ---------------------------------------------------------------");
                    descriptor2.print(stream);
                    stream.println();
                    ++count2;
                }
            }, "Generating Comments", true, p);
        }
        catch (Throwable e1) {
            LOG.error(e1);
            Messages.showErrorDialog((Project)p, (String)("Error writing? " + e1.getMessage()), (String)"Problem writing");
        }
    }

    private void commentFound(VirtualFile file2, String text2) {
        String reduced = text2.replaceAll("\\s", "");
        CommentDescriptor descriptor2 = this.myComments.get(reduced);
        if (descriptor2 == null) {
            descriptor2 = new CommentDescriptor(text2);
            this.myComments.put(reduced, descriptor2);
        }
        descriptor2.addFile(file2);
    }

    private void scanCommentsInFile(Project project2, final VirtualFile vFile) {
        if (!vFile.isDirectory() && vFile.getFileType() instanceof LanguageFileType) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile psiFile = PsiManager.getInstance(project2).findFile(vFile);
                if (psiFile == null) {
                    return;
                }
                for (PsiFile root : psiFile.getViewProvider().getAllFiles()) {
                    root.accept(new PsiRecursiveElementWalkingVisitor(){

                        @Override
                        public void visitComment(@NotNull PsiComment comment) {
                            if (comment == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ScanSourceCommentsAction.this.commentFound(vFile, comment.getText());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/tools/ScanSourceCommentsAction$1", "visitComment"));
                        }
                    });
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ScanSourceCommentsAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ScanSourceCommentsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }

    private static class CommentDescriptor {
        private final String myText;
        private final Set<VirtualFile> myFiles = new LinkedHashSet<VirtualFile>();

        CommentDescriptor(String text2) {
            this.myText = text2;
        }

        public void addFile(VirtualFile file2) {
            this.myFiles.add(file2);
        }

        public void print(PrintStream out) {
            out.println(this.myText);
            int count2 = this.myFiles.size();
            int i2 = 0;
            for (VirtualFile file2 : this.myFiles) {
                out.println(file2.getPresentableUrl());
                if (++i2 <= 5 || --count2 <= 2) continue;
                break;
            }
            if (count2 > 0) {
                out.println("And " + count2 + " more files");
            }
        }
    }
}

