/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslMacroPathConverter;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolProcessAdapter;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsCustomizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tool
implements SchemeElement {
    private static final Logger LOG = Logger.getInstance(Tool.class);
    @NonNls
    public static final String ACTION_ID_PREFIX = "Tool_";
    public static final String DEFAULT_GROUP_NAME = "External Tools";
    protected static final ProcessEvent NOT_STARTED_EVENT = new ProcessEvent((ProcessHandler)new NopProcessHandler(), -1);
    @NlsSafe
    private String myName;
    private String myDescription;
    @NotNull
    private String myGroup = "External Tools";
    private boolean myShownInMainMenu;
    private boolean myShownInEditor;
    private boolean myShownInProjectViews;
    private boolean myShownInSearchResultsPopup;
    private boolean myEnabled;
    private boolean myUseConsole;
    private boolean myShowConsoleOnStdOut;
    private boolean myShowConsoleOnStdErr;
    private boolean mySynchronizeAfterExecution;
    private String myWorkingDirectory;
    private String myProgram;
    private String myParameters;
    private ArrayList<FilterInfo> myOutputFilters = new ArrayList();

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @NlsSafe
    public String getDescription() {
        return this.myDescription;
    }

    @NlsSafe
    @NotNull
    public String getGroup() {
        String string2 = this.myGroup;
        if (string2 == null) {
            Tool.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public boolean isShownInMainMenu() {
        return this.myShownInMainMenu;
    }

    public boolean isShownInEditor() {
        return this.myShownInEditor;
    }

    public boolean isShownInProjectViews() {
        return this.myShownInProjectViews;
    }

    public boolean isShownInSearchResultsPopup() {
        return this.myShownInSearchResultsPopup;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isUseConsole() {
        return this.myUseConsole;
    }

    public boolean isShowConsoleOnStdOut() {
        return this.myShowConsoleOnStdOut;
    }

    public boolean isShowConsoleOnStdErr() {
        return this.myShowConsoleOnStdErr;
    }

    public boolean synchronizeAfterExecution() {
        return this.mySynchronizeAfterExecution;
    }

    public void setName(@NlsSafe String name) {
        this.myName = name;
    }

    public void setDescription(@NlsSafe String description) {
        this.myDescription = description;
    }

    public void setGroup(@NonNls @NotNull String group2) {
        if (group2 == null) {
            Tool.$$$reportNull$$$0(1);
        }
        this.myGroup = StringUtil.isEmpty(group2) ? DEFAULT_GROUP_NAME : group2;
    }

    public void setShownInMainMenu(boolean shownInMainMenu) {
        this.myShownInMainMenu = shownInMainMenu;
    }

    public void setShownInEditor(boolean shownInEditor) {
        this.myShownInEditor = shownInEditor;
    }

    public void setShownInProjectViews(boolean shownInProjectViews) {
        this.myShownInProjectViews = shownInProjectViews;
    }

    public void setShownInSearchResultsPopup(boolean shownInSearchResultsPopup) {
        this.myShownInSearchResultsPopup = shownInSearchResultsPopup;
    }

    public void setUseConsole(boolean useConsole) {
        this.myUseConsole = useConsole;
    }

    public void setShowConsoleOnStdOut(boolean showConsole) {
        this.myShowConsoleOnStdOut = showConsole;
    }

    public void setShowConsoleOnStdErr(boolean showConsole) {
        this.myShowConsoleOnStdErr = showConsole;
    }

    public void setFilesSynchronizedAfterRun(boolean synchronizeAfterRun) {
        this.mySynchronizeAfterExecution = synchronizeAfterRun;
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public String getProgram() {
        return this.myProgram;
    }

    public void setProgram(String program) {
        this.myProgram = program;
    }

    public String getParameters() {
        return this.myParameters;
    }

    public void setParameters(String parameters2) {
        this.myParameters = parameters2;
    }

    public void addOutputFilter(FilterInfo filter2) {
        this.myOutputFilters.add(filter2);
    }

    public void setOutputFilters(FilterInfo[] filters) {
        this.myOutputFilters = new ArrayList();
        if (filters != null) {
            Collections.addAll(this.myOutputFilters, filters);
        }
    }

    public FilterInfo[] getOutputFilters() {
        return this.myOutputFilters.toArray(new FilterInfo[0]);
    }

    public void copyFrom(Tool source) {
        this.myName = source.getName();
        this.myDescription = source.getDescription();
        this.myGroup = source.getGroup();
        this.myShownInMainMenu = source.isShownInMainMenu();
        this.myShownInEditor = source.isShownInEditor();
        this.myShownInProjectViews = source.isShownInProjectViews();
        this.myShownInSearchResultsPopup = source.isShownInSearchResultsPopup();
        this.myEnabled = source.isEnabled();
        this.myUseConsole = source.isUseConsole();
        this.myShowConsoleOnStdOut = source.isShowConsoleOnStdOut();
        this.myShowConsoleOnStdErr = source.isShowConsoleOnStdErr();
        this.mySynchronizeAfterExecution = source.synchronizeAfterExecution();
        this.myWorkingDirectory = source.getWorkingDirectory();
        this.myProgram = source.getProgram();
        this.myParameters = source.getParameters();
        this.myOutputFilters = new ArrayList<FilterInfo>(Arrays.asList(source.getOutputFilters()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tool)) {
            return false;
        }
        Tool source = (Tool)obj;
        return Objects.equals(this.myName, source.myName) && Objects.equals(this.myDescription, source.myDescription) && Objects.equals(this.myGroup, source.myGroup) && this.myShownInMainMenu == source.myShownInMainMenu && this.myShownInEditor == source.myShownInEditor && this.myShownInProjectViews == source.myShownInProjectViews && this.myShownInSearchResultsPopup == source.myShownInSearchResultsPopup && this.myEnabled == source.myEnabled && this.myUseConsole == source.myUseConsole && this.myShowConsoleOnStdOut == source.myShowConsoleOnStdOut && this.myShowConsoleOnStdErr == source.myShowConsoleOnStdErr && this.mySynchronizeAfterExecution == source.mySynchronizeAfterExecution && Objects.equals(this.myWorkingDirectory, source.myWorkingDirectory) && Objects.equals(this.myProgram, source.myProgram) && Objects.equals(this.myParameters, source.myParameters) && Comparing.equal(this.myOutputFilters, source.myOutputFilters);
    }

    @NotNull
    public String getActionId() {
        StringBuilder name = new StringBuilder(this.getActionIdPrefix());
        name.append(this.myGroup);
        name.append('_');
        if (this.myName != null) {
            name.append(this.myName);
        }
        String string2 = name.toString();
        if (string2 == null) {
            Tool.$$$reportNull$$$0(2);
        }
        return string2;
    }

    protected static void notifyCouldNotStart(@Nullable ProcessListener listener2) {
        if (listener2 != null) {
            listener2.processTerminated(NOT_STARTED_EVENT);
        }
    }

    public void execute(AnActionEvent event, DataContext dataContext2, long executionId, @Nullable ProcessListener processListener) {
        if (!this.executeIfPossible(event, dataContext2, executionId, processListener)) {
            Tool.notifyCouldNotStart(processListener);
        }
    }

    public boolean executeIfPossible(AnActionEvent event, DataContext dataContext2, long executionId, final @Nullable ProcessListener processListener) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return false;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            if (this.isUseConsole()) {
                ExecutionEnvironment environment = ExecutionEnvironmentBuilder.create((Project)project2, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)new ToolRunProfile(this, dataContext2)).build(new ProgramRunner.Callback(){

                    public void processStarted(RunContentDescriptor descriptor2) {
                        ProcessHandler processHandler = descriptor2.getProcessHandler();
                        if (processHandler != null && processListener != null) {
                            LOG.assertTrue(!processHandler.isStartNotified(), "ProcessHandler is already startNotified, the listener won't be correctly notified");
                            processHandler.addProcessListener(processListener);
                        }
                    }

                    public void processNotStarted() {
                        if (processListener != null) {
                            processListener.processNotStarted();
                        }
                    }
                });
                if (environment.getState() == null) {
                    return false;
                }
                environment.setExecutionId(executionId);
                environment.getRunner().execute(environment);
            } else {
                GeneralCommandLine commandLine = this.createCommandLine(dataContext2);
                if (commandLine == null) {
                    return false;
                }
                OSProcessHandler handler2 = new OSProcessHandler(commandLine);
                handler2.addProcessListener((ProcessListener)new ToolProcessAdapter(project2, this.synchronizeAfterExecution(), this.getName()));
                if (processListener != null) {
                    handler2.addProcessListener(processListener);
                }
                handler2.startNotify();
            }
        }
        catch (ExecutionException ex) {
            ExecutionErrorDialog.show((ExecutionException)ex, (String)ToolsBundle.message("tools.process.start.error", new Object[0]), (Project)project2);
            Tool.notifyCouldNotStart(processListener);
            return false;
        }
        return true;
    }

    @Nullable
    public GeneralCommandLine createCommandLine(DataContext dataContext2) {
        if (StringUtil.isEmpty(this.getWorkingDirectory())) {
            this.setWorkingDirectory("$ProjectFileDir$");
        }
        GeneralCommandLine commandLine = Registry.is("use.tty.for.external.tools", false) ? new PtyCommandLine().withConsoleMode(true) : new GeneralCommandLine();
        try {
            File exeFile;
            String exePath = MacroManager.getInstance().expandMacrosInString(this.getProgram(), true, dataContext2);
            exePath = MacroManager.getInstance().expandMacrosInString(exePath, false, dataContext2);
            if (exePath == null) {
                return null;
            }
            WSLDistribution wsl = WslPath.getDistributionByWindowsUncPath((String)exePath);
            WslMacroPathConverter pathConverter = null;
            if (wsl != null) {
                pathConverter = new WslMacroPathConverter(wsl);
                dataContext2 = SimpleDataContext.getSimpleContext((DataKey)MacroManager.PATH_CONVERTER_KEY, (Object)pathConverter, (DataContext)dataContext2);
            }
            String paramString = MacroManager.getInstance().expandMacrosInString(this.getParameters(), true, dataContext2);
            String workingDir = MacroManager.getInstance().expandMacrosInString(this.getWorkingDirectory(), true, dataContext2);
            commandLine.getParametersList().addParametersString(MacroManager.getInstance().expandMacrosInString(paramString, false, dataContext2));
            String workDirExpanded = MacroManager.getInstance().expandMacrosInString(workingDir, false, dataContext2);
            if (!StringUtil.isEmpty(workDirExpanded)) {
                commandLine.setWorkDirectory(workDirExpanded);
            }
            if ((exeFile = new File(exePath)).isDirectory() && exeFile.getName().endsWith(".app")) {
                commandLine.setExePath("open");
                commandLine.getParametersList().prependAll(new String[]{"-a", exePath});
            } else if (wsl != null) {
                try {
                    commandLine = Tool.createWslCommandLine((Project)CommonDataKeys.PROJECT.getData(dataContext2), wsl, commandLine, workDirExpanded, pathConverter.convertPath(exePath));
                }
                catch (ExecutionException e) {
                    LOG.error("Failed to create wsl command line", e);
                }
            } else {
                commandLine.setExePath(exePath);
            }
        }
        catch (Macro.ExecutionCancelledException ignored) {
            return null;
        }
        return ToolsCustomizer.customizeCommandLine(commandLine, dataContext2);
    }

    @Override
    public void setGroupName(@NotNull String name) {
        if (name == null) {
            Tool.$$$reportNull$$$0(3);
        }
        this.setGroup(name);
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    @NotNull
    public SchemeElement copy() {
        Tool copy2 = new Tool();
        copy2.copyFrom(this);
        Tool tool = copy2;
        if (tool == null) {
            Tool.$$$reportNull$$$0(4);
        }
        return tool;
    }

    public String toString() {
        return this.myGroup + ": " + this.myName;
    }

    public String getActionIdPrefix() {
        return ACTION_ID_PREFIX;
    }

    @NotNull
    public static GeneralCommandLine createWslCommandLine(@Nullable Project project2, @NotNull WSLDistribution wsl, @NotNull GeneralCommandLine cmd, @Nullable String linuxWorkingDir, @NotNull String linuxExePath) throws ExecutionException {
        if (wsl == null) {
            Tool.$$$reportNull$$$0(5);
        }
        if (cmd == null) {
            Tool.$$$reportNull$$$0(6);
        }
        if (linuxExePath == null) {
            Tool.$$$reportNull$$$0(7);
        }
        cmd.setExePath(linuxExePath);
        WSLCommandLineOptions wslOptions = new WSLCommandLineOptions();
        if (StringUtil.isNotEmpty(linuxWorkingDir)) {
            wslOptions.setRemoteWorkingDirectory(linuxWorkingDir);
        }
        cmd.setWorkDirectory((String)null);
        wslOptions.setShellPath(wsl.getShellPath()).setExecuteCommandInInteractiveShell(true);
        GeneralCommandLine generalCommandLine = wsl.patchCommandLine(cmd, project2, wslOptions);
        if (generalCommandLine == null) {
            Tool.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/Tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linuxExePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/Tool";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setGroupName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWslCommandLine";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 3, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }
}

