/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolAction
extends AnAction
implements DumbAware {
    private final String myActionId;

    public ToolAction(@NotNull Tool tool) {
        if (tool == null) {
            ToolAction.$$$reportNull$$$0(0);
        }
        this.myActionId = tool.getActionId();
        this.getTemplatePresentation().setText(tool.getName(), false);
        this.getTemplatePresentation().setDescription(tool.getDescription());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolAction.$$$reportNull$$$0(1);
        }
        ToolAction.runTool(this.myActionId, e.getDataContext(), e, 0L, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Tool tool;
        if (e == null) {
            ToolAction.$$$reportNull$$$0(2);
        }
        if ((tool = ToolAction.findTool(this.myActionId)) != null) {
            e.getPresentation().setText(ToolRunProfile.expandMacrosInName(tool, e.getDataContext()), false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToolAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @Nullable
    private static Tool findTool(@NotNull String actionId) {
        if (actionId == null) {
            ToolAction.$$$reportNull$$$0(4);
        }
        for (Tool tool : ToolsProvider.getAllTools()) {
            if (!actionId.equals(tool.getActionId())) continue;
            return tool;
        }
        return null;
    }

    static void runTool(@NotNull String actionId, @NotNull DataContext context2) {
        if (actionId == null) {
            ToolAction.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            ToolAction.$$$reportNull$$$0(6);
        }
        ToolAction.runTool(actionId, context2, null, 0L, null);
    }

    static void runTool(@NotNull String actionId, @NotNull DataContext context2, @Nullable AnActionEvent e, long executionId, @Nullable ProcessListener processListener) {
        if (actionId == null) {
            ToolAction.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            ToolAction.$$$reportNull$$$0(8);
        }
        MacroManager.getInstance().cacheMacrosPreview(context2);
        Tool tool = ToolAction.findTool(actionId);
        if (tool != null) {
            tool.execute(e, ToolAction.getToolDataContext(context2), executionId, (ProcessListener)processListener);
        } else {
            Tool.notifyCouldNotStart((ProcessListener)processListener);
        }
    }

    @Nullable
    public String getTemplateText() {
        return ToolsBundle.message("action.text.external.tool", new Object[0]);
    }

    @NotNull
    public static DataContext getToolDataContext(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            ToolAction.$$$reportNull$$$0(9);
        }
        if (dataContext2 instanceof SimpleDataContext) {
            DataContext dataContext3 = dataContext2;
            if (dataContext3 == null) {
                ToolAction.$$$reportNull$$$0(10);
            }
            return dataContext3;
        }
        SimpleDataContext.Builder builder2 = SimpleDataContext.builder().addAll(dataContext2, new DataKey[]{CommonDataKeys.PROJECT, PlatformCoreDataKeys.PROJECT_FILE_DIRECTORY, CommonDataKeys.EDITOR, CommonDataKeys.VIRTUAL_FILE, PlatformCoreDataKeys.MODULE, CommonDataKeys.PSI_FILE});
        VirtualFile virtualFile2 = (VirtualFile)dataContext2.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null) {
            Project project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
            FileEditor editor2 = project2 == null ? null : FileEditorManager.getInstance(project2).getSelectedEditor();
            VirtualFile editorFile = editor2 == null ? null : editor2.getFile();
            builder2.add(CommonDataKeys.VIRTUAL_FILE, (Object)editorFile);
        }
        DataContext dataContext4 = builder2.build();
        if (dataContext4 == null) {
            ToolAction.$$$reportNull$$$0(11);
        }
        return dataContext4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ToolAction";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ToolAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTool";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolDataContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 10, 11 -> new IllegalStateException(string2);
        };
    }
}

